/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.messages.MessageBus;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.impl.VcsLogContentUtil;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.impl.VcsLogProjectTabsProperties;
import com.intellij.vcs.log.impl.VcsProjectLog;
import com.intellij.vcs.log.ui.VcsLogUiImpl;
import com.intellij.vcs.log.visible.filters.VcsLogFiltersKt;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogTabsManager {
    @NotNull
    private final Project myProject;
    @NotNull
    private final VcsLogProjectTabsProperties myUiProperties;
    private boolean myIsLogDisposing;

    public VcsLogTabsManager(@NotNull Project project, @NotNull MessageBus messageBus, @NotNull VcsLogProjectTabsProperties uiProperties, @NotNull Disposable parent) {
        if (project == null) {
            VcsLogTabsManager.$$$reportNull$$$0(0);
        }
        if (messageBus == null) {
            VcsLogTabsManager.$$$reportNull$$$0(1);
        }
        if (uiProperties == null) {
            VcsLogTabsManager.$$$reportNull$$$0(2);
        }
        if (parent == null) {
            VcsLogTabsManager.$$$reportNull$$$0(3);
        }
        this.myIsLogDisposing = false;
        this.myProject = project;
        this.myUiProperties = uiProperties;
        messageBus.connect(parent).subscribe(VcsProjectLog.VCS_PROJECT_LOG_CHANGED, (Object)new VcsProjectLog.ProjectLogListener(){

            @Override
            public void logCreated(@NotNull VcsLogManager manager) {
                if (manager == null) {
                    1.$$$reportNull$$$0(0);
                }
                VcsLogTabsManager.this.myIsLogDisposing = false;
                VcsLogTabsManager.this.createLogTabs(manager);
            }

            @Override
            public void logDisposed(@NotNull VcsLogManager manager) {
                if (manager == null) {
                    1.$$$reportNull$$$0(1);
                }
                VcsLogTabsManager.this.myIsLogDisposing = true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "manager";
                objectArray2[1] = "com/intellij/vcs/log/impl/VcsLogTabsManager$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "logCreated";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "logDisposed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private void createLogTabs(@NotNull VcsLogManager manager) {
        if (manager == null) {
            VcsLogTabsManager.$$$reportNull$$$0(4);
        }
        List<String> tabIds = this.myUiProperties.getTabs();
        for (String tabId : tabIds) {
            this.openLogTab(manager, tabId, false, null);
        }
    }

    @NotNull
    public List<String> getTabs() {
        List<String> list2 = this.myUiProperties.getTabs();
        if (list2 == null) {
            VcsLogTabsManager.$$$reportNull$$$0(5);
        }
        return list2;
    }

    public void openAnotherLogTab(@NotNull VcsLogManager manager) {
        if (manager == null) {
            VcsLogTabsManager.$$$reportNull$$$0(6);
        }
        this.openAnotherLogTab(manager, null);
    }

    @NotNull
    public VcsLogUiImpl openAnotherLogTab(@NotNull VcsLogManager manager, @Nullable VcsLogFilterCollection filters) {
        if (manager == null) {
            VcsLogTabsManager.$$$reportNull$$$0(7);
        }
        VcsLogUiImpl vcsLogUiImpl = this.openLogTab(manager, VcsLogContentUtil.generateTabId(this.myProject), true, filters);
        if (vcsLogUiImpl == null) {
            VcsLogTabsManager.$$$reportNull$$$0(8);
        }
        return vcsLogUiImpl;
    }

    @NotNull
    private VcsLogUiImpl openLogTab(@NotNull VcsLogManager manager, @NotNull String tabId, boolean focus, @Nullable VcsLogFilterCollection filters) {
        if (manager == null) {
            VcsLogTabsManager.$$$reportNull$$$0(9);
        }
        if (tabId == null) {
            VcsLogTabsManager.$$$reportNull$$$0(10);
        }
        if (filters != null) {
            this.myUiProperties.resetState(tabId);
        }
        PersistentVcsLogUiFactory factory = new PersistentVcsLogUiFactory(manager.getMainLogUiFactory(tabId, filters));
        VcsLogUiImpl ui = VcsLogContentUtil.openLogTab(this.myProject, manager, "Log", tabId, factory, focus);
        this.updateTabName(ui);
        ui.addFilterListener(() -> this.updateTabName(ui));
        VcsLogUiImpl vcsLogUiImpl = ui;
        if (vcsLogUiImpl == null) {
            VcsLogTabsManager.$$$reportNull$$$0(11);
        }
        return vcsLogUiImpl;
    }

    private void updateTabName(@NotNull VcsLogUiImpl ui) {
        if (ui == null) {
            VcsLogTabsManager.$$$reportNull$$$0(12);
        }
        VcsLogContentUtil.renameLogUi(this.myProject, ui, VcsLogTabsManager.generateDisplayName(ui));
    }

    @NotNull
    private static String generateDisplayName(@NotNull VcsLogUiImpl ui) {
        VcsLogFilterCollection filters;
        if (ui == null) {
            VcsLogTabsManager.$$$reportNull$$$0(13);
        }
        if ((filters = ui.getFilterUi().getFilters()).isEmpty()) {
            if ("all" == null) {
                VcsLogTabsManager.$$$reportNull$$$0(14);
            }
            return "all";
        }
        String string = StringUtil.shortenTextWithEllipsis((String)VcsLogFiltersKt.getPresentation(filters), (int)150, (int)20);
        if (string == null) {
            VcsLogTabsManager.$$$reportNull$$$0(15);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 8: 
            case 11: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 8: 
            case 11: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageBus";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiProperties";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 5: 
            case 8: 
            case 11: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/impl/VcsLogTabsManager";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tabId";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ui";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/impl/VcsLogTabsManager";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTabs";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "openAnotherLogTab";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "openLogTab";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "generateDisplayName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createLogTabs";
                break;
            }
            case 5: 
            case 8: 
            case 11: 
            case 14: 
            case 15: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "openAnotherLogTab";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "openLogTab";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "updateTabName";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "generateDisplayName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 8: 
            case 11: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class PersistentVcsLogUiFactory
    implements VcsLogManager.VcsLogUiFactory<VcsLogUiImpl> {
        private final VcsLogManager.VcsLogUiFactory<? extends VcsLogUiImpl> myFactory;

        PersistentVcsLogUiFactory(VcsLogManager.VcsLogUiFactory<? extends VcsLogUiImpl> factory) {
            if (factory == null) {
                PersistentVcsLogUiFactory.$$$reportNull$$$0(0);
            }
            this.myFactory = factory;
        }

        @Override
        public VcsLogUiImpl createLogUi(@NotNull Project project, @NotNull VcsLogData logData) {
            if (project == null) {
                PersistentVcsLogUiFactory.$$$reportNull$$$0(1);
            }
            if (logData == null) {
                PersistentVcsLogUiFactory.$$$reportNull$$$0(2);
            }
            VcsLogUiImpl ui = this.myFactory.createLogUi(project, logData);
            VcsLogTabsManager.this.myUiProperties.addTab(ui.getId());
            Disposer.register((Disposable)ui, () -> {
                if (Disposer.isDisposing((Disposable)VcsLogTabsManager.this.myProject) || VcsLogTabsManager.this.myIsLogDisposing) {
                    return;
                }
                VcsLogTabsManager.this.myUiProperties.removeTab(ui.getId());
            });
            return ui;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "factory";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "logData";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/vcs/log/impl/VcsLogTabsManager$PersistentVcsLogUiFactory";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createLogUi";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

