/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Storage;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.XCollection;
import com.intellij.vcs.log.impl.MainVcsLogUiProperties;
import com.intellij.vcs.log.impl.VcsLogApplicationSettings;
import com.intellij.vcs.log.impl.VcsLogTabsProperties;
import com.intellij.vcs.log.impl.VcsLogUiPropertiesImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="Vcs.Log.Tabs.Properties", storages={@Storage(value="$WORKSPACE_FILE$")})
public class VcsLogProjectTabsProperties
implements PersistentStateComponent<State>,
VcsLogTabsProperties {
    public static final String MAIN_LOG_ID = "MAIN";
    private static final int RECENTLY_FILTERED_VALUES_LIMIT = 10;
    @NotNull
    private final VcsLogApplicationSettings myAppSettings;
    private State myState;

    public VcsLogProjectTabsProperties(@NotNull VcsLogApplicationSettings appSettings) {
        if (appSettings == null) {
            VcsLogProjectTabsProperties.$$$reportNull$$$0(0);
        }
        this.myState = new State();
        this.myAppSettings = appSettings;
    }

    @Nullable
    public State getState() {
        return this.myState;
    }

    public void loadState(@NotNull State state) {
        if (state == null) {
            VcsLogProjectTabsProperties.$$$reportNull$$$0(1);
        }
        this.myState = state;
        this.migrateRecentItems();
    }

    private void migrateRecentItems() {
        if (ContainerUtil.isEmpty(this.myState.RECENT_FILTERS)) {
            this.myState.RECENT_FILTERS = ContainerUtil.newHashMap();
            HashMultiset branchFrequencies = HashMultiset.create();
            HashMultiset userFrequencies = HashMultiset.create();
            for (Map.Entry<String, VcsLogUiPropertiesImpl.State> entry : this.myState.TAB_STATES.entrySet()) {
                if (entry.getKey().startsWith("EXTERNAL")) continue;
                VcsLogUiPropertiesImpl.State s = entry.getValue();
                branchFrequencies.addAll((Collection)ContainerUtil.map(s.RECENTLY_FILTERED_BRANCH_GROUPS, RecentGroup::new));
                userFrequencies.addAll((Collection)ContainerUtil.map(s.RECENTLY_FILTERED_USER_GROUPS, RecentGroup::new));
                s.RECENTLY_FILTERED_BRANCH_GROUPS.clear();
                s.RECENTLY_FILTERED_USER_GROUPS.clear();
            }
            List sortedBranches = ContainerUtil.sorted((Collection)branchFrequencies.elementSet(), Comparator.comparingInt(arg_0 -> VcsLogProjectTabsProperties.lambda$migrateRecentItems$0((Multiset)branchFrequencies, arg_0)));
            List sortedUsers = ContainerUtil.sorted((Collection)userFrequencies.elementSet(), Comparator.comparingInt(arg_0 -> VcsLogProjectTabsProperties.lambda$migrateRecentItems$1((Multiset)userFrequencies, arg_0)));
            this.myState.RECENT_FILTERS.put("Branch", ContainerUtil.newArrayList((Iterable)ContainerUtil.getFirstItems((List)sortedBranches, (int)10)));
            this.myState.RECENT_FILTERS.put("User", ContainerUtil.newArrayList((Iterable)ContainerUtil.getFirstItems((List)sortedUsers, (int)10)));
        }
    }

    @Deprecated
    @Nullable
    public VcsLogUiPropertiesImpl.State removeTabState(@NotNull String id) {
        if (id == null) {
            VcsLogProjectTabsProperties.$$$reportNull$$$0(2);
        }
        return this.myState.TAB_STATES.remove(id);
    }

    @Override
    @NotNull
    public MainVcsLogUiProperties createProperties(@NotNull String id) {
        if (id == null) {
            VcsLogProjectTabsProperties.$$$reportNull$$$0(3);
        }
        this.myState.TAB_STATES.putIfAbsent(id, new VcsLogUiPropertiesImpl.State());
        MyVcsLogUiPropertiesImpl myVcsLogUiPropertiesImpl = new MyVcsLogUiPropertiesImpl(id);
        if (myVcsLogUiPropertiesImpl == null) {
            VcsLogProjectTabsProperties.$$$reportNull$$$0(4);
        }
        return myVcsLogUiPropertiesImpl;
    }

    public void addTab(@NotNull String tabId) {
        if (tabId == null) {
            VcsLogProjectTabsProperties.$$$reportNull$$$0(5);
        }
        this.myState.OPEN_TABS.add(tabId);
    }

    public void removeTab(@NotNull String tabId) {
        if (tabId == null) {
            VcsLogProjectTabsProperties.$$$reportNull$$$0(6);
        }
        this.myState.OPEN_TABS.remove(tabId);
    }

    public void resetState(@NotNull String tabId) {
        if (tabId == null) {
            VcsLogProjectTabsProperties.$$$reportNull$$$0(7);
        }
        this.myState.TAB_STATES.put(tabId, null);
    }

    @NotNull
    public List<String> getTabs() {
        ArrayList arrayList = ContainerUtil.newArrayList(this.myState.OPEN_TABS);
        if (arrayList == null) {
            VcsLogProjectTabsProperties.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    public static void addRecentGroup(@NotNull Map<String, List<RecentGroup>> stateField, @NotNull String filterName, @NotNull Collection<String> values) {
        ArrayList recentGroups;
        if (stateField == null) {
            VcsLogProjectTabsProperties.$$$reportNull$$$0(9);
        }
        if (filterName == null) {
            VcsLogProjectTabsProperties.$$$reportNull$$$0(10);
        }
        if (values == null) {
            VcsLogProjectTabsProperties.$$$reportNull$$$0(11);
        }
        if ((recentGroups = stateField.get(filterName)) == null) {
            recentGroups = ContainerUtil.newArrayList();
            stateField.put(filterName, recentGroups);
        }
        RecentGroup group = new RecentGroup(values);
        recentGroups.remove(group);
        recentGroups.add(0, group);
        while (recentGroups.size() > 10) {
            recentGroups.remove(recentGroups.size() - 1);
        }
    }

    @NotNull
    public static List<List<String>> getRecentGroup(@NotNull Map<String, List<RecentGroup>> stateField, @NotNull String filterName) {
        List<RecentGroup> values;
        if (stateField == null) {
            VcsLogProjectTabsProperties.$$$reportNull$$$0(12);
        }
        if (filterName == null) {
            VcsLogProjectTabsProperties.$$$reportNull$$$0(13);
        }
        if ((values = stateField.get(filterName)) == null) {
            List list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                VcsLogProjectTabsProperties.$$$reportNull$$$0(14);
            }
            return list2;
        }
        List list3 = ContainerUtil.map2List(values, group -> group.FILTER_VALUES);
        if (list3 == null) {
            VcsLogProjectTabsProperties.$$$reportNull$$$0(15);
        }
        return list3;
    }

    private static /* synthetic */ int lambda$migrateRecentItems$1(Multiset userFrequencies, RecentGroup value) {
        return -userFrequencies.count((Object)value);
    }

    private static /* synthetic */ int lambda$migrateRecentItems$0(Multiset branchFrequencies, RecentGroup value) {
        return -branchFrequencies.count((Object)value);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 8: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 8: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appSettings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 4: 
            case 8: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/impl/VcsLogProjectTabsProperties";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tabId";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stateField";
                break;
            }
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filterName";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/impl/VcsLogProjectTabsProperties";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createProperties";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getTabs";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getRecentGroup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "removeTabState";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createProperties";
                break;
            }
            case 4: 
            case 8: 
            case 14: 
            case 15: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addTab";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "removeTab";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "resetState";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addRecentGroup";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getRecentGroup";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 8: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyVcsLogUiPropertiesImpl
    extends VcsLogUiPropertiesImpl<VcsLogUiPropertiesImpl.State> {
        private final String myId;

        MyVcsLogUiPropertiesImpl(String id) {
            super(VcsLogProjectTabsProperties.this.myAppSettings);
            this.myId = id;
        }

        @Override
        @NotNull
        public VcsLogUiPropertiesImpl.State getState() {
            VcsLogUiPropertiesImpl.State state = ((VcsLogProjectTabsProperties)VcsLogProjectTabsProperties.this).myState.TAB_STATES.get(this.myId);
            if (state == null) {
                state = new VcsLogUiPropertiesImpl.State();
                ((VcsLogProjectTabsProperties)VcsLogProjectTabsProperties.this).myState.TAB_STATES.put(this.myId, state);
            }
            VcsLogUiPropertiesImpl.State state2 = state;
            if (state2 == null) {
                MyVcsLogUiPropertiesImpl.$$$reportNull$$$0(0);
            }
            return state2;
        }

        public void loadState(@NotNull VcsLogUiPropertiesImpl.State state) {
            if (state == null) {
                MyVcsLogUiPropertiesImpl.$$$reportNull$$$0(1);
            }
            ((VcsLogProjectTabsProperties)VcsLogProjectTabsProperties.this).myState.TAB_STATES.put(this.myId, state);
        }

        @Override
        public void addRecentlyFilteredGroup(@NotNull String filterName, @NotNull Collection<String> values) {
            if (filterName == null) {
                MyVcsLogUiPropertiesImpl.$$$reportNull$$$0(2);
            }
            if (values == null) {
                MyVcsLogUiPropertiesImpl.$$$reportNull$$$0(3);
            }
            VcsLogProjectTabsProperties.addRecentGroup(((VcsLogProjectTabsProperties)VcsLogProjectTabsProperties.this).myState.RECENT_FILTERS, filterName, values);
        }

        @Override
        @NotNull
        public List<List<String>> getRecentlyFilteredGroups(@NotNull String filterName) {
            if (filterName == null) {
                MyVcsLogUiPropertiesImpl.$$$reportNull$$$0(4);
            }
            List<List<String>> list2 = VcsLogProjectTabsProperties.getRecentGroup(((VcsLogProjectTabsProperties)VcsLogProjectTabsProperties.this).myState.RECENT_FILTERS, filterName);
            if (list2 == null) {
                MyVcsLogUiPropertiesImpl.$$$reportNull$$$0(5);
            }
            return list2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/impl/VcsLogProjectTabsProperties$MyVcsLogUiPropertiesImpl";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filterName";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "values";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getState";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/impl/VcsLogProjectTabsProperties$MyVcsLogUiPropertiesImpl";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRecentlyFilteredGroups";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "loadState";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "addRecentlyFilteredGroup";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getRecentlyFilteredGroups";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class RecentGroup {
        @XCollection
        public List<String> FILTER_VALUES;

        public RecentGroup() {
            this.FILTER_VALUES = ContainerUtil.newArrayList();
        }

        public RecentGroup(@NotNull Collection<String> values) {
            if (values == null) {
                RecentGroup.$$$reportNull$$$0(0);
            }
            this.FILTER_VALUES = ContainerUtil.newArrayList();
            this.FILTER_VALUES.addAll(values);
        }

        public RecentGroup(@NotNull VcsLogUiPropertiesImpl.UserGroup oldGroup) {
            if (oldGroup == null) {
                RecentGroup.$$$reportNull$$$0(1);
            }
            this(oldGroup.users);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RecentGroup group = (RecentGroup)o;
            return Objects.equals(this.FILTER_VALUES, group.FILTER_VALUES);
        }

        public int hashCode() {
            return Objects.hash(this.FILTER_VALUES);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "values";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "oldGroup";
                    break;
                }
            }
            objectArray[1] = "com/intellij/vcs/log/impl/VcsLogProjectTabsProperties$RecentGroup";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class State {
        public Map<String, VcsLogUiPropertiesImpl.State> TAB_STATES = ContainerUtil.newTreeMap();
        public LinkedHashSet<String> OPEN_TABS = ContainerUtil.newLinkedHashSet();
        public Map<String, List<RecentGroup>> RECENT_FILTERS = ContainerUtil.newHashMap();
    }
}

