/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.history;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.data.DataPack;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.graph.PermanentGraph;
import com.intellij.vcs.log.history.FileHistoryFilterer;
import com.intellij.vcs.log.history.FileHistoryUi;
import com.intellij.vcs.log.history.FileHistoryUiProperties;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.ui.VcsLogColorManagerImpl;
import com.intellij.vcs.log.visible.VisiblePackRefresherImpl;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileHistoryUiFactory
implements VcsLogManager.VcsLogUiFactory<FileHistoryUi> {
    @NotNull
    private final FilePath myFilePath;
    @NotNull
    private final VirtualFile myRoot;
    @Nullable
    private final Hash myHash;

    public FileHistoryUiFactory(@NotNull FilePath path, @NotNull VirtualFile root, @Nullable Hash hash) {
        if (path == null) {
            FileHistoryUiFactory.$$$reportNull$$$0(0);
        }
        if (root == null) {
            FileHistoryUiFactory.$$$reportNull$$$0(1);
        }
        this.myFilePath = path;
        this.myRoot = root;
        this.myHash = hash;
    }

    @Override
    public FileHistoryUi createLogUi(@NotNull Project project, final @NotNull VcsLogData logData) {
        if (project == null) {
            FileHistoryUiFactory.$$$reportNull$$$0(2);
        }
        if (logData == null) {
            FileHistoryUiFactory.$$$reportNull$$$0(3);
        }
        FileHistoryUiProperties properties = (FileHistoryUiProperties)ServiceManager.getService((Project)project, FileHistoryUiProperties.class);
        VcsLogFilterCollection filters = FileHistoryFilterer.createFilters(this.myFilePath, this.myHash, this.myRoot, properties.get(FileHistoryUiProperties.SHOW_ALL_BRANCHES));
        return new FileHistoryUi(logData, new VcsLogColorManagerImpl(Collections.singleton(this.myRoot)), properties, new VisiblePackRefresherImpl(project, logData, filters, PermanentGraph.SortType.Normal, new FileHistoryFilterer(logData), FileHistoryUi.getFileHistoryLogId(this.myFilePath, this.myHash)){

            @Override
            public void onRefresh() {
                DataPack pack = logData.getDataPack();
                if (!FileHistoryUiFactory.this.myFilePath.isDirectory() && pack != DataPack.EMPTY && !pack.isFull()) {
                    return;
                }
                super.onRefresh();
            }
        }, this.myFilePath, this.myHash, this.myRoot);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logData";
                break;
            }
        }
        objectArray2[1] = "com/intellij/vcs/log/history/FileHistoryUiFactory";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createLogUi";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

