/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.openapi.util.Pair;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.data.VcsLogRefreshNotEnoughDataException;
import com.intellij.vcs.log.graph.GraphCommit;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.jetbrains.annotations.NotNull;

public class VcsLogJoiner<CommitId, Commit extends GraphCommit<CommitId>> {
    public static final String ILLEGAL_DATA_RELOAD_ALL = "All data is illegal - request reload all";

    @NotNull
    public Pair<List<Commit>, Integer> addCommits(@NotNull List<? extends Commit> savedLog, @NotNull Collection<? extends CommitId> previousRefs, @NotNull List<? extends Commit> firstBlock, @NotNull Collection<? extends CommitId> newRefs) {
        if (savedLog == null) {
            VcsLogJoiner.$$$reportNull$$$0(0);
        }
        if (previousRefs == null) {
            VcsLogJoiner.$$$reportNull$$$0(1);
        }
        if (firstBlock == null) {
            VcsLogJoiner.$$$reportNull$$$0(2);
        }
        if (newRefs == null) {
            VcsLogJoiner.$$$reportNull$$$0(3);
        }
        Pair<Integer, Set<? extends Commit>> newCommitsAndSavedGreenIndex = this.getNewCommitsAndSavedGreenIndex(savedLog, previousRefs, firstBlock, newRefs);
        Pair<Integer, Set<? extends CommitId>> redCommitsAndSavedRedIndex = this.getRedCommitsAndSavedRedIndex(savedLog, previousRefs, firstBlock, newRefs);
        Set removeCommits = (Set)redCommitsAndSavedRedIndex.second;
        Set allNewsCommits = (Set)newCommitsAndSavedGreenIndex.second;
        int unsafeBlockSize = Math.max((Integer)redCommitsAndSavedRedIndex.first, (Integer)newCommitsAndSavedGreenIndex.first);
        List<GraphCommit> unsafePartSavedLog = new ArrayList();
        for (GraphCommit commit2 : savedLog.subList(0, unsafeBlockSize)) {
            if (removeCommits.contains(commit2.getId())) continue;
            unsafePartSavedLog.add(commit2);
        }
        unsafePartSavedLog = new NewCommitIntegrator(unsafePartSavedLog, allNewsCommits).getResultList();
        Pair pair = Pair.create((Object)ContainerUtil.concat(unsafePartSavedLog, savedLog.subList(unsafeBlockSize, savedLog.size())), (Object)(unsafePartSavedLog.size() - unsafeBlockSize));
        if (pair == null) {
            VcsLogJoiner.$$$reportNull$$$0(4);
        }
        return pair;
    }

    @NotNull
    private Pair<Integer, Set<Commit>> getNewCommitsAndSavedGreenIndex(@NotNull List<? extends Commit> savedLog, @NotNull Collection<? extends CommitId> previousRefs, @NotNull List<? extends Commit> firstBlock, @NotNull Collection<? extends CommitId> newRefs) {
        if (savedLog == null) {
            VcsLogJoiner.$$$reportNull$$$0(5);
        }
        if (previousRefs == null) {
            VcsLogJoiner.$$$reportNull$$$0(6);
        }
        if (firstBlock == null) {
            VcsLogJoiner.$$$reportNull$$$0(7);
        }
        if (newRefs == null) {
            VcsLogJoiner.$$$reportNull$$$0(8);
        }
        THashSet allUnresolvedLinkedHashes = new THashSet(newRefs);
        allUnresolvedLinkedHashes.removeAll(previousRefs);
        for (GraphCommit commit2 : firstBlock) {
            allUnresolvedLinkedHashes.add(commit2.getId());
            allUnresolvedLinkedHashes.addAll(commit2.getParents());
        }
        for (GraphCommit commit2 : firstBlock) {
            if (commit2.getParents().size() == 0) continue;
            allUnresolvedLinkedHashes.remove(commit2.getId());
        }
        int saveGreenIndex = this.getFirstUnTrackedIndex((List<? extends Commit>)savedLog, (Set<CommitId>)allUnresolvedLinkedHashes);
        Pair pair = new Pair((Object)saveGreenIndex, this.getAllNewCommits(savedLog.subList(0, saveGreenIndex), firstBlock));
        if (pair == null) {
            VcsLogJoiner.$$$reportNull$$$0(9);
        }
        return pair;
    }

    private int getFirstUnTrackedIndex(@NotNull List<? extends Commit> commits, @NotNull Set<CommitId> searchHashes) {
        int lastIndex;
        if (commits == null) {
            VcsLogJoiner.$$$reportNull$$$0(10);
        }
        if (searchHashes == null) {
            VcsLogJoiner.$$$reportNull$$$0(11);
        }
        for (lastIndex = 0; lastIndex < commits.size(); ++lastIndex) {
            GraphCommit commit2 = (GraphCommit)commits.get(lastIndex);
            if (searchHashes.size() == 0) {
                return lastIndex;
            }
            searchHashes.remove(commit2.getId());
        }
        if (searchHashes.size() != 0) {
            throw new VcsLogRefreshNotEnoughDataException();
        }
        return lastIndex;
    }

    private Set<Commit> getAllNewCommits(@NotNull List<? extends Commit> unsafeGreenPartSavedLog, @NotNull List<? extends Commit> firstBlock) {
        if (unsafeGreenPartSavedLog == null) {
            VcsLogJoiner.$$$reportNull$$$0(12);
        }
        if (firstBlock == null) {
            VcsLogJoiner.$$$reportNull$$$0(13);
        }
        HashSet existedCommitHashes = ContainerUtil.newHashSet();
        for (GraphCommit commit2 : unsafeGreenPartSavedLog) {
            existedCommitHashes.add(commit2.getId());
        }
        HashSet allNewsCommits = ContainerUtil.newHashSet();
        for (GraphCommit newCommit : firstBlock) {
            if (existedCommitHashes.contains(newCommit.getId())) continue;
            allNewsCommits.add(newCommit);
        }
        return allNewsCommits;
    }

    @NotNull
    private Pair<Integer, Set<CommitId>> getRedCommitsAndSavedRedIndex(@NotNull List<? extends Commit> savedLog, @NotNull Collection<? extends CommitId> previousRefs, @NotNull List<? extends Commit> firstBlock, @NotNull Collection<? extends CommitId> newRefs) {
        if (savedLog == null) {
            VcsLogJoiner.$$$reportNull$$$0(14);
        }
        if (previousRefs == null) {
            VcsLogJoiner.$$$reportNull$$$0(15);
        }
        if (firstBlock == null) {
            VcsLogJoiner.$$$reportNull$$$0(16);
        }
        if (newRefs == null) {
            VcsLogJoiner.$$$reportNull$$$0(17);
        }
        THashSet startRedCommits = new THashSet(previousRefs);
        startRedCommits.removeAll(newRefs);
        THashSet startGreenNodes = new THashSet(newRefs);
        for (GraphCommit commit2 : firstBlock) {
            startGreenNodes.add(commit2.getId());
            startGreenNodes.addAll(commit2.getParents());
        }
        RedGreenSorter sorter = new RedGreenSorter((Set)startRedCommits, (Set)startGreenNodes, savedLog);
        int saveRegIndex = sorter.getFirstSaveIndex();
        Pair pair = new Pair((Object)saveRegIndex, sorter.getAllRedCommit());
        if (pair == null) {
            VcsLogJoiner.$$$reportNull$$$0(18);
        }
        return pair;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 9: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 9: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "savedLog";
                break;
            }
            case 1: 
            case 6: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "previousRefs";
                break;
            }
            case 2: 
            case 7: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "firstBlock";
                break;
            }
            case 3: 
            case 8: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newRefs";
                break;
            }
            case 4: 
            case 9: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/data/VcsLogJoiner";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commits";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchHashes";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unsafeGreenPartSavedLog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/data/VcsLogJoiner";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "addCommits";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getNewCommitsAndSavedGreenIndex";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getRedCommitsAndSavedRedIndex";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addCommits";
                break;
            }
            case 4: 
            case 9: 
            case 18: {
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getNewCommitsAndSavedGreenIndex";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getFirstUnTrackedIndex";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getAllNewCommits";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getRedCommitsAndSavedRedIndex";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 9: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class NewCommitIntegrator<CommitId, Commit extends GraphCommit<CommitId>> {
        private final List<Commit> list;
        private final Map<CommitId, Commit> newCommitsMap;
        private final Stack<Commit> commitsStack;

        NewCommitIntegrator(@NotNull List<Commit> list2, @NotNull Collection<Commit> newCommits) {
            if (list2 == null) {
                NewCommitIntegrator.$$$reportNull$$$0(0);
            }
            if (newCommits == null) {
                NewCommitIntegrator.$$$reportNull$$$0(1);
            }
            this.list = list2;
            this.newCommitsMap = ContainerUtil.newHashMap();
            for (GraphCommit commit2 : newCommits) {
                this.newCommitsMap.put(commit2.getId(), commit2);
            }
            this.commitsStack = new Stack();
        }

        private void insertAllUseStack() {
            while (!this.newCommitsMap.isEmpty()) {
                this.visitCommit((GraphCommit)ObjectUtils.notNull((Object)ContainerUtil.getFirstItem(this.newCommitsMap.values())));
                while (!this.commitsStack.isEmpty()) {
                    GraphCommit someCommit;
                    int insertIndex;
                    GraphCommit currentCommit = (GraphCommit)this.commitsStack.peek();
                    boolean allParentsWereAdded = true;
                    for (Object parentHash : currentCommit.getParents()) {
                        GraphCommit parentCommit = (GraphCommit)this.newCommitsMap.get(parentHash);
                        if (parentCommit == null) continue;
                        this.visitCommit(parentCommit);
                        allParentsWereAdded = false;
                        break;
                    }
                    if (!allParentsWereAdded) continue;
                    THashSet parents = new THashSet((Collection)currentCommit.getParents());
                    for (insertIndex = 0; insertIndex < this.list.size() && !parents.contains((someCommit = (GraphCommit)this.list.get(insertIndex)).getId()) && someCommit.getTimestamp() >= currentCommit.getTimestamp(); ++insertIndex) {
                    }
                    this.list.add(insertIndex, currentCommit);
                    this.commitsStack.pop();
                }
            }
        }

        private void visitCommit(@NotNull Commit commit2) {
            if (commit2 == null) {
                NewCommitIntegrator.$$$reportNull$$$0(2);
            }
            this.commitsStack.push(commit2);
            this.newCommitsMap.remove(commit2.getId());
        }

        @NotNull
        public List<Commit> getResultList() {
            this.insertAllUseStack();
            List<Commit> list2 = this.list;
            if (list2 == null) {
                NewCommitIntegrator.$$$reportNull$$$0(3);
            }
            return list2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newCommits";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "commit";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/data/VcsLogJoiner$NewCommitIntegrator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/data/VcsLogJoiner$NewCommitIntegrator";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getResultList";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "visitCommit";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class RedGreenSorter<CommitId, Commit extends GraphCommit<CommitId>> {
        private final Set<? super CommitId> currentRed;
        private final Set<? super CommitId> currentGreen;
        private final Set<CommitId> allRedCommit = new THashSet();
        private final List<? extends Commit> savedLog;

        private RedGreenSorter(Set<? super CommitId> startRedNodes, Set<? super CommitId> startGreenNodes, List<? extends Commit> savedLog) {
            this.currentRed = startRedNodes;
            this.currentGreen = startGreenNodes;
            this.savedLog = savedLog;
        }

        private void markRealRedNode(@NotNull CommitId node) {
            if (node == null) {
                RedGreenSorter.$$$reportNull$$$0(0);
            }
            if (!this.currentRed.remove(node)) {
                throw new IllegalStateException(VcsLogJoiner.ILLEGAL_DATA_RELOAD_ALL);
            }
            this.allRedCommit.add(node);
        }

        private int getFirstSaveIndex() {
            for (int lastIndex = 0; lastIndex < this.savedLog.size(); ++lastIndex) {
                GraphCommit commit2 = (GraphCommit)this.savedLog.get(lastIndex);
                boolean isGreen = this.currentGreen.contains(commit2.getId());
                if (isGreen) {
                    this.currentRed.remove(commit2.getId());
                    this.currentGreen.addAll(commit2.getParents());
                } else {
                    this.markRealRedNode(commit2.getId());
                    this.currentRed.addAll(commit2.getParents());
                }
                if (!this.currentRed.isEmpty()) continue;
                return lastIndex + 1;
            }
            throw new IllegalStateException(VcsLogJoiner.ILLEGAL_DATA_RELOAD_ALL);
        }

        public Set<CommitId> getAllRedCommit() {
            return this.allRedCommit;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/vcs/log/data/VcsLogJoiner$RedGreenSorter", "markRealRedNode"));
        }
    }
}

