/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.VcsLogBranchFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class VcsLogBranchFilterImpl
implements VcsLogBranchFilter {
    @NotNull
    private final List<String> myBranches;
    @NotNull
    private final List<Pattern> myPatterns;
    @NotNull
    private final List<String> myExcludedBranches;
    @NotNull
    private final List<Pattern> myExcludedPatterns;

    protected VcsLogBranchFilterImpl(@NotNull List<String> branches, @NotNull List<Pattern> patterns, @NotNull List<String> excludedBranches, @NotNull List<Pattern> excludedPatterns) {
        if (branches == null) {
            VcsLogBranchFilterImpl.$$$reportNull$$$0(0);
        }
        if (patterns == null) {
            VcsLogBranchFilterImpl.$$$reportNull$$$0(1);
        }
        if (excludedBranches == null) {
            VcsLogBranchFilterImpl.$$$reportNull$$$0(2);
        }
        if (excludedPatterns == null) {
            VcsLogBranchFilterImpl.$$$reportNull$$$0(3);
        }
        this.myBranches = branches;
        this.myPatterns = patterns;
        this.myExcludedBranches = excludedBranches;
        this.myExcludedPatterns = excludedPatterns;
    }

    @Deprecated
    public VcsLogBranchFilterImpl(@NotNull Collection<String> branches, @NotNull Collection<String> excludedBranches) {
        if (branches == null) {
            VcsLogBranchFilterImpl.$$$reportNull$$$0(4);
        }
        if (excludedBranches == null) {
            VcsLogBranchFilterImpl.$$$reportNull$$$0(5);
        }
        this.myBranches = new ArrayList<String>(branches);
        this.myPatterns = new ArrayList<Pattern>();
        this.myExcludedBranches = new ArrayList<String>(excludedBranches);
        this.myExcludedPatterns = new ArrayList<Pattern>();
    }

    @NotNull
    public Collection<String> getTextPresentation() {
        ArrayList<String> result2 = new ArrayList<String>();
        result2.addAll(this.myBranches);
        result2.addAll(ContainerUtil.map(this.myPatterns, pattern -> pattern.pattern()));
        result2.addAll(ContainerUtil.map(this.myExcludedBranches, branchName -> "-" + branchName));
        result2.addAll(ContainerUtil.map(this.myExcludedPatterns, pattern -> "-" + pattern.pattern()));
        ArrayList<String> arrayList = result2;
        if (arrayList == null) {
            VcsLogBranchFilterImpl.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    public String toString() {
        String result2 = "";
        if (!this.myPatterns.isEmpty()) {
            result2 = result2 + "on patterns: " + StringUtil.join(this.myPatterns, (String)", ");
        }
        if (!this.myBranches.isEmpty()) {
            if (!result2.isEmpty()) {
                result2 = result2 + "; ";
            }
            result2 = result2 + "on branches: " + StringUtil.join(this.myBranches, (String)", ");
        }
        if (!this.myExcludedPatterns.isEmpty()) {
            if (result2.isEmpty()) {
                result2 = result2 + "; ";
            }
            result2 = result2 + "not on patterns: " + StringUtil.join(this.myExcludedPatterns, (String)", ");
        }
        if (!this.myExcludedBranches.isEmpty()) {
            if (result2.isEmpty()) {
                result2 = result2 + "; ";
            }
            result2 = result2 + "not on branches: " + StringUtil.join(this.myExcludedBranches, (String)", ");
        }
        return result2;
    }

    public boolean matches(@NotNull String name) {
        if (name == null) {
            VcsLogBranchFilterImpl.$$$reportNull$$$0(7);
        }
        return this.isIncluded(name) && !this.isExcluded(name);
    }

    private boolean isIncluded(@NotNull String name) {
        if (name == null) {
            VcsLogBranchFilterImpl.$$$reportNull$$$0(8);
        }
        if (this.myPatterns.isEmpty() && this.myBranches.isEmpty()) {
            return true;
        }
        return VcsLogBranchFilterImpl.isMatched(name, this.myBranches, this.myPatterns);
    }

    private boolean isExcluded(@NotNull String name) {
        if (name == null) {
            VcsLogBranchFilterImpl.$$$reportNull$$$0(9);
        }
        return VcsLogBranchFilterImpl.isMatched(name, this.myExcludedBranches, this.myExcludedPatterns);
    }

    private static boolean isMatched(@NotNull String name, @NotNull List<String> branches, @NotNull List<Pattern> patterns) {
        if (name == null) {
            VcsLogBranchFilterImpl.$$$reportNull$$$0(10);
        }
        if (branches == null) {
            VcsLogBranchFilterImpl.$$$reportNull$$$0(11);
        }
        if (patterns == null) {
            VcsLogBranchFilterImpl.$$$reportNull$$$0(12);
        }
        if (branches.contains(name)) {
            return true;
        }
        for (Pattern regexp : patterns) {
            if (!regexp.matcher(name).matches()) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branches";
                break;
            }
            case 1: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patterns";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludedBranches";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludedPatterns";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/data/VcsLogBranchFilterImpl";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/data/VcsLogBranchFilterImpl";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextPresentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "matches";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isIncluded";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isExcluded";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isMatched";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

