/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usageView;

import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.GeneratedSourcesFilter;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiReference;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.MoveRenameUsageInfo;
import com.intellij.refactoring.util.NonCodeUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewLongNameLocation;
import com.intellij.usageView.UsageViewNodeTextLocation;
import com.intellij.usageView.UsageViewShortNameLocation;
import com.intellij.usageView.UsageViewTypeLocation;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageView;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class UsageViewUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.usageView.UsageViewUtil");

    private UsageViewUtil() {
    }

    @NotNull
    public static String createNodeText(@NotNull PsiElement element) {
        if (element == null) {
            UsageViewUtil.$$$reportNull$$$0(0);
        }
        String string = ElementDescriptionUtil.getElementDescription((PsiElement)element, (ElementDescriptionLocation)UsageViewNodeTextLocation.INSTANCE);
        if (string == null) {
            UsageViewUtil.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public static String getShortName(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            UsageViewUtil.$$$reportNull$$$0(2);
        }
        LOG.assertTrue(psiElement.isValid(), (Object)psiElement);
        String string = ElementDescriptionUtil.getElementDescription((PsiElement)psiElement, (ElementDescriptionLocation)UsageViewShortNameLocation.INSTANCE);
        if (string == null) {
            UsageViewUtil.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public static String getLongName(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            UsageViewUtil.$$$reportNull$$$0(4);
        }
        LOG.assertTrue(psiElement.isValid(), (Object)psiElement);
        String string = ElementDescriptionUtil.getElementDescription((PsiElement)psiElement, (ElementDescriptionLocation)UsageViewLongNameLocation.INSTANCE);
        if (string == null) {
            UsageViewUtil.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public static String getType(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            UsageViewUtil.$$$reportNull$$$0(6);
        }
        String string = ElementDescriptionUtil.getElementDescription((PsiElement)psiElement, (ElementDescriptionLocation)UsageViewTypeLocation.INSTANCE);
        if (string == null) {
            UsageViewUtil.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static boolean hasNonCodeUsages(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            UsageViewUtil.$$$reportNull$$$0(8);
        }
        for (UsageInfo usage : usages) {
            if (!usage.isNonCodeUsage) continue;
            return true;
        }
        return false;
    }

    private static boolean hasUsagesInGeneratedCode(@NotNull UsageInfo[] usages, @NotNull Project project) {
        if (usages == null) {
            UsageViewUtil.$$$reportNull$$$0(9);
        }
        if (project == null) {
            UsageViewUtil.$$$reportNull$$$0(10);
        }
        for (UsageInfo usage : usages) {
            VirtualFile file2 = usage.getVirtualFile();
            if (file2 == null || !GeneratedSourcesFilter.isGeneratedSourceByAnyFilter((VirtualFile)file2, (Project)project)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasReadOnlyUsages(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            UsageViewUtil.$$$reportNull$$$0(11);
        }
        for (UsageInfo usage : usages) {
            if (usage.isWritable()) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static UsageInfo[] removeDuplicatedUsages(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            UsageViewUtil.$$$reportNull$$$0(12);
        }
        LinkedHashSet<UsageInfo> set2 = new LinkedHashSet<UsageInfo>(Arrays.asList(usages));
        String newTextInNonCodeUsage = Arrays.stream(usages).filter(usage -> usage instanceof NonCodeUsageInfo).map(usage -> ((NonCodeUsageInfo)usage).newText).findFirst().orElse(null);
        if (newTextInNonCodeUsage != null) {
            for (UsageInfo usage2 : usages) {
                PsiReference psiReference;
                PsiElement usageElement;
                PsiLanguageInjectionHost context;
                PsiFile file2;
                if (!(usage2 instanceof MoveRenameUsageInfo) || (file2 = usage2.getFile()) == null || (context = InjectedLanguageManager.getInstance((Project)file2.getProject()).getInjectionHost((PsiElement)file2)) == null || (usageElement = usage2.getElement()) == null || (psiReference = usage2.getReference()) == null) continue;
                int injectionOffsetInMasterFile = InjectedLanguageManager.getInstance((Project)usageElement.getProject()).injectedToHost(usageElement, usageElement.getTextOffset());
                ProperTextRange rangeInElement = usage2.getRangeInElement();
                assert (rangeInElement != null) : usage2;
                TextRange range2 = rangeInElement.shiftRight(injectionOffsetInMasterFile);
                PsiFile containingFile = context.getContainingFile();
                if (containingFile == null) continue;
                set2.remove(NonCodeUsageInfo.create((PsiFile)containingFile, (int)range2.getStartOffset(), (int)range2.getEndOffset(), (PsiElement)((MoveRenameUsageInfo)usage2).getReferencedElement(), (String)newTextInNonCodeUsage));
            }
        }
        UsageInfo[] usageInfoArray = set2.toArray(UsageInfo.EMPTY_ARRAY);
        if (usageInfoArray == null) {
            UsageViewUtil.$$$reportNull$$$0(13);
        }
        return usageInfoArray;
    }

    @NotNull
    public static UsageInfo[] toUsageInfoArray(@NotNull Collection<? extends UsageInfo> collection) {
        int size;
        if (collection == null) {
            UsageViewUtil.$$$reportNull$$$0(14);
        }
        UsageInfo[] usageInfoArray = (size = collection.size()) == 0 ? UsageInfo.EMPTY_ARRAY : collection.toArray(new UsageInfo[size]);
        if (usageInfoArray == null) {
            UsageViewUtil.$$$reportNull$$$0(15);
        }
        return usageInfoArray;
    }

    @NotNull
    public static PsiElement[] toElements(@NotNull UsageInfo[] usageInfos) {
        if (usageInfos == null) {
            UsageViewUtil.$$$reportNull$$$0(16);
        }
        PsiElement[] psiElementArray = (PsiElement[])ContainerUtil.map2Array((Object[])usageInfos, PsiElement.class, UsageInfo::getElement);
        if (psiElementArray == null) {
            UsageViewUtil.$$$reportNull$$$0(17);
        }
        return psiElementArray;
    }

    public static void navigateTo(@NotNull UsageInfo info, boolean requestFocus) {
        if (info == null) {
            UsageViewUtil.$$$reportNull$$$0(18);
        }
        int offset = info.getNavigationOffset();
        VirtualFile file2 = info.getVirtualFile();
        Project project = info.getProject();
        if (file2 != null) {
            FileEditorManager.getInstance((Project)project).openTextEditor(new OpenFileDescriptor(project, file2, offset), requestFocus);
        }
    }

    @NotNull
    public static Set<UsageInfo> getNotExcludedUsageInfos(@NotNull UsageView usageView) {
        if (usageView == null) {
            UsageViewUtil.$$$reportNull$$$0(19);
        }
        Set excludedUsages = usageView.getExcludedUsages();
        LinkedHashSet<UsageInfo> usageInfos = new LinkedHashSet<UsageInfo>();
        for (Usage usage : usageView.getUsages()) {
            if (!(usage instanceof UsageInfo2UsageAdapter) || excludedUsages.contains(usage)) continue;
            UsageInfo usageInfo = ((UsageInfo2UsageAdapter)usage).getUsageInfo();
            usageInfos.add(usageInfo);
        }
        LinkedHashSet<UsageInfo> linkedHashSet = usageInfos;
        if (linkedHashSet == null) {
            UsageViewUtil.$$$reportNull$$$0(20);
        }
        return linkedHashSet;
    }

    public static boolean reportNonRegularUsages(@NotNull UsageInfo[] usages, @NotNull Project project) {
        if (usages == null) {
            UsageViewUtil.$$$reportNull$$$0(21);
        }
        if (project == null) {
            UsageViewUtil.$$$reportNull$$$0(22);
        }
        boolean inGeneratedCode = UsageViewUtil.hasUsagesInGeneratedCode(usages, project);
        if (UsageViewUtil.hasNonCodeUsages(usages) || inGeneratedCode) {
            StatusBar statusBar = WindowManager.getInstance().getStatusBar(project);
            if (statusBar != null) {
                statusBar.setInfo(RefactoringBundle.message((String)(inGeneratedCode ? "occurrences.found.in.comments.strings.non.java.files.and.generated.code" : "occurrences.found.in.comments.strings.and.non.java.files")));
            }
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 13: 
            case 15: 
            case 17: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 13: 
            case 15: 
            case 17: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 13: 
            case 15: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/usageView/UsageViewUtil";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 10: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageInfos";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageView";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/usageView/UsageViewUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createNodeText";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getLongName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "removeDuplicatedUsages";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "toUsageInfoArray";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "toElements";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotExcludedUsageInfos";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createNodeText";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 13: 
            case 15: 
            case 17: 
            case 20: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getShortName";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getLongName";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "hasNonCodeUsages";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "hasUsagesInGeneratedCode";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "hasReadOnlyUsages";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "removeDuplicatedUsages";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "toUsageInfoArray";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "toElements";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "navigateTo";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getNotExcludedUsageInfos";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "reportNonRegularUsages";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 13: 
            case 15: 
            case 17: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

