/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.notification.impl.NotificationsConfigurationImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.GrowlNotifications;
import com.intellij.ui.LibNotifyWrapper;
import com.intellij.ui.MountainLionNotifications;
import com.intellij.ui.SystemNotifications;
import com.intellij.ui.SystemTrayNotifications;
import org.jetbrains.annotations.NotNull;

public class SystemNotificationsImpl
extends SystemNotifications {
    private final Notifier myNotifier = SystemNotificationsImpl.getPlatformNotifier();

    @Override
    public boolean isAvailable() {
        return this.myNotifier != null;
    }

    @Override
    public void notify(@NotNull String notificationName, @NotNull String title, @NotNull String text) {
        if (notificationName == null) {
            SystemNotificationsImpl.$$$reportNull$$$0(0);
        }
        if (title == null) {
            SystemNotificationsImpl.$$$reportNull$$$0(1);
        }
        if (text == null) {
            SystemNotificationsImpl.$$$reportNull$$$0(2);
        }
        if (this.myNotifier != null && NotificationsConfigurationImpl.getInstanceImpl().SYSTEM_NOTIFICATIONS && !ApplicationManager.getApplication().isActive()) {
            this.myNotifier.notify(notificationName, title, text);
        }
    }

    private static Notifier getPlatformNotifier() {
        try {
            if (SystemInfo.isMac) {
                if (SystemInfo.isMacOSMountainLion && Registry.is((String)"ide.mac.mountain.lion.notifications.enabled")) {
                    return MountainLionNotifications.getInstance();
                }
                if (!Boolean.getBoolean("growl.disable")) {
                    return GrowlNotifications.getInstance();
                }
            }
            if (SystemInfo.isXWindow && Registry.is((String)"ide.libnotify.enabled")) {
                return LibNotifyWrapper.getInstance();
            }
            if (SystemInfo.isWin10OrNewer && Registry.is((String)"ide.system.tray.enabled")) {
                return SystemTrayNotifications.getWin10Instance();
            }
        }
        catch (Throwable t) {
            Logger logger = Logger.getInstance(SystemNotifications.class);
            if (logger.isDebugEnabled()) {
                logger.debug(t);
            }
            logger.info(t.getMessage());
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "notificationName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "title";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "text";
                break;
            }
        }
        objectArray[1] = "com/intellij/ui/SystemNotificationsImpl";
        objectArray[2] = "notify";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static interface Notifier {
        public void notify(@NotNull String var1, @NotNull String var2, @NotNull String var3);
    }
}

