/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.impl;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.tasks.CommitPlaceholderProvider;
import com.intellij.tasks.LocalTask;
import com.intellij.tasks.Task;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.impl.LocalTaskImpl;
import com.intellij.util.Function;
import com.intellij.util.JdomKt;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.DateFormatUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TaskUtil {
    private static final Pattern ISO8601_DATE_PATTERN = Pattern.compile("(\\d{4}[/-]\\d{2}[/-]\\d{2})(?:[ T](\\d{2}:\\d{2}:\\d{2})(.\\d{3,})?(?:\\s?([+-]\\d{2}:\\d{2}|[+-]\\d{4}|[+-]\\d{2}|Z))?)?");

    private TaskUtil() {
    }

    public static String formatTask(@NotNull Task task2, String format) {
        if (task2 == null) {
            TaskUtil.$$$reportNull$$$0(0);
        }
        Map map2 = TaskUtil.formatFromExtensions((LocalTask)(task2 instanceof LocalTask ? (LocalTask)task2 : new LocalTaskImpl(task2)));
        format = TaskUtil.updateToVelocity(format);
        try {
            return FileTemplateUtil.mergeTemplate(map2, format, false);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static Map formatFromExtensions(@NotNull LocalTask task2) {
        if (task2 == null) {
            TaskUtil.$$$reportNull$$$0(1);
        }
        HashMap<String, String> map2 = new HashMap<String, String>();
        for (CommitPlaceholderProvider extension : CommitPlaceholderProvider.EXTENSION_POINT_NAME.getExtensionList()) {
            String[] placeholders;
            for (String placeholder : placeholders = extension.getPlaceholders(task2.getRepository())) {
                String value = extension.getPlaceholderValue(task2, placeholder);
                if (value == null) continue;
                map2.put(placeholder, value);
            }
        }
        return map2;
    }

    public static String getChangeListComment(Task task2) {
        return TaskUtil.getChangeListComment(task2, false);
    }

    @Nullable
    public static String getChangeListComment(Task task2, boolean forCommit) {
        TaskRepository repository = task2.getRepository();
        if (repository == null || !repository.isShouldFormatCommitMessage()) {
            return null;
        }
        return TaskUtil.formatTask(task2, repository.getCommitMessageFormat());
    }

    public static String getTrimmedSummary(Task task2) {
        String text = task2.isIssue() ? task2.getPresentableId() + ": " + task2.getSummary() : task2.getSummary();
        return StringUtil.first((String)text, (int)60, (boolean)true);
    }

    @Nullable
    public static Date parseDate(@NotNull String s) {
        String milliseconds;
        Matcher m;
        if (s == null) {
            TaskUtil.$$$reportNull$$$0(2);
        }
        if (!(m = ISO8601_DATE_PATTERN.matcher(s)).matches()) {
            return null;
        }
        String datePart = m.group(1).replace('/', '-');
        String timePart = m.group(2);
        if (timePart == null) {
            timePart = "00:00:00";
        }
        milliseconds = (milliseconds = m.group(3)) == null ? "000" : milliseconds.substring(1, 4);
        String timezone = m.group(4);
        if (timezone == null || timezone.equals("Z")) {
            timezone = "+0000";
        } else if (timezone.length() == 3) {
            timezone = timezone + "00";
        } else if (timezone.length() == 6) {
            timezone = timezone.substring(0, 3) + timezone.substring(4, 6);
        }
        String canonicalForm = String.format("%sT%s.%s%s", datePart, timePart, milliseconds, timezone);
        try {
            return DateFormatUtil.getIso8601Format().parse(canonicalForm);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static String formatDate(@NotNull Date date) {
        if (date == null) {
            TaskUtil.$$$reportNull$$$0(3);
        }
        return DateFormatUtil.getIso8601Format().format(date);
    }

    public static boolean tasksEqual(@NotNull Task t1, @NotNull Task t2) {
        if (t1 == null) {
            TaskUtil.$$$reportNull$$$0(4);
        }
        if (t2 == null) {
            TaskUtil.$$$reportNull$$$0(5);
        }
        if (!t1.getId().equals(t2.getId())) {
            return false;
        }
        if (!t1.getSummary().equals(t2.getSummary())) {
            return false;
        }
        if (t1.isClosed() != t2.isClosed()) {
            return false;
        }
        if (t1.isIssue() != t2.isIssue()) {
            return false;
        }
        if (!Comparing.equal((Object)t1.getState(), (Object)t2.getState())) {
            return false;
        }
        if (!Comparing.equal((Object)t1.getType(), (Object)t2.getType())) {
            return false;
        }
        if (!Comparing.equal((String)t1.getDescription(), (String)t2.getDescription())) {
            return false;
        }
        if (!Comparing.equal((Object)t1.getCreated(), (Object)t2.getCreated())) {
            return false;
        }
        if (!Comparing.equal((Object)t1.getUpdated(), (Object)t2.getUpdated())) {
            return false;
        }
        if (!Comparing.equal((String)t1.getIssueUrl(), (String)t2.getIssueUrl())) {
            return false;
        }
        if (!Comparing.equal((Object[])t1.getComments(), (Object[])t2.getComments())) {
            return false;
        }
        if (!Comparing.equal((Object)t1.getIcon(), (Object)t2.getIcon())) {
            return false;
        }
        if (!Comparing.equal((String)t1.getCustomIcon(), (String)t2.getCustomIcon())) {
            return false;
        }
        return Comparing.equal((Object)t1.getRepository(), (Object)t2.getRepository());
    }

    public static boolean tasksEqual(@NotNull List<? extends Task> tasks1, @NotNull List<? extends Task> tasks2) {
        if (tasks1 == null) {
            TaskUtil.$$$reportNull$$$0(6);
        }
        if (tasks2 == null) {
            TaskUtil.$$$reportNull$$$0(7);
        }
        if (tasks1.size() != tasks2.size()) {
            return false;
        }
        for (int i = 0; i < tasks1.size(); ++i) {
            if (TaskUtil.tasksEqual(tasks1.get(i), tasks2.get(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean tasksEqual(@NotNull Task[] task1, @NotNull Task[] task2) {
        if (task1 == null) {
            TaskUtil.$$$reportNull$$$0(8);
        }
        if (task2 == null) {
            TaskUtil.$$$reportNull$$$0(9);
        }
        return TaskUtil.tasksEqual(Arrays.asList(task1), Arrays.asList(task2));
    }

    public static void prettyFormatXmlToLog(@NotNull Logger logger, @NotNull Element element) {
        if (logger == null) {
            TaskUtil.$$$reportNull$$$0(10);
        }
        if (element == null) {
            TaskUtil.$$$reportNull$$$0(11);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("\n" + JDOMUtil.createOutputter((String)"\n").outputString(element));
        }
    }

    public static void prettyFormatXmlToLog(@NotNull Logger logger, @NotNull InputStream xml) {
        if (logger == null) {
            TaskUtil.$$$reportNull$$$0(12);
        }
        if (xml == null) {
            TaskUtil.$$$reportNull$$$0(13);
        }
        if (logger.isDebugEnabled()) {
            try {
                logger.debug("\n" + JDOMUtil.createOutputter((String)"\n").outputString(JDOMUtil.load((InputStream)xml)));
            }
            catch (Exception e) {
                logger.debug((Throwable)e);
            }
        }
    }

    public static void prettyFormatXmlToLog(@NotNull Logger logger, @NotNull String xml) {
        if (logger == null) {
            TaskUtil.$$$reportNull$$$0(14);
        }
        if (xml == null) {
            TaskUtil.$$$reportNull$$$0(15);
        }
        if (logger.isDebugEnabled()) {
            try {
                logger.debug("\n" + JDOMUtil.createOutputter((String)"\n").outputString(JdomKt.loadElement((CharSequence)xml)));
            }
            catch (Exception e) {
                logger.debug((Throwable)e);
            }
        }
    }

    public static void prettyFormatJsonToLog(@NotNull Logger logger, @NotNull String json) {
        if (logger == null) {
            TaskUtil.$$$reportNull$$$0(16);
        }
        if (json == null) {
            TaskUtil.$$$reportNull$$$0(17);
        }
        if (logger.isDebugEnabled()) {
            try {
                Gson gson2 = new GsonBuilder().setPrettyPrinting().create();
                logger.debug("\n" + gson2.toJson((JsonElement)gson2.fromJson(json, JsonElement.class)));
            }
            catch (JsonSyntaxException e) {
                logger.debug("Malformed JSON\n" + json);
            }
        }
    }

    public static void prettyFormatJsonToLog(@NotNull Logger logger, @NotNull JsonElement json) {
        if (logger == null) {
            TaskUtil.$$$reportNull$$$0(18);
        }
        if (json == null) {
            TaskUtil.$$$reportNull$$$0(19);
        }
        if (logger.isDebugEnabled()) {
            try {
                Gson gson2 = new GsonBuilder().setPrettyPrinting().create();
                logger.debug("\n" + gson2.toJson(json));
            }
            catch (JsonSyntaxException e) {
                logger.debug("Malformed JSON\n" + json);
            }
        }
    }

    @NotNull
    public static String encodeUrl(@NotNull String s) {
        String string;
        if (s == null) {
            TaskUtil.$$$reportNull$$$0(20);
        }
        try {
            string = URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)"UTF-8 is not supported");
        }
        if (string == null) {
            TaskUtil.$$$reportNull$$$0(21);
        }
        return string;
    }

    public static List<Task> filterTasks(String pattern, List<? extends Task> tasks) {
        com.intellij.util.text.Matcher matcher = TaskUtil.getMatcher(pattern);
        return ContainerUtil.mapNotNull(tasks, (Function)((NullableFunction)task2 -> matcher.matches(task2.getPresentableId()) || matcher.matches(task2.getSummary()) ? task2 : null));
    }

    private static com.intellij.util.text.Matcher getMatcher(String pattern) {
        StringTokenizer tokenizer = new StringTokenizer(pattern, " ");
        StringBuilder builder2 = new StringBuilder();
        while (tokenizer.hasMoreTokens()) {
            String word = tokenizer.nextToken();
            builder2.append('*');
            builder2.append(word);
            builder2.append("* ");
        }
        return NameUtil.buildMatcher((String)builder2.toString(), (NameUtil.MatchingCaseSensitivity)NameUtil.MatchingCaseSensitivity.NONE);
    }

    static String updateToVelocity(String format) {
        return format.replaceAll("\\{", "\\$\\{").replaceAll("\\$\\$\\{", "\\$\\{");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 2: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "date";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t1";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t2";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tasks1";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tasks2";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task1";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task2";
                break;
            }
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logger";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xml";
                break;
            }
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "json";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/tasks/impl/TaskUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/tasks/impl/TaskUtil";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "encodeUrl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "formatTask";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "formatFromExtensions";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "parseDate";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "formatDate";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "tasksEqual";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "prettyFormatXmlToLog";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "prettyFormatJsonToLog";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "encodeUrl";
                break;
            }
            case 21: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

