/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.settings;

import com.intellij.ide.DataManager;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.ex.Settings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.profile.codeInspection.ui.ErrorsConfigurable;
import com.intellij.spellchecker.SpellCheckerManager;
import com.intellij.spellchecker.settings.CustomDictionariesPanel;
import com.intellij.spellchecker.settings.SpellCheckerSettings;
import com.intellij.spellchecker.util.SpellCheckerBundle;
import com.intellij.spellchecker.util.Strings;
import com.intellij.ui.AddDeleteListPanel;
import com.intellij.ui.HideableDecorator;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.OptionalChooserComponent;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;

public class SpellCheckerSettingsPane
implements Disposable {
    public static final int MIN_CORRECTIONS = 1;
    public static final int MAX_CORRECTIONS = 15;
    private JPanel root;
    private JPanel linkContainer;
    private JPanel myPanelForBundledDictionaries;
    private JPanel panelForAcceptedWords;
    private JPanel myPanelForCustomDictionaries;
    private JSpinner myMaxCorrectionsSpinner;
    private JBLabel myAddDictionaryLabel;
    private JBCheckBox myUseSingleDictionary;
    private ComboBox<String> myDictionariesComboBox;
    private JPanel myAdvancedSettingsPanel;
    private JPanel myAdvancedSettingsPlaceHolder;
    private final OptionalChooserComponent<String> myBundledDictionariesChooserComponent;
    private final CustomDictionariesPanel myDictionariesPanel;
    private final List<Pair<String, Boolean>> bundledDictionaries;
    private final WordsPanel wordsPanel;
    private final SpellCheckerManager manager;
    private final SpellCheckerSettings settings;
    private final HideableDecorator decorator;

    public SpellCheckerSettingsPane(final SpellCheckerSettings settings, Project project) {
        this.$$$setupUI$$$();
        this.bundledDictionaries = new ArrayList<Pair<String, Boolean>>();
        this.settings = settings;
        this.manager = SpellCheckerManager.getInstance(project);
        HyperlinkLabel link2 = new HyperlinkLabel(SpellCheckerBundle.message("link.to.inspection.settings", new Object[0]));
        link2.addHyperlinkListener(e -> {
            ErrorsConfigurable errorsConfigurable;
            Settings allSettings;
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && (allSettings = (Settings)Settings.KEY.getData(DataManager.getInstance().getDataContext())) != null && (errorsConfigurable = allSettings.find(ErrorsConfigurable.class)) != null) {
                allSettings.select(errorsConfigurable).doWhenDone(() -> errorsConfigurable.selectInspectionTool("SpellCheckingInspection"));
            }
        });
        this.myUseSingleDictionary.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SpellCheckerSettingsPane.this.myDictionariesComboBox.setEnabled(SpellCheckerSettingsPane.this.myUseSingleDictionary.isSelected());
            }
        });
        this.myAddDictionaryLabel.setText(SpellCheckerBundle.message("add.dictionary.description", new Object[0]) + SpellCheckerSettingsPane.getHunspellDescription());
        this.myMaxCorrectionsSpinner.setModel(new SpinnerNumberModel(1, 1, 15, 1));
        this.myDictionariesComboBox.addItem((Object)SpellCheckerManager.DictionaryLevel.APP.getName());
        this.myDictionariesComboBox.addItem((Object)SpellCheckerManager.DictionaryLevel.PROJECT.getName());
        this.linkContainer.setLayout(new BorderLayout());
        this.linkContainer.add((Component)link2);
        this.fillBundledDictionaries();
        this.myDictionariesPanel = new CustomDictionariesPanel(settings, project, this.manager);
        this.myPanelForCustomDictionaries.setLayout(new BorderLayout());
        this.myPanelForCustomDictionaries.add((Component)this.myDictionariesPanel, "Center");
        this.myBundledDictionariesChooserComponent = new OptionalChooserComponent<String>(this.bundledDictionaries){

            public JCheckBox createCheckBox(String path, boolean checked) {
                return new JCheckBox(FileUtil.toSystemDependentName((String)path), checked);
            }

            public void apply() {
                super.apply();
                HashSet<String> bundledDisabledDictionaries = new HashSet<String>();
                for (Pair pair : SpellCheckerSettingsPane.this.bundledDictionaries) {
                    if (((Boolean)pair.second).booleanValue()) continue;
                    bundledDisabledDictionaries.add((String)pair.first);
                }
                settings.setBundledDisabledDictionariesPaths(bundledDisabledDictionaries);
            }

            public void reset() {
                super.reset();
                SpellCheckerSettingsPane.this.fillBundledDictionaries();
            }
        };
        this.myPanelForBundledDictionaries.setLayout(new BorderLayout());
        this.myPanelForBundledDictionaries.add((Component)this.myBundledDictionariesChooserComponent.getContentPane(), "Center");
        this.myBundledDictionariesChooserComponent.getEmptyText().setText(SpellCheckerBundle.message("no.dictionaries", new Object[0]));
        this.wordsPanel = new WordsPanel(this.manager);
        this.panelForAcceptedWords.setLayout(new BorderLayout());
        this.panelForAcceptedWords.add((Component)((Object)this.wordsPanel), "Center");
        this.decorator = new HideableDecorator(this.myAdvancedSettingsPlaceHolder, SpellCheckerBundle.message("advanced.settings", new Object[0]), false);
        this.decorator.setContentComponent(this.myAdvancedSettingsPanel);
        this.decorator.setOn(!settings.isDefaultAdvancedSettings());
    }

    private static String getHunspellDescription() {
        PluginId hunspellId = PluginId.getId((String)"hunspell");
        IdeaPluginDescriptor ideaPluginDescriptor = PluginManager.getPlugin(hunspellId);
        if (PluginManager.isPluginInstalled(hunspellId) && ideaPluginDescriptor != null && ideaPluginDescriptor.isEnabled()) {
            return ", " + SpellCheckerBundle.message("hunspell.description", new Object[0]);
        }
        return "";
    }

    public JComponent getPane() {
        return this.root;
    }

    public boolean isModified() {
        return this.wordsPanel.isModified() || this.myBundledDictionariesChooserComponent.isModified() || this.myDictionariesPanel.isModified() || this.settings.getCorrectionsLimit() != this.getLimit() || this.settings.isUseSingleDictionaryToSave() != this.myUseSingleDictionary.isSelected() || this.settings.isUseSingleDictionaryToSave() && this.settings.getDictionaryToSave() != this.myDictionariesComboBox.getSelectedItem();
    }

    public void apply() throws ConfigurationException {
        if (this.wordsPanel.isModified()) {
            this.manager.updateUserDictionary(this.wordsPanel.getWords());
        }
        if (this.settings.getCorrectionsLimit() != this.getLimit()) {
            this.settings.setCorrectionsLimit(this.getLimit());
        }
        if (this.settings.isUseSingleDictionaryToSave() != this.myUseSingleDictionary.isSelected()) {
            this.settings.setUseSingleDictionaryToSave(this.myUseSingleDictionary.isSelected());
        }
        if (this.myUseSingleDictionary.isSelected() && this.settings.getDictionaryToSave() != this.myDictionariesComboBox.getSelectedItem()) {
            this.settings.setDictionaryToSave((String)this.myDictionariesComboBox.getSelectedItem());
        }
        SpellCheckerManager.restartInspections();
        if (!this.myBundledDictionariesChooserComponent.isModified() && !this.myDictionariesPanel.isModified()) {
            return;
        }
        this.myBundledDictionariesChooserComponent.apply();
        this.myDictionariesPanel.apply();
        this.manager.updateBundledDictionaries(this.myDictionariesPanel.getRemovedDictionaries());
    }

    private int getLimit() {
        return ((SpinnerNumberModel)this.myMaxCorrectionsSpinner.getModel()).getNumber().intValue();
    }

    public void reset() {
        this.myMaxCorrectionsSpinner.setValue(this.settings.getCorrectionsLimit());
        this.myUseSingleDictionary.setSelected(this.settings.isUseSingleDictionaryToSave());
        this.myDictionariesComboBox.setSelectedItem((Object)this.settings.getDictionaryToSave());
        this.myDictionariesComboBox.setEnabled(this.myUseSingleDictionary.isSelected());
        this.myDictionariesPanel.reset();
        this.myBundledDictionariesChooserComponent.reset();
    }

    private void fillBundledDictionaries() {
        this.bundledDictionaries.clear();
        for (String dictionary : SpellCheckerManager.getBundledDictionaries()) {
            this.bundledDictionaries.add((Pair<String, Boolean>)Pair.create((Object)dictionary, (Object)(!this.settings.getBundledDisabledDictionariesPaths().contains(dictionary) ? 1 : 0)));
        }
    }

    public void dispose() {
        if (this.wordsPanel != null) {
            Disposer.dispose((Disposable)this.wordsPanel);
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        ComboBox comboBox2;
        JBCheckBox jBCheckBox;
        JSpinner jSpinner;
        JPanel jPanel2;
        JPanel jPanel3;
        JBLabel jBLabel;
        JPanel jPanel4;
        JPanel jPanel5;
        JPanel jPanel6;
        JPanel jPanel7;
        this.root = jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel7.add((Component)jPanel8, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 1, null, null, null));
        this.linkContainer = jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel8.add((Component)jPanel6, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(24, 38), null));
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel7.add((Component)jPanel9, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 7, null, null, null));
        JBTabbedPane jBTabbedPane = new JBTabbedPane();
        jPanel9.add((Component)jBTabbedPane, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 7, null, new Dimension(200, 200), null));
        JPanel jPanel10 = new JPanel();
        jPanel10.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBTabbedPane.addTab("Dictionaries", null, jPanel10, null);
        JPanel jPanel11 = new JPanel();
        jPanel11.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel11.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel10.add((Component)jPanel11, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel11.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)ResourceBundle.getBundle("com/intellij/spellchecker/util/SpellCheckerBundle").getString("bundled.dictionaries.title"), (int)0, (int)0, null, null));
        this.myPanelForBundledDictionaries = jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel11.add((Component)jPanel5, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        jBLabel2.setFontColor(UIUtil.FontColor.BRIGHTER);
        this.$$$loadLabelText$$$((JLabel)jBLabel2, ResourceBundle.getBundle("com/intellij/spellchecker/util/SpellCheckerBundle").getString("dictionaries.panel.description"));
        jPanel11.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel12 = new JPanel();
        jPanel12.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel12.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel10.add((Component)jPanel12, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel12.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)ResourceBundle.getBundle("com/intellij/spellchecker/util/SpellCheckerBundle").getString("custom.dictionaries.title"), (int)0, (int)0, null, null));
        this.myPanelForCustomDictionaries = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel12.add((Component)jPanel4, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myAddDictionaryLabel = jBLabel = new JBLabel();
        jBLabel.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        jBLabel.setFontColor(UIUtil.FontColor.BRIGHTER);
        this.$$$loadLabelText$$$((JLabel)jBLabel, ResourceBundle.getBundle("com/intellij/spellchecker/util/SpellCheckerBundle").getString("add.dictionary.description"));
        jPanel12.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myAdvancedSettingsPlaceHolder = jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 0));
        jPanel10.add((Component)jPanel3, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myAdvancedSettingsPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel3.add((Component)jPanel2, "Center");
        JBLabel jBLabel3 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel3, ResourceBundle.getBundle("com/intellij/spellchecker/util/SpellCheckerBundle").getString("max.number.of.corrections"));
        jPanel2.add((Component)jBLabel3, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myMaxCorrectionsSpinner = jSpinner = new JSpinner();
        jPanel2.add((Component)jSpinner, new GridConstraints(1, 1, 1, 2, 8, 2, 2, 0, null, new Dimension(50, -1), null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myUseSingleDictionary = jBCheckBox = new JBCheckBox();
        jBCheckBox.setName("");
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, ResourceBundle.getBundle("com/intellij/spellchecker/util/SpellCheckerBundle").getString("use.single.dictionary"));
        jPanel2.add((Component)jBCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDictionariesComboBox = comboBox2 = new ComboBox();
        jPanel2.add((Component)comboBox2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel13 = new JPanel();
        jPanel13.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBTabbedPane.addTab("Accepted Words", null, jPanel13, null);
        this.panelForAcceptedWords = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel13.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.root;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static final class WordsPanel
    extends AddDeleteListPanel<String>
    implements Disposable {
        private final SpellCheckerManager manager;

        private WordsPanel(SpellCheckerManager manager) {
            super(null, ContainerUtil.sorted(manager.getUserDictionaryWords()));
            this.manager = manager;
            this.getEmptyText().setText(SpellCheckerBundle.message("no.words", new Object[0]));
        }

        protected String findItemToAdd() {
            String word = Messages.showInputDialog((String)SpellCheckerBundle.message("enter.simple.word", new Object[0]), (String)SpellCheckerBundle.message("add.new.word", new Object[0]), null);
            if (word == null) {
                return null;
            }
            if (Strings.isMixedCase(word = word.trim())) {
                Messages.showWarningDialog((String)SpellCheckerBundle.message("entered.word.0.is.mixed.cased.you.must.enter.simple.word", word), (String)SpellCheckerBundle.message("add.new.word", new Object[0]));
                return null;
            }
            if (!this.manager.hasProblem(word)) {
                Messages.showWarningDialog((String)SpellCheckerBundle.message("entered.word.0.is.correct.you.no.need.to.add.this.in.list", word), (String)SpellCheckerBundle.message("add.new.word", new Object[0]));
                return null;
            }
            return word;
        }

        public void dispose() {
            this.myListModel.removeAllElements();
        }

        @NotNull
        public List<String> getWords() {
            Object[] pairs = this.getListItems();
            if (pairs == null) {
                ArrayList<String> arrayList = new ArrayList<String>();
                if (arrayList == null) {
                    WordsPanel.$$$reportNull$$$0(0);
                }
                return arrayList;
            }
            ArrayList<String> words = new ArrayList<String>();
            for (Object pair : pairs) {
                words.add(pair.toString());
            }
            ArrayList<String> arrayList = words;
            if (arrayList == null) {
                WordsPanel.$$$reportNull$$$0(1);
            }
            return arrayList;
        }

        public boolean isModified() {
            List<String> newWords = this.getWords();
            Set<String> words = this.manager.getUserDictionaryWords();
            if (newWords.size() != words.size()) {
                return true;
            }
            return !words.containsAll(newWords) || !newWords.containsAll(words);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spellchecker/settings/SpellCheckerSettingsPane$WordsPanel", "getWords"));
        }
    }
}

