/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.semantic;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.patterns.ElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.semantic.SemContributor;
import com.intellij.semantic.SemContributorEP;
import com.intellij.semantic.SemElement;
import com.intellij.semantic.SemKey;
import com.intellij.semantic.SemRegistrar;
import com.intellij.semantic.SemService;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.ExtensionInstantiator;
import com.intellij.util.NullableFunction;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.IntObjectMap;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.messages.MessageBusConnection;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.picocontainer.PicoContainer;

public class SemServiceImpl
extends SemService {
    private static final Logger LOG = Logger.getInstance(SemServiceImpl.class);
    private final AtomicReference<ConcurrentMap<PsiElement, SemCacheChunk>> myCache = new AtomicReference();
    private volatile MultiMap<SemKey, NullableFunction<PsiElement, Collection<? extends SemElement>>> myProducers;
    private final Project myProject;
    private boolean myBulkChange = false;
    private final AtomicInteger myCreatingSem = new AtomicInteger(0);

    public SemServiceImpl(Project project, PsiManager psiManager) {
        this.myProject = project;
        MessageBusConnection connection = project.getMessageBus().connect();
        connection.subscribe(PsiModificationTracker.TOPIC, () -> {
            if (!this.isInsideAtomicChange()) {
                this.clearCache();
            }
        });
        ((PsiManagerEx)psiManager).registerRunnableToRunOnChange(() -> {
            if (!this.isInsideAtomicChange()) {
                this.clearCache();
            }
        });
        LowMemoryWatcher.register(() -> {
            if (this.myCreatingSem.get() == 0) {
                this.clearCache();
            }
        }, (Disposable)project);
    }

    private MultiMap<SemKey, NullableFunction<PsiElement, Collection<? extends SemElement>>> collectProducers() {
        final MultiMap map2 = MultiMap.createSmart();
        SemRegistrar registrar = new SemRegistrar(){

            public <T extends SemElement, V extends PsiElement> void registerSemElementProvider(SemKey<T> key, ElementPattern<? extends V> place, NullableFunction<? super V, ? extends T> provider) {
                map2.putValue(key, element -> {
                    if (place.accepts(element)) {
                        return Collections.singleton(provider.fun(element));
                    }
                    return null;
                });
            }

            public <T extends SemElement, V extends PsiElement> void registerRepeatableSemElementProvider(SemKey<T> key, ElementPattern<? extends V> place, NullableFunction<? super V, ? extends Collection<T>> provider) {
                map2.putValue(key, element -> {
                    if (place.accepts(element)) {
                        return (Collection)provider.fun(element);
                    }
                    return null;
                });
            }
        };
        for (SemContributorEP contributor : SemContributor.EP_NAME.getExtensionList()) {
            SemContributor semContributor;
            try {
                semContributor = (SemContributor)ExtensionInstantiator.instantiateWithPicoContainerOnlyIfNeeded((String)contributor.implementation, (PicoContainer)this.myProject.getPicoContainer(), (PluginDescriptor)contributor.getPluginDescriptor());
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
                continue;
            }
            semContributor.registerSemProviders(registrar, this.myProject);
        }
        return map2;
    }

    public void clearCache() {
        this.myCache.set(null);
    }

    public void performAtomicChange(@NotNull Runnable change) {
        if (change == null) {
            SemServiceImpl.$$$reportNull$$$0(0);
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        boolean oldValue = this.myBulkChange;
        this.myBulkChange = true;
        try {
            change.run();
        }
        finally {
            this.myBulkChange = oldValue;
            if (!oldValue) {
                this.clearCache();
            }
        }
    }

    public boolean isInsideAtomicChange() {
        return this.myBulkChange;
    }

    @Nullable
    public <T extends SemElement> List<T> getSemElements(@NotNull SemKey<T> key, @NotNull PsiElement psi) {
        List<T> cached;
        if (key == null) {
            SemServiceImpl.$$$reportNull$$$0(1);
        }
        if (psi == null) {
            SemServiceImpl.$$$reportNull$$$0(2);
        }
        if ((cached = this._getCachedSemElements(key, true, psi)) != null) {
            return cached;
        }
        this.ensureInitialized();
        RecursionGuard.StackStamp stamp = RecursionManager.createGuard((String)"semService").markStack();
        LinkedHashSet<SemElement> result2 = new LinkedHashSet<SemElement>();
        THashMap map2 = new THashMap();
        for (SemKey each : key.getInheritors()) {
            List<SemElement> list2 = this.createSemElements(each, psi);
            map2.put(each, list2);
            result2.addAll(list2);
        }
        if (stamp.mayCacheNow()) {
            SemCacheChunk persistent = this.getOrCreateChunk(psi);
            for (SemKey semKey : map2.keySet()) {
                persistent.putSemElements(semKey, (List)map2.get(semKey));
            }
        }
        return new ArrayList(result2);
    }

    private void ensureInitialized() {
        if (this.myProducers == null) {
            this.myProducers = this.collectProducers();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private List<SemElement> createSemElements(SemKey key, PsiElement psi) {
        SmartList result2 = null;
        Collection functions = this.myProducers.get((Object)key);
        if (!functions.isEmpty()) {
            for (NullableFunction producer : functions) {
                this.myCreatingSem.incrementAndGet();
                try {
                    Collection elements = (Collection)producer.fun((Object)psi);
                    if (elements == null) continue;
                    if (result2 == null) {
                        result2 = new SmartList();
                    }
                    ContainerUtil.addAllNotNull(result2, (Iterable)elements);
                }
                finally {
                    this.myCreatingSem.decrementAndGet();
                }
            }
        }
        List<Object> list2 = result2 == null ? Collections.emptyList() : Collections.unmodifiableList(result2);
        if (list2 == null) {
            SemServiceImpl.$$$reportNull$$$0(3);
        }
        return list2;
    }

    @Nullable
    public <T extends SemElement> List<T> getCachedSemElements(SemKey<T> key, @NotNull PsiElement psi) {
        if (psi == null) {
            SemServiceImpl.$$$reportNull$$$0(4);
        }
        return this._getCachedSemElements(key, false, psi);
    }

    @Nullable
    private <T extends SemElement> List<T> _getCachedSemElements(@NotNull SemKey<T> key, boolean paranoid, PsiElement element) {
        SemCacheChunk chunk;
        if (key == null) {
            SemServiceImpl.$$$reportNull$$$0(5);
        }
        if ((chunk = this.obtainChunk(element)) == null) {
            return null;
        }
        List<SemElement> singleList = null;
        LinkedHashSet<SemElement> result2 = null;
        List inheritors = key.getInheritors();
        for (int i = 0; i < inheritors.size(); ++i) {
            List<SemElement> cached = chunk.getSemElements((SemKey)inheritors.get(i));
            if (cached == null && paranoid) {
                return null;
            }
            if (cached == null || cached == Collections.emptyList()) continue;
            if (singleList == null) {
                singleList = cached;
                continue;
            }
            if (result2 == null) {
                result2 = new LinkedHashSet<SemElement>(singleList);
            }
            result2.addAll(cached);
        }
        if (result2 == null) {
            if (singleList != null) {
                return singleList;
            }
            return Collections.emptyList();
        }
        return new ArrayList(result2);
    }

    @Nullable
    private SemCacheChunk obtainChunk(@Nullable PsiElement root) {
        ConcurrentMap<PsiElement, SemCacheChunk> map2 = this.myCache.get();
        return map2 == null ? null : (SemCacheChunk)map2.get(root);
    }

    public <T extends SemElement> void setCachedSemElement(SemKey<T> key, @NotNull PsiElement psi, @Nullable T semElement) {
        if (psi == null) {
            SemServiceImpl.$$$reportNull$$$0(6);
        }
        this.getOrCreateChunk(psi).putSemElements(key, ContainerUtil.createMaybeSingletonList(semElement));
    }

    private SemCacheChunk getOrCreateChunk(PsiElement element) {
        SemCacheChunk chunk = this.obtainChunk(element);
        if (chunk == null) {
            ConcurrentMap map2 = this.myCache.get();
            if (map2 == null) {
                map2 = (ConcurrentMap)ConcurrencyUtil.cacheOrGet(this.myCache, (Object)ContainerUtil.createConcurrentWeakKeySoftValueMap());
            }
            chunk = (SemCacheChunk)ConcurrencyUtil.cacheOrGet((ConcurrentMap)map2, (Object)element, (Object)new SemCacheChunk());
        }
        return chunk;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/semantic/SemServiceImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/semantic/SemServiceImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createSemElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "performAtomicChange";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getSemElements";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getCachedSemElements";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "_getCachedSemElements";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setCachedSemElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class SemCacheChunk {
        private final IntObjectMap<List<SemElement>> map = ContainerUtil.createConcurrentIntObjectMap();

        private SemCacheChunk() {
        }

        public List<SemElement> getSemElements(SemKey<?> key) {
            return (List)this.map.get(key.getUniqueId());
        }

        public void putSemElements(SemKey<?> key, List<SemElement> elements) {
            this.map.put(key.getUniqueId(), elements);
        }

        public int hashCode() {
            return 0;
        }
    }
}

