/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.util;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.impl.runtime.ui.ServersToolWindowContent;
import com.intellij.remoteServer.impl.runtime.ui.tree.DeploymentNode;
import com.intellij.remoteServer.impl.runtime.ui.tree.actions.ServersTreeAction;
import com.intellij.remoteServer.runtime.Deployment;
import com.intellij.remoteServer.runtime.ServerConnection;
import com.intellij.remoteServer.runtime.ServerConnectionManager;
import com.intellij.remoteServer.util.CloudApplicationRuntime;
import com.intellij.util.ObjectUtils;
import java.util.Optional;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@Deprecated
@ApiStatus.ScheduledForRemoval(inVersion="2019.3")
public abstract class ApplicationActionBase<T extends CloudApplicationRuntime>
extends ServersTreeAction<DeploymentNode> {
    protected ApplicationActionBase(String text, String description, Icon icon) {
        super(text, description, icon);
    }

    protected Class<DeploymentNode> getTargetNodeClass() {
        return DeploymentNode.class;
    }

    protected Deployment getDeployment(@Nullable DeploymentNode node) {
        return node == null ? null : (Deployment)ObjectUtils.tryCast((Object)node.getValue(), Deployment.class);
    }

    protected T getApplicationRuntime(@Nullable DeploymentNode node) {
        return (T)((Object)((CloudApplicationRuntime)Optional.ofNullable(this.getDeployment(node)).map(Deployment::getRuntime).map(rt -> (CloudApplicationRuntime)((Object)((Object)ObjectUtils.tryCast((Object)rt, this.getApplicationRuntimeClass())))).orElse(null)));
    }

    protected static ServerConnection<?> getConnection(DeploymentNode node) {
        RemoteServer server = (RemoteServer)node.getServerNode().getValue();
        return ServerConnectionManager.getInstance().getConnection(server);
    }

    @Override
    protected boolean isVisible4(DeploymentNode node) {
        return this.getApplicationRuntime(node) != null;
    }

    protected abstract Class<T> getApplicationRuntimeClass();

    protected class SelectLogRunnable
    implements Runnable {
        private final ServersToolWindowContent myContent;
        private final DeploymentNode myNode;
        private final String myLogName;

        public SelectLogRunnable(ServersToolWindowContent content, DeploymentNode node, String logName) {
            this.myContent = content;
            this.myNode = node;
            this.myLogName = logName;
        }

        @Override
        public void run() {
            ServerConnection<?> connection = ApplicationActionBase.getConnection(this.myNode);
            if (connection == null) {
                return;
            }
            Deployment deployment = this.findDeployment(connection);
            if (deployment == null) {
                return;
            }
            ApplicationManager.getApplication().invokeLater(() -> this.myContent.select(connection, deployment.getName(), this.myLogName));
        }

        private Deployment findDeployment(ServerConnection<?> connection) {
            Object applicationRuntime = ApplicationActionBase.this.getApplicationRuntime(this.myNode);
            for (Deployment deployment : connection.getDeployments()) {
                if (applicationRuntime != deployment.getRuntime()) continue;
                return deployment;
            }
            return null;
        }
    }
}

