/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.impl.runtime.ui;

import com.intellij.execution.dashboard.TreeContent;
import com.intellij.ide.ui.SplitterProportionsDataImpl;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.NodeRenderer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.RemoteServerListener;
import com.intellij.remoteServer.impl.runtime.ui.RemoteServersViewContribution;
import com.intellij.remoteServer.impl.runtime.ui.ServersToolWindowMessagePanel;
import com.intellij.remoteServer.impl.runtime.ui.TreeNodeSelector;
import com.intellij.remoteServer.impl.runtime.ui.tree.ServersTreeNodeSelector;
import com.intellij.remoteServer.impl.runtime.ui.tree.ServersTreeStructure;
import com.intellij.remoteServer.impl.runtime.ui.tree.TreeBuilderBase;
import com.intellij.remoteServer.runtime.ConnectionStatus;
import com.intellij.remoteServer.runtime.ServerConnection;
import com.intellij.remoteServer.runtime.ServerConnectionListener;
import com.intellij.remoteServer.runtime.ServerConnectionManager;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.Alarm;
import com.intellij.util.ObjectUtils;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ServersToolWindowContent
extends JPanel
implements Disposable,
ServersTreeNodeSelector,
TreeContent {
    public static final DataKey<ServersToolWindowContent> KEY = DataKey.create((String)"serversToolWindowContent");
    @NonNls
    private static final String PLACE_TOOLBAR = "ServersToolWindowContent#Toolbar";
    @NonNls
    private static final String PLACE_TOOLBAR_TOP = "ServersToolWindowContent#Toolbar.Top";
    private static final String MESSAGE_CARD = "message";
    private static final String EMPTY_SELECTION_MESSAGE = "Select a server or deployment in the tree to view details";
    private static final int POLL_DEPLOYMENTS_DELAY = 2000;
    private final Tree myTree;
    private final CardLayout myPropertiesPanelLayout;
    private final JPanel myPropertiesPanel;
    private final MessagePanel myMessagePanel;
    private final Map<String, JComponent> myLogComponents;
    private final DefaultTreeModel myTreeModel;
    private TreeBuilderBase myBuilder;
    private AbstractTreeNode<?> myLastSelection;
    private final Set<Object> myCollapsedTreeNodeValues;
    private final Project myProject;
    private final RemoteServersViewContribution myContribution;
    private final Splitter mySplitter;

    @Deprecated
    public ServersToolWindowContent(@NotNull Project project, @NotNull RemoteServersViewContribution contribution) {
        if (project == null) {
            ServersToolWindowContent.$$$reportNull$$$0(0);
        }
        if (contribution == null) {
            ServersToolWindowContent.$$$reportNull$$$0(1);
        }
        this(project, contribution, ActionGroups.SHARED_ACTION_GROUPS);
    }

    public ServersToolWindowContent(@NotNull Project project, @NotNull RemoteServersViewContribution contribution, @NotNull ActionGroups actionGroups) {
        if (project == null) {
            ServersToolWindowContent.$$$reportNull$$$0(2);
        }
        if (contribution == null) {
            ServersToolWindowContent.$$$reportNull$$$0(3);
        }
        if (actionGroups == null) {
            ServersToolWindowContent.$$$reportNull$$$0(4);
        }
        super(new BorderLayout());
        this.myLogComponents = new HashMap<String, JComponent>();
        this.myCollapsedTreeNodeValues = new HashSet<Object>();
        this.myProject = project;
        this.myContribution = contribution;
        this.myTreeModel = new DefaultTreeModel(new DefaultMutableTreeNode());
        this.myTree = new Tree((TreeModel)this.myTreeModel);
        this.myTree.setRootVisible(false);
        this.myTree.setShowsRootHandles(true);
        this.myTree.setCellRenderer((TreeCellRenderer)new NodeRenderer());
        this.myTree.setLineStyleAngled();
        this.getMainPanel().add((Component)this.createTopToolbar(actionGroups.getSecondaryToolbarID()), "North");
        this.getMainPanel().add((Component)this.createMainToolbar(actionGroups.getMainToolbarID()), "West");
        this.mySplitter = new Splitter(false, 0.3f);
        this.mySplitter.setFirstComponent((JComponent)ScrollPaneFactory.createScrollPane((Component)this.myTree, (int)1));
        this.myPropertiesPanelLayout = new CardLayout();
        this.myPropertiesPanel = new JPanel(this.myPropertiesPanelLayout);
        this.myMessagePanel = new ServersToolWindowMessagePanel();
        this.myMessagePanel.setEmptyText(EMPTY_SELECTION_MESSAGE);
        this.myPropertiesPanel.add(MESSAGE_CARD, this.myMessagePanel.getComponent());
        this.mySplitter.setSecondComponent((JComponent)this.myPropertiesPanel);
        this.getMainPanel().add((Component)this.mySplitter, "Center");
        this.setupBuilder(project);
        contribution.setupTree(this.myProject, this.myTree, this.myBuilder);
        this.myTree.addTreeSelectionListener(e -> this.onSelectionChanged());
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent event) {
                AnAction connectAction = ActionManager.getInstance().getAction("RemoteServers.ConnectServer");
                AnActionEvent actionEvent = AnActionEvent.createFromInputEvent((AnAction)connectAction, (InputEvent)event, (String)"unknown");
                connectAction.actionPerformed(actionEvent);
                return true;
            }
        }.installOn((Component)this.myTree);
        this.myTree.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                Object value = this.getNodeValue(event);
                if (value != null) {
                    ServersToolWindowContent.this.myCollapsedTreeNodeValues.remove(value);
                }
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
                Object value = this.getNodeValue(event);
                if (value != null) {
                    ServersToolWindowContent.this.myCollapsedTreeNodeValues.add(value);
                }
            }

            private Object getNodeValue(TreeExpansionEvent event) {
                DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)ObjectUtils.tryCast((Object)event.getPath().getLastPathComponent(), DefaultMutableTreeNode.class);
                if (treeNode == null) {
                    return null;
                }
                AbstractTreeNode nodeDescriptor = (AbstractTreeNode)ObjectUtils.tryCast((Object)treeNode.getUserObject(), AbstractTreeNode.class);
                if (nodeDescriptor == null) {
                    return null;
                }
                return nodeDescriptor.getValue();
            }
        });
        DefaultActionGroup popupActionGroup = new DefaultActionGroup();
        popupActionGroup.add(ActionManager.getInstance().getAction(actionGroups.getMainToolbarID()));
        popupActionGroup.add(ActionManager.getInstance().getAction(actionGroups.getPopupID()));
        PopupHandler.installPopupHandler((JComponent)this.myTree, (ActionGroup)popupActionGroup, (String)"unknown", (ActionManager)ActionManager.getInstance());
        new TreeSpeedSearch(this.myTree, TreeSpeedSearch.NODE_DESCRIPTOR_TOSTRING, true);
        this.restoreSplitterProportion();
        this.myPropertiesPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                ServersToolWindowContent.this.saveSplitterProportion();
            }
        });
    }

    private void onSelectionChanged() {
        Set nodes = this.myBuilder.getSelectedElements(AbstractTreeNode.class);
        if (nodes.size() != 1) {
            this.showMessageLabel(EMPTY_SELECTION_MESSAGE);
            this.myLastSelection = null;
            return;
        }
        AbstractTreeNode node = (AbstractTreeNode)nodes.iterator().next();
        if (Comparing.equal((Object)node, this.myLastSelection)) {
            return;
        }
        this.myLastSelection = node;
        if (node instanceof ServersTreeStructure.LogProvidingNode) {
            ServersTreeStructure.LogProvidingNode logNode = (ServersTreeStructure.LogProvidingNode)node;
            JComponent logComponent = logNode.getComponent();
            if (logComponent != null) {
                String cardName = logNode.getLogId();
                JComponent oldComponent = this.myLogComponents.get(cardName);
                if (!logComponent.equals(oldComponent)) {
                    this.myLogComponents.put(cardName, logComponent);
                    if (oldComponent != null) {
                        this.myPropertiesPanel.remove(oldComponent);
                    }
                    this.myPropertiesPanel.add(cardName, logComponent);
                }
                this.myPropertiesPanelLayout.show(this.myPropertiesPanel, cardName);
            } else {
                this.showMessageLabel("");
            }
        } else if (node instanceof ServersTreeStructure.RemoteServerNode) {
            this.updateServerDetails((ServersTreeStructure.RemoteServerNode)node);
        } else {
            this.showMessageLabel("");
        }
    }

    private void updateServerDetails(ServersTreeStructure.RemoteServerNode node) {
        ServerConnection connection = ServerConnectionManager.getInstance().getConnection(node.getServer());
        if (connection == null) {
            this.showMessageLabel("Double-click on the server node to connect");
        } else {
            this.showMessageLabel(connection.getStatusText());
        }
    }

    private void showMessageLabel(@NotNull String text) {
        if (text == null) {
            ServersToolWindowContent.$$$reportNull$$$0(5);
        }
        if (text.contains("<br/>") && !text.startsWith("<html>")) {
            String html = "<html><center>" + text + "</center></html>";
            this.myMessagePanel.setEmptyText(html);
        } else {
            this.myMessagePanel.setEmptyText(text);
        }
        this.myPropertiesPanelLayout.show(this.myPropertiesPanel, MESSAGE_CARD);
    }

    private void setupBuilder(@NotNull Project project) {
        if (project == null) {
            ServersToolWindowContent.$$$reportNull$$$0(6);
        }
        ServersTreeStructure structure = this.myContribution.createTreeStructure(project, this);
        this.myBuilder = new TreeBuilderBase((JTree)this.myTree, structure, this.myTreeModel){

            protected boolean isAutoExpandNode(NodeDescriptor nodeDescriptor) {
                return (nodeDescriptor instanceof ServersTreeStructure.RemoteServerNode || nodeDescriptor instanceof ServersTreeStructure.DeploymentNodeImpl) && !ServersToolWindowContent.this.myCollapsedTreeNodeValues.contains(((AbstractTreeNode)nodeDescriptor).getValue());
            }
        };
        Disposer.register((Disposable)this, (Disposable)this.myBuilder);
        project.getMessageBus().connect().subscribe(ServerConnectionListener.TOPIC, (Object)new ServerConnectionListener(){

            public void onConnectionCreated(@NotNull ServerConnection<?> connection) {
                if (connection == null) {
                    5.$$$reportNull$$$0(0);
                }
                ServersToolWindowContent.this.getBuilder().queueUpdate();
            }

            public void onConnectionStatusChanged(@NotNull ServerConnection<?> connection) {
                if (connection == null) {
                    5.$$$reportNull$$$0(1);
                }
                ServersToolWindowContent.this.getBuilder().queueUpdate();
                ServersToolWindowContent.this.updateSelectedServerDetails();
                if (connection.getStatus() == ConnectionStatus.CONNECTED) {
                    ServersToolWindowContent.pollDeployments(connection);
                }
            }

            public void onDeploymentsChanged(@NotNull ServerConnection<?> connection) {
                if (connection == null) {
                    5.$$$reportNull$$$0(2);
                }
                ServersToolWindowContent.this.getBuilder().queueUpdate();
                ServersToolWindowContent.this.updateSelectedServerDetails();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "connection";
                objectArray2[1] = "com/intellij/remoteServer/impl/runtime/ui/ServersToolWindowContent$5";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onConnectionCreated";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onConnectionStatusChanged";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onDeploymentsChanged";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        project.getMessageBus().connect().subscribe(RemoteServerListener.TOPIC, (Object)new RemoteServerListener(){

            public void serverAdded(@NotNull RemoteServer<?> server) {
                if (server == null) {
                    6.$$$reportNull$$$0(0);
                }
                ServersToolWindowContent.this.getBuilder().queueUpdate();
            }

            public void serverRemoved(@NotNull RemoteServer<?> server) {
                if (server == null) {
                    6.$$$reportNull$$$0(1);
                }
                ServersToolWindowContent.this.getBuilder().queueUpdate();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "server";
                objectArray2[1] = "com/intellij/remoteServer/impl/runtime/ui/ServersToolWindowContent$6";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "serverAdded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "serverRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private void updateSelectedServerDetails() {
        if (this.myLastSelection instanceof ServersTreeStructure.RemoteServerNode) {
            this.updateServerDetails((ServersTreeStructure.RemoteServerNode)this.myLastSelection);
        }
    }

    private static void pollDeployments(ServerConnection connection) {
        connection.computeDeployments(() -> new Alarm().addRequest(() -> {
            if (connection == ServerConnectionManager.getInstance().getConnection(connection.getServer())) {
                ServersToolWindowContent.pollDeployments(connection);
            }
        }, 2000, ModalityState.any()));
    }

    private JComponent createTopToolbar(@NotNull String actionGroupID) {
        if (actionGroupID == null) {
            ServersToolWindowContent.$$$reportNull$$$0(7);
        }
        DefaultActionGroup group = new DefaultActionGroup();
        group.add(ActionManager.getInstance().getAction(actionGroupID));
        ActionToolbar topToolbar = ActionManager.getInstance().createActionToolbar(PLACE_TOOLBAR_TOP, (ActionGroup)group, true);
        topToolbar.setTargetComponent((JComponent)this.myTree);
        return topToolbar.getComponent();
    }

    private JComponent createMainToolbar(@NotNull String actionGroupID) {
        if (actionGroupID == null) {
            ServersToolWindowContent.$$$reportNull$$$0(8);
        }
        DefaultActionGroup group = new DefaultActionGroup();
        group.add(ActionManager.getInstance().getAction(actionGroupID));
        ActionToolbar actionToolBar = ActionManager.getInstance().createActionToolbar(PLACE_TOOLBAR, (ActionGroup)group, false);
        this.myTree.putClientProperty((Object)"DataProvider", dataId -> {
            if (KEY.getName().equals(dataId)) {
                return this;
            }
            if (PlatformDataKeys.SELECTED_ITEMS.is(dataId)) {
                return this.myBuilder.getSelectedElements().toArray();
            }
            if (PlatformDataKeys.HELP_ID.is(dataId)) {
                return this.myContribution.getContextHelpId();
            }
            return this.myContribution.getData(dataId, this);
        });
        actionToolBar.setTargetComponent((JComponent)this.myTree);
        return actionToolBar.getComponent();
    }

    private void saveSplitterProportion() {
        SplitterProportionsDataImpl data = new SplitterProportionsDataImpl();
        data.saveSplitterProportions((Component)this.mySplitter);
        data.externalizeToDimensionService(this.getDimensionServiceKey());
    }

    private void restoreSplitterProportion() {
        SplitterProportionsDataImpl data = new SplitterProportionsDataImpl();
        data.externalizeFromDimensionService(this.getDimensionServiceKey());
        data.restoreSplitterProportions((Component)this.mySplitter);
    }

    private String getDimensionServiceKey() {
        return this.getClass().getName() + ":" + this.myContribution.getClass().getName();
    }

    public JPanel getMainPanel() {
        return this;
    }

    public void dispose() {
    }

    @NotNull
    public TreeBuilderBase getBuilder() {
        TreeBuilderBase treeBuilderBase = this.myBuilder;
        if (treeBuilderBase == null) {
            ServersToolWindowContent.$$$reportNull$$$0(9);
        }
        return treeBuilderBase;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            ServersToolWindowContent.$$$reportNull$$$0(10);
        }
        return project;
    }

    @Override
    public void select(@NotNull ServerConnection<?> connection) {
        if (connection == null) {
            ServersToolWindowContent.$$$reportNull$$$0(11);
        }
        this.myBuilder.select(ServersTreeStructure.RemoteServerNode.class, node -> ServersToolWindowContent.isServerNodeMatch(node, connection), null, false);
    }

    @Override
    public void select(@NotNull ServerConnection<?> connection, @NotNull String deploymentName) {
        if (connection == null) {
            ServersToolWindowContent.$$$reportNull$$$0(12);
        }
        if (deploymentName == null) {
            ServersToolWindowContent.$$$reportNull$$$0(13);
        }
        this.myBuilder.getUi().queueUpdate(connection).doWhenDone(() -> this.myBuilder.select(ServersTreeStructure.DeploymentNodeImpl.class, node -> ServersToolWindowContent.isDeploymentNodeMatch(node, connection, deploymentName), null, false));
    }

    @Override
    public void select(@NotNull ServerConnection<?> connection, @NotNull String deploymentName, @NotNull String logName) {
        if (connection == null) {
            ServersToolWindowContent.$$$reportNull$$$0(14);
        }
        if (deploymentName == null) {
            ServersToolWindowContent.$$$reportNull$$$0(15);
        }
        if (logName == null) {
            ServersToolWindowContent.$$$reportNull$$$0(16);
        }
        this.myBuilder.getUi().queueUpdate(connection).doWhenDone(() -> {
            TreeNodeSelector nodeSelector = this.myContribution.createLogNodeSelector(connection, deploymentName, logName);
            this.myBuilder.select(nodeSelector.getNodeClass(), nodeSelector, null, false);
        });
    }

    private static boolean isServerNodeMatch(@NotNull ServersTreeStructure.RemoteServerNode node, @NotNull ServerConnection<?> connection) {
        if (node == null) {
            ServersToolWindowContent.$$$reportNull$$$0(17);
        }
        if (connection == null) {
            ServersToolWindowContent.$$$reportNull$$$0(18);
        }
        return node.getServer().equals((Object)connection.getServer());
    }

    public static boolean isDeploymentNodeMatch(@NotNull ServersTreeStructure.DeploymentNodeImpl node, @NotNull ServerConnection<?> connection, @NotNull String deploymentName) {
        ServersTreeStructure.RemoteServerNode serverNode;
        if (node == null) {
            ServersToolWindowContent.$$$reportNull$$$0(19);
        }
        if (connection == null) {
            ServersToolWindowContent.$$$reportNull$$$0(20);
        }
        if (deploymentName == null) {
            ServersToolWindowContent.$$$reportNull$$$0(21);
        }
        return ServersToolWindowContent.isServerNodeMatch(serverNode = node.getServerNode(), connection) && node.getDeployment().getName().equals(deploymentName);
    }

    public static MessagePanel createMessagePanel() {
        return new ServersToolWindowMessagePanel();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contribution";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionGroups";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionGroupID";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/remoteServer/impl/runtime/ui/ServersToolWindowContent";
                break;
            }
            case 11: 
            case 12: 
            case 14: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 13: 
            case 15: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deploymentName";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logName";
                break;
            }
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/remoteServer/impl/runtime/ui/ServersToolWindowContent";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuilder";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "showMessageLabel";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setupBuilder";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createTopToolbar";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createMainToolbar";
                break;
            }
            case 9: 
            case 10: {
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "select";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isServerNodeMatch";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isDeploymentNodeMatch";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface MessagePanel {
        public void setEmptyText(@NotNull String var1);

        @NotNull
        public JComponent getComponent();
    }

    public static class ActionGroups {
        @NotNull
        private final String myMainToolbarID;
        @NotNull
        private final String mySecondaryToolbarID;
        @NotNull
        private final String myPopupID;
        public static final ActionGroups SHARED_ACTION_GROUPS = new ActionGroups("RemoteServersViewToolbar", "RemoteServersViewToolbar.Top", "RemoteServersViewPopup");

        public ActionGroups(@NotNull String mainToolbarID, @NotNull String secondaryToolbarID, @NotNull String popupID) {
            if (mainToolbarID == null) {
                ActionGroups.$$$reportNull$$$0(0);
            }
            if (secondaryToolbarID == null) {
                ActionGroups.$$$reportNull$$$0(1);
            }
            if (popupID == null) {
                ActionGroups.$$$reportNull$$$0(2);
            }
            this.myMainToolbarID = mainToolbarID;
            this.mySecondaryToolbarID = secondaryToolbarID;
            this.myPopupID = popupID;
        }

        @NotNull
        public String getMainToolbarID() {
            String string = this.myMainToolbarID;
            if (string == null) {
                ActionGroups.$$$reportNull$$$0(3);
            }
            return string;
        }

        @NotNull
        public String getPopupID() {
            String string = this.myPopupID;
            if (string == null) {
                ActionGroups.$$$reportNull$$$0(4);
            }
            return string;
        }

        @NotNull
        public String getSecondaryToolbarID() {
            String string = this.mySecondaryToolbarID;
            if (string == null) {
                ActionGroups.$$$reportNull$$$0(5);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mainToolbarID";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "secondaryToolbarID";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "popupID";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/remoteServer/impl/runtime/ui/ServersToolWindowContent$ActionGroups";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/remoteServer/impl/runtime/ui/ServersToolWindowContent$ActionGroups";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMainToolbarID";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPopupID";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSecondaryToolbarID";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

