/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.psi.stubs.ObjectStubSerializer;
import com.intellij.psi.stubs.PsiFileStubImpl;
import com.intellij.psi.stubs.SerializationManagerEx;
import com.intellij.psi.stubs.SerializerNotFoundException;
import com.intellij.psi.stubs.Stub;
import com.intellij.psi.stubs.StubSerializationHelper;
import com.intellij.util.io.AbstractStringEnumerator;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.PersistentStringEnumerator;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;

public class SerializationManagerImpl
extends SerializationManagerEx
implements Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.stubs.SerializationManagerImpl");
    private final AtomicBoolean myNameStorageCrashed;
    private final File myFile;
    private final AtomicBoolean myShutdownPerformed;
    private AbstractStringEnumerator myNameStorage;
    private StubSerializationHelper myStubSerializationHelper;

    public SerializationManagerImpl() {
        this(new File(PathManager.getIndexRoot(), "rep.names"));
    }

    public SerializationManagerImpl(@NotNull File nameStorageFile) {
        if (nameStorageFile == null) {
            SerializationManagerImpl.$$$reportNull$$$0(0);
        }
        this.myNameStorageCrashed = new AtomicBoolean(false);
        this.myShutdownPerformed = new AtomicBoolean(false);
        this.myFile = nameStorageFile;
        this.myFile.getParentFile().mkdirs();
        try {
            this.myNameStorage = new PersistentStringEnumerator(this.myFile, true);
            this.myStubSerializationHelper = new StubSerializationHelper(this.myNameStorage, this);
        }
        catch (IOException e) {
            this.nameStorageCrashed();
            LOG.info((Throwable)e);
            this.repairNameStorage();
            this.nameStorageCrashed();
        }
        finally {
            this.registerSerializer((ObjectStubSerializer)PsiFileStubImpl.TYPE);
            ShutDownTracker.getInstance().registerShutdownTask(this::performShutdown);
        }
    }

    public boolean isNameStorageCorrupted() {
        return this.myNameStorageCrashed.get();
    }

    public void repairNameStorage() {
        if (this.myNameStorageCrashed.getAndSet(false)) {
            try {
                LOG.info("Name storage is repaired");
                if (this.myNameStorage != null) {
                    this.myNameStorage.close();
                }
                StubSerializationHelper prevHelper = this.myStubSerializationHelper;
                IOUtil.deleteAllFilesStartingWith((File)this.myFile);
                this.myNameStorage = new PersistentStringEnumerator(this.myFile, true);
                this.myStubSerializationHelper = new StubSerializationHelper(this.myNameStorage, this);
                this.myStubSerializationHelper.copyFrom(prevHelper);
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
                this.nameStorageCrashed();
            }
        }
    }

    public void flushNameStorage() {
        if (this.myNameStorage.isDirty()) {
            this.myNameStorage.force();
        }
    }

    public String internString(String string) {
        return this.myStubSerializationHelper.intern(string);
    }

    public void reinitializeNameStorage() {
        this.nameStorageCrashed();
        this.repairNameStorage();
    }

    private void nameStorageCrashed() {
        this.myNameStorageCrashed.set(true);
    }

    public void dispose() {
        this.performShutdown();
    }

    private void performShutdown() {
        if (!this.myShutdownPerformed.compareAndSet(false, true)) {
            return;
        }
        LOG.info("START StubSerializationManager SHUTDOWN");
        try {
            this.myNameStorage.close();
            LOG.info("END StubSerializationManager SHUTDOWN");
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    protected void registerSerializer(String externalId, Computable<ObjectStubSerializer> lazySerializer) {
        try {
            this.myStubSerializationHelper.assignId(lazySerializer, externalId);
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            this.nameStorageCrashed();
        }
    }

    public void serialize(@NotNull Stub rootStub, @NotNull OutputStream stream) {
        if (rootStub == null) {
            SerializationManagerImpl.$$$reportNull$$$0(1);
        }
        if (stream == null) {
            SerializationManagerImpl.$$$reportNull$$$0(2);
        }
        this.initSerializers();
        try {
            this.myStubSerializationHelper.serialize(rootStub, stream);
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            this.nameStorageCrashed();
        }
    }

    @NotNull
    public Stub deserialize(@NotNull InputStream stream) throws SerializerNotFoundException {
        Stub stub;
        if (stream == null) {
            SerializationManagerImpl.$$$reportNull$$$0(3);
        }
        this.initSerializers();
        try {
            stub = this.myStubSerializationHelper.deserialize(stream);
        }
        catch (IOException e) {
            this.nameStorageCrashed();
            LOG.info((Throwable)e);
            throw new RuntimeException(e);
        }
        if (stub == null) {
            SerializationManagerImpl.$$$reportNull$$$0(4);
        }
        return stub;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameStorageFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootStub";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/stubs/SerializationManagerImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/stubs/SerializationManagerImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "deserialize";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

