/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.cache.impl.id;

import com.intellij.lang.cacheBuilder.CacheBuilderRegistry;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.impl.CustomSyntaxTableFileType;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.cache.impl.id.IdIndexEntry;
import com.intellij.psi.impl.cache.impl.id.IdIndexer;
import com.intellij.psi.impl.cache.impl.id.IdTableBuilding;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.SystemProperties;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.InlineKeyDescriptor;
import com.intellij.util.io.KeyDescriptor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class IdIndex
extends FileBasedIndexExtension<IdIndexEntry, Integer> {
    @NonNls
    public static final ID<IdIndexEntry, Integer> NAME = ID.create((String)"IdIndex");
    private final FileBasedIndex.InputFilter myInputFilter = file2 -> IdIndex.isIndexable(file2.getFileType());
    public static final boolean ourSnapshotMappingsEnabled = SystemProperties.getBooleanProperty((String)"idea.index.snapshot.mappings.enabled", (boolean)true);
    private final DataExternalizer<Integer> myValueExternalizer = new DataExternalizer<Integer>(){

        public void save(@NotNull DataOutput out, Integer value) throws IOException {
            if (out == null) {
                1.$$$reportNull$$$0(0);
            }
            out.write((int)(value & 0xFF));
        }

        public Integer read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                1.$$$reportNull$$$0(1);
            }
            return in.readByte() & 0xFF;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/psi/impl/cache/impl/id/IdIndex$1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    private final KeyDescriptor<IdIndexEntry> myKeyDescriptor = new InlineKeyDescriptor<IdIndexEntry>(){

        public IdIndexEntry fromInt(int n) {
            return new IdIndexEntry(n);
        }

        public int toInt(IdIndexEntry idIndexEntry) {
            return idIndexEntry.getWordHashCode();
        }
    };
    private final DataIndexer<IdIndexEntry, Integer, FileContent> myIndexer = new DataIndexer<IdIndexEntry, Integer, FileContent>(){

        @NotNull
        public Map<IdIndexEntry, Integer> map(@NotNull FileContent inputData) {
            IdIndexer indexer;
            if (inputData == null) {
                3.$$$reportNull$$$0(0);
            }
            if ((indexer = IdTableBuilding.getFileTypeIndexer(inputData.getFileType())) != null) {
                Map map2 = indexer.map(inputData);
                if (map2 == null) {
                    3.$$$reportNull$$$0(1);
                }
                return map2;
            }
            Map<IdIndexEntry, Integer> map3 = Collections.emptyMap();
            if (map3 == null) {
                3.$$$reportNull$$$0(2);
            }
            return map3;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "inputData";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/impl/cache/impl/id/IdIndex$3";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/impl/cache/impl/id/IdIndex$3";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "map";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "map";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };

    public int getVersion() {
        return 16 + (ourSnapshotMappingsEnabled ? 255 : 0);
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    @NotNull
    public ID<IdIndexEntry, Integer> getName() {
        ID<IdIndexEntry, Integer> iD = NAME;
        if (iD == null) {
            IdIndex.$$$reportNull$$$0(0);
        }
        return iD;
    }

    @NotNull
    public DataIndexer<IdIndexEntry, Integer, FileContent> getIndexer() {
        DataIndexer<IdIndexEntry, Integer, FileContent> dataIndexer = this.myIndexer;
        if (dataIndexer == null) {
            IdIndex.$$$reportNull$$$0(1);
        }
        return dataIndexer;
    }

    @NotNull
    public DataExternalizer<Integer> getValueExternalizer() {
        DataExternalizer<Integer> dataExternalizer = this.myValueExternalizer;
        if (dataExternalizer == null) {
            IdIndex.$$$reportNull$$$0(2);
        }
        return dataExternalizer;
    }

    @NotNull
    public KeyDescriptor<IdIndexEntry> getKeyDescriptor() {
        KeyDescriptor<IdIndexEntry> keyDescriptor = this.myKeyDescriptor;
        if (keyDescriptor == null) {
            IdIndex.$$$reportNull$$$0(3);
        }
        return keyDescriptor;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        FileBasedIndex.InputFilter inputFilter = this.myInputFilter;
        if (inputFilter == null) {
            IdIndex.$$$reportNull$$$0(4);
        }
        return inputFilter;
    }

    public static boolean isIndexable(FileType fileType) {
        return fileType instanceof LanguageFileType || fileType instanceof CustomSyntaxTableFileType || IdTableBuilding.isIdIndexerRegistered(fileType) || CacheBuilderRegistry.getInstance().getCacheBuilder(fileType) != null;
    }

    public boolean hasSnapshotMapping() {
        return true;
    }

    public static boolean hasIdentifierInFile(@NotNull PsiFile file2, @NotNull String name) {
        if (file2 == null) {
            IdIndex.$$$reportNull$$$0(5);
        }
        if (name == null) {
            IdIndex.$$$reportNull$$$0(6);
        }
        if (file2.getVirtualFile() == null || DumbService.isDumb((Project)file2.getProject())) {
            return StringUtil.contains((CharSequence)file2.getViewProvider().getContents(), (CharSequence)name);
        }
        GlobalSearchScope scope = GlobalSearchScope.fileScope((PsiFile)file2);
        return !FileBasedIndex.getInstance().getContainingFiles(NAME, (Object)new IdIndexEntry(name, true), scope).isEmpty();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/cache/impl/id/IdIndex";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueExternalizer";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyDescriptor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputFilter";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/cache/impl/id/IdIndex";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "hasIdentifierInFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

