/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.cache.impl;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.cache.TodoCacheManager;
import com.intellij.psi.impl.cache.impl.IndexPatternUtil;
import com.intellij.psi.impl.cache.impl.todo.TodoIndex;
import com.intellij.psi.impl.cache.impl.todo.TodoIndexEntry;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.IndexPattern;
import com.intellij.psi.search.IndexPatternProvider;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class IndexTodoCacheManagerImpl
implements TodoCacheManager {
    private final Project myProject;

    public IndexTodoCacheManagerImpl(@NotNull Project project) {
        if (project == null) {
            IndexTodoCacheManagerImpl.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    @Override
    @NotNull
    public PsiFile[] getFilesWithTodoItems() {
        if (this.myProject.isDefault()) {
            if (PsiFile.EMPTY_ARRAY == null) {
                IndexTodoCacheManagerImpl.$$$reportNull$$$0(1);
            }
            return PsiFile.EMPTY_ARRAY;
        }
        FileBasedIndex fileBasedIndex = FileBasedIndex.getInstance();
        HashSet allFiles = new HashSet();
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
        for (IndexPattern indexPattern : IndexPatternUtil.getIndexPatterns()) {
            Collection files2 = fileBasedIndex.getContainingFiles(TodoIndex.NAME, (Object)new TodoIndexEntry(indexPattern.getPatternString(), indexPattern.isCaseSensitive()), GlobalSearchScope.allScope((Project)this.myProject));
            PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
            ApplicationManager.getApplication().runReadAction(() -> {
                for (VirtualFile file2 : files2) {
                    PsiFile psiFile;
                    if (!projectFileIndex.isInContent(file2) || (psiFile = psiManager.findFile(file2)) == null) continue;
                    allFiles.add(psiFile);
                }
            });
        }
        PsiFile[] psiFileArray = allFiles.isEmpty() ? PsiFile.EMPTY_ARRAY : PsiUtilCore.toPsiFileArray(allFiles);
        if (psiFileArray == null) {
            IndexTodoCacheManagerImpl.$$$reportNull$$$0(2);
        }
        return psiFileArray;
    }

    @Override
    public int getTodoCount(@NotNull VirtualFile file2, @NotNull IndexPatternProvider patternProvider) {
        if (file2 == null) {
            IndexTodoCacheManagerImpl.$$$reportNull$$$0(3);
        }
        if (patternProvider == null) {
            IndexTodoCacheManagerImpl.$$$reportNull$$$0(4);
        }
        if (this.myProject.isDefault() || !ProjectFileIndex.getInstance((Project)this.myProject).isInContent(file2)) {
            return 0;
        }
        if (file2 instanceof VirtualFileWindow) {
            return -1;
        }
        FileBasedIndex fileBasedIndex = FileBasedIndex.getInstance();
        return Arrays.stream(patternProvider.getIndexPatterns()).mapToInt(indexPattern -> this.fetchCount(fileBasedIndex, file2, (IndexPattern)indexPattern)).sum();
    }

    @Override
    public int getTodoCount(@NotNull VirtualFile file2, @NotNull IndexPattern pattern) {
        if (file2 == null) {
            IndexTodoCacheManagerImpl.$$$reportNull$$$0(5);
        }
        if (pattern == null) {
            IndexTodoCacheManagerImpl.$$$reportNull$$$0(6);
        }
        if (this.myProject.isDefault() || !ProjectFileIndex.getInstance((Project)this.myProject).isInContent(file2)) {
            return 0;
        }
        if (file2 instanceof VirtualFileWindow) {
            return -1;
        }
        return this.fetchCount(FileBasedIndex.getInstance(), file2, pattern);
    }

    private int fetchCount(@NotNull FileBasedIndex fileBasedIndex, @NotNull VirtualFile file2, @NotNull IndexPattern indexPattern) {
        if (fileBasedIndex == null) {
            IndexTodoCacheManagerImpl.$$$reportNull$$$0(7);
        }
        if (file2 == null) {
            IndexTodoCacheManagerImpl.$$$reportNull$$$0(8);
        }
        if (indexPattern == null) {
            IndexTodoCacheManagerImpl.$$$reportNull$$$0(9);
        }
        int[] count = new int[]{0};
        fileBasedIndex.processValues(TodoIndex.NAME, (Object)new TodoIndexEntry(indexPattern.getPatternString(), indexPattern.isCaseSensitive()), file2, (file1, value) -> {
            count[0] = count[0] + value;
            return true;
        }, GlobalSearchScope.fileScope((Project)this.myProject, (VirtualFile)file2));
        return count[0];
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/cache/impl/IndexTodoCacheManagerImpl";
                break;
            }
            case 3: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patternProvider";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileBasedIndex";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexPattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/cache/impl/IndexTodoCacheManagerImpl";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesWithTodoItems";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getTodoCount";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "fetchCount";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

