/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.Optional;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public interface ExternalFormatProcessor {
    public static final ExtensionPointName<ExternalFormatProcessor> EP_NAME = ExtensionPointName.create((String)"com.intellij.externalFormatProcessor");

    public boolean activeForFile(@NotNull PsiFile var1);

    @Nullable
    public TextRange format(@NotNull PsiFile var1, @NotNull TextRange var2, boolean var3);

    @NonNls
    @NotNull
    public String getId();

    public static boolean useExternalFormatter(@NotNull PsiFile source) {
        if (source == null) {
            ExternalFormatProcessor.$$$reportNull$$$0(0);
        }
        return EP_NAME.getExtensionList().stream().anyMatch(efp -> efp.activeForFile(source));
    }

    @NotNull
    public static Optional<ExternalFormatProcessor> findExternalFormatter(@NonNls @NotNull String externalFormatterId) {
        if (externalFormatterId == null) {
            ExternalFormatProcessor.$$$reportNull$$$0(1);
        }
        Optional<ExternalFormatProcessor> optional = EP_NAME.getExtensionList().stream().filter(efp -> externalFormatterId.equals(efp.getId())).findFirst();
        if (optional == null) {
            ExternalFormatProcessor.$$$reportNull$$$0(2);
        }
        return optional;
    }

    @Nullable
    public static TextRange formatRangeInFile(@NotNull PsiFile source, @NotNull TextRange range2, boolean canChangeWhiteSpacesOnly) {
        if (source == null) {
            ExternalFormatProcessor.$$$reportNull$$$0(3);
        }
        if (range2 == null) {
            ExternalFormatProcessor.$$$reportNull$$$0(4);
        }
        for (ExternalFormatProcessor efp : EP_NAME.getExtensionList()) {
            if (!efp.activeForFile(source)) continue;
            return efp.format(source, range2, canChangeWhiteSpacesOnly);
        }
        return null;
    }

    @NotNull
    public static PsiElement formatElement(@NotNull PsiElement elementToFormat, @NotNull TextRange range2, boolean canChangeWhiteSpacesOnly) {
        TextRange rangeAfterFormat;
        PsiFile file2;
        Document document;
        if (elementToFormat == null) {
            ExternalFormatProcessor.$$$reportNull$$$0(5);
        }
        if (range2 == null) {
            ExternalFormatProcessor.$$$reportNull$$$0(6);
        }
        if ((document = (file2 = elementToFormat.getContainingFile()).getViewProvider().getDocument()) != null && (rangeAfterFormat = ExternalFormatProcessor.formatRangeInFile(file2, range2, canChangeWhiteSpacesOnly)) != null) {
            PsiElement elementAtStart;
            PsiDocumentManager.getInstance((Project)file2.getProject()).commitDocument(document);
            if (!elementToFormat.isValid() && (elementAtStart = file2.findElementAt(rangeAfterFormat.getStartOffset())) != null) {
                PsiElement psiElement = elementAtStart;
                if (psiElement == null) {
                    ExternalFormatProcessor.$$$reportNull$$$0(7);
                }
                return psiElement;
            }
        }
        PsiElement psiElement = elementToFormat;
        if (psiElement == null) {
            ExternalFormatProcessor.$$$reportNull$$$0(8);
        }
        return psiElement;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalFormatterId";
                break;
            }
            case 2: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/codeStyle/ExternalFormatProcessor";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToFormat";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/codeStyle/ExternalFormatProcessor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "findExternalFormatter";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "formatElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "useExternalFormatter";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findExternalFormatter";
                break;
            }
            case 2: 
            case 7: 
            case 8: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "formatRangeInFile";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "formatElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

