/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.psi.codeStyle.SequentialTaskWithFixedIterationsNumber;
import com.intellij.util.SequentialModalProgressTask;
import com.intellij.util.SequentialTask;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class CompositeSequentialTask
implements SequentialTask {
    private final List<SequentialTaskWithFixedIterationsNumber> myUnfinishedTasks;
    private SequentialTask myCurrentTask;
    private int myIterationsFinished;
    private int myTotalIterations;
    private final SequentialModalProgressTask myProgressTask;
    private String myProgressText;
    private String myProgressText2;

    CompositeSequentialTask(@NotNull SequentialModalProgressTask progressTask) {
        if (progressTask == null) {
            CompositeSequentialTask.$$$reportNull$$$0(0);
        }
        this.myUnfinishedTasks = ContainerUtil.newArrayList();
        this.myCurrentTask = null;
        this.myTotalIterations = 0;
        this.myProgressTask = progressTask;
    }

    public void addTask(@NotNull SequentialTaskWithFixedIterationsNumber task2) {
        if (task2 == null) {
            CompositeSequentialTask.$$$reportNull$$$0(1);
        }
        this.myUnfinishedTasks.add(task2);
        this.myTotalIterations += task2.getTotalIterationsNumber();
    }

    public void setProgressText(@NotNull String progressText) {
        if (progressText == null) {
            CompositeSequentialTask.$$$reportNull$$$0(2);
        }
        this.myProgressText = progressText;
    }

    public boolean isDone() {
        return this.myCurrentTask == null && this.myUnfinishedTasks.size() == 0;
    }

    public boolean iteration() {
        this.popUntilCurrentTaskUnfinishedOrNull();
        if (this.myCurrentTask != null) {
            ProgressIndicator indicator = this.myProgressTask.getIndicator();
            if (indicator != null) {
                if (this.myProgressText != null) {
                    indicator.setText(this.myProgressText);
                }
                if (this.myProgressText2 != null) {
                    indicator.setText2(this.myProgressText2);
                }
                indicator.setFraction((double)this.myIterationsFinished++ / (double)this.myTotalIterations);
            }
            this.myCurrentTask.iteration();
        }
        return true;
    }

    private void popUntilCurrentTaskUnfinishedOrNull() {
        if (this.myCurrentTask != null) {
            if (!this.myCurrentTask.isDone()) {
                return;
            }
            this.myCurrentTask = null;
            this.popUntilCurrentTaskUnfinishedOrNull();
        } else if (this.myUnfinishedTasks.size() > 0) {
            this.myCurrentTask = this.myUnfinishedTasks.get(0);
            this.myUnfinishedTasks.remove(0);
            this.popUntilCurrentTaskUnfinishedOrNull();
        }
    }

    public void prepare() {
    }

    public void stop() {
        if (this.myCurrentTask != null) {
            this.myCurrentTask.stop();
        }
        for (SequentialTaskWithFixedIterationsNumber task2 : this.myUnfinishedTasks) {
            task2.stop();
        }
    }

    public void setProgressText2(String progressText2) {
        this.myProgressText2 = progressText2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressTask";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressText";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/codeStyle/CompositeSequentialTask";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "addTask";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setProgressText";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

