/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.commands;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.FocusWatcher;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.impl.FloatingDecorator;
import com.intellij.openapi.wm.impl.ToolWindowImpl;
import com.intellij.openapi.wm.impl.WindowManagerImpl;
import com.intellij.openapi.wm.impl.WindowWatcher;
import com.intellij.openapi.wm.impl.commands.FinalizableCommand;
import com.intellij.util.Alarm;
import java.awt.Component;
import java.awt.FocusTraversalPolicy;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RequestFocusInToolWindowCmd
extends FinalizableCommand {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.wm.impl.commands.RequestFocusInToolWindowCmd");
    private final ToolWindowImpl myToolWindow;
    private final FocusWatcher myFocusWatcher;
    private final Project myProject;

    public RequestFocusInToolWindowCmd(IdeFocusManager focusManager, ToolWindowImpl toolWindow, FocusWatcher focusWatcher, @NotNull Runnable finishCallBack, Project project) {
        if (finishCallBack == null) {
            RequestFocusInToolWindowCmd.$$$reportNull$$$0(0);
        }
        super(finishCallBack);
        this.myToolWindow = toolWindow;
        this.myFocusWatcher = focusWatcher;
        this.myProject = project;
    }

    @Override
    public final void run() {
        try {
            this.requestFocus();
        }
        finally {
            this.finish();
        }
    }

    private void bringOwnerToFront() {
        Window activeWindow;
        Window owner = SwingUtilities.getWindowAncestor(this.myToolWindow.getComponent());
        Window activeFrame = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        if (activeFrame != null && activeFrame != owner) {
            return;
        }
        if (owner != null && owner.getFocusOwner() == null && ((activeWindow = RequestFocusInToolWindowCmd.getActiveWindow(owner.getOwnedWindows())) == null || activeWindow instanceof FloatingDecorator)) {
            LOG.debug("owner.toFront()");
            owner.toFront();
        }
    }

    @Nullable
    private Component getShowingComponentToRequestFocus() {
        JComponent container = this.myToolWindow.getComponent();
        if (container == null || !container.isShowing()) {
            LOG.debug(this.myToolWindow.getId(), new Object[]{" tool window - parent container is hidden: ", container});
            return null;
        }
        FocusTraversalPolicy policy = container.getFocusTraversalPolicy();
        if (policy == null) {
            LOG.warn(this.myToolWindow.getId() + " tool window does not provide focus traversal policy");
            return null;
        }
        Component component = policy.getDefaultComponent(container);
        if (component == null || !component.isShowing()) {
            LOG.debug(this.myToolWindow.getId(), new Object[]{" tool window - default component is hidden: ", container});
            return null;
        }
        return component;
    }

    private void requestFocus() {
        final Alarm checkerAlarm = new Alarm();
        Runnable checker = new Runnable(){
            final long startTime = System.currentTimeMillis();

            @Override
            public void run() {
                if (System.currentTimeMillis() - this.startTime > 10000L) {
                    LOG.debug(RequestFocusInToolWindowCmd.this.myToolWindow.getId(), new Object[]{" tool window - cannot wait for showing component"});
                    return;
                }
                Component c = RequestFocusInToolWindowCmd.this.getShowingComponentToRequestFocus();
                if (c != null) {
                    Component owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner();
                    if (owner != c) {
                        RequestFocusInToolWindowCmd.this.myManager.getFocusManager().requestFocusInProject(c, RequestFocusInToolWindowCmd.this.myProject);
                        RequestFocusInToolWindowCmd.this.bringOwnerToFront();
                    }
                    RequestFocusInToolWindowCmd.this.myManager.getFocusManager().doWhenFocusSettlesDown(() -> RequestFocusInToolWindowCmd.this.updateToolWindow(c));
                } else {
                    checkerAlarm.addRequest((Runnable)this, 100);
                }
            }
        };
        checkerAlarm.addRequest(checker, 0);
    }

    private void updateToolWindow(Component c) {
        if (c.isFocusOwner()) {
            this.myFocusWatcher.setFocusedComponentImpl(c);
            if (this.myToolWindow.isAvailable() && !this.myToolWindow.isActive()) {
                this.myToolWindow.activate(null, true, false);
            }
        }
        RequestFocusInToolWindowCmd.updateFocusedComponentForWatcher(c);
    }

    private static void updateFocusedComponentForWatcher(Component c) {
        WindowWatcher watcher = ((WindowManagerImpl)WindowManager.getInstance()).getWindowWatcher();
        FocusWatcher focusWatcher = watcher.getFocusWatcherFor(c);
        if (focusWatcher != null && c.isFocusOwner()) {
            focusWatcher.setFocusedComponentImpl(c);
        }
    }

    private static Window getActiveWindow(Window[] windows) {
        for (Window window : windows) {
            if (window.isShowing() && window.isActive()) {
                return window;
            }
            if ((window = RequestFocusInToolWindowCmd.getActiveWindow(window.getOwnedWindows())) == null) continue;
            return window;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "finishCallBack", "com/intellij/openapi/wm/impl/commands/RequestFocusInToolWindowCmd", "<init>"));
    }
}

