/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.ide.DataManager;
import com.intellij.ide.RecentProjectsManagerBase;
import com.intellij.ide.impl.DataManagerImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WindowManagerListener;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.openapi.wm.impl.AWTUtilitiesWrapper;
import com.intellij.openapi.wm.impl.CommandProcessor;
import com.intellij.openapi.wm.impl.DesktopLayout;
import com.intellij.openapi.wm.impl.FrameInfo;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.openapi.wm.impl.IdeMenuBar;
import com.intellij.openapi.wm.impl.ProjectFrameBounds;
import com.intellij.openapi.wm.impl.ProjectFrameBoundsKt;
import com.intellij.openapi.wm.impl.WindowWatcher;
import com.intellij.openapi.wm.impl.X11UiUtil;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeFrame;
import com.intellij.ui.FrameState;
import com.intellij.ui.ScreenUtil;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.sun.jna.platform.WindowUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ContainerEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.peer.FramePeer;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import javax.swing.JViewport;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.awt.AWTAccessor;

@State(name="WindowManager", defaultStateAsResource=true, storages={@Storage(value="window.manager.xml", roamingType=RoamingType.DISABLED)})
public final class WindowManagerImpl
extends WindowManagerEx
implements PersistentStateComponent<Element> {
    private static final Logger LOG = Logger.getInstance(WindowManagerImpl.class);
    @NonNls
    public static final String FULL_SCREEN = "ide.frame.full.screen";
    @NonNls
    private static final String FOCUSED_WINDOW_PROPERTY_NAME = "focusedWindow";
    @NonNls
    private static final String FRAME_ELEMENT = "frame";
    @NonNls
    private static final String EXTENDED_STATE_ATTR = "extended-state";
    private Boolean myAlphaModeSupported;
    private final EventDispatcher<WindowManagerListener> myEventDispatcher = EventDispatcher.create(WindowManagerListener.class);
    private final CommandProcessor myCommandProcessor = new CommandProcessor();
    private final WindowWatcher myWindowWatcher = new WindowWatcher();
    private final DesktopLayout myLayout = new DesktopLayout();
    private final Map<Project, IdeFrameImpl> myProjectToFrame = new HashMap<Project, IdeFrameImpl>();
    private final Map<Project, Set<JDialog>> myDialogsToDispose = new HashMap<Project, Set<JDialog>>();
    @NotNull
    final FrameInfo myDefaultFrameInfo = new FrameInfo();
    private final WindowAdapter myActivationListener;
    private final DataManager myDataManager;
    private final ActionManagerEx myActionManager;

    public WindowManagerImpl(DataManager dataManager, ActionManagerEx actionManager) {
        Application application;
        this.myDataManager = dataManager;
        this.myActionManager = actionManager;
        if (this.myDataManager instanceof DataManagerImpl) {
            ((DataManagerImpl)this.myDataManager).setWindowManager(this);
        }
        if (!(application = ApplicationManager.getApplication()).isUnitTestMode()) {
            Disposer.register((Disposable)application, this::disposeRootFrame);
        }
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        keyboardFocusManager.addPropertyChangeListener(FOCUSED_WINDOW_PROPERTY_NAME, this.myWindowWatcher);
        this.myActivationListener = new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent e) {
                Window activeWindow = e.getWindow();
                if (activeWindow instanceof IdeFrameImpl) {
                    WindowManagerImpl.this.proceedDialogDisposalQueue(((IdeFrameImpl)activeWindow).getProject());
                }
            }
        };
        if (UIUtil.hasLeakingAppleListeners()) {
            UIUtil.addAwtListener(event -> {
                if (event.getID() == 300 && ((ContainerEvent)event).getChild() instanceof JViewport) {
                    UIUtil.removeLeakingAppleListeners();
                }
            }, (long)2L, (Disposable)application);
        }
    }

    @NotNull
    public IdeFrameImpl[] getAllProjectFrames() {
        Collection<IdeFrameImpl> ideFrames = this.myProjectToFrame.values();
        IdeFrameImpl[] ideFrameImplArray = ideFrames.toArray(new IdeFrameImpl[0]);
        if (ideFrameImplArray == null) {
            WindowManagerImpl.$$$reportNull$$$0(0);
        }
        return ideFrameImplArray;
    }

    public JFrame findVisibleFrame() {
        IdeFrameImpl[] frames = this.getAllProjectFrames();
        return frames.length > 0 ? frames[0] : (JFrame)WelcomeFrame.getInstance();
    }

    public void addListener(WindowManagerListener listener2) {
        this.myEventDispatcher.addListener((EventListener)listener2);
    }

    public void removeListener(WindowManagerListener listener2) {
        this.myEventDispatcher.removeListener((EventListener)listener2);
    }

    @Override
    public final Rectangle getScreenBounds() {
        return ScreenUtil.getAllScreensRectangle();
    }

    @Override
    public Rectangle getScreenBounds(@NotNull Project project) {
        GraphicsDevice[] devices;
        if (project == null) {
            WindowManagerImpl.$$$reportNull$$$0(1);
        }
        GraphicsEnvironment environment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Point onScreen = this.getFrame(project).getLocationOnScreen();
        for (GraphicsDevice device : devices = environment.getScreenDevices()) {
            Rectangle bounds2 = device.getDefaultConfiguration().getBounds();
            if (!bounds2.contains(onScreen)) continue;
            return bounds2;
        }
        return null;
    }

    public final boolean isInsideScreenBounds(int x, int y, int width) {
        return ScreenUtil.getAllScreensShape().contains(x, y, width, 1.0);
    }

    public final boolean isAlphaModeSupported() {
        if (this.myAlphaModeSupported == null) {
            this.myAlphaModeSupported = WindowManagerImpl.calcAlphaModelSupported();
        }
        return this.myAlphaModeSupported;
    }

    private static boolean calcAlphaModelSupported() {
        if (AWTUtilitiesWrapper.isTranslucencyAPISupported()) {
            return AWTUtilitiesWrapper.isTranslucencySupported(AWTUtilitiesWrapper.TRANSLUCENT);
        }
        try {
            return WindowUtils.isWindowAlphaSupported();
        }
        catch (Throwable e) {
            return false;
        }
    }

    public final void setAlphaModeRatio(Window window, float ratio) {
        if (!window.isDisplayable() || !window.isShowing()) {
            throw new IllegalArgumentException("window must be displayable and showing. window=" + window);
        }
        if (ratio < 0.0f || ratio > 1.0f) {
            throw new IllegalArgumentException("ratio must be in [0..1] range. ratio=" + ratio);
        }
        if (!this.isAlphaModeSupported() || !this.isAlphaModeEnabled(window)) {
            return;
        }
        WindowManagerImpl.setAlphaMode(window, ratio);
    }

    private static void setAlphaMode(Window window, float ratio) {
        try {
            if (SystemInfo.isMacOSLeopard) {
                if (window instanceof JWindow) {
                    ((JWindow)window).getRootPane().putClientProperty("Window.alpha", Float.valueOf(1.0f - ratio));
                } else if (window instanceof JDialog) {
                    ((JDialog)window).getRootPane().putClientProperty("Window.alpha", Float.valueOf(1.0f - ratio));
                } else if (window instanceof JFrame) {
                    ((JFrame)window).getRootPane().putClientProperty("Window.alpha", Float.valueOf(1.0f - ratio));
                }
            } else if (AWTUtilitiesWrapper.isTranslucencySupported(AWTUtilitiesWrapper.TRANSLUCENT)) {
                AWTUtilitiesWrapper.setWindowOpacity(window, 1.0f - ratio);
            } else {
                WindowUtils.setWindowAlpha((Window)window, (float)(1.0f - ratio));
            }
        }
        catch (Throwable e) {
            LOG.debug(e);
        }
    }

    @Override
    public void setWindowMask(Window window, @Nullable Shape mask) {
        try {
            if (AWTUtilitiesWrapper.isTranslucencySupported(AWTUtilitiesWrapper.PERPIXEL_TRANSPARENT)) {
                AWTUtilitiesWrapper.setWindowShape(window, mask);
            } else {
                WindowUtils.setWindowMask((Window)window, (Shape)mask);
            }
        }
        catch (Throwable e) {
            LOG.debug(e);
        }
    }

    @Override
    public void setWindowShadow(Window window, WindowManagerEx.WindowShadowMode mode) {
        if (window instanceof JWindow) {
            JRootPane root = ((JWindow)window).getRootPane();
            root.putClientProperty("Window.shadow", mode == WindowManagerEx.WindowShadowMode.DISABLED ? Boolean.FALSE : Boolean.TRUE);
            root.putClientProperty("Window.style", mode == WindowManagerEx.WindowShadowMode.SMALL ? "small" : null);
        }
    }

    @Override
    public void resetWindow(Window window) {
        try {
            if (!this.isAlphaModeSupported()) {
                return;
            }
            this.setWindowMask(window, null);
            WindowManagerImpl.setAlphaMode(window, 0.0f);
            this.setWindowShadow(window, WindowManagerEx.WindowShadowMode.NORMAL);
        }
        catch (Throwable e) {
            LOG.debug(e);
        }
    }

    public final boolean isAlphaModeEnabled(Window window) {
        if (!window.isDisplayable() || !window.isShowing()) {
            throw new IllegalArgumentException("window must be displayable and showing. window=" + window);
        }
        return this.isAlphaModeSupported();
    }

    public final void setAlphaModeEnabled(Window window, boolean state) {
        if (!window.isDisplayable() || !window.isShowing()) {
            throw new IllegalArgumentException("window must be displayable and showing. window=" + window);
        }
    }

    @Override
    public void hideDialog(JDialog dialog2, Project project) {
        if (project == null) {
            dialog2.dispose();
        } else {
            IdeFrameImpl frame = this.getFrame(project);
            if (frame.isActive()) {
                dialog2.dispose();
            } else {
                this.queueForDisposal(dialog2, project);
                dialog2.setVisible(false);
            }
        }
    }

    @Override
    public void adjustContainerWindow(Component c, Dimension oldSize, Dimension newSize) {
        JBPopup popup2;
        if (c == null) {
            return;
        }
        Window wnd = SwingUtilities.getWindowAncestor(c);
        if (wnd instanceof JWindow && (popup2 = (JBPopup)((JWindow)wnd).getRootPane().getClientProperty("JBPopup")) != null && oldSize.height < newSize.height) {
            Dimension size = popup2.getSize();
            size.height += newSize.height - oldSize.height;
            popup2.setSize(size);
            popup2.moveToFitScreen();
        }
    }

    public final void doNotSuggestAsParent(Window window) {
        this.myWindowWatcher.doNotSuggestAsParent(window);
    }

    @Override
    public final void dispatchComponentEvent(ComponentEvent e) {
        this.myWindowWatcher.dispatchComponentEvent(e);
    }

    @Nullable
    public final Window suggestParentWindow(@Nullable Project project) {
        return this.myWindowWatcher.suggestParentWindow(project);
    }

    public final StatusBar getStatusBar(Project project) {
        IdeFrameImpl frame = this.myProjectToFrame.get(project);
        return frame == null ? null : frame.getStatusBar();
    }

    public StatusBar getStatusBar(@NotNull Component c, @Nullable Project project) {
        Component parent;
        if (c == null) {
            WindowManagerImpl.$$$reportNull$$$0(2);
        }
        if ((parent = UIUtil.findUltimateParent((Component)c)) instanceof IdeFrame) {
            return ((IdeFrame)parent).getStatusBar().findChild(c);
        }
        IdeFrame frame = this.findFrameFor(project);
        if (frame != null) {
            return frame.getStatusBar().findChild(c);
        }
        assert (false) : "Cannot find status bar for " + c;
        return null;
    }

    @Override
    public IdeFrame findFrameFor(@Nullable Project project) {
        IdeFrame frame = null;
        if (project != null) {
            Object object = frame = project.isDefault() ? WelcomeFrame.getInstance() : this.getFrame(project);
            if (frame == null) {
                frame = this.myProjectToFrame.get(null);
            }
        } else {
            for (Container eachParent = this.getMostRecentFocusedWindow(); eachParent != null; eachParent = eachParent.getParent()) {
                if (!(eachParent instanceof IdeFrame)) continue;
                frame = (IdeFrame)eachParent;
                break;
            }
            if (frame == null) {
                frame = WindowManagerImpl.tryToFindTheOnlyFrame();
            }
        }
        return frame;
    }

    private static IdeFrame tryToFindTheOnlyFrame() {
        Frame[] all;
        IdeFrame candidate = null;
        for (Frame each : all = Frame.getFrames()) {
            if (!(each instanceof IdeFrame)) continue;
            if (candidate == null) {
                candidate = (IdeFrame)each;
                continue;
            }
            candidate = null;
            break;
        }
        return candidate;
    }

    @Override
    public final IdeFrameImpl getFrame(@Nullable Project project) {
        return this.myProjectToFrame.get(project);
    }

    public IdeFrame getIdeFrame(@Nullable Project project) {
        Frame[] frames;
        if (project != null) {
            return this.getFrame(project);
        }
        Window window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        Component parent = UIUtil.findUltimateParent((Component)window);
        if (parent instanceof IdeFrame) {
            return (IdeFrame)parent;
        }
        for (Frame each : frames = Frame.getFrames()) {
            if (!(each instanceof IdeFrame)) continue;
            return (IdeFrame)each;
        }
        return null;
    }

    public void showFrame() {
        IdeFrameImpl frame = new IdeFrameImpl(this.myActionManager, this.myDataManager);
        this.myProjectToFrame.put(null, frame);
        Rectangle frameBounds = WindowManagerImpl.validateFrameBounds(this.myDefaultFrameInfo.getBounds());
        this.myDefaultFrameInfo.setBounds(frameBounds);
        frame.setBounds(frameBounds);
        frame.setExtendedState(this.myDefaultFrameInfo.getExtendedState());
        frame.setVisible(true);
        this.addFrameStateListener(frame);
        IdeMenuBar.installAppMenuIfNeeded(frame);
    }

    @NotNull
    private static Rectangle validateFrameBounds(@Nullable Rectangle frameBounds) {
        Rectangle bounds2;
        Rectangle rectangle = bounds2 = frameBounds != null ? frameBounds.getBounds() : null;
        if (bounds2 == null || !ScreenUtil.isVisible((Rectangle)bounds2)) {
            bounds2 = ScreenUtil.getMainScreenBounds();
            int xOff = bounds2.width / 8;
            int yOff = bounds2.height / 8;
            JBInsets.removeFrom((Rectangle)bounds2, (Insets)new Insets(yOff, xOff, yOff, xOff));
        }
        Rectangle rectangle2 = bounds2;
        if (rectangle2 == null) {
            WindowManagerImpl.$$$reportNull$$$0(3);
        }
        return rectangle2;
    }

    @Override
    public final IdeFrameImpl allocateFrame(@NotNull Project project) {
        Rectangle bounds2;
        FrameInfo frameInfo;
        boolean addComponentListener;
        if (project == null) {
            WindowManagerImpl.$$$reportNull$$$0(4);
        }
        LOG.assertTrue(!this.myProjectToFrame.containsKey(project));
        IdeFrameImpl frame = this.myProjectToFrame.remove(null);
        if (frame == null) {
            frame = new IdeFrameImpl(this.myActionManager, this.myDataManager);
        }
        boolean bl = addComponentListener = (frameInfo = ProjectFrameBounds.getInstance(project).getRawFrameInfo()) == null;
        if (frameInfo != null && frameInfo.getBounds() != null) {
            this.myDefaultFrameInfo.copyFrom(frameInfo);
            Rectangle frameBounds = FrameBoundsConverter.convertFromDeviceSpace(frameInfo.getBounds());
            this.myDefaultFrameInfo.setBounds(WindowManagerImpl.validateFrameBounds(frameBounds));
        }
        if (!((FrameState.isMaximized(frame.getExtendedState()) || FrameState.isFullScreen(frame)) && FrameState.isMaximized(this.myDefaultFrameInfo.getExtendedState()) || (bounds2 = this.myDefaultFrameInfo.getBounds()) == null)) {
            frame.setBounds(bounds2);
        }
        frame.setExtendedState(this.myDefaultFrameInfo.getExtendedState());
        frame.setProject(project);
        this.myProjectToFrame.put(project, frame);
        frame.setVisible(true);
        frame.addWindowListener(this.myActivationListener);
        if (addComponentListener) {
            if (RecentProjectsManagerBase.getInstanceEx().isBatchOpening()) {
                frame.toBack();
            }
            this.addFrameStateListener(frame);
        }
        ((WindowManagerListener)this.myEventDispatcher.getMulticaster()).frameCreated((IdeFrame)frame);
        IdeMenuBar.installAppMenuIfNeeded(frame);
        return frame;
    }

    private void addFrameStateListener(final @NotNull IdeFrameImpl frame) {
        if (frame == null) {
            WindowManagerImpl.$$$reportNull$$$0(5);
        }
        frame.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(@NotNull ComponentEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                WindowManagerImpl.this.updateFrameBounds(frame);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/wm/impl/WindowManagerImpl$2", "componentMoved"));
            }
        });
    }

    private void proceedDialogDisposalQueue(Project project) {
        Set<JDialog> dialogs = this.myDialogsToDispose.get(project);
        if (dialogs == null) {
            return;
        }
        for (JDialog dialog2 : dialogs) {
            dialog2.dispose();
        }
        this.myDialogsToDispose.put(project, null);
    }

    private void queueForDisposal(JDialog dialog2, Project project) {
        Set dialogs = this.myDialogsToDispose.computeIfAbsent(project, k -> new HashSet());
        dialogs.add(dialog2);
    }

    @Override
    public final void releaseFrame(@NotNull IdeFrameImpl frame) {
        if (frame == null) {
            WindowManagerImpl.$$$reportNull$$$0(6);
        }
        ((WindowManagerListener)this.myEventDispatcher.getMulticaster()).beforeFrameReleased((IdeFrame)frame);
        Project project = frame.getProject();
        LOG.assertTrue(project != null);
        frame.removeWindowListener(this.myActivationListener);
        this.proceedDialogDisposalQueue(project);
        frame.setProject(null);
        frame.setTitle(null);
        frame.setFileTitle(null, null);
        this.myProjectToFrame.remove(project);
        if (this.myProjectToFrame.isEmpty()) {
            this.myProjectToFrame.put(null, frame);
        } else {
            Disposer.dispose((Disposable)frame.getStatusBar());
            frame.dispose();
        }
    }

    public final void disposeRootFrame() {
        IdeFrameImpl rootFrame;
        if (this.myProjectToFrame.size() == 1 && (rootFrame = this.myProjectToFrame.remove(null)) != null) {
            rootFrame.dispose();
        }
    }

    @Override
    public final Window getMostRecentFocusedWindow() {
        return this.myWindowWatcher.getFocusedWindow();
    }

    @Override
    public final Component getFocusedComponent(@NotNull Window window) {
        if (window == null) {
            WindowManagerImpl.$$$reportNull$$$0(7);
        }
        return this.myWindowWatcher.getFocusedComponent(window);
    }

    @Override
    @Nullable
    public final Component getFocusedComponent(@Nullable Project project) {
        return this.myWindowWatcher.getFocusedComponent(project);
    }

    @Override
    @NotNull
    public final CommandProcessor getCommandProcessor() {
        CommandProcessor commandProcessor = this.myCommandProcessor;
        if (commandProcessor == null) {
            WindowManagerImpl.$$$reportNull$$$0(8);
        }
        return commandProcessor;
    }

    public void loadState(@NotNull Element state) {
        Element desktopElement;
        Element frameElement;
        if (state == null) {
            WindowManagerImpl.$$$reportNull$$$0(9);
        }
        if ((frameElement = state.getChild(FRAME_ELEMENT)) != null) {
            int frameExtendedState = StringUtil.parseInt((String)frameElement.getAttributeValue(EXTENDED_STATE_ATTR), (int)0);
            if ((frameExtendedState & 1) > 0) {
                frameExtendedState = 0;
            }
            this.myDefaultFrameInfo.setBounds(WindowManagerImpl.loadFrameBounds(frameElement));
            this.myDefaultFrameInfo.setExtendedState(frameExtendedState);
        }
        if ((desktopElement = state.getChild("layout")) != null) {
            this.myLayout.readExternal(desktopElement);
        }
    }

    @Nullable
    private static Rectangle loadFrameBounds(@NotNull Element frameElement) {
        Rectangle bounds2;
        if (frameElement == null) {
            WindowManagerImpl.$$$reportNull$$$0(10);
        }
        return (bounds2 = ProjectFrameBoundsKt.deserializeBounds(frameElement)) == null ? null : FrameBoundsConverter.convertFromDeviceSpace(bounds2);
    }

    @Nullable
    public Element getState() {
        Element frameState = this.getFrameState();
        if (frameState == null) {
            return null;
        }
        Element state = new Element("state");
        state.addContent(frameState);
        Element layoutElement = this.myLayout.writeExternal("layout");
        if (layoutElement != null) {
            state.addContent(layoutElement);
        }
        return state;
    }

    @Nullable
    private Element getFrameState() {
        Project[] projects = ProjectManager.getInstance().getOpenProjects();
        if (projects.length == 0) {
            return null;
        }
        Project project = projects[0];
        FrameInfo frameInfo = ProjectFrameBoundsKt.getFrameInfoInDeviceSpace(this, project);
        if (frameInfo == null) {
            return null;
        }
        Element frameElement = new Element(FRAME_ELEMENT);
        Rectangle rectangle = frameInfo.getBounds();
        if (rectangle != null) {
            ProjectFrameBoundsKt.serializeBounds(rectangle, frameElement);
        }
        if (frameInfo.getExtendedState() != 0) {
            frameElement.setAttribute(EXTENDED_STATE_ATTR, Integer.toString(frameInfo.getExtendedState()));
        }
        return frameElement;
    }

    int updateFrameBounds(@NotNull IdeFrameImpl frame) {
        boolean usePreviousBounds;
        Object peer;
        if (frame == null) {
            WindowManagerImpl.$$$reportNull$$$0(11);
        }
        int extendedState = frame.getExtendedState();
        if (SystemInfo.isMacOSLion && (peer = AWTAccessor.getComponentAccessor().getPeer(frame)) instanceof FramePeer) {
            extendedState = ((FramePeer)peer).getState();
        }
        boolean isMaximized = FrameState.isMaximized(extendedState) || this.isFullScreenSupportedInCurrentOS() && frame.isInFullScreen();
        Rectangle frameBounds = this.myDefaultFrameInfo.getBounds();
        boolean bl = usePreviousBounds = isMaximized && frameBounds != null && frame.getBounds().contains(new Point((int)frameBounds.getCenterX(), (int)frameBounds.getCenterY()));
        if (!usePreviousBounds) {
            this.myDefaultFrameInfo.setBounds(frame.getBounds());
        }
        return extendedState;
    }

    @Override
    public final DesktopLayout getLayout() {
        return this.myLayout;
    }

    @Override
    public final void setLayout(DesktopLayout layout) {
        this.myLayout.copyFrom(layout);
    }

    public WindowWatcher getWindowWatcher() {
        return this.myWindowWatcher;
    }

    public boolean isFullScreenSupportedInCurrentOS() {
        return SystemInfo.isMacOSLion || SystemInfo.isWindows || SystemInfo.isXWindow && X11UiUtil.isFullScreenSupported();
    }

    static boolean isFloatingMenuBarSupported() {
        return !SystemInfo.isMac && WindowManagerImpl.getInstance().isFullScreenSupportedInCurrentOS();
    }

    static {
        try {
            System.loadLibrary("jawt");
        }
        catch (Throwable t) {
            LOG.info("jawt failed to load", t);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/wm/impl/WindowManagerImpl";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 5: 
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = FRAME_ELEMENT;
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "window";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frameElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllProjectFrames";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/wm/impl/WindowManagerImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "validateFrameBounds";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getScreenBounds";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getStatusBar";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "allocateFrame";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addFrameStateListener";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "releaseFrame";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getFocusedComponent";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "loadFrameBounds";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "updateFrameBounds";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class FrameBoundsConverter {
        FrameBoundsConverter() {
        }

        @NotNull
        static Rectangle convertFromDeviceSpace(@NotNull Rectangle bounds2) {
            if (bounds2 == null) {
                FrameBoundsConverter.$$$reportNull$$$0(0);
            }
            Rectangle b = bounds2.getBounds();
            if (!FrameBoundsConverter.shouldConvert()) {
                Rectangle rectangle = b;
                if (rectangle == null) {
                    FrameBoundsConverter.$$$reportNull$$$0(1);
                }
                return rectangle;
            }
            try {
                for (GraphicsDevice gd : GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()) {
                    Rectangle devBounds = gd.getDefaultConfiguration().getBounds();
                    FrameBoundsConverter.scaleUp(devBounds, gd.getDefaultConfiguration());
                    Rectangle2D.Float devBounds2D = new Rectangle2D.Float(devBounds.x, devBounds.y, devBounds.width, devBounds.height);
                    Point2D.Float center2d = new Point2D.Float(b.x + b.width / 2, b.y + b.height / 2);
                    if (!devBounds2D.contains(center2d)) continue;
                    FrameBoundsConverter.scaleDown(b, gd.getDefaultConfiguration());
                    break;
                }
            }
            catch (HeadlessException headlessException) {
                // empty catch block
            }
            Rectangle rectangle = b;
            if (rectangle == null) {
                FrameBoundsConverter.$$$reportNull$$$0(2);
            }
            return rectangle;
        }

        public static Rectangle convertToDeviceSpace(GraphicsConfiguration gc, @NotNull Rectangle bounds2) {
            if (bounds2 == null) {
                FrameBoundsConverter.$$$reportNull$$$0(3);
            }
            Rectangle b = bounds2.getBounds();
            if (!FrameBoundsConverter.shouldConvert()) {
                return b;
            }
            try {
                FrameBoundsConverter.scaleUp(b, gc);
            }
            catch (HeadlessException headlessException) {
                // empty catch block
            }
            return b;
        }

        private static boolean shouldConvert() {
            if (SystemInfo.isLinux || SystemInfo.isMac) {
                return false;
            }
            return UIUtil.isJreHiDPIEnabled();
        }

        private static void scaleUp(@NotNull Rectangle bounds2, @NotNull GraphicsConfiguration gc) {
            if (bounds2 == null) {
                FrameBoundsConverter.$$$reportNull$$$0(4);
            }
            if (gc == null) {
                FrameBoundsConverter.$$$reportNull$$$0(5);
            }
            FrameBoundsConverter.scale(bounds2, gc.getBounds(), JBUI.sysScale((GraphicsConfiguration)gc));
        }

        private static void scaleDown(@NotNull Rectangle bounds2, @NotNull GraphicsConfiguration gc) {
            if (bounds2 == null) {
                FrameBoundsConverter.$$$reportNull$$$0(6);
            }
            if (gc == null) {
                FrameBoundsConverter.$$$reportNull$$$0(7);
            }
            float scale = JBUI.sysScale((GraphicsConfiguration)gc);
            assert (scale != 0.0f);
            FrameBoundsConverter.scale(bounds2, gc.getBounds(), 1.0f / scale);
        }

        private static void scale(@NotNull Rectangle bounds2, @NotNull Rectangle deviceBounds, float scale) {
            if (bounds2 == null) {
                FrameBoundsConverter.$$$reportNull$$$0(8);
            }
            if (deviceBounds == null) {
                FrameBoundsConverter.$$$reportNull$$$0(9);
            }
            int x = (int)Math.floor((float)deviceBounds.x + (float)(bounds2.x - deviceBounds.x) * scale);
            int y = (int)Math.floor((float)deviceBounds.y + (float)(bounds2.y - deviceBounds.y) * scale);
            bounds2.setBounds(x, y, (int)Math.ceil((float)bounds2.width * scale), (int)Math.ceil((float)bounds2.height * scale));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "bounds";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/wm/impl/WindowManagerImpl$FrameBoundsConverter";
                    break;
                }
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "gc";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "deviceBounds";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/wm/impl/WindowManagerImpl$FrameBoundsConverter";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "convertFromDeviceSpace";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "convertFromDeviceSpace";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "convertToDeviceSpace";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "scaleUp";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "scaleDown";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "scale";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

