/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.persistent;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.ex.temp.TempFileSystem;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.impl.FakeVirtualFile;
import com.intellij.openapi.vfs.newvfs.impl.VirtualDirectoryImpl;
import com.intellij.openapi.vfs.newvfs.impl.VirtualFileSystemEntry;
import com.intellij.openapi.vfs.newvfs.persistent.LocalFileSystemRefreshWorker;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.openapi.vfs.newvfs.persistent.VfsEventGenerationHelper;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.OpenTHashSet;
import com.intellij.util.containers.Queue;
import com.intellij.util.text.FilePathHashingStrategy;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RefreshWorker {
    private final boolean myIsRecursive;
    private final Queue<Pair<NewVirtualFile, FileAttributes>> myRefreshQueue;
    private final VfsEventGenerationHelper myHelper;
    private volatile boolean myCancelled;
    private final LocalFileSystemRefreshWorker myLocalFileSystemRefreshWorker;
    private static Function<? super VirtualFile, Boolean> ourCancellingCondition;

    public RefreshWorker(@NotNull NewVirtualFile refreshRoot, boolean isRecursive) {
        if (refreshRoot == null) {
            RefreshWorker.$$$reportNull$$$0(0);
        }
        this.myRefreshQueue = new Queue(100);
        this.myHelper = new VfsEventGenerationHelper();
        boolean canUseNioRefresher = refreshRoot.isInLocalFileSystem() && !(refreshRoot.getFileSystem() instanceof TempFileSystem);
        this.myLocalFileSystemRefreshWorker = canUseNioRefresher && Registry.is((String)"vfs.use.nio-based.local.refresh.worker") ? new LocalFileSystemRefreshWorker(refreshRoot, isRecursive) : null;
        this.myIsRecursive = isRecursive;
        this.myRefreshQueue.addLast((Object)Pair.pair((Object)refreshRoot, null));
    }

    @NotNull
    public List<VFileEvent> getEvents() {
        if (this.myLocalFileSystemRefreshWorker != null) {
            List<VFileEvent> list2 = this.myLocalFileSystemRefreshWorker.getEvents();
            if (list2 == null) {
                RefreshWorker.$$$reportNull$$$0(1);
            }
            return list2;
        }
        List<VFileEvent> list3 = this.myHelper.getEvents();
        if (list3 == null) {
            RefreshWorker.$$$reportNull$$$0(2);
        }
        return list3;
    }

    public void cancel() {
        if (this.myLocalFileSystemRefreshWorker != null) {
            this.myLocalFileSystemRefreshWorker.cancel();
        }
        this.myCancelled = true;
    }

    public void scan() {
        if (this.myLocalFileSystemRefreshWorker != null) {
            this.myLocalFileSystemRefreshWorker.scan();
            return;
        }
        NewVirtualFile root = (NewVirtualFile)((Pair)this.myRefreshQueue.peekFirst()).first;
        NewVirtualFileSystem fs = root.getFileSystem();
        if (root.isDirectory()) {
            fs = PersistentFS.replaceWithNativeFS(fs);
        }
        try {
            this.processQueue(fs, PersistentFS.getInstance());
        }
        catch (RefreshCancelledException e) {
            VfsEventGenerationHelper.LOG.trace("refresh cancelled");
        }
    }

    private void processQueue(@NotNull NewVirtualFileSystem fs, @NotNull PersistentFS persistence) throws RefreshCancelledException {
        if (fs == null) {
            RefreshWorker.$$$reportNull$$$0(3);
        }
        if (persistence == null) {
            RefreshWorker.$$$reportNull$$$0(4);
        }
        TObjectHashingStrategy strategy = FilePathHashingStrategy.create((boolean)fs.isCaseSensitive());
        while (!this.myRefreshQueue.isEmpty()) {
            FileAttributes attributes;
            Pair pair = (Pair)this.myRefreshQueue.pullFirst();
            NewVirtualFile file2 = (NewVirtualFile)pair.first;
            if (!this.myHelper.checkDirty(file2)) continue;
            this.checkCancelled(file2);
            FileAttributes fileAttributes = attributes = pair.second != null ? (FileAttributes)pair.second : fs.getAttributes((VirtualFile)file2);
            if (attributes == null) {
                this.myHelper.scheduleDeletion((VirtualFile)file2);
                file2.markClean();
                continue;
            }
            NewVirtualFile parent = file2.getParent();
            if (parent != null && this.checkAndScheduleFileTypeChange(fs, (VirtualFile)parent, (VirtualFile)file2, attributes)) {
                file2.markClean();
                continue;
            }
            if (file2.isDirectory()) {
                boolean fullSync = ((VirtualDirectoryImpl)file2).allChildrenLoaded();
                if (fullSync) {
                    this.fullDirRefresh(fs, persistence, (TObjectHashingStrategy<String>)strategy, (VirtualDirectoryImpl)file2);
                } else {
                    this.partialDirRefresh(fs, (TObjectHashingStrategy<String>)strategy, (VirtualDirectoryImpl)file2);
                }
            } else {
                this.myHelper.checkContentChanged((VirtualFile)file2, persistence.getTimeStamp((VirtualFile)file2), attributes.lastModified, persistence.getLastRecordedLength((VirtualFile)file2), attributes.length);
            }
            this.myHelper.checkWritableAttributeChange((VirtualFile)file2, persistence.isWritable((VirtualFile)file2), attributes.isWritable());
            if (SystemInfo.isWindows) {
                this.myHelper.checkHiddenAttributeChange((VirtualFile)file2, file2.is(VFileProperty.HIDDEN), attributes.isHidden());
            }
            if (attributes.isSymLink()) {
                this.myHelper.checkSymbolicLinkChange((VirtualFile)file2, file2.getCanonicalPath(), fs.resolveSymLink((VirtualFile)file2));
            }
            if (!this.myIsRecursive && file2.isDirectory()) continue;
            file2.markClean();
        }
    }

    private void fullDirRefresh(@NotNull NewVirtualFileSystem fs, @NotNull PersistentFS persistence, @NotNull TObjectHashingStrategy<String> strategy, @NotNull VirtualDirectoryImpl dir) {
        OpenTHashSet actualNames;
        ArrayList updatedMap;
        ArrayList newKids;
        THashSet deletedNames;
        VirtualFile[] children2;
        Object[] currentNames;
        boolean hasEvents;
        if (fs == null) {
            RefreshWorker.$$$reportNull$$$0(5);
        }
        if (persistence == null) {
            RefreshWorker.$$$reportNull$$$0(6);
        }
        if (strategy == null) {
            RefreshWorker.$$$reportNull$$$0(7);
        }
        if (dir == null) {
            RefreshWorker.$$$reportNull$$$0(8);
        }
        do {
            Pair<String[], VirtualFile[]> result2;
            if ((result2 = LocalFileSystemRefreshWorker.getDirectorySnapshot(persistence, dir)) == null) {
                return;
            }
            currentNames = (String[])result2.getFirst();
            children2 = (VirtualFile[])result2.getSecond();
            Object[] upToDateNames = VfsUtil.filterNames((String[])fs.list((VirtualFile)dir));
            THashSet newNames = ContainerUtil.newTroveSet(strategy, (Object[])upToDateNames);
            ContainerUtil.removeAll((Collection)newNames, (Object[])currentNames);
            deletedNames = ContainerUtil.newTroveSet(strategy, (Object[])currentNames);
            ContainerUtil.removeAll((Collection)deletedNames, (Object[])upToDateNames);
            OpenTHashSet openTHashSet = actualNames = fs.isCaseSensitive() ? null : new OpenTHashSet(strategy, upToDateNames);
            if (VfsEventGenerationHelper.LOG.isTraceEnabled()) {
                VfsEventGenerationHelper.LOG.trace("current=" + Arrays.toString(currentNames) + " +" + newNames + " -" + deletedNames);
            }
            newKids = ContainerUtil.newArrayListWithCapacity((int)newNames.size());
            for (VirtualFile[] name : newNames) {
                this.checkCancelled(dir);
                NewChildRecord record = RefreshWorker.childRecord(fs, (VirtualFile)dir, (String)name);
                if (record != null) {
                    newKids.add(record);
                    continue;
                }
                if (!VfsEventGenerationHelper.LOG.isTraceEnabled()) continue;
                VfsEventGenerationHelper.LOG.trace("[+] fs=" + fs + " dir=" + (Object)((Object)dir) + " name=" + (String)name);
            }
            updatedMap = ContainerUtil.newArrayListWithCapacity((int)children2.length);
            for (VirtualFile child2 : children2) {
                if (deletedNames.contains(child2.getName())) continue;
                this.checkCancelled(dir);
                updatedMap.add(Pair.pair((Object)child2, (Object)fs.getAttributes(child2)));
            }
        } while (!(hasEvents = ((Boolean)ReadAction.compute(() -> this.lambda$fullDirRefresh$0((String[])currentNames, persistence, dir, children2, (Set)deletedNames, newKids, updatedMap, fs, actualNames))).booleanValue()));
    }

    private void partialDirRefresh(@NotNull NewVirtualFileSystem fs, @NotNull TObjectHashingStrategy<String> strategy, @NotNull VirtualDirectoryImpl dir) {
        ArrayList newKids;
        OpenTHashSet actualNames;
        ArrayList existingMap;
        List wanted;
        List cached;
        boolean hasEvents;
        if (fs == null) {
            RefreshWorker.$$$reportNull$$$0(9);
        }
        if (strategy == null) {
            RefreshWorker.$$$reportNull$$$0(10);
        }
        if (dir == null) {
            RefreshWorker.$$$reportNull$$$0(11);
        }
        do {
            Object child22;
            Pair result2 = (Pair)ReadAction.compute(() -> Pair.pair((Object)dir.getCachedChildren(), dir.getSuspiciousNames()));
            cached = (List)result2.getFirst();
            wanted = (List)result2.getSecond();
            OpenTHashSet openTHashSet = actualNames = fs.isCaseSensitive() || cached.isEmpty() ? null : new OpenTHashSet(strategy, (Object[])VfsUtil.filterNames((String[])fs.list((VirtualFile)dir)));
            if (VfsEventGenerationHelper.LOG.isTraceEnabled()) {
                VfsEventGenerationHelper.LOG.trace("cached=" + cached + " actual=" + actualNames);
                VfsEventGenerationHelper.LOG.trace("suspicious=" + wanted);
            }
            existingMap = ContainerUtil.newArrayListWithCapacity((int)cached.size());
            for (Object child22 : cached) {
                this.checkCancelled(dir);
                existingMap.add(Pair.pair((Object)child22, (Object)fs.getAttributes((VirtualFile)child22)));
            }
            newKids = ContainerUtil.newArrayListWithCapacity((int)wanted.size());
            child22 = wanted.iterator();
            while (child22.hasNext()) {
                String name = (String)child22.next();
                if (name.isEmpty()) continue;
                this.checkCancelled(dir);
                NewChildRecord record = RefreshWorker.childRecord(fs, (VirtualFile)dir, name);
                if (record == null) continue;
                newKids.add(record);
            }
        } while (!(hasEvents = ((Boolean)ReadAction.compute(() -> {
            if (!cached.equals(dir.getCachedChildren()) || !wanted.equals(dir.getSuspiciousNames())) {
                if (VfsEventGenerationHelper.LOG.isTraceEnabled()) {
                    VfsEventGenerationHelper.LOG.trace("retry: " + (Object)((Object)dir));
                }
                return false;
            }
            for (Pair pair : existingMap) {
                VirtualFile child2 = (VirtualFile)pair.first;
                FileAttributes childAttributes = (FileAttributes)pair.second;
                if (childAttributes != null) {
                    this.checkAndScheduleChildRefresh(fs, (VirtualFile)dir, child2, childAttributes);
                    this.checkAndScheduleFileNameChange((OpenTHashSet<String>)actualNames, child2);
                    continue;
                }
                this.myHelper.scheduleDeletion(child2);
            }
            for (NewChildRecord record : newKids) {
                this.myHelper.scheduleCreation((VirtualFile)dir, record.name, record.attributes, record.isEmptyDir, record.symlinkTarget);
            }
            return true;
        })).booleanValue()));
    }

    private static NewChildRecord childRecord(NewVirtualFileSystem fs, VirtualFile dir, String name) {
        FakeVirtualFile file2 = new FakeVirtualFile(dir, name);
        FileAttributes attributes = fs.getAttributes((VirtualFile)file2);
        if (attributes == null) {
            return null;
        }
        boolean isEmptyDir = attributes.isDirectory() && !fs.hasChildren((VirtualFile)file2);
        String symlinkTarget = attributes.isSymLink() ? fs.resolveSymLink((VirtualFile)file2) : null;
        return new NewChildRecord(name, attributes, isEmptyDir, symlinkTarget);
    }

    private void checkCancelled(@NotNull NewVirtualFile stopAt) {
        if (stopAt == null) {
            RefreshWorker.$$$reportNull$$$0(12);
        }
        if (this.myCancelled || ourCancellingCondition != null && ((Boolean)ourCancellingCondition.fun((Object)stopAt)).booleanValue()) {
            if (VfsEventGenerationHelper.LOG.isTraceEnabled()) {
                VfsEventGenerationHelper.LOG.trace("cancelled at: " + stopAt);
            }
            RefreshWorker.forceMarkDirty(stopAt);
            while (!this.myRefreshQueue.isEmpty()) {
                NewVirtualFile next = (NewVirtualFile)((Pair)this.myRefreshQueue.pullFirst()).first;
                RefreshWorker.forceMarkDirty(next);
            }
            throw new RefreshCancelledException();
        }
    }

    private static void forceMarkDirty(@NotNull NewVirtualFile file2) {
        if (file2 == null) {
            RefreshWorker.$$$reportNull$$$0(13);
        }
        file2.markClean();
        file2.markDirty();
    }

    private void checkAndScheduleChildRefresh(NewVirtualFileSystem fs, @NotNull VirtualFile parent, @NotNull VirtualFile child2, @NotNull FileAttributes childAttributes) {
        if (parent == null) {
            RefreshWorker.$$$reportNull$$$0(14);
        }
        if (child2 == null) {
            RefreshWorker.$$$reportNull$$$0(15);
        }
        if (childAttributes == null) {
            RefreshWorker.$$$reportNull$$$0(16);
        }
        if (!this.checkAndScheduleFileTypeChange(fs, parent, child2, childAttributes)) {
            boolean upToDateIsDirectory = childAttributes.isDirectory();
            if (this.myIsRecursive || !upToDateIsDirectory) {
                this.myRefreshQueue.addLast((Object)Pair.pair((Object)((NewVirtualFile)child2), (Object)childAttributes));
            }
        }
    }

    private boolean checkAndScheduleFileTypeChange(NewVirtualFileSystem fs, @NotNull VirtualFile parent, @NotNull VirtualFile child2, @NotNull FileAttributes childAttributes) {
        if (parent == null) {
            RefreshWorker.$$$reportNull$$$0(17);
        }
        if (child2 == null) {
            RefreshWorker.$$$reportNull$$$0(18);
        }
        if (childAttributes == null) {
            RefreshWorker.$$$reportNull$$$0(19);
        }
        boolean currentIsDirectory = child2.isDirectory();
        boolean currentIsSymlink = child2.is(VFileProperty.SYMLINK);
        boolean currentIsSpecial = child2.is(VFileProperty.SPECIAL);
        boolean upToDateIsDirectory = childAttributes.isDirectory();
        boolean upToDateIsSymlink = childAttributes.isSymLink();
        boolean upToDateIsSpecial = childAttributes.isSpecial();
        if (currentIsDirectory != upToDateIsDirectory || currentIsSymlink != upToDateIsSymlink || currentIsSpecial != upToDateIsSpecial) {
            this.myHelper.scheduleDeletion(child2);
            boolean isEmptyDir = upToDateIsDirectory && !fs.hasChildren(child2);
            String symlinkTarget = upToDateIsSymlink ? fs.resolveSymLink(child2) : null;
            this.myHelper.scheduleCreation(parent, child2.getName(), childAttributes, isEmptyDir, symlinkTarget);
            return true;
        }
        return false;
    }

    private void checkAndScheduleFileNameChange(@Nullable OpenTHashSet<String> actualNames, @NotNull VirtualFile child2) {
        String currentName;
        String actualName;
        if (child2 == null) {
            RefreshWorker.$$$reportNull$$$0(20);
        }
        if (actualNames != null && (actualName = (String)actualNames.get((Object)(currentName = child2.getName()))) != null && !currentName.equals(actualName)) {
            this.myHelper.scheduleAttributeChange(child2, "name", currentName, actualName);
        }
    }

    public static void setCancellingCondition(@Nullable Function<? super VirtualFile, Boolean> condition) {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        LocalFileSystemRefreshWorker.setCancellingCondition(condition);
        ourCancellingCondition = condition;
    }

    private /* synthetic */ Boolean lambda$fullDirRefresh$0(String[] currentNames, PersistentFS persistence, VirtualDirectoryImpl dir, VirtualFile[] children2, Set deletedNames, List newKids, List updatedMap, NewVirtualFileSystem fs, OpenTHashSet actualNames) throws RuntimeException {
        VirtualFileSystemEntry child2;
        if (!Arrays.equals(currentNames, persistence.list((VirtualFile)dir)) || !Arrays.equals(children2, dir.getChildren())) {
            if (VfsEventGenerationHelper.LOG.isTraceEnabled()) {
                VfsEventGenerationHelper.LOG.trace("retry: " + (Object)((Object)dir));
            }
            return false;
        }
        for (String name : deletedNames) {
            child2 = dir.findChild(name);
            if (child2 == null) continue;
            this.myHelper.scheduleDeletion((VirtualFile)child2);
        }
        for (NewChildRecord record : newKids) {
            this.myHelper.scheduleCreation((VirtualFile)dir, record.name, record.attributes, record.isEmptyDir, record.symlinkTarget);
        }
        for (Pair pair : updatedMap) {
            child2 = (VirtualFile)pair.first;
            FileAttributes childAttributes = (FileAttributes)pair.second;
            if (childAttributes != null) {
                this.checkAndScheduleChildRefresh(fs, (VirtualFile)dir, (VirtualFile)child2, childAttributes);
                this.checkAndScheduleFileNameChange((OpenTHashSet<String>)actualNames, (VirtualFile)child2);
                continue;
            }
            if (VfsEventGenerationHelper.LOG.isTraceEnabled()) {
                VfsEventGenerationHelper.LOG.warn("[x] fs=" + fs + " dir=" + (Object)((Object)dir) + " name=" + child2.getName());
            }
            this.myHelper.scheduleDeletion((VirtualFile)child2);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refreshRoot";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/newvfs/persistent/RefreshWorker";
                break;
            }
            case 3: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fs";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "persistence";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strategy";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stopAt";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 15: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childAttributes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/newvfs/persistent/RefreshWorker";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getEvents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processQueue";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "fullDirRefresh";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "partialDirRefresh";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "checkCancelled";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "forceMarkDirty";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "checkAndScheduleChildRefresh";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "checkAndScheduleFileTypeChange";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "checkAndScheduleFileNameChange";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class RefreshCancelledException
    extends RuntimeException {
        private RefreshCancelledException() {
        }
    }

    private static class NewChildRecord {
        final String name;
        final FileAttributes attributes;
        final boolean isEmptyDir;
        final String symlinkTarget;

        NewChildRecord(String name, FileAttributes attributes, boolean isEmptyDir, String symlinkTarget) {
            this.name = name;
            this.attributes = attributes;
            this.isEmptyDir = isEmptyDir;
            this.symlinkTarget = symlinkTarget;
        }
    }
}

