/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.encoding;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.undo.GlobalUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectLocator;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.ChooseFileEncodingAction;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.encoding.EncodingUtil;
import com.intellij.openapi.vfs.encoding.IncompatibleEncodingDialog;
import com.intellij.util.Function;
import java.io.IOException;
import java.nio.charset.Charset;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeFileEncodingAction
extends AnAction
implements DumbAware {
    private final boolean allowDirectories;

    public ChangeFileEncodingAction() {
        this(false);
    }

    public ChangeFileEncodingAction(boolean allowDirectories) {
        this.allowDirectories = allowDirectories;
    }

    private boolean checkEnabled(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            ChangeFileEncodingAction.$$$reportNull$$$0(0);
        }
        if (this.allowDirectories && virtualFile.isDirectory()) {
            return true;
        }
        FileDocumentManager documentManager = FileDocumentManager.getInstance();
        Document document = documentManager.getDocument(virtualFile);
        if (document == null) {
            return false;
        }
        return EncodingUtil.checkCanConvert(virtualFile) == null || EncodingUtil.checkCanReload(virtualFile, null) == null;
    }

    public void update(@NotNull AnActionEvent e) {
        VirtualFile myFile;
        if (e == null) {
            ChangeFileEncodingAction.$$$reportNull$$$0(1);
        }
        boolean enabled = (myFile = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE)) != null && this.checkEnabled(myFile);
        e.getPresentation().setEnabled(enabled);
        e.getPresentation().setVisible(myFile != null);
    }

    public final void actionPerformed(@NotNull AnActionEvent e) {
        DataContext dataContext;
        ListPopup popup2;
        if (e == null) {
            ChangeFileEncodingAction.$$$reportNull$$$0(2);
        }
        if ((popup2 = this.createPopup(dataContext = e.getDataContext())) != null) {
            popup2.showInBestPositionFor(dataContext);
        }
    }

    @Nullable
    public ListPopup createPopup(@NotNull DataContext dataContext) {
        byte[] bytes;
        VirtualFile virtualFile;
        if (dataContext == null) {
            ChangeFileEncodingAction.$$$reportNull$$$0(3);
        }
        if ((virtualFile = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(dataContext)) == null) {
            return null;
        }
        boolean enabled = this.checkEnabled(virtualFile);
        if (!enabled) {
            return null;
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        FileDocumentManager documentManager = FileDocumentManager.getInstance();
        Document document = documentManager.getDocument(virtualFile);
        if (!this.allowDirectories && virtualFile.isDirectory() || document == null && !virtualFile.isDirectory()) {
            return null;
        }
        try {
            bytes = virtualFile.isDirectory() ? null : VfsUtilCore.loadBytes((VirtualFile)virtualFile);
        }
        catch (IOException e) {
            return null;
        }
        DefaultActionGroup group = this.createActionGroup(virtualFile, editor, document, bytes, null);
        return JBPopupFactory.getInstance().createActionGroupPopup(this.getTemplatePresentation().getText(), (ActionGroup)group, dataContext, JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, false);
    }

    public DefaultActionGroup createActionGroup(@Nullable VirtualFile myFile, final Editor editor, final Document document, final byte[] bytes, final @Nullable String clearItemText) {
        return new ChooseFileEncodingAction(myFile){

            @Override
            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
            }

            @NotNull
            protected DefaultActionGroup createPopupActionGroup(JComponent button) {
                DefaultActionGroup defaultActionGroup = this.createCharsetsActionGroup(clearItemText, null, (Function<? super Charset, String>)((Function)charset -> "Change encoding to '" + charset.displayName() + "'"));
                if (defaultActionGroup == null) {
                    1.$$$reportNull$$$0(1);
                }
                return defaultActionGroup;
            }

            @Override
            protected void chosen(@Nullable VirtualFile virtualFile, @NotNull Charset charset) {
                if (charset == null) {
                    1.$$$reportNull$$$0(2);
                }
                ChangeFileEncodingAction.this.chosen(document, editor, virtualFile, bytes, charset);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/openapi/vfs/encoding/ChangeFileEncodingAction$1";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "charset";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/openapi/vfs/encoding/ChangeFileEncodingAction$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createPopupActionGroup";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "update";
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "chosen";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }.createPopupActionGroup(null);
    }

    protected boolean chosen(Document document, Editor editor, @Nullable VirtualFile virtualFile, byte[] bytes, @NotNull Charset charset) {
        if (charset == null) {
            ChangeFileEncodingAction.$$$reportNull$$$0(4);
        }
        if (virtualFile == null) {
            return false;
        }
        String text = document.getText();
        EncodingUtil.Magic8 isSafeToConvert = EncodingUtil.isSafeToConvertTo(virtualFile, text, bytes, charset);
        EncodingUtil.Magic8 isSafeToReload = EncodingUtil.isSafeToReloadIn(virtualFile, text, bytes, charset);
        Project project = ProjectLocator.getInstance().guessProjectForFile(virtualFile);
        return ChangeFileEncodingAction.changeTo(project, document, editor, virtualFile, charset, isSafeToConvert, isSafeToReload);
    }

    public static boolean changeTo(final Project project, @NotNull Document document, Editor editor, @NotNull VirtualFile virtualFile, @NotNull Charset charset, @NotNull EncodingUtil.Magic8 isSafeToConvert, @NotNull EncodingUtil.Magic8 isSafeToReload) {
        Runnable redo;
        Runnable undo;
        if (document == null) {
            ChangeFileEncodingAction.$$$reportNull$$$0(5);
        }
        if (virtualFile == null) {
            ChangeFileEncodingAction.$$$reportNull$$$0(6);
        }
        if (charset == null) {
            ChangeFileEncodingAction.$$$reportNull$$$0(7);
        }
        if (isSafeToConvert == null) {
            ChangeFileEncodingAction.$$$reportNull$$$0(8);
        }
        if (isSafeToReload == null) {
            ChangeFileEncodingAction.$$$reportNull$$$0(9);
        }
        Charset oldCharset = virtualFile.getCharset();
        if (isSafeToConvert == EncodingUtil.Magic8.ABSOLUTELY && isSafeToReload == EncodingUtil.Magic8.ABSOLUTELY) {
            undo = () -> EncodingManager.getInstance().setEncoding(virtualFile, oldCharset);
            redo = () -> EncodingManager.getInstance().setEncoding(virtualFile, charset);
        } else {
            IncompatibleEncodingDialog dialog2 = new IncompatibleEncodingDialog(virtualFile, charset, isSafeToReload, isSafeToConvert);
            dialog2.show();
            if (dialog2.getExitCode() == 10) {
                undo = () -> EncodingUtil.reloadIn(virtualFile, oldCharset, project);
                redo = () -> EncodingUtil.reloadIn(virtualFile, charset, project);
            } else if (dialog2.getExitCode() == 20) {
                undo = () -> EncodingUtil.saveIn(document, editor, virtualFile, oldCharset);
                redo = () -> EncodingUtil.saveIn(document, editor, virtualFile, charset);
            } else {
                return false;
            }
        }
        GlobalUndoableAction action = new GlobalUndoableAction(new VirtualFile[]{virtualFile}){

            public void undo() {
                Application application = ApplicationManager.getApplication();
                application.invokeLater(undo, ModalityState.NON_MODAL, (project == null ? application : project).getDisposed());
            }

            public void redo() {
                Application application = ApplicationManager.getApplication();
                application.invokeLater(redo, ModalityState.NON_MODAL, (project == null ? application : project).getDisposed());
            }
        };
        redo.run();
        CommandProcessor.getInstance().executeCommand(project, () -> ChangeFileEncodingAction.lambda$changeTo$6(project, (UndoableAction)action), "Change encoding for '" + virtualFile.getName() + "'", null, UndoConfirmationPolicy.REQUEST_CONFIRMATION);
        return true;
    }

    private static /* synthetic */ void lambda$changeTo$6(Project project, UndoableAction action) {
        UndoManager undoManager = project == null ? UndoManager.getGlobalInstance() : UndoManager.getInstance((Project)project);
        undoManager.undoableActionPerformed(action);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charset";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isSafeToConvert";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isSafeToReload";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vfs/encoding/ChangeFileEncodingAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkEnabled";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createPopup";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "chosen";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "changeTo";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

