/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.LocallyDeletedChange;
import com.intellij.openapi.vcs.changes.LogicalLock;
import com.intellij.openapi.vcs.changes.RemoteRevisionsCache;
import com.intellij.openapi.vcs.changes.ui.BaseChangesGroupingPolicy;
import com.intellij.openapi.vcs.changes.ui.ChangeListRemoteState;
import com.intellij.openapi.vcs.changes.ui.ChangeNodeDecorator;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserChangeListNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserChangeNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserIgnoredFilesNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserModuleNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserSpecificFilesNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserUnversionedFilesNode;
import com.intellij.openapi.vcs.changes.ui.ChangesGroupingPolicy;
import com.intellij.openapi.vcs.changes.ui.ChangesGroupingPolicyFactory;
import com.intellij.openapi.vcs.changes.ui.ChangesGroupingSupport;
import com.intellij.openapi.vcs.changes.ui.RemoteStatusChangeNodeDecorator;
import com.intellij.openapi.vcs.changes.ui.StaticFilePath;
import com.intellij.openapi.vcs.changes.ui.VirtualFileHierarchicalComparator;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TreeModelBuilder {
    public static final Key<Function<StaticFilePath, ChangesBrowserNode<?>>> PATH_NODE_BUILDER = Key.create((String)"ChangesTree.PathNodeBuilder");
    public static final NotNullLazyKey<Map<String, ChangesBrowserNode<?>>, ChangesBrowserNode<?>> DIRECTORY_CACHE = NotNullLazyKey.create((String)"ChangesTree.DirectoryCache", node -> ContainerUtil.newHashMap());
    private static final Key<ChangesGroupingPolicy> GROUPING_POLICY = Key.create((String)"ChangesTree.GroupingPolicy");
    public static final Key<Boolean> IS_CACHING_ROOT = Key.create((String)"ChangesTree.IsCachingRoot");
    protected final Project myProject;
    @NotNull
    protected final DefaultTreeModel myModel;
    @NotNull
    protected final ChangesBrowserNode myRoot;
    @NotNull
    private final ChangesGroupingPolicyFactory myGroupingPolicyFactory;
    private static final Comparator<ChangesBrowserNode> BROWSER_NODE_COMPARATOR = (node1, node2) -> {
        Class<?> clazz2;
        int sortWeightDiff = Comparing.compare((int)node1.getSortWeight(), (int)node2.getSortWeight());
        if (sortWeightDiff != 0) {
            return sortWeightDiff;
        }
        Class<?> clazz1 = node1.getClass();
        if (!clazz1.equals(clazz2 = node2.getClass())) {
            return Comparing.compare((Comparable)((Object)clazz1.getName()), (Comparable)((Object)clazz2.getName()));
        }
        if (node1 instanceof Comparable) {
            return ((Comparable)((Object)node1)).compareTo(node2);
        }
        return node1.compareUserObjects(node2.getUserObject());
    };
    protected static final Comparator<FilePath> PATH_COMPARATOR = Comparator.comparingInt(path -> path.getPath().length());
    protected static final Comparator<Change> CHANGE_COMPARATOR = Comparator.comparing(ChangesUtil::getFilePath, PATH_COMPARATOR);

    @Deprecated
    public TreeModelBuilder(@NotNull Project project, boolean showFlatten) {
        if (project == null) {
            TreeModelBuilder.$$$reportNull$$$0(0);
        }
        this(project, ChangesGroupingSupport.getFactory(project, showFlatten ? "none" : "directory"));
    }

    public TreeModelBuilder(Project project, @NotNull ChangesGroupingPolicyFactory grouping2) {
        if (grouping2 == null) {
            TreeModelBuilder.$$$reportNull$$$0(1);
        }
        this.myProject = project != null && !project.isDefault() ? project : null;
        this.myRoot = ChangesBrowserNode.createRoot();
        this.myModel = new DefaultTreeModel(this.myRoot);
        this.myGroupingPolicyFactory = grouping2;
    }

    @NotNull
    public static DefaultTreeModel buildEmpty() {
        DefaultTreeModel defaultTreeModel = new DefaultTreeModel(ChangesBrowserNode.createRoot());
        if (defaultTreeModel == null) {
            TreeModelBuilder.$$$reportNull$$$0(2);
        }
        return defaultTreeModel;
    }

    @Deprecated
    @NotNull
    public static DefaultTreeModel buildFromChanges(@NotNull Project project, boolean showFlatten, @NotNull Collection<? extends Change> changes2, @Nullable ChangeNodeDecorator changeNodeDecorator) {
        if (project == null) {
            TreeModelBuilder.$$$reportNull$$$0(3);
        }
        if (changes2 == null) {
            TreeModelBuilder.$$$reportNull$$$0(4);
        }
        DefaultTreeModel defaultTreeModel = new TreeModelBuilder(project, showFlatten).setChanges(changes2, changeNodeDecorator).build();
        if (defaultTreeModel == null) {
            TreeModelBuilder.$$$reportNull$$$0(5);
        }
        return defaultTreeModel;
    }

    @NotNull
    public static DefaultTreeModel buildFromChanges(@Nullable Project project, @NotNull ChangesGroupingPolicyFactory grouping2, @NotNull Collection<? extends Change> changes2, @Nullable ChangeNodeDecorator changeNodeDecorator) {
        if (grouping2 == null) {
            TreeModelBuilder.$$$reportNull$$$0(6);
        }
        if (changes2 == null) {
            TreeModelBuilder.$$$reportNull$$$0(7);
        }
        DefaultTreeModel defaultTreeModel = new TreeModelBuilder(project, grouping2).setChanges(changes2, changeNodeDecorator).build();
        if (defaultTreeModel == null) {
            TreeModelBuilder.$$$reportNull$$$0(8);
        }
        return defaultTreeModel;
    }

    @NotNull
    public static DefaultTreeModel buildFromFilePaths(@Nullable Project project, @NotNull ChangesGroupingPolicyFactory grouping2, @NotNull Collection<? extends FilePath> filePaths) {
        if (grouping2 == null) {
            TreeModelBuilder.$$$reportNull$$$0(9);
        }
        if (filePaths == null) {
            TreeModelBuilder.$$$reportNull$$$0(10);
        }
        DefaultTreeModel defaultTreeModel = new TreeModelBuilder(project, grouping2).setFilePaths(filePaths).build();
        if (defaultTreeModel == null) {
            TreeModelBuilder.$$$reportNull$$$0(11);
        }
        return defaultTreeModel;
    }

    @NotNull
    public static DefaultTreeModel buildFromChangeLists(@NotNull Project project, @NotNull ChangesGroupingPolicyFactory grouping2, @NotNull Collection<? extends ChangeList> changeLists) {
        if (project == null) {
            TreeModelBuilder.$$$reportNull$$$0(12);
        }
        if (grouping2 == null) {
            TreeModelBuilder.$$$reportNull$$$0(13);
        }
        if (changeLists == null) {
            TreeModelBuilder.$$$reportNull$$$0(14);
        }
        DefaultTreeModel defaultTreeModel = TreeModelBuilder.buildFromChangeLists(project, grouping2, changeLists, false);
        if (defaultTreeModel == null) {
            TreeModelBuilder.$$$reportNull$$$0(15);
        }
        return defaultTreeModel;
    }

    @NotNull
    public static DefaultTreeModel buildFromChangeLists(@NotNull Project project, @NotNull ChangesGroupingPolicyFactory grouping2, @NotNull Collection<? extends ChangeList> changeLists, boolean skipSingleDefaultChangelist) {
        if (project == null) {
            TreeModelBuilder.$$$reportNull$$$0(16);
        }
        if (grouping2 == null) {
            TreeModelBuilder.$$$reportNull$$$0(17);
        }
        if (changeLists == null) {
            TreeModelBuilder.$$$reportNull$$$0(18);
        }
        DefaultTreeModel defaultTreeModel = new TreeModelBuilder(project, grouping2).setChangeLists(changeLists, skipSingleDefaultChangelist).build();
        if (defaultTreeModel == null) {
            TreeModelBuilder.$$$reportNull$$$0(19);
        }
        return defaultTreeModel;
    }

    @NotNull
    public static DefaultTreeModel buildFromVirtualFiles(@Nullable Project project, @NotNull ChangesGroupingPolicyFactory grouping2, @NotNull Collection<? extends VirtualFile> virtualFiles) {
        if (grouping2 == null) {
            TreeModelBuilder.$$$reportNull$$$0(20);
        }
        if (virtualFiles == null) {
            TreeModelBuilder.$$$reportNull$$$0(21);
        }
        DefaultTreeModel defaultTreeModel = new TreeModelBuilder(project, grouping2).setVirtualFiles(virtualFiles, null).build();
        if (defaultTreeModel == null) {
            TreeModelBuilder.$$$reportNull$$$0(22);
        }
        return defaultTreeModel;
    }

    @NotNull
    public TreeModelBuilder setChanges(@NotNull Collection<? extends Change> changes2, @Nullable ChangeNodeDecorator changeNodeDecorator) {
        if (changes2 == null) {
            TreeModelBuilder.$$$reportNull$$$0(23);
        }
        TreeModelBuilder treeModelBuilder = this.setChanges(changes2, changeNodeDecorator, null);
        if (treeModelBuilder == null) {
            TreeModelBuilder.$$$reportNull$$$0(24);
        }
        return treeModelBuilder;
    }

    @NotNull
    public TreeModelBuilder setChanges(@NotNull Collection<? extends Change> changes2, @Nullable ChangeNodeDecorator changeNodeDecorator, @Nullable Object tag) {
        if (changes2 == null) {
            TreeModelBuilder.$$$reportNull$$$0(25);
        }
        ChangesBrowserNode parentNode = this.createTagNode(tag);
        List sortedChanges = ContainerUtil.sorted(changes2, CHANGE_COMPARATOR);
        for (Change change : sortedChanges) {
            this.insertChangeNode(change, parentNode, this.createChangeNode(change, changeNodeDecorator));
        }
        TreeModelBuilder treeModelBuilder = this;
        if (treeModelBuilder == null) {
            TreeModelBuilder.$$$reportNull$$$0(26);
        }
        return treeModelBuilder;
    }

    @NotNull
    public TreeModelBuilder setUnversioned(@Nullable List<VirtualFile> unversionedFiles) {
        assert (this.myProject != null);
        if (ContainerUtil.isEmpty(unversionedFiles)) {
            TreeModelBuilder treeModelBuilder = this;
            if (treeModelBuilder == null) {
                TreeModelBuilder.$$$reportNull$$$0(27);
            }
            return treeModelBuilder;
        }
        ChangesBrowserUnversionedFilesNode node = new ChangesBrowserUnversionedFilesNode(this.myProject, unversionedFiles);
        TreeModelBuilder treeModelBuilder = this.insertSpecificNodeToModel(unversionedFiles, node);
        if (treeModelBuilder == null) {
            TreeModelBuilder.$$$reportNull$$$0(28);
        }
        return treeModelBuilder;
    }

    @NotNull
    public TreeModelBuilder setIgnored(@Nullable List<VirtualFile> ignoredFiles, boolean updatingMode) {
        assert (this.myProject != null);
        if (ContainerUtil.isEmpty(ignoredFiles)) {
            TreeModelBuilder treeModelBuilder = this;
            if (treeModelBuilder == null) {
                TreeModelBuilder.$$$reportNull$$$0(29);
            }
            return treeModelBuilder;
        }
        ChangesBrowserIgnoredFilesNode node = new ChangesBrowserIgnoredFilesNode(this.myProject, ignoredFiles, updatingMode);
        TreeModelBuilder treeModelBuilder = this.insertSpecificNodeToModel(ignoredFiles, node);
        if (treeModelBuilder == null) {
            TreeModelBuilder.$$$reportNull$$$0(30);
        }
        return treeModelBuilder;
    }

    @NotNull
    private TreeModelBuilder insertSpecificNodeToModel(@NotNull List<? extends VirtualFile> specificFiles, @NotNull ChangesBrowserSpecificFilesNode node) {
        if (specificFiles == null) {
            TreeModelBuilder.$$$reportNull$$$0(31);
        }
        if (node == null) {
            TreeModelBuilder.$$$reportNull$$$0(32);
        }
        this.myModel.insertNodeInto(node, this.myRoot, this.myRoot.getChildCount());
        if (!node.isManyFiles()) {
            node.markAsHelperNode();
            this.insertFilesIntoNode(specificFiles, node);
        }
        TreeModelBuilder treeModelBuilder = this;
        if (treeModelBuilder == null) {
            TreeModelBuilder.$$$reportNull$$$0(33);
        }
        return treeModelBuilder;
    }

    @NotNull
    public TreeModelBuilder setChangeLists(@NotNull Collection<? extends ChangeList> changeLists, boolean skipSingleDefaultChangeList) {
        if (changeLists == null) {
            TreeModelBuilder.$$$reportNull$$$0(34);
        }
        assert (this.myProject != null);
        RemoteRevisionsCache revisionsCache = RemoteRevisionsCache.getInstance(this.myProject);
        boolean skipChangeListNode = skipSingleDefaultChangeList && TreeModelBuilder.isSingleBlankChangeList(changeLists);
        for (ChangeList changeList : changeLists) {
            ChangesBrowserNode changesParent;
            List changes2 = ContainerUtil.sorted((Collection)changeList.getChanges(), CHANGE_COMPARATOR);
            ChangeListRemoteState listRemoteState = new ChangeListRemoteState(changes2.size());
            if (!skipChangeListNode) {
                ChangesBrowserChangeListNode listNode = new ChangesBrowserChangeListNode(this.myProject, changeList, listRemoteState);
                listNode.markAsHelperNode();
                this.myModel.insertNodeInto(listNode, this.myRoot, 0);
                changesParent = listNode;
            } else {
                changesParent = this.myRoot;
            }
            for (int i = 0; i < changes2.size(); ++i) {
                Change change = (Change)changes2.get(i);
                RemoteStatusChangeNodeDecorator decorator = new RemoteStatusChangeNodeDecorator(revisionsCache, listRemoteState, i);
                this.insertChangeNode(change, changesParent, this.createChangeNode(change, decorator));
            }
        }
        TreeModelBuilder treeModelBuilder = this;
        if (treeModelBuilder == null) {
            TreeModelBuilder.$$$reportNull$$$0(35);
        }
        return treeModelBuilder;
    }

    private static boolean isSingleBlankChangeList(Collection<? extends ChangeList> lists) {
        if (lists.size() != 1) {
            return false;
        }
        ChangeList single = lists.iterator().next();
        if (!(single instanceof LocalChangeList)) {
            return false;
        }
        return ((LocalChangeList)single).isBlank();
    }

    protected ChangesBrowserNode createChangeNode(Change change, ChangeNodeDecorator decorator) {
        return new ChangesBrowserChangeNode(this.myProject, change, decorator);
    }

    @NotNull
    public TreeModelBuilder setLockedFolders(@Nullable List<? extends VirtualFile> lockedFolders) {
        assert (this.myProject != null);
        if (ContainerUtil.isEmpty(lockedFolders)) {
            TreeModelBuilder treeModelBuilder = this;
            if (treeModelBuilder == null) {
                TreeModelBuilder.$$$reportNull$$$0(36);
            }
            return treeModelBuilder;
        }
        this.insertFilesIntoNode(lockedFolders, ChangesBrowserNode.createLockedFolders(this.myProject));
        TreeModelBuilder treeModelBuilder = this;
        if (treeModelBuilder == null) {
            TreeModelBuilder.$$$reportNull$$$0(37);
        }
        return treeModelBuilder;
    }

    @NotNull
    public TreeModelBuilder setModifiedWithoutEditing(@NotNull List<? extends VirtualFile> modifiedWithoutEditing) {
        if (modifiedWithoutEditing == null) {
            TreeModelBuilder.$$$reportNull$$$0(38);
        }
        TreeModelBuilder treeModelBuilder = this.setVirtualFiles(modifiedWithoutEditing, ChangesBrowserNode.MODIFIED_WITHOUT_EDITING_TAG);
        if (treeModelBuilder == null) {
            TreeModelBuilder.$$$reportNull$$$0(39);
        }
        return treeModelBuilder;
    }

    @NotNull
    private TreeModelBuilder setVirtualFiles(@Nullable Collection<? extends VirtualFile> files2, @Nullable Object tag) {
        if (ContainerUtil.isEmpty(files2)) {
            TreeModelBuilder treeModelBuilder = this;
            if (treeModelBuilder == null) {
                TreeModelBuilder.$$$reportNull$$$0(40);
            }
            return treeModelBuilder;
        }
        this.insertFilesIntoNode(files2, this.createTagNode(tag));
        TreeModelBuilder treeModelBuilder = this;
        if (treeModelBuilder == null) {
            TreeModelBuilder.$$$reportNull$$$0(41);
        }
        return treeModelBuilder;
    }

    @NotNull
    protected ChangesBrowserNode createTagNode(@Nullable Object tag) {
        if (tag == null) {
            ChangesBrowserNode changesBrowserNode = this.myRoot;
            if (changesBrowserNode == null) {
                TreeModelBuilder.$$$reportNull$$$0(42);
            }
            return changesBrowserNode;
        }
        ChangesBrowserNode subtreeRoot = ChangesBrowserNode.createObject(tag);
        subtreeRoot.markAsHelperNode();
        this.myModel.insertNodeInto(subtreeRoot, this.myRoot, this.myRoot.getChildCount());
        ChangesBrowserNode changesBrowserNode = subtreeRoot;
        if (changesBrowserNode == null) {
            TreeModelBuilder.$$$reportNull$$$0(43);
        }
        return changesBrowserNode;
    }

    private void insertFilesIntoNode(@NotNull Collection<? extends VirtualFile> files2, @NotNull ChangesBrowserNode subtreeRoot) {
        if (files2 == null) {
            TreeModelBuilder.$$$reportNull$$$0(44);
        }
        if (subtreeRoot == null) {
            TreeModelBuilder.$$$reportNull$$$0(45);
        }
        List sortedFiles = ContainerUtil.sorted(files2, (Comparator)VirtualFileHierarchicalComparator.getInstance());
        for (VirtualFile file2 : sortedFiles) {
            this.insertChangeNode(file2, subtreeRoot, ChangesBrowserNode.createFile(this.myProject, file2));
        }
    }

    @NotNull
    public TreeModelBuilder setLocallyDeletedPaths(@Nullable Collection<? extends LocallyDeletedChange> locallyDeletedChanges) {
        if (ContainerUtil.isEmpty(locallyDeletedChanges)) {
            TreeModelBuilder treeModelBuilder = this;
            if (treeModelBuilder == null) {
                TreeModelBuilder.$$$reportNull$$$0(46);
            }
            return treeModelBuilder;
        }
        ChangesBrowserNode subtreeRoot = this.createTagNode(ChangesBrowserNode.LOCALLY_DELETED_NODE_TAG);
        for (LocallyDeletedChange change : ContainerUtil.sorted(locallyDeletedChanges, Comparator.comparing(LocallyDeletedChange::getPath, PATH_COMPARATOR))) {
            this.insertChangeNode(change, subtreeRoot, ChangesBrowserNode.createLocallyDeleted(change));
        }
        TreeModelBuilder treeModelBuilder = this;
        if (treeModelBuilder == null) {
            TreeModelBuilder.$$$reportNull$$$0(47);
        }
        return treeModelBuilder;
    }

    @NotNull
    public TreeModelBuilder setFilePaths(@NotNull Collection<? extends FilePath> filePaths) {
        if (filePaths == null) {
            TreeModelBuilder.$$$reportNull$$$0(48);
        }
        TreeModelBuilder treeModelBuilder = this.setFilePaths(filePaths, this.myRoot);
        if (treeModelBuilder == null) {
            TreeModelBuilder.$$$reportNull$$$0(49);
        }
        return treeModelBuilder;
    }

    @NotNull
    private TreeModelBuilder setFilePaths(@NotNull Collection<? extends FilePath> filePaths, @NotNull ChangesBrowserNode subtreeRoot) {
        if (filePaths == null) {
            TreeModelBuilder.$$$reportNull$$$0(50);
        }
        if (subtreeRoot == null) {
            TreeModelBuilder.$$$reportNull$$$0(51);
        }
        for (FilePath file2 : ContainerUtil.sorted(filePaths, PATH_COMPARATOR)) {
            assert (file2 != null);
            this.insertChangeNode(file2, subtreeRoot, ChangesBrowserNode.createFilePath(file2));
        }
        TreeModelBuilder treeModelBuilder = this;
        if (treeModelBuilder == null) {
            TreeModelBuilder.$$$reportNull$$$0(52);
        }
        return treeModelBuilder;
    }

    @NotNull
    public TreeModelBuilder setSwitchedRoots(@Nullable Map<VirtualFile, String> switchedRoots) {
        if (ContainerUtil.isEmpty(switchedRoots)) {
            TreeModelBuilder treeModelBuilder = this;
            if (treeModelBuilder == null) {
                TreeModelBuilder.$$$reportNull$$$0(53);
            }
            return treeModelBuilder;
        }
        ChangesBrowserNode rootsHeadNode = this.createTagNode(ChangesBrowserNode.SWITCHED_ROOTS_TAG);
        rootsHeadNode.setAttributes(SimpleTextAttributes.GRAYED_BOLD_ATTRIBUTES);
        List files2 = ContainerUtil.sorted(switchedRoots.keySet(), (Comparator)VirtualFileHierarchicalComparator.getInstance());
        for (VirtualFile vf : files2) {
            CurrentContentRevision cr = new CurrentContentRevision(VcsUtil.getFilePath((VirtualFile)vf));
            Change change = new Change((ContentRevision)cr, (ContentRevision)cr, FileStatus.NOT_CHANGED);
            final String branchName = switchedRoots.get(vf);
            this.insertChangeNode(vf, rootsHeadNode, this.createChangeNode(change, new ChangeNodeDecorator(){

                @Override
                public void decorate(Change change1, SimpleColoredComponent component, boolean isShowFlatten) {
                }

                @Override
                public void preDecorate(Change change1, ChangesBrowserNodeRenderer renderer2, boolean showFlatten) {
                    renderer2.append("[" + branchName + "] ", SimpleTextAttributes.GRAYED_BOLD_ATTRIBUTES);
                }
            }));
        }
        TreeModelBuilder treeModelBuilder = this;
        if (treeModelBuilder == null) {
            TreeModelBuilder.$$$reportNull$$$0(54);
        }
        return treeModelBuilder;
    }

    @NotNull
    public TreeModelBuilder setSwitchedFiles(@NotNull MultiMap<String, VirtualFile> switchedFiles) {
        if (switchedFiles == null) {
            TreeModelBuilder.$$$reportNull$$$0(55);
        }
        if (switchedFiles.isEmpty()) {
            TreeModelBuilder treeModelBuilder = this;
            if (treeModelBuilder == null) {
                TreeModelBuilder.$$$reportNull$$$0(56);
            }
            return treeModelBuilder;
        }
        ChangesBrowserNode subtreeRoot = this.createTagNode(ChangesBrowserNode.SWITCHED_FILES_TAG);
        for (String branchName : switchedFiles.keySet()) {
            List switchedFileList = ContainerUtil.sorted((Collection)switchedFiles.get((Object)branchName), (Comparator)VirtualFileHierarchicalComparator.getInstance());
            if (switchedFileList.size() <= 0) continue;
            ChangesBrowserNode branchNode = ChangesBrowserNode.createObject(branchName);
            branchNode.markAsHelperNode();
            this.myModel.insertNodeInto(branchNode, subtreeRoot, subtreeRoot.getChildCount());
            for (VirtualFile file2 : switchedFileList) {
                this.insertChangeNode(file2, branchNode, ChangesBrowserNode.createFile(this.myProject, file2));
            }
        }
        TreeModelBuilder treeModelBuilder = this;
        if (treeModelBuilder == null) {
            TreeModelBuilder.$$$reportNull$$$0(57);
        }
        return treeModelBuilder;
    }

    @NotNull
    public TreeModelBuilder setLogicallyLockedFiles(@Nullable Map<VirtualFile, LogicalLock> logicallyLockedFiles) {
        if (ContainerUtil.isEmpty(logicallyLockedFiles)) {
            TreeModelBuilder treeModelBuilder = this;
            if (treeModelBuilder == null) {
                TreeModelBuilder.$$$reportNull$$$0(58);
            }
            return treeModelBuilder;
        }
        ChangesBrowserNode subtreeRoot = this.createTagNode(ChangesBrowserNode.LOGICALLY_LOCKED_TAG);
        List keys = ContainerUtil.sorted(logicallyLockedFiles.keySet(), (Comparator)VirtualFileHierarchicalComparator.getInstance());
        for (VirtualFile file2 : keys) {
            LogicalLock lock = logicallyLockedFiles.get(file2);
            this.insertChangeNode(file2, subtreeRoot, ChangesBrowserNode.createLogicallyLocked(this.myProject, file2, lock));
        }
        TreeModelBuilder treeModelBuilder = this;
        if (treeModelBuilder == null) {
            TreeModelBuilder.$$$reportNull$$$0(59);
        }
        return treeModelBuilder;
    }

    protected void insertChangeNode(@NotNull Object change, @NotNull ChangesBrowserNode subtreeRoot, @NotNull ChangesBrowserNode node) {
        if (change == null) {
            TreeModelBuilder.$$$reportNull$$$0(60);
        }
        if (subtreeRoot == null) {
            TreeModelBuilder.$$$reportNull$$$0(61);
        }
        if (node == null) {
            TreeModelBuilder.$$$reportNull$$$0(62);
        }
        this.insertChangeNode(change, subtreeRoot, node, TreeModelBuilder::createPathNode);
    }

    protected void insertChangeNode(@NotNull Object change, @NotNull ChangesBrowserNode subtreeRoot, @NotNull ChangesBrowserNode node, @NotNull Function<StaticFilePath, ChangesBrowserNode<?>> nodeBuilder) {
        if (change == null) {
            TreeModelBuilder.$$$reportNull$$$0(63);
        }
        if (subtreeRoot == null) {
            TreeModelBuilder.$$$reportNull$$$0(64);
        }
        if (node == null) {
            TreeModelBuilder.$$$reportNull$$$0(65);
        }
        if (nodeBuilder == null) {
            TreeModelBuilder.$$$reportNull$$$0(66);
        }
        PATH_NODE_BUILDER.set((UserDataHolder)subtreeRoot, nodeBuilder);
        if (!GROUPING_POLICY.isIn((UserDataHolder)subtreeRoot)) {
            GROUPING_POLICY.set((UserDataHolder)subtreeRoot, (Object)this.myGroupingPolicyFactory.createGroupingPolicy(this.myModel));
        }
        StaticFilePath pathKey = TreeModelBuilder.getKey(change);
        ChangesBrowserNode parentNode = (ChangesBrowserNode)ReadAction.compute(() -> (ChangesBrowserNode)ObjectUtils.notNull((Object)((ChangesGroupingPolicy)GROUPING_POLICY.getRequired((UserDataHolder)subtreeRoot)).getParentNodeFor(pathKey, subtreeRoot), (Object)subtreeRoot));
        ChangesBrowserNode<?> cachingRoot = BaseChangesGroupingPolicy.getCachingRoot(parentNode, subtreeRoot);
        this.myModel.insertNodeInto(node, parentNode, this.myModel.getChildCount(parentNode));
        if (pathKey.isDirectory()) {
            ((Map)DIRECTORY_CACHE.getValue(cachingRoot)).put(pathKey.getKey(), node);
        }
    }

    @NotNull
    public DefaultTreeModel build() {
        TreeModelBuilder.collapseDirectories(this.myModel, this.myRoot);
        this.sortNodes();
        DefaultTreeModel defaultTreeModel = this.myModel;
        if (defaultTreeModel == null) {
            TreeModelBuilder.$$$reportNull$$$0(67);
        }
        return defaultTreeModel;
    }

    private void sortNodes() {
        TreeUtil.sort((DefaultTreeModel)this.myModel, BROWSER_NODE_COMPARATOR);
        this.myModel.nodeStructureChanged((TreeNode)this.myModel.getRoot());
    }

    private static void collapseDirectories(@NotNull DefaultTreeModel model, @NotNull ChangesBrowserNode node) {
        ChangesBrowserNode child2;
        ChangesBrowserNode collapsed;
        if (model == null) {
            TreeModelBuilder.$$$reportNull$$$0(68);
        }
        if (node == null) {
            TreeModelBuilder.$$$reportNull$$$0(69);
        }
        ChangesBrowserNode collapsedNode = node;
        while (collapsedNode.getChildCount() == 1 && (collapsed = TreeModelBuilder.collapseParentWithOnlyChild(collapsedNode, child2 = (ChangesBrowserNode)collapsedNode.getChildAt(0))) != null) {
            collapsedNode = collapsed;
        }
        if (collapsedNode != node) {
            TreeNode parent = node.getParent();
            int idx = ((DefaultMutableTreeNode)parent).getIndex(node);
            model.removeNodeFromParent(node);
            model.insertNodeInto(collapsedNode, (MutableTreeNode)parent, idx);
            node = collapsedNode;
        }
        Enumeration<TreeNode> children2 = node.children();
        while (children2.hasMoreElements()) {
            ChangesBrowserNode child3 = (ChangesBrowserNode)children2.nextElement();
            TreeModelBuilder.collapseDirectories(model, child3);
        }
    }

    @Nullable
    private static ChangesBrowserNode collapseParentWithOnlyChild(@NotNull ChangesBrowserNode parent, @NotNull ChangesBrowserNode child2) {
        if (parent == null) {
            TreeModelBuilder.$$$reportNull$$$0(70);
        }
        if (child2 == null) {
            TreeModelBuilder.$$$reportNull$$$0(71);
        }
        if (child2.isLeaf()) {
            return null;
        }
        Object parentUserObject = parent.getUserObject();
        Object childUserObject = child2.getUserObject();
        if (parentUserObject instanceof FilePath && childUserObject instanceof FilePath) {
            return child2;
        }
        if (parent instanceof ChangesBrowserModuleNode && childUserObject instanceof FilePath) {
            FilePath childPath;
            FilePath parentPath = ((ChangesBrowserModuleNode)parent).getModuleRoot();
            if (!parentPath.equals(childPath = (FilePath)childUserObject)) {
                return null;
            }
            parent.remove(0);
            Enumeration<TreeNode> children2 = child2.children();
            for (ChangesBrowserNode childNode : ContainerUtil.toList(children2)) {
                parent.add(childNode);
            }
            return parent;
        }
        return null;
    }

    @NotNull
    private static StaticFilePath getKey(@NotNull Object o) {
        if (o == null) {
            TreeModelBuilder.$$$reportNull$$$0(72);
        }
        if (o instanceof Change) {
            StaticFilePath staticFilePath = TreeModelBuilder.staticFrom(ChangesUtil.getFilePath((Change)((Change)o)));
            if (staticFilePath == null) {
                TreeModelBuilder.$$$reportNull$$$0(73);
            }
            return staticFilePath;
        }
        if (o instanceof VirtualFile) {
            StaticFilePath staticFilePath = TreeModelBuilder.staticFrom((VirtualFile)o);
            if (staticFilePath == null) {
                TreeModelBuilder.$$$reportNull$$$0(74);
            }
            return staticFilePath;
        }
        if (o instanceof FilePath) {
            StaticFilePath staticFilePath = TreeModelBuilder.staticFrom((FilePath)o);
            if (staticFilePath == null) {
                TreeModelBuilder.$$$reportNull$$$0(75);
            }
            return staticFilePath;
        }
        if (o instanceof LocallyDeletedChange) {
            StaticFilePath staticFilePath = TreeModelBuilder.staticFrom(((LocallyDeletedChange)o).getPath());
            if (staticFilePath == null) {
                TreeModelBuilder.$$$reportNull$$$0(76);
            }
            return staticFilePath;
        }
        throw new IllegalArgumentException("Unknown type - " + o.getClass());
    }

    @NotNull
    public static StaticFilePath staticFrom(@NotNull FilePath fp) {
        if (fp == null) {
            TreeModelBuilder.$$$reportNull$$$0(77);
        }
        StaticFilePath staticFilePath = new StaticFilePath(fp.isDirectory(), fp.getPath(), fp.getVirtualFile());
        if (staticFilePath == null) {
            TreeModelBuilder.$$$reportNull$$$0(78);
        }
        return staticFilePath;
    }

    @NotNull
    public static StaticFilePath staticFrom(@NotNull VirtualFile vf) {
        if (vf == null) {
            TreeModelBuilder.$$$reportNull$$$0(79);
        }
        StaticFilePath staticFilePath = new StaticFilePath(vf.isDirectory(), vf.getPath(), vf);
        if (staticFilePath == null) {
            TreeModelBuilder.$$$reportNull$$$0(80);
        }
        return staticFilePath;
    }

    @NotNull
    public static FilePath getPathForObject(@NotNull Object o) {
        if (o == null) {
            TreeModelBuilder.$$$reportNull$$$0(81);
        }
        if (o instanceof Change) {
            FilePath filePath = ChangesUtil.getFilePath((Change)((Change)o));
            if (filePath == null) {
                TreeModelBuilder.$$$reportNull$$$0(82);
            }
            return filePath;
        }
        if (o instanceof VirtualFile) {
            FilePath filePath = VcsUtil.getFilePath((VirtualFile)((VirtualFile)o));
            if (filePath == null) {
                TreeModelBuilder.$$$reportNull$$$0(83);
            }
            return filePath;
        }
        if (o instanceof FilePath) {
            FilePath filePath = (FilePath)o;
            if (filePath == null) {
                TreeModelBuilder.$$$reportNull$$$0(84);
            }
            return filePath;
        }
        if (o instanceof LocallyDeletedChange) {
            FilePath filePath = ((LocallyDeletedChange)o).getPath();
            if (filePath == null) {
                TreeModelBuilder.$$$reportNull$$$0(85);
            }
            return filePath;
        }
        throw new IllegalArgumentException("Unknown type - " + o.getClass());
    }

    @NotNull
    private static ChangesBrowserNode createPathNode(@NotNull StaticFilePath path) {
        if (path == null) {
            TreeModelBuilder.$$$reportNull$$$0(86);
        }
        FilePath filePath = VcsUtil.getFilePath((String)path.getPath(), (boolean)path.isDirectory());
        ChangesBrowserNode changesBrowserNode = ChangesBrowserNode.createFilePath(filePath);
        if (changesBrowserNode == null) {
            TreeModelBuilder.$$$reportNull$$$0(87);
        }
        return changesBrowserNode;
    }

    public boolean isEmpty() {
        return this.myModel.getChildCount(this.myRoot) == 0;
    }

    @Deprecated
    @NotNull
    public DefaultTreeModel buildModel(@NotNull List<? extends Change> changes2, @Nullable ChangeNodeDecorator changeNodeDecorator) {
        if (changes2 == null) {
            TreeModelBuilder.$$$reportNull$$$0(88);
        }
        DefaultTreeModel defaultTreeModel = this.setChanges(changes2, changeNodeDecorator).build();
        if (defaultTreeModel == null) {
            TreeModelBuilder.$$$reportNull$$$0(89);
        }
        return defaultTreeModel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 11: 
            case 15: 
            case 19: 
            case 22: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 46: 
            case 47: 
            case 49: 
            case 52: 
            case 53: 
            case 54: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 67: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 78: 
            case 80: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 87: 
            case 89: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 11: 
            case 15: 
            case 19: 
            case 22: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 46: 
            case 47: 
            case 49: 
            case 52: 
            case 53: 
            case 54: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 67: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 78: 
            case 80: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 87: 
            case 89: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 6: 
            case 9: 
            case 13: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grouping";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 11: 
            case 15: 
            case 19: 
            case 22: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 46: 
            case 47: 
            case 49: 
            case 52: 
            case 53: 
            case 54: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 67: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 78: 
            case 80: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 87: 
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder";
                break;
            }
            case 4: 
            case 7: 
            case 23: 
            case 25: 
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 10: 
            case 48: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePaths";
                break;
            }
            case 14: 
            case 18: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeLists";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFiles";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "specificFiles";
                break;
            }
            case 32: 
            case 62: 
            case 65: 
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifiedWithoutEditing";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 45: 
            case 51: 
            case 61: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subtreeRoot";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "switchedFiles";
                break;
            }
            case 60: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeBuilder";
                break;
            }
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 72: 
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fp";
                break;
            }
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vf";
                break;
            }
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildEmpty";
                break;
            }
            case 5: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFromChanges";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFromFilePaths";
                break;
            }
            case 15: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFromChangeLists";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFromVirtualFiles";
                break;
            }
            case 24: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "setChanges";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "setUnversioned";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "setIgnored";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "insertSpecificNodeToModel";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "setChangeLists";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "setLockedFolders";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "setModifiedWithoutEditing";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "setVirtualFiles";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "createTagNode";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "setLocallyDeletedPaths";
                break;
            }
            case 49: 
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "setFilePaths";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "setSwitchedRoots";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "setSwitchedFiles";
                break;
            }
            case 58: 
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "setLogicallyLockedFiles";
                break;
            }
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "build";
                break;
            }
            case 73: 
            case 74: 
            case 75: 
            case 76: {
                objectArray = objectArray2;
                objectArray2[1] = "getKey";
                break;
            }
            case 78: 
            case 80: {
                objectArray = objectArray2;
                objectArray2[1] = "staticFrom";
                break;
            }
            case 82: 
            case 83: 
            case 84: 
            case 85: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathForObject";
                break;
            }
            case 87: {
                objectArray = objectArray2;
                objectArray2[1] = "createPathNode";
                break;
            }
            case 89: {
                objectArray = objectArray2;
                objectArray2[1] = "buildModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 11: 
            case 15: 
            case 19: 
            case 22: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 46: 
            case 47: 
            case 49: 
            case 52: 
            case 53: 
            case 54: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 67: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 78: 
            case 80: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 87: 
            case 89: {
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "buildFromChanges";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "buildFromFilePaths";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "buildFromChangeLists";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "buildFromVirtualFiles";
                break;
            }
            case 23: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "setChanges";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "insertSpecificNodeToModel";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "setChangeLists";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "setModifiedWithoutEditing";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "insertFilesIntoNode";
                break;
            }
            case 48: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "setFilePaths";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "setSwitchedFiles";
                break;
            }
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "insertChangeNode";
                break;
            }
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "collapseDirectories";
                break;
            }
            case 70: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "collapseParentWithOnlyChild";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "getKey";
                break;
            }
            case 77: 
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "staticFrom";
                break;
            }
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "getPathForObject";
                break;
            }
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "createPathNode";
                break;
            }
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "buildModel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 11: 
            case 15: 
            case 19: 
            case 22: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 46: 
            case 47: 
            case 49: 
            case 52: 
            case 53: 
            case 54: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 67: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 78: 
            case 80: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 87: 
            case 89: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

