/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.ChangeListOwner;
import com.intellij.openapi.vcs.changes.IgnoredViewDialog;
import com.intellij.openapi.vcs.changes.ui.ChangeListDragBean;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserSpecificFilesNode;
import com.intellij.openapi.vcs.changes.ui.IgnoreUnversionedDialog;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ChangesBrowserIgnoredFilesNode
extends ChangesBrowserSpecificFilesNode {
    private final boolean myUpdatingMode;

    protected ChangesBrowserIgnoredFilesNode(Project project, @NotNull List<VirtualFile> files2, boolean updatingMode) {
        if (files2 == null) {
            ChangesBrowserIgnoredFilesNode.$$$reportNull$$$0(0);
        }
        super(IGNORED_FILES_TAG, files2, () -> {
            if (!project.isDisposed()) {
                new IgnoredViewDialog(project).show();
            }
        });
        this.myUpdatingMode = updatingMode;
    }

    @Override
    public void render(@NotNull ChangesBrowserNodeRenderer renderer2, boolean selected, boolean expanded, boolean hasFocus) {
        if (renderer2 == null) {
            ChangesBrowserIgnoredFilesNode.$$$reportNull$$$0(1);
        }
        super.render(renderer2, selected, expanded, hasFocus);
        if (this.myUpdatingMode) {
            this.appendUpdatingState(renderer2);
        }
    }

    @Override
    public boolean canAcceptDrop(ChangeListDragBean dragBean) {
        return dragBean.getUnversionedFiles().size() > 0;
    }

    @Override
    public void acceptDrop(ChangeListOwner dragOwner, ChangeListDragBean dragBean) {
        IgnoreUnversionedDialog.ignoreSelectedFiles(dragOwner.getProject(), dragBean.getUnversionedFiles());
    }

    @Override
    public int getSortWeight() {
        return 11;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/ChangesBrowserIgnoredFilesNode";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "render";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

