/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.diff.actions.impl.GoToChangePopupBuilder;
import com.intellij.diff.chains.DiffRequestChain;
import com.intellij.diff.chains.DiffRequestChainBase;
import com.intellij.diff.chains.DiffRequestProducer;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.changes.actions.diff.ChangeGoToChangePopupAction;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.openapi.vcs.changes.ui.ChangesGroupingPolicyFactory;
import com.intellij.openapi.vcs.changes.ui.TreeModelBuilder;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import javax.swing.tree.DefaultTreeModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeDiffRequestChain
extends DiffRequestChainBase
implements GoToChangePopupBuilder.Chain {
    private static final Logger LOG = Logger.getInstance(ChangeDiffRequestChain.class);
    @NotNull
    private final List<? extends Producer> myProducers;

    public ChangeDiffRequestChain(@NotNull List<? extends Producer> producers, int index) {
        if (producers == null) {
            ChangeDiffRequestChain.$$$reportNull$$$0(0);
        }
        super(index);
        if (ContainerUtil.exists(producers, Objects::isNull)) {
            producers = ContainerUtil.skipNulls(producers);
            LOG.error("Producers must not be null");
        }
        this.myProducers = producers;
    }

    @NotNull
    public List<? extends Producer> getRequests() {
        List<? extends Producer> list2 = this.myProducers;
        if (list2 == null) {
            ChangeDiffRequestChain.$$$reportNull$$$0(1);
        }
        return list2;
    }

    @Override
    @NotNull
    public AnAction createGoToChangeAction(@NotNull Consumer<? super Integer> onSelected) {
        if (onSelected == null) {
            ChangeDiffRequestChain.$$$reportNull$$$0(2);
        }
        AnAction anAction = ChangeDiffRequestChain.createGoToChangeAction(this, onSelected);
        if (anAction == null) {
            ChangeDiffRequestChain.$$$reportNull$$$0(3);
        }
        return anAction;
    }

    @NotNull
    public static AnAction createGoToChangeAction(final @NotNull DiffRequestChain chain, final @NotNull Consumer<? super Integer> onSelected) {
        if (chain == null) {
            ChangeDiffRequestChain.$$$reportNull$$$0(4);
        }
        if (onSelected == null) {
            ChangeDiffRequestChain.$$$reportNull$$$0(5);
        }
        ChangeGoToChangePopupAction<DiffRequestChain> changeGoToChangePopupAction = new ChangeGoToChangePopupAction<DiffRequestChain>(chain, (Object)chain.getIndex()){

            @Override
            @NotNull
            protected DefaultTreeModel buildTreeModel(@NotNull Project project, @NotNull ChangesGroupingPolicyFactory grouping2) {
                if (project == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (grouping2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                MultiMap groups = new MultiMap();
                List producers = chain.getRequests();
                for (int i = 0; i < producers.size(); ++i) {
                    Producer producer = (Producer)ObjectUtils.tryCast(producers.get(i), Producer.class);
                    if (producer == null) continue;
                    FilePath filePath = producer.getFilePath();
                    FileStatus fileStatus = producer.getFileStatus();
                    Object tag = producer.getPopupTag();
                    groups.putValue(tag, (Object)new GenericChangesBrowserNode(filePath, fileStatus, i));
                }
                MyTreeModelBuilder builder2 = new MyTreeModelBuilder(project, grouping2);
                for (Object tag : groups.keySet()) {
                    builder2.setGenericNodes(groups.get(tag), tag);
                }
                DefaultTreeModel defaultTreeModel = builder2.build();
                if (defaultTreeModel == null) {
                    1.$$$reportNull$$$0(2);
                }
                return defaultTreeModel;
            }

            @Override
            protected void onSelected(@Nullable Object object) {
                onSelected.consume((Object)((Integer)object));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "grouping";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/openapi/vcs/changes/ui/ChangeDiffRequestChain$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/ChangeDiffRequestChain$1";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "buildTreeModel";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "buildTreeModel";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        if (changeGoToChangePopupAction == null) {
            ChangeDiffRequestChain.$$$reportNull$$$0(6);
        }
        return changeGoToChangePopupAction;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "producers";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/ui/ChangeDiffRequestChain";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onSelected";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chain";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/ChangeDiffRequestChain";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequests";
                break;
            }
            case 3: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createGoToChangeAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createGoToChangeAction";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class GenericChangesBrowserNode
    extends ChangesBrowserNode<Object>
    implements Comparable<GenericChangesBrowserNode> {
        @NotNull
        private final FilePath myFilePath;
        @NotNull
        private final FileStatus myFileStatus;

        protected GenericChangesBrowserNode(@NotNull FilePath filePath, @NotNull FileStatus fileStatus, @NotNull Object userObject) {
            if (filePath == null) {
                GenericChangesBrowserNode.$$$reportNull$$$0(0);
            }
            if (fileStatus == null) {
                GenericChangesBrowserNode.$$$reportNull$$$0(1);
            }
            if (userObject == null) {
                GenericChangesBrowserNode.$$$reportNull$$$0(2);
            }
            super(userObject);
            this.myFilePath = filePath;
            this.myFileStatus = fileStatus;
        }

        @Override
        protected boolean isFile() {
            return !this.isDirectory();
        }

        @Override
        protected boolean isDirectory() {
            return this.myFilePath.isDirectory();
        }

        @Override
        public void render(@NotNull ChangesBrowserNodeRenderer renderer2, boolean selected, boolean expanded, boolean hasFocus) {
            if (renderer2 == null) {
                GenericChangesBrowserNode.$$$reportNull$$$0(3);
            }
            renderer2.appendFileName(this.myFilePath.getVirtualFile(), this.myFilePath.getName(), this.myFileStatus.getColor());
            if (renderer2.isShowFlatten()) {
                this.appendParentPath(renderer2, this.myFilePath.getParentPath());
            }
            if (!renderer2.isShowFlatten() && this.getFileCount() != 1 || this.getDirectoryCount() != 0) {
                this.appendCount(renderer2);
            }
            renderer2.setIcon(this.myFilePath.getFileType(), this.myFilePath.isDirectory() || !this.isLeaf());
        }

        @Override
        public String getTextPresentation() {
            return this.myFilePath.getName();
        }

        @Override
        public String toString() {
            return FileUtil.toSystemDependentName((String)this.myFilePath.getPath());
        }

        @Override
        public int compareTo(@NotNull GenericChangesBrowserNode o) {
            if (o == null) {
                GenericChangesBrowserNode.$$$reportNull$$$0(4);
            }
            return this.myFilePath.getPath().compareToIgnoreCase(o.myFilePath.getPath());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filePath";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileStatus";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "userObject";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "renderer";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "o";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/ChangeDiffRequestChain$GenericChangesBrowserNode";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "render";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "compareTo";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyTreeModelBuilder
    extends TreeModelBuilder {
        MyTreeModelBuilder(@NotNull Project project, @NotNull ChangesGroupingPolicyFactory grouping2) {
            if (project == null) {
                MyTreeModelBuilder.$$$reportNull$$$0(0);
            }
            if (grouping2 == null) {
                MyTreeModelBuilder.$$$reportNull$$$0(1);
            }
            super(project, grouping2);
        }

        public void setGenericNodes(@NotNull Collection<GenericChangesBrowserNode> nodes, @Nullable Object tag) {
            if (nodes == null) {
                MyTreeModelBuilder.$$$reportNull$$$0(2);
            }
            ChangesBrowserNode parentNode = this.createTagNode(tag);
            for (GenericChangesBrowserNode node : ContainerUtil.sorted(nodes, Comparator.comparing(data -> ((GenericChangesBrowserNode)data).myFilePath, PATH_COMPARATOR))) {
                this.insertChangeNode(node.myFilePath, parentNode, node);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "grouping";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nodes";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/ChangeDiffRequestChain$MyTreeModelBuilder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setGenericNodes";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface Producer
    extends DiffRequestProducer {
        @NotNull
        public FilePath getFilePath();

        @NotNull
        public FileStatus getFileStatus();

        @Nullable
        default public Object getPopupTag() {
            return null;
        }
    }
}

