/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ui.AbstractCommitter;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u001a$\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002\u001a\u0016\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "markCommittingDocuments", "", "Lcom/intellij/openapi/editor/Document;", "project", "Lcom/intellij/openapi/project/Project;", "changes", "", "Lcom/intellij/openapi/vcs/changes/Change;", "unmarkCommittingDocuments", "", "committingDocuments", "intellij.platform.vcs.impl"})
public final class AbstractCommitterKt {
    private static final Logger LOG;

    private static final Collection<Document> markCommittingDocuments(Project project, List<? extends Change> changes2) {
        List result2 = new ArrayList();
        for (Change change : changes2) {
            Document doc;
            FilePath filePath = ChangesUtil.getFilePath((Change)change);
            Intrinsics.checkExpressionValueIsNotNull((Object)filePath, (String)"ChangesUtil.getFilePath(change)");
            VirtualFile virtualFile = filePath.getVirtualFile();
            if (virtualFile == null) continue;
            FileType fileType = virtualFile.getFileType();
            Intrinsics.checkExpressionValueIsNotNull((Object)fileType, (String)"virtualFile.fileType");
            if (fileType.isBinary() || (doc = FileDocumentManager.getInstance().getDocument(virtualFile)) == null) continue;
            doc.putUserData(AbstractCommitter.DOCUMENT_BEING_COMMITTED_KEY, (Object)project);
            result2.add(doc);
        }
        return result2;
    }

    private static final void unmarkCommittingDocuments(Collection<? extends Document> committingDocuments) {
        Iterable $receiver$iv = committingDocuments;
        for (Object element$iv : $receiver$iv) {
            Document document = (Document)element$iv;
            boolean bl = false;
            document.putUserData(AbstractCommitter.DOCUMENT_BEING_COMMITTED_KEY, null);
        }
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(AbstractCommitter.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    public static final /* synthetic */ Collection access$markCommittingDocuments(Project project, List changes2) {
        return AbstractCommitterKt.markCommittingDocuments(project, changes2);
    }

    public static final /* synthetic */ void access$unmarkCommittingDocuments(Collection committingDocuments) {
        AbstractCommitterKt.unmarkCommittingDocuments(committingDocuments);
    }
}

