/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.shelf;

import com.intellij.diff.DiffContentFactoryEx;
import com.intellij.diff.chains.DiffRequestProducerException;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.impl.CacheDiffRequestProcessor;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.DeleteProvider;
import com.intellij.ide.actions.EditSourceAction;
import com.intellij.ide.dnd.DnDActionInfo;
import com.intellij.ide.dnd.DnDDragStartBean;
import com.intellij.ide.dnd.DnDDropHandler;
import com.intellij.ide.dnd.DnDEvent;
import com.intellij.ide.dnd.DnDImage;
import com.intellij.ide.dnd.DnDSupport;
import com.intellij.ide.dnd.DnDTargetChecker;
import com.intellij.ide.dnd.aware.DnDAwareTree;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Anchor;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Constraints;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.DiffPreviewUpdateProcessor;
import com.intellij.openapi.vcs.changes.DnDActivateOnHoldTargetContent;
import com.intellij.openapi.vcs.changes.PreviewDiffSplitterComponent;
import com.intellij.openapi.vcs.changes.actions.ShowDiffPreviewAction;
import com.intellij.openapi.vcs.changes.patch.tool.PatchDiffRequest;
import com.intellij.openapi.vcs.changes.shelf.DiffShelvedChangesActionProvider;
import com.intellij.openapi.vcs.changes.shelf.ShelfDeleteNotification;
import com.intellij.openapi.vcs.changes.shelf.ShelfNotification;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager;
import com.intellij.openapi.vcs.changes.shelf.ShelvedBinaryFile;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChange;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangeList;
import com.intellij.openapi.vcs.changes.shelf.ShelvedWrapper;
import com.intellij.openapi.vcs.changes.ui.ChangeListDragBean;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.openapi.vcs.changes.ui.ChangesGroupingSupport;
import com.intellij.openapi.vcs.changes.ui.ChangesTree;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManager;
import com.intellij.openapi.vcs.changes.ui.ShelvedChangeListDragBean;
import com.intellij.openapi.vcs.changes.ui.TreeModelBuilder;
import com.intellij.openapi.vcs.changes.ui.VcsTreeModelData;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.pom.Navigatable;
import com.intellij.pom.NavigatableAdapter;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.FontUtil;
import com.intellij.util.IconUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.UtilKt;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.intellij.vcsUtil.VcsUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShelvedChangesViewManager
implements Disposable {
    private static final Logger LOG = Logger.getInstance(ShelvedChangesViewManager.class);
    @NonNls
    static final String SHELF_CONTEXT_MENU = "Vcs.Shelf.ContextMenu";
    private static final String SHELVE_PREVIEW_SPLITTER_PROPORTION = "ShelvedChangesViewManager.DETAILS_SPLITTER_PROPORTION";
    private final ChangesViewContentManager myContentManager;
    private final ShelveChangesManager myShelveChangesManager;
    private final Project myProject;
    final ShelfTree myTree;
    @NotNull
    private final PropertyChangeListener myGroupingChangeListener;
    private MyShelfContent myContent = null;
    final DeleteProvider myDeleteProvider = new MyShelveDeleteProvider();
    private final MergingUpdateQueue myUpdateQueue;
    private final VcsConfiguration myVcsConfiguration;
    public static final DataKey<List<ShelvedChangeList>> SHELVED_CHANGELIST_KEY = DataKey.create((String)"ShelveChangesManager.ShelvedChangeListData");
    public static final DataKey<List<ShelvedChangeList>> SHELVED_RECYCLED_CHANGELIST_KEY = DataKey.create((String)"ShelveChangesManager.ShelvedRecycledChangeListData");
    public static final DataKey<List<ShelvedChangeList>> SHELVED_DELETED_CHANGELIST_KEY = DataKey.create((String)"ShelveChangesManager.ShelvedDeletedChangeListData");
    public static final DataKey<List<ShelvedChange>> SHELVED_CHANGE_KEY = DataKey.create((String)"ShelveChangesManager.ShelvedChange");
    public static final DataKey<List<ShelvedBinaryFile>> SHELVED_BINARY_FILE_KEY = DataKey.create((String)"ShelveChangesManager.ShelvedBinaryFile");
    private PreviewDiffSplitterComponent mySplitterComponent;

    public static ShelvedChangesViewManager getInstance(Project project) {
        return (ShelvedChangesViewManager)project.getComponent(ShelvedChangesViewManager.class);
    }

    public ShelvedChangesViewManager(final Project project, ChangesViewContentManager contentManager, ShelveChangesManager shelveChangesManager, MessageBus bus, StartupManager startupManager) {
        this.myProject = project;
        this.myContentManager = contentManager;
        this.myShelveChangesManager = shelveChangesManager;
        this.myUpdateQueue = new MergingUpdateQueue("Update Shelf Content", 200, true, null, (Disposable)this.myProject, null, true);
        this.myVcsConfiguration = VcsConfiguration.getInstance((Project)this.myProject);
        bus.connect().subscribe(ShelveChangesManager.SHELF_TOPIC, (Object)new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ShelvedChangesViewManager.this.myUpdateQueue.queue((Update)new MyContentUpdater());
            }
        });
        this.myTree = new ShelfTree(this.myProject);
        this.myTree.setEditable(true);
        this.myTree.setDragEnabled(true);
        this.myTree.getGroupingSupport().setGroupingKeysOrSkip(this.myShelveChangesManager.getGrouping());
        this.myGroupingChangeListener = e -> {
            this.myShelveChangesManager.setGrouping(this.myTree.getGroupingSupport().getGroupingKeys());
            this.myTree.rebuildTree();
        };
        this.myTree.addGroupingChangeListener(this.myGroupingChangeListener);
        DefaultTreeCellEditor treeCellEditor = new DefaultTreeCellEditor((JTree)((Object)this.myTree), null){

            @Override
            public boolean isCellEditable(EventObject event) {
                return !(event instanceof MouseEvent) && super.isCellEditable(event);
            }
        };
        this.myTree.setCellEditor(treeCellEditor);
        treeCellEditor.addCellEditorListener(new CellEditorListener(){

            @Override
            public void editingStopped(ChangeEvent e) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)ShelvedChangesViewManager.this.myTree.getLastSelectedPathComponent();
                if (node instanceof ShelvedListNode && e.getSource() instanceof TreeCellEditor) {
                    String editorValue = ((TreeCellEditor)e.getSource()).getCellEditorValue().toString();
                    ShelvedChangeList shelvedChangeList = ((ShelvedListNode)node).getList();
                    ShelveChangesManager.getInstance(project).renameChangeList(shelvedChangeList, editorValue);
                    ShelvedChangesViewManager.this.myTree.getModel().valueForPathChanged(TreeUtil.getPathFromRoot((TreeNode)node), shelvedChangeList);
                }
            }

            @Override
            public void editingCanceled(ChangeEvent e) {
            }
        });
        AnAction showDiffAction = ActionManager.getInstance().getAction("Diff.ShowDiff");
        showDiffAction.registerCustomShortcutSet(showDiffAction.getShortcutSet(), (JComponent)((Object)this.myTree));
        EditSourceAction editSourceAction = new EditSourceAction();
        editSourceAction.registerCustomShortcutSet(editSourceAction.getShortcutSet(), (JComponent)((Object)this.myTree));
        PopupHandler.installPopupHandler((JComponent)((Object)this.myTree), (String)"ShelvedChangesPopupMenu", (String)SHELF_CONTEXT_MENU);
        this.myTree.addSelectionListener(() -> this.mySplitterComponent.updatePreview(false));
        if (startupManager == null) {
            LOG.error("Couldn't start loading shelved changes");
            return;
        }
        startupManager.registerPostStartupActivity((Runnable)((DumbAwareRunnable)() -> this.myUpdateQueue.queue((Update)new MyContentUpdater())));
    }

    private boolean hasExactlySelectedChanges() {
        return !UtilKt.isEmpty(VcsTreeModelData.exactlySelected((JTree)((Object)this.myTree)).userObjectsStream(ShelvedWrapper.class));
    }

    private void updateChangesContent() {
        if (this.myShelveChangesManager.getAllLists().isEmpty()) {
            if (this.myContent != null) {
                this.myContentManager.removeContent(this.myContent);
                this.myContentManager.selectContent("Local Changes");
                VcsNotifier.getInstance(this.myProject).hideAllNotificationsByType(ShelfNotification.class);
            }
            this.myContent = null;
        } else {
            if (this.myContent == null) {
                this.myTree.updateUI();
                JPanel rootPanel = this.createRootPanel();
                this.myContent = new MyShelfContent(rootPanel, VcsBundle.message((String)"shelf.tab", (Object[])new Object[0]), false);
                this.myContent.setCloseable(false);
                this.myContentManager.addContent(this.myContent);
                DnDSupport.createBuilder((JComponent)((Object)this.myTree)).setImageProvider(this::createDraggedImage).setBeanProvider(this::createDragStartBean).setTargetChecker((DnDTargetChecker)this.myContent).setDropHandler((DnDDropHandler)this.myContent).setDisposableParent((Disposable)this.myContent).install();
            }
            this.myTree.rebuildTree();
        }
    }

    private ToolWindow getVcsToolWindow() {
        return ToolWindowManager.getInstance((Project)this.myProject).getToolWindow(ChangesViewContentManager.TOOLWINDOW_ID);
    }

    @NotNull
    private JPanel createRootPanel() {
        JScrollPane pane = ScrollPaneFactory.createScrollPane((Component)((Object)this.myTree), (int)1);
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        actionGroup.addAll((ActionGroup)ActionManager.getInstance().getAction("ShelvedChangesToolbar"));
        actionGroup.add((AnAction)new MyToggleDetailsAction(), new Constraints(Anchor.AFTER, "ShelvedChanges.ShowHideDeleted"));
        MyShelvedPreviewProcessor changeProcessor = new MyShelvedPreviewProcessor(this.myProject);
        this.mySplitterComponent = new PreviewDiffSplitterComponent(pane, changeProcessor, SHELVE_PREVIEW_SPLITTER_PROPORTION, this.myVcsConfiguration.SHELVE_DETAILS_PREVIEW_SHOWN);
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("ShelvedChanges", (ActionGroup)actionGroup, false);
        JPanel rootPanel = new JPanel(new BorderLayout());
        rootPanel.add((Component)toolbar.getComponent(), "West");
        rootPanel.add((Component)((Object)this.mySplitterComponent), "Center");
        DataManager.registerDataProvider((JComponent)rootPanel, (DataProvider)this.myTree);
        JPanel jPanel = rootPanel;
        if (jPanel == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(0);
        }
        return jPanel;
    }

    public void startEditing(@NotNull ShelvedChangeList shelvedChangeList) {
        if (shelvedChangeList == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(1);
        }
        this.runAfterUpdate(() -> {
            this.selectShelvedList(shelvedChangeList);
            this.myTree.startEditingAtPath(this.myTree.getLeadSelectionPath());
        });
    }

    public void activateView(@Nullable ShelvedChangeList list2) {
        this.runAfterUpdate(() -> {
            if (this.myContent == null) {
                return;
            }
            if (list2 != null) {
                this.selectShelvedList(list2);
            }
            this.myContentManager.setSelectedContent(this.myContent);
            ToolWindow window = this.getVcsToolWindow();
            if (window != null && !window.isVisible()) {
                window.activate(null);
            }
        });
    }

    private void runAfterUpdate(@NotNull Runnable postUpdateRunnable) {
        if (postUpdateRunnable == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(2);
        }
        GuiUtils.invokeLaterIfNeeded(() -> {
            this.myUpdateQueue.cancelAllUpdates();
            this.updateChangesContent();
            postUpdateRunnable.run();
        }, (ModalityState)ModalityState.NON_MODAL);
    }

    public void dispose() {
        this.myUpdateQueue.cancelAllUpdates();
        this.myTree.removeGroupingChangeListener(this.myGroupingChangeListener);
    }

    public void updateOnVcsMappingsChanged() {
        ApplicationManager.getApplication().invokeLater(() -> {
            ChangesGroupingSupport treeGroupingSupport = this.myTree.getGroupingSupport();
            if (treeGroupingSupport.isAvailable("repository") && treeGroupingSupport.get("repository")) {
                this.myTree.rebuildTree();
            }
        }, this.myProject.getDisposed());
    }

    public void selectShelvedList(@NotNull ShelvedChangeList list2) {
        DefaultMutableTreeNode treeNode;
        if (list2 == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(3);
        }
        if ((treeNode = TreeUtil.findNodeWithObject((DefaultMutableTreeNode)((DefaultMutableTreeNode)this.myTree.getModel().getRoot()), (Object)list2)) == null) {
            LOG.warn(String.format("Shelved changeList %s not found", list2.DESCRIPTION));
            return;
        }
        TreeUtil.selectNode((JTree)((Object)this.myTree), (TreeNode)treeNode);
    }

    @NotNull
    public static List<ShelvedChangeList> getShelvedLists(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(4);
        }
        ArrayList shelvedChangeLists = ContainerUtil.newArrayList();
        ContainerUtil.addAll((Collection)shelvedChangeLists, (Iterable)ContainerUtil.notNullize((List)((List)SHELVED_CHANGELIST_KEY.getData(dataContext))));
        ContainerUtil.addAll((Collection)shelvedChangeLists, (Iterable)ContainerUtil.notNullize((List)((List)SHELVED_RECYCLED_CHANGELIST_KEY.getData(dataContext))));
        ContainerUtil.addAll((Collection)shelvedChangeLists, (Iterable)ContainerUtil.notNullize((List)((List)SHELVED_DELETED_CHANGELIST_KEY.getData(dataContext))));
        ArrayList arrayList = shelvedChangeLists;
        if (arrayList == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    @NotNull
    public static List<ShelvedChange> getShelveChanges(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(6);
        }
        List list2 = ContainerUtil.notNullize((List)((List)dataContext.getData(SHELVED_CHANGE_KEY)));
        if (list2 == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(7);
        }
        return list2;
    }

    @NotNull
    public static List<ShelvedBinaryFile> getBinaryShelveChanges(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(8);
        }
        List list2 = ContainerUtil.notNullize((List)((List)dataContext.getData(SHELVED_BINARY_FILE_KEY)));
        if (list2 == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(9);
        }
        return list2;
    }

    @Nullable
    private DnDDragStartBean createDragStartBean(@NotNull DnDActionInfo info) {
        if (info == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(10);
        }
        if (info.isMove()) {
            DataContext dc = DataManager.getInstance().getDataContext((Component)((Object)this.myTree));
            return new DnDDragStartBean((Object)new ShelvedChangeListDragBean(ShelvedChangesViewManager.getShelveChanges(dc), ShelvedChangesViewManager.getBinaryShelveChanges(dc), ShelvedChangesViewManager.getShelvedLists(dc)));
        }
        return null;
    }

    @NotNull
    private DnDImage createDraggedImage(@NotNull DnDActionInfo info) {
        if (info == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(11);
        }
        String imageText = "Unshelve changes";
        Image image = (Image)DnDAwareTree.getDragImage((Tree)this.myTree, imageText, null).getFirst();
        DnDImage dnDImage = new DnDImage(image, new Point(-image.getWidth(null), -image.getHeight(null)));
        if (dnDImage == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(12);
        }
        return dnDImage;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 11: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 11: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/shelf/ShelvedChangesViewManager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shelvedChangeList";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "postUpdateRunnable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createRootPanel";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/shelf/ShelvedChangesViewManager";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getShelvedLists";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getShelveChanges";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getBinaryShelveChanges";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createDraggedImage";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "startEditing";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "runAfterUpdate";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "selectShelvedList";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getShelvedLists";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getShelveChanges";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getBinaryShelveChanges";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createDragStartBean";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createDraggedImage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 11: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyContentUpdater
    extends Update {
        MyContentUpdater() {
            super((Object)"ShelfContentUpdate");
        }

        public void run() {
            ShelvedChangesViewManager.this.updateChangesContent();
        }

        public boolean canEat(Update update) {
            return true;
        }
    }

    private static class ShelvedChangeNode
    extends ChangesBrowserNode<ShelvedWrapper> {
        @NotNull
        private final ShelvedWrapper myShelvedChange;
        @Nullable
        private final String myAdditionalText;

        protected ShelvedChangeNode(@NotNull ShelvedWrapper shelvedChange, @Nullable String additionalText) {
            if (shelvedChange == null) {
                ShelvedChangeNode.$$$reportNull$$$0(0);
            }
            super(shelvedChange);
            this.myShelvedChange = shelvedChange;
            this.myAdditionalText = additionalText;
        }

        @Override
        public void render(@NotNull ChangesBrowserNodeRenderer renderer2, boolean selected, boolean expanded, boolean hasFocus) {
            if (renderer2 == null) {
                ShelvedChangeNode.$$$reportNull$$$0(1);
            }
            String path = this.myShelvedChange.getRequestName();
            String directory = StringUtil.defaultIfEmpty((String)PathUtil.getParentPath((String)path), (String)"<project root>");
            String fileName2 = StringUtil.defaultIfEmpty((String)PathUtil.getFileName((String)path), (String)path);
            renderer2.append(fileName2, new SimpleTextAttributes(0, this.myShelvedChange.getFileStatus().getColor()));
            if (this.myAdditionalText != null) {
                renderer2.append(this.myAdditionalText, SimpleTextAttributes.REGULAR_ATTRIBUTES);
            }
            if (renderer2.isShowFlatten()) {
                renderer2.append(FontUtil.spaceAndThinSpace() + FileUtil.toSystemDependentName((String)directory), SimpleTextAttributes.GRAYED_ATTRIBUTES);
            }
            renderer2.setIcon(FileTypeManager.getInstance().getFileTypeByFileName(fileName2).getIcon());
        }

        @Override
        public String getTextPresentation() {
            return PathUtil.getFileName((String)this.myShelvedChange.getRequestName());
        }

        @Override
        protected boolean isFile() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "shelvedChange";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "renderer";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/changes/shelf/ShelvedChangesViewManager$ShelvedChangeNode";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "render";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ShelvedListNode
    extends ChangesBrowserNode<ShelvedChangeList> {
        private static final Icon PatchIcon = StdFileTypes.PATCH.getIcon();
        private static final Icon AppliedPatchIcon = new IconUtil.IconSizeWrapper(AllIcons.Vcs.Patch_applied, AllIcons.Vcs.Patch_applied.getIconWidth(), AllIcons.Vcs.Patch_applied.getIconHeight()){

            public void paintIcon(Component c, Graphics g, int x, int y) {
                GraphicsUtil.paintWithAlpha((Graphics)g, (float)0.6f);
                super.paintIcon(c, g, x, y);
            }
        };
        private static final Icon DisabledToDeleteIcon = IconUtil.desaturate((Icon)AllIcons.Actions.GC);
        @NotNull
        private final ShelvedChangeList myList;

        ShelvedListNode(@NotNull ShelvedChangeList list2) {
            if (list2 == null) {
                ShelvedListNode.$$$reportNull$$$0(0);
            }
            super(list2);
            this.myList = list2;
        }

        @NotNull
        public ShelvedChangeList getList() {
            ShelvedChangeList shelvedChangeList = this.myList;
            if (shelvedChangeList == null) {
                ShelvedListNode.$$$reportNull$$$0(1);
            }
            return shelvedChangeList;
        }

        @Override
        public void render(@NotNull ChangesBrowserNodeRenderer renderer2, boolean selected, boolean expanded, boolean hasFocus) {
            if (renderer2 == null) {
                ShelvedListNode.$$$reportNull$$$0(2);
            }
            if (this.myList.isRecycled() || this.myList.isDeleted()) {
                renderer2.appendTextWithIssueLinks(this.myList.DESCRIPTION, SimpleTextAttributes.GRAYED_BOLD_ATTRIBUTES);
                renderer2.setIcon(this.myList.isMarkedToDelete() || this.myList.isDeleted() ? DisabledToDeleteIcon : AppliedPatchIcon);
            } else {
                renderer2.appendTextWithIssueLinks(this.myList.DESCRIPTION, SimpleTextAttributes.REGULAR_ATTRIBUTES);
                renderer2.setIcon(PatchIcon);
            }
            this.appendCount(renderer2);
            String date = DateFormatUtil.formatPrettyDateTime((Date)this.myList.DATE);
            renderer2.append(", " + date, SimpleTextAttributes.GRAYED_ATTRIBUTES);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/shelf/ShelvedChangesViewManager$ShelvedListNode";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "renderer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/shelf/ShelvedChangesViewManager$ShelvedListNode";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getList";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "render";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class MyShelvedPreviewProcessor
    extends CacheDiffRequestProcessor<ShelvedWrapper>
    implements DiffPreviewUpdateProcessor {
        @NotNull
        private final DiffShelvedChangesActionProvider.PatchesPreloader myPreloader;
        @Nullable
        private ShelvedWrapper myCurrentShelvedElement;

        MyShelvedPreviewProcessor(Project project) {
            if (project == null) {
                MyShelvedPreviewProcessor.$$$reportNull$$$0(0);
            }
            super(project);
            this.myPreloader = new DiffShelvedChangesActionProvider.PatchesPreloader(project);
            Disposer.register((Disposable)project, (Disposable)this);
        }

        @Override
        @NotNull
        protected String getRequestName(@NotNull ShelvedWrapper provider) {
            if (provider == null) {
                MyShelvedPreviewProcessor.$$$reportNull$$$0(1);
            }
            String string = provider.getRequestName();
            if (string == null) {
                MyShelvedPreviewProcessor.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        protected ShelvedWrapper getCurrentRequestProvider() {
            return this.myCurrentShelvedElement;
        }

        @Override
        public void clear() {
            this.myCurrentShelvedElement = null;
            this.updateRequest();
            this.dropCaches();
        }

        @Override
        public void refresh(boolean fromModelRefresh) {
            DataContext dc = DataManager.getInstance().getDataContext((Component)((Object)ShelvedChangesViewManager.this.myTree));
            List<ShelvedChange> selectedChanges = ShelvedChangesViewManager.getShelveChanges(dc);
            List<ShelvedBinaryFile> selectedBinaryChanges = ShelvedChangesViewManager.getBinaryShelveChanges(dc);
            if (selectedChanges.isEmpty() && selectedBinaryChanges.isEmpty()) {
                this.clear();
                return;
            }
            if (this.myCurrentShelvedElement != null && (this.keepBinarySelection(selectedBinaryChanges, this.myCurrentShelvedElement.getBinaryFile()) || this.keepShelvedSelection(selectedChanges, this.myCurrentShelvedElement.getShelvedChange()))) {
                this.dropCachesIfNeededAndUpdate(this.myCurrentShelvedElement);
                return;
            }
            this.myCurrentShelvedElement = !selectedChanges.isEmpty() ? new ShelvedWrapper(selectedChanges.get(0)) : new ShelvedWrapper(selectedBinaryChanges.get(0));
            this.dropCachesIfNeededAndUpdate(this.myCurrentShelvedElement);
        }

        private void dropCachesIfNeededAndUpdate(@NotNull ShelvedWrapper currentShelvedElement) {
            ShelvedChange shelvedChange;
            boolean dropCaches;
            if (currentShelvedElement == null) {
                MyShelvedPreviewProcessor.$$$reportNull$$$0(3);
            }
            boolean bl = dropCaches = (shelvedChange = currentShelvedElement.getShelvedChange()) != null && this.myPreloader.isPatchFileChanged(shelvedChange.getPatchPath());
            if (dropCaches) {
                this.dropCaches();
            }
            this.updateRequest(dropCaches);
        }

        boolean keepShelvedSelection(@NotNull List<ShelvedChange> selectedChanges, @Nullable ShelvedChange currentShelvedChange) {
            if (selectedChanges == null) {
                MyShelvedPreviewProcessor.$$$reportNull$$$0(4);
            }
            return currentShelvedChange != null && selectedChanges.contains(currentShelvedChange);
        }

        boolean keepBinarySelection(@NotNull List<ShelvedBinaryFile> selectedBinaryChanges, @Nullable ShelvedBinaryFile currentBinary) {
            if (selectedBinaryChanges == null) {
                MyShelvedPreviewProcessor.$$$reportNull$$$0(5);
            }
            return currentBinary != null && selectedBinaryChanges.contains(currentBinary);
        }

        @Override
        @NotNull
        protected DiffRequest loadRequest(@NotNull ShelvedWrapper provider, @NotNull ProgressIndicator indicator) throws ProcessCanceledException, DiffRequestProducerException {
            SimpleDiffRequest simpleDiffRequest;
            block8: {
                block6: {
                    PatchDiffRequest patchDiffRequest;
                    block7: {
                        if (provider == null) {
                            MyShelvedPreviewProcessor.$$$reportNull$$$0(6);
                        }
                        if (indicator == null) {
                            MyShelvedPreviewProcessor.$$$reportNull$$$0(7);
                        }
                        ShelvedChange shelvedChange = provider.getShelvedChange();
                        if (shelvedChange == null) break block6;
                        patchDiffRequest = new PatchDiffRequest(DiffShelvedChangesActionProvider.createAppliedTextPatch(this.myPreloader.getPatch(shelvedChange, null)));
                        if (patchDiffRequest != null) break block7;
                        MyShelvedPreviewProcessor.$$$reportNull$$$0(8);
                    }
                    return patchDiffRequest;
                }
                try {
                    DiffContentFactoryEx factory = DiffContentFactoryEx.getInstanceEx();
                    ShelvedBinaryFile binaryFile = (ShelvedBinaryFile)ObjectUtils.assertNotNull((Object)provider.getBinaryFile());
                    if (binaryFile.AFTER_PATH == null) {
                        throw new DiffRequestProducerException("Content for '" + this.getRequestName(provider) + "' was removed");
                    }
                    byte[] binaryContent = binaryFile.createBinaryContentRevision(ShelvedChangesViewManager.this.myProject).getBinaryContent();
                    FileType fileType = VcsUtil.getFilePath((String)binaryFile.SHELVED_PATH).getFileType();
                    simpleDiffRequest = new SimpleDiffRequest(this.getRequestName(provider), (DiffContent)factory.createEmpty(), factory.createBinary(ShelvedChangesViewManager.this.myProject, binaryContent, fileType, this.getRequestName(provider)), null, null);
                    if (simpleDiffRequest != null) break block8;
                }
                catch (VcsException | IOException e) {
                    throw new DiffRequestProducerException("Can't show diff for '" + this.getRequestName(provider) + "'", e);
                }
                MyShelvedPreviewProcessor.$$$reportNull$$$0(9);
            }
            return simpleDiffRequest;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 8: 
                case 9: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 8: 
                case 9: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "provider";
                    break;
                }
                case 2: 
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/shelf/ShelvedChangesViewManager$MyShelvedPreviewProcessor";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "currentShelvedElement";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selectedChanges";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selectedBinaryChanges";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/shelf/ShelvedChangesViewManager$MyShelvedPreviewProcessor";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRequestName";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "loadRequest";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getRequestName";
                    break;
                }
                case 2: 
                case 8: 
                case 9: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "dropCachesIfNeededAndUpdate";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "keepShelvedSelection";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "keepBinarySelection";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "loadRequest";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 8: 
                case 9: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class MyToggleDetailsAction
    extends ShowDiffPreviewAction {
        private MyToggleDetailsAction() {
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                MyToggleDetailsAction.$$$reportNull$$$0(0);
            }
            ShelvedChangesViewManager.this.mySplitterComponent.setDetailsOn(state);
            ((ShelvedChangesViewManager)ShelvedChangesViewManager.this).myVcsConfiguration.SHELVE_DETAILS_PREVIEW_SHOWN = state;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                MyToggleDetailsAction.$$$reportNull$$$0(1);
            }
            return ((ShelvedChangesViewManager)ShelvedChangesViewManager.this).myVcsConfiguration.SHELVE_DETAILS_PREVIEW_SHOWN;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/openapi/vcs/changes/shelf/ShelvedChangesViewManager$MyToggleDetailsAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public class MyShelfContent
    extends DnDActivateOnHoldTargetContent {
        private MyShelfContent(@NotNull JPanel panel2, String displayName, boolean isLockable) {
            if (displayName == null) {
                MyShelfContent.$$$reportNull$$$0(0);
            }
            super(ShelvedChangesViewManager.this.myProject, panel2, displayName, isLockable);
        }

        @Override
        public void drop(DnDEvent event) {
            super.drop(event);
            Object attachedObject = event.getAttachedObject();
            if (attachedObject instanceof ChangeListDragBean) {
                FileDocumentManager.getInstance().saveAllDocuments();
                List<Change> changes2 = Arrays.asList(((ChangeListDragBean)attachedObject).getChanges());
                ShelvedChangesViewManager.this.myShelveChangesManager.shelveSilentlyUnderProgress(changes2);
            }
        }

        @Override
        public boolean isDropPossible(@NotNull DnDEvent event) {
            Object attachedObject;
            if (event == null) {
                MyShelfContent.$$$reportNull$$$0(1);
            }
            return (attachedObject = event.getAttachedObject()) instanceof ChangeListDragBean && ((ChangeListDragBean)attachedObject).getChanges().length > 0;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "displayName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/changes/shelf/ShelvedChangesViewManager$MyShelfContent";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isDropPossible";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyShelveDeleteProvider
    implements DeleteProvider {
        private MyShelveDeleteProvider() {
        }

        public void deleteElement(@NotNull DataContext dataContext) {
            Project project;
            if (dataContext == null) {
                MyShelveDeleteProvider.$$$reportNull$$$0(0);
            }
            if ((project = (Project)CommonDataKeys.PROJECT.getData(dataContext)) == null) {
                return;
            }
            List shelvedListsToDelete = TreeUtil.collectSelectedObjectsOfType((JTree)((Object)ShelvedChangesViewManager.this.myTree), ShelvedChangeList.class);
            List<ShelvedChange> changesToDelete = this.getChangesNotInLists(shelvedListsToDelete, ShelvedChangesViewManager.getShelveChanges(dataContext));
            List<ShelvedBinaryFile> binariesToDelete = this.getBinariesNotInLists(shelvedListsToDelete, ShelvedChangesViewManager.getBinaryShelveChanges(dataContext));
            int fileListSize = binariesToDelete.size() + changesToDelete.size();
            Map<ShelvedChangeList, Date> createdDeletedListsWithOriginalDates = ShelvedChangesViewManager.this.myShelveChangesManager.deleteShelves(shelvedListsToDelete, ShelvedChangesViewManager.getShelvedLists(dataContext), changesToDelete, binariesToDelete);
            if (!createdDeletedListsWithOriginalDates.isEmpty()) {
                this.showUndoDeleteNotification(shelvedListsToDelete, fileListSize, createdDeletedListsWithOriginalDates);
            }
        }

        private void showUndoDeleteNotification(@NotNull List<? extends ShelvedChangeList> shelvedListsToDelete, int fileListSize, @NotNull Map<ShelvedChangeList, Date> createdDeletedListsWithOriginalDate) {
            if (shelvedListsToDelete == null) {
                MyShelveDeleteProvider.$$$reportNull$$$0(1);
            }
            if (createdDeletedListsWithOriginalDate == null) {
                MyShelveDeleteProvider.$$$reportNull$$$0(2);
            }
            String message = this.constructDeleteSuccessfullyMessage(fileListSize, shelvedListsToDelete.size(), (ShelvedChangeList)ContainerUtil.getFirstItem(shelvedListsToDelete));
            ShelfDeleteNotification shelfDeletionNotification = new ShelfDeleteNotification(message);
            shelfDeletionNotification.addAction((AnAction)new UndoShelfDeletionAction(createdDeletedListsWithOriginalDate));
            shelfDeletionNotification.addAction(ActionManager.getInstance().getAction("ShelvedChanges.ShowRecentlyDeleted"));
            VcsNotifier.getInstance(ShelvedChangesViewManager.this.myProject).showNotificationAndHideExisting(shelfDeletionNotification, ShelfDeleteNotification.class);
        }

        private List<ShelvedBinaryFile> getBinariesNotInLists(@NotNull List<? extends ShelvedChangeList> listsToDelete, @NotNull List<? extends ShelvedBinaryFile> binaryFiles) {
            if (listsToDelete == null) {
                MyShelveDeleteProvider.$$$reportNull$$$0(3);
            }
            if (binaryFiles == null) {
                MyShelveDeleteProvider.$$$reportNull$$$0(4);
            }
            ArrayList<ShelvedBinaryFile> result2 = new ArrayList<ShelvedBinaryFile>(binaryFiles);
            for (ShelvedChangeList shelvedChangeList : listsToDelete) {
                result2.removeAll(shelvedChangeList.getBinaryFiles());
            }
            return result2;
        }

        @NotNull
        private List<ShelvedChange> getChangesNotInLists(@NotNull List<? extends ShelvedChangeList> listsToDelete, @NotNull List<? extends ShelvedChange> shelvedChanges) {
            if (listsToDelete == null) {
                MyShelveDeleteProvider.$$$reportNull$$$0(5);
            }
            if (shelvedChanges == null) {
                MyShelveDeleteProvider.$$$reportNull$$$0(6);
            }
            ArrayList<ShelvedChange> result2 = new ArrayList<ShelvedChange>(shelvedChanges);
            for (ShelvedChangeList shelvedChangeList : listsToDelete) {
                result2.removeAll(shelvedChangeList.getChanges(ShelvedChangesViewManager.this.myProject));
            }
            ArrayList<ShelvedChange> arrayList = result2;
            if (arrayList == null) {
                MyShelveDeleteProvider.$$$reportNull$$$0(7);
            }
            return arrayList;
        }

        @NotNull
        private String constructDeleteSuccessfullyMessage(int fileNum, int listNum, @Nullable ShelvedChangeList first) {
            StringBuilder stringBuilder = new StringBuilder();
            String delimiter = "";
            if (fileNum != 0) {
                stringBuilder.append(fileNum == 1 ? "one" : Integer.valueOf(fileNum)).append(StringUtil.pluralize((String)" file", (int)fileNum));
                delimiter = " and ";
            }
            if (listNum != 0) {
                stringBuilder.append(delimiter);
                if (listNum == 1 && first != null) {
                    stringBuilder.append("one shelved changelist [<b>").append(first.DESCRIPTION).append("</b>]");
                } else {
                    stringBuilder.append(listNum).append(" shelved ").append(StringUtil.pluralize((String)"changelist", (int)listNum));
                }
            }
            stringBuilder.append(" deleted successfully");
            String string = StringUtil.capitalize((String)stringBuilder.toString());
            if (string == null) {
                MyShelveDeleteProvider.$$$reportNull$$$0(8);
            }
            return string;
        }

        public boolean canDeleteElement(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                MyShelveDeleteProvider.$$$reportNull$$$0(9);
            }
            return !ShelvedChangesViewManager.getShelvedLists(dataContext).isEmpty();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 7: 
                case 8: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 7: 
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataContext";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "shelvedListsToDelete";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "createdDeletedListsWithOriginalDate";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "listsToDelete";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "binaryFiles";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "shelvedChanges";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/shelf/ShelvedChangesViewManager$MyShelveDeleteProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/shelf/ShelvedChangesViewManager$MyShelveDeleteProvider";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChangesNotInLists";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "constructDeleteSuccessfullyMessage";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "deleteElement";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "showUndoDeleteNotification";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getBinariesNotInLists";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getChangesNotInLists";
                    break;
                }
                case 7: 
                case 8: {
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "canDeleteElement";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 7: 
                case 8: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private class UndoShelfDeletionAction
        extends NotificationAction {
            @NotNull
            private final Map<ShelvedChangeList, Date> myListDateMap;

            private UndoShelfDeletionAction(Map<ShelvedChangeList, Date> listDateMap) {
                if (listDateMap == null) {
                    UndoShelfDeletionAction.$$$reportNull$$$0(0);
                }
                super("Undo");
                this.myListDateMap = listDateMap;
            }

            public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                if (e == null) {
                    UndoShelfDeletionAction.$$$reportNull$$$0(1);
                }
                if (notification == null) {
                    UndoShelfDeletionAction.$$$reportNull$$$0(2);
                }
                ShelveChangesManager manager = ShelveChangesManager.getInstance(ShelvedChangesViewManager.this.myProject);
                List cantRestoreList = ContainerUtil.findAll(this.myListDateMap.keySet(), l -> !ShelvedChangesViewManager.this.myShelveChangesManager.getDeletedLists().contains(l));
                this.myListDateMap.forEach((l, d) -> manager.restoreList((ShelvedChangeList)l, (Date)d));
                notification.expire();
                if (!cantRestoreList.isEmpty()) {
                    VcsNotifier.getInstance(ShelvedChangesViewManager.this.myProject).notifyMinorWarning("Undo Shelf Deletion", VcsBundle.message((String)"shelve.changes.restore.error", (Object[])new Object[]{cantRestoreList.size(), StringUtil.pluralize((String)"changelist", (int)cantRestoreList.size())}));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "listDateMap";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "notification";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/openapi/vcs/changes/shelf/ShelvedChangesViewManager$MyShelveDeleteProvider$UndoShelfDeletionAction";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "<init>";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }

    private class ShelfTree
    extends ChangesTree {
        private ShelfTree(Project project) {
            if (project == null) {
                ShelfTree.$$$reportNull$$$0(0);
            }
            super(project, false, false, true);
            this.setKeepTreeState(true);
        }

        public boolean isPathEditable(TreePath path) {
            return this.isEditable() && ShelvedChangesViewManager.this.myTree.getSelectionCount() == 1 && path.getLastPathComponent() instanceof ShelvedListNode;
        }

        @Override
        @NotNull
        protected ChangesGroupingSupport installGroupingSupport() {
            ChangesGroupingSupport changesGroupingSupport = new ChangesGroupingSupport(this.myProject, (Object)this, false);
            if (changesGroupingSupport == null) {
                ShelfTree.$$$reportNull$$$0(1);
            }
            return changesGroupingSupport;
        }

        @Override
        public int getToggleClickCount() {
            return 2;
        }

        @Override
        protected void installDoubleClickHandler() {
            new DoubleClickListener(){

                protected boolean onDoubleClick(MouseEvent e) {
                    if (!ShelvedChangesViewManager.this.hasExactlySelectedChanges()) {
                        return false;
                    }
                    DiffShelvedChangesActionProvider.showShelvedChangesDiff(DataManager.getInstance().getDataContext((Component)((Object)ShelvedChangesViewManager.this.myTree)));
                    return true;
                }
            }.installOn((Component)((Object)this));
        }

        @Override
        public void rebuildTree() {
            DefaultTreeModel newModel = this.buildTreeModel();
            this.updateTreeModel(newModel);
        }

        private DefaultTreeModel buildTreeModel() {
            MyShelvedTreeModelBuilder modelBuilder = new MyShelvedTreeModelBuilder();
            ArrayList<ShelvedChangeList> changeLists = new ArrayList<ShelvedChangeList>(ShelvedChangesViewManager.this.myShelveChangesManager.getShelvedChangeLists());
            if (ShelvedChangesViewManager.this.myShelveChangesManager.isShowRecycled()) {
                changeLists.addAll(ShelvedChangesViewManager.this.myShelveChangesManager.getRecycledShelvedChangeLists());
            }
            changeLists.sort(ChangelistComparator.getInstance());
            modelBuilder.setShelvedLists(changeLists);
            modelBuilder.setDeletedShelvedLists(ContainerUtil.sorted(ShelvedChangesViewManager.this.myShelveChangesManager.getDeletedLists(), (Comparator)ChangelistComparator.getInstance()));
            return modelBuilder.build();
        }

        @Override
        @Nullable
        public Object getData(@NotNull @NonNls String dataId) {
            if (dataId == null) {
                ShelfTree.$$$reportNull$$$0(2);
            }
            if (SHELVED_CHANGELIST_KEY.is(dataId)) {
                return ContainerUtil.newArrayList(this.getSelectedLists(l -> !l.isRecycled() && !l.isDeleted()));
            }
            if (SHELVED_RECYCLED_CHANGELIST_KEY.is(dataId)) {
                return ContainerUtil.newArrayList(this.getSelectedLists(l -> l.isRecycled() && !l.isDeleted()));
            }
            if (SHELVED_DELETED_CHANGELIST_KEY.is(dataId)) {
                return ContainerUtil.newArrayList(this.getSelectedLists(l -> l.isDeleted()));
            }
            if (SHELVED_CHANGE_KEY.is(dataId)) {
                return StreamEx.of(VcsTreeModelData.selected((JTree)((Object)ShelvedChangesViewManager.this.myTree)).userObjectsStream(ShelvedWrapper.class)).map(s -> s.getShelvedChange()).nonNull().toList();
            }
            if (SHELVED_BINARY_FILE_KEY.is(dataId)) {
                return StreamEx.of(VcsTreeModelData.selected((JTree)((Object)ShelvedChangesViewManager.this.myTree)).userObjectsStream(ShelvedWrapper.class)).map(s -> s.getBinaryFile()).nonNull().toList();
            }
            if (VcsDataKeys.HAVE_SELECTED_CHANGES.is(dataId)) {
                return this.getSelectionCount() > 0;
            }
            if (VcsDataKeys.CHANGES.is(dataId)) {
                List<ShelvedWrapper> shelvedChanges = VcsTreeModelData.selected((JTree)((Object)ShelvedChangesViewManager.this.myTree)).userObjects(ShelvedWrapper.class);
                if (!shelvedChanges.isEmpty()) {
                    return ContainerUtil.map2Array(shelvedChanges, Change.class, s -> s.getChange(this.myProject));
                }
            } else {
                if (PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(dataId)) {
                    return ShelvedChangesViewManager.this.myDeleteProvider;
                }
                if (CommonDataKeys.NAVIGATABLE_ARRAY.is(dataId)) {
                    List<ShelvedWrapper> shelvedChanges = VcsTreeModelData.selected((JTree)((Object)ShelvedChangesViewManager.this.myTree)).userObjects(ShelvedWrapper.class);
                    ArrayDeque<2> navigatables = new ArrayDeque<2>();
                    for (final ShelvedWrapper shelvedChange : shelvedChanges) {
                        if (shelvedChange.getBeforePath() == null || FileStatus.ADDED.equals(shelvedChange.getFileStatus())) continue;
                        NavigatableAdapter navigatable = new NavigatableAdapter(){

                            public void navigate(boolean requestFocus) {
                                VirtualFile vf = shelvedChange.getBeforeVFUnderProject(ShelfTree.this.myProject);
                                if (vf != null) {
                                    2.navigate((Project)ShelfTree.this.myProject, (VirtualFile)vf, (boolean)true);
                                }
                            }
                        };
                        navigatables.add(navigatable);
                    }
                    return navigatables.toArray(new Navigatable[0]);
                }
            }
            return super.getData(dataId);
        }

        @NotNull
        private Set<ShelvedChangeList> getSelectedLists(@NotNull Predicate<? super ShelvedChangeList> condition) {
            Object[] selectionPaths;
            if (condition == null) {
                ShelfTree.$$$reportNull$$$0(3);
            }
            if ((selectionPaths = this.getSelectionPaths()) == null) {
                Set<ShelvedChangeList> set2 = Collections.emptySet();
                if (set2 == null) {
                    ShelfTree.$$$reportNull$$$0(4);
                }
                return set2;
            }
            Set set3 = (Set)((StreamEx)((StreamEx)StreamEx.of((Object[])selectionPaths).map(path -> (ShelvedChangeList)TreeUtil.findObjectInPath((TreePath)path, ShelvedChangeList.class)).filter(Objects::nonNull)).filter(condition)).collect(Collectors.toSet());
            if (set3 == null) {
                ShelfTree.$$$reportNull$$$0(5);
            }
            return set3;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/shelf/ShelvedChangesViewManager$ShelfTree";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataId";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "condition";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/shelf/ShelvedChangesViewManager$ShelfTree";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "installGroupingSupport";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSelectedLists";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 4: 
                case 5: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getData";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getSelectedLists";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class ChangelistComparator
    implements Comparator<ShelvedChangeList> {
        private static final ChangelistComparator ourInstance = new ChangelistComparator();

        ChangelistComparator() {
        }

        public static ChangelistComparator getInstance() {
            return ourInstance;
        }

        @Override
        public int compare(ShelvedChangeList o1, ShelvedChangeList o2) {
            return o2.DATE.compareTo(o1.DATE);
        }
    }

    private class MyShelvedTreeModelBuilder
    extends TreeModelBuilder {
        private MyShelvedTreeModelBuilder() {
            super(ShelvedChangesViewManager.this.myProject, ShelvedChangesViewManager.this.myTree.getGrouping());
        }

        public void setShelvedLists(@NotNull List<ShelvedChangeList> shelvedLists) {
            if (shelvedLists == null) {
                MyShelvedTreeModelBuilder.$$$reportNull$$$0(0);
            }
            this.createShelvedListsWithChangesNode(shelvedLists, this.myRoot);
        }

        public void setDeletedShelvedLists(@NotNull List<ShelvedChangeList> shelvedLists) {
            if (shelvedLists == null) {
                MyShelvedTreeModelBuilder.$$$reportNull$$$0(1);
            }
            this.createShelvedListsWithChangesNode(shelvedLists, this.createTagNode("Recently Deleted"));
        }

        private void createShelvedListsWithChangesNode(@NotNull List<ShelvedChangeList> shelvedLists, @NotNull MutableTreeNode parentNode) {
            if (shelvedLists == null) {
                MyShelvedTreeModelBuilder.$$$reportNull$$$0(2);
            }
            if (parentNode == null) {
                MyShelvedTreeModelBuilder.$$$reportNull$$$0(3);
            }
            shelvedLists.forEach(changeList -> {
                ArrayList shelvedChanges = ContainerUtil.newArrayList();
                changeList.getChanges(this.myProject).stream().map(ShelvedWrapper::new).forEach(shelvedChanges::add);
                changeList.getBinaryFiles().stream().map(ShelvedWrapper::new).forEach(shelvedChanges::add);
                shelvedChanges.sort(Comparator.comparing(s -> s.getChange(this.myProject), CHANGE_COMPARATOR));
                ShelvedListNode shelvedListNode = new ShelvedListNode((ShelvedChangeList)changeList);
                this.myModel.insertNodeInto(shelvedListNode, parentNode, parentNode.getChildCount());
                for (ShelvedWrapper shelved : shelvedChanges) {
                    Change change = shelved.getChange(this.myProject);
                    this.insertChangeNode(change, shelvedListNode, new ShelvedChangeNode(shelved, change.getOriginText(this.myProject)));
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "shelvedLists";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parentNode";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/changes/shelf/ShelvedChangesViewManager$MyShelvedTreeModelBuilder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setShelvedLists";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setDeletedShelvedLists";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createShelvedListsWithChangesNode";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

