/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions.diff.lst;

import com.intellij.diff.DiffContext;
import com.intellij.diff.comparison.DiffTooBigException;
import com.intellij.diff.fragments.LineFragment;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.simple.SimpleDiffChange;
import com.intellij.diff.tools.simple.SimpleDiffViewer;
import com.intellij.diff.tools.util.DiffNotifications;
import com.intellij.diff.util.DiffGutterRenderer;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.Range;
import com.intellij.diff.util.Side;
import com.intellij.icons.AllIcons;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.actions.diff.lst.LocalChangeListDiffRequest;
import com.intellij.openapi.vcs.changes.actions.diff.lst.LocalChangeListDiffTool;
import com.intellij.openapi.vcs.ex.ExclusionState;
import com.intellij.openapi.vcs.ex.LineStatusTracker;
import com.intellij.openapi.vcs.ex.LocalRange;
import com.intellij.openapi.vcs.ex.MoveChangesLineStatusAction;
import com.intellij.openapi.vcs.ex.PartialLocalLineStatusTracker;
import com.intellij.openapi.vcs.ex.SimpleLocalLineStatusTracker;
import com.intellij.openapi.vcs.impl.LineStatusTrackerManager;
import com.intellij.ui.InplaceButton;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleLocalChangeListDiffViewer
extends SimpleDiffViewer {
    @NotNull
    private final LocalChangeListDiffRequest myLocalRequest;
    @NotNull
    private final String myChangelistId;
    @NotNull
    private final String myChangelistName;
    private ExcludeAllCheckboxPanel myExcludeAllCheckboxPanel;
    private final boolean myAllowExcludeChangesFromCommit;

    public SimpleLocalChangeListDiffViewer(@NotNull DiffContext context, @NotNull LocalChangeListDiffRequest localRequest) {
        if (context == null) {
            SimpleLocalChangeListDiffViewer.$$$reportNull$$$0(0);
        }
        if (localRequest == null) {
            SimpleLocalChangeListDiffViewer.$$$reportNull$$$0(1);
        }
        super(context, (DiffRequest)localRequest.getRequest());
        this.myLocalRequest = localRequest;
        this.myChangelistId = localRequest.getChangelistId();
        this.myChangelistName = localRequest.getChangelistName();
        MyTrackerListener trackerListener = new MyTrackerListener();
        MyLineStatusTrackerManagerListener lstmListener = new MyLineStatusTrackerManagerListener(trackerListener);
        LineStatusTrackerManager.getInstanceImpl(this.getProject()).addTrackerListener(lstmListener, (Disposable)this);
        PartialLocalLineStatusTracker tracker = this.getPartialTracker();
        if (tracker != null) {
            tracker.addListener(trackerListener, (Disposable)this);
        }
        DiffUtil.registerAction((AnAction)new MoveSelectedChangesToAnotherChangelistAction(true), this.myPanel);
        DiffUtil.registerAction((AnAction)new ExcludeSelectedChangesFromCommitAction(true), this.myPanel);
        DiffUtil.registerAction((AnAction)new IncludeOnlySelectedChangesIntoCommitAction(true), this.myPanel);
        this.myAllowExcludeChangesFromCommit = Boolean.TRUE.equals(context.getUserData(LocalChangeListDiffTool.ALLOW_EXCLUDE_FROM_COMMIT));
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = super.getProject();
        if (project == null) {
            SimpleLocalChangeListDiffViewer.$$$reportNull$$$0(2);
        }
        return project;
    }

    @Nullable
    public PartialLocalLineStatusTracker getPartialTracker() {
        return (PartialLocalLineStatusTracker)ObjectUtils.tryCast((Object)this.myLocalRequest.getLineStatusTracker(), PartialLocalLineStatusTracker.class);
    }

    @Override
    @NotNull
    protected List<JComponent> createTitles() {
        List<JComponent> titles = DiffUtil.createTextTitles(this.myRequest, this.getEditors());
        assert (titles.size() == 2);
        this.myExcludeAllCheckboxPanel = new ExcludeAllCheckboxPanel();
        BorderLayoutPanel titleWithCheckbox = JBUI.Panels.simplePanel((Component)titles.get(1)).addToLeft((Component)this.myExcludeAllCheckboxPanel);
        List<JComponent> list2 = DiffUtil.createSyncHeightComponents(ContainerUtil.list((Object[])new JComponent[]{titles.get(0), titleWithCheckbox}));
        if (list2 == null) {
            SimpleLocalChangeListDiffViewer.$$$reportNull$$$0(3);
        }
        return list2;
    }

    @Override
    @NotNull
    protected List<AnAction> createEditorPopupActions() {
        ArrayList<AnAction> group = new ArrayList<AnAction>(super.createEditorPopupActions());
        group.add((AnAction)new MoveSelectedChangesToAnotherChangelistAction(false));
        group.add((AnAction)new ExcludeSelectedChangesFromCommitAction(false));
        group.add((AnAction)new IncludeOnlySelectedChangesIntoCommitAction(false));
        ArrayList<AnAction> arrayList = group;
        if (arrayList == null) {
            SimpleLocalChangeListDiffViewer.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @NotNull
    protected Runnable performRediff(@NotNull ProgressIndicator indicator) {
        block17: {
            block16: {
                if (indicator == null) {
                    SimpleLocalChangeListDiffViewer.$$$reportNull$$$0(5);
                }
                if ((tracker = this.myLocalRequest.getLineStatusTracker()) instanceof SimpleLocalLineStatusTracker) {
                    v0 = super.performRediff(indicator);
                    if (v0 == null) {
                        SimpleLocalChangeListDiffViewer.$$$reportNull$$$0(6);
                    }
                    return v0;
                }
                partialTracker = (PartialLocalLineStatusTracker)ObjectUtils.tryCast((Object)tracker, PartialLocalLineStatusTracker.class);
                if (partialTracker == null || this.getContent2().getDocument() != tracker.getDocument()) {
                    v1 = this.applyNotification(DiffNotifications.createError());
                    if (v1 == null) {
                        SimpleLocalChangeListDiffViewer.$$$reportNull$$$0(7);
                    }
                    return v1;
                }
                indicator.checkCanceled();
                data = (TrackerData)ReadAction.compute((ThrowableComputable)(ThrowableComputable)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$performRediff$0(com.intellij.openapi.vcs.ex.PartialLocalLineStatusTracker ), ()Lcom/intellij/openapi/vcs/changes/actions/diff/lst/SimpleLocalChangeListDiffViewer$TrackerData;)((SimpleLocalChangeListDiffViewer)this, (PartialLocalLineStatusTracker)partialTracker));
                if (!TrackerData.access$200(data)) break block16;
                v2 = this.applyNotification(DiffNotifications.createError());
                if (v2 == null) {
                    SimpleLocalChangeListDiffViewer.$$$reportNull$$$0(8);
                }
                return v2;
            }
            diffData = data.diffData;
            if (diffData != null && diffData.ranges != null) ** GOTO lbl36
            if (data.affectedChangelist.size() != 1 || !data.affectedChangelist.contains(this.myChangelistId)) break block17;
            callback = super.performRediff(indicator);
            v3 = (Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$performRediff$1(java.lang.Runnable ), ()V)((SimpleLocalChangeListDiffViewer)this, (Runnable)callback);
            if (v3 == null) {
                SimpleLocalChangeListDiffViewer.$$$reportNull$$$0(9);
            }
            return v3;
        }
        try {
            this.scheduleRediff();
            throw new ProcessCanceledException();
lbl36:
            // 1 sources

            v4 = this.performRediffUsingPartialTracker(diffData.ranges, diffData.localText, diffData.vcsText, diffData.trackerVcsText, indicator);
        }
        catch (DiffTooBigException e) {
            v5 = this.applyNotification(DiffNotifications.createDiffTooBig());
            if (v5 == null) {
                SimpleLocalChangeListDiffViewer.$$$reportNull$$$0(11);
            }
            return v5;
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            SimpleLocalChangeListDiffViewer.LOG.error(e);
            v6 = this.applyNotification(DiffNotifications.createError());
            if (v6 == null) {
                SimpleLocalChangeListDiffViewer.$$$reportNull$$$0(12);
            }
            return v6;
        }
        if (v4 == null) {
            SimpleLocalChangeListDiffViewer.$$$reportNull$$$0(10);
        }
        return v4;
    }

    @NotNull
    private Runnable performRediffUsingPartialTracker(@NotNull List<LocalRange> ranges, @NotNull CharSequence localText, @NotNull CharSequence vcsText, @NotNull CharSequence trackerVcsText, @NotNull ProgressIndicator indicator) {
        if (ranges == null) {
            SimpleLocalChangeListDiffViewer.$$$reportNull$$$0(13);
        }
        if (localText == null) {
            SimpleLocalChangeListDiffViewer.$$$reportNull$$$0(14);
        }
        if (vcsText == null) {
            SimpleLocalChangeListDiffViewer.$$$reportNull$$$0(15);
        }
        if (trackerVcsText == null) {
            SimpleLocalChangeListDiffViewer.$$$reportNull$$$0(16);
        }
        if (indicator == null) {
            SimpleLocalChangeListDiffViewer.$$$reportNull$$$0(17);
        }
        if (!StringUtil.equals((CharSequence)trackerVcsText, (CharSequence)vcsText)) {
            Runnable runnable2 = this.applyNotification(DiffNotifications.createError());
            if (runnable2 == null) {
                SimpleLocalChangeListDiffViewer.$$$reportNull$$$0(18);
            }
            return runnable2;
        }
        if (this.myTextDiffProvider.isHighlightingDisabled()) {
            Runnable runnable3 = this.apply(new SimpleDiffViewer.CompareData(null, ranges.isEmpty()));
            if (runnable3 == null) {
                SimpleLocalChangeListDiffViewer.$$$reportNull$$$0(19);
            }
            return runnable3;
        }
        List linesRanges = ContainerUtil.map(ranges, range2 -> new Range(range2.getVcsLine1(), range2.getVcsLine2(), range2.getLine1(), range2.getLine2()));
        List newFragments = (List)ObjectUtils.notNull(this.myTextDiffProvider.compare(vcsText, localText, linesRanges, indicator));
        boolean isContentsEqual = ranges.isEmpty();
        ArrayList<SimpleDiffChange> changes2 = new ArrayList<SimpleDiffChange>();
        for (int i = 0; i < ranges.size(); ++i) {
            LocalRange localRange = ranges.get(i);
            List rangeFragments = (List)newFragments.get(i);
            boolean isExcludedFromCommit = localRange.isExcludedFromCommit();
            boolean isFromActiveChangelist = localRange.getChangelistId().equals(this.myChangelistId);
            boolean isSkipped = !isFromActiveChangelist;
            boolean isExcluded = !isFromActiveChangelist || this.myAllowExcludeChangesFromCommit && isExcludedFromCommit;
            changes2.addAll(ContainerUtil.map((Collection)rangeFragments, fragment -> new MySimpleDiffChange((LineFragment)fragment, isExcluded, isSkipped, localRange.getChangelistId(), isExcludedFromCommit)));
        }
        Runnable runnable4 = this.apply(new SimpleDiffViewer.CompareData(changes2, isContentsEqual));
        if (runnable4 == null) {
            SimpleLocalChangeListDiffViewer.$$$reportNull$$$0(20);
        }
        return runnable4;
    }

    @Override
    protected void onAfterRediff() {
        super.onAfterRediff();
        this.myExcludeAllCheckboxPanel.refresh();
    }

    @NotNull
    private static BitSet getLocalSelectedLines(@NotNull List<MySimpleDiffChange> changes2) {
        if (changes2 == null) {
            SimpleLocalChangeListDiffViewer.$$$reportNull$$$0(21);
        }
        BitSet selectedLines = new BitSet();
        for (SimpleDiffChange simpleDiffChange : changes2) {
            int endLine;
            int startLine;
            selectedLines.set(startLine, (startLine = simpleDiffChange.getStartLine(Side.RIGHT)) == (endLine = simpleDiffChange.getEndLine(Side.RIGHT)) ? startLine + 1 : endLine);
        }
        BitSet bitSet = selectedLines;
        if (bitSet == null) {
            SimpleLocalChangeListDiffViewer.$$$reportNull$$$0(22);
        }
        return bitSet;
    }

    private /* synthetic */ void lambda$performRediff$1(Runnable callback2) {
        callback2.run();
        this.getStatusPanel().setBusy(true);
    }

    private /* synthetic */ TrackerData lambda$performRediff$0(PartialLocalLineStatusTracker partialTracker) throws RuntimeException {
        boolean isReleased = partialTracker.isReleased();
        boolean isOperational = partialTracker.isOperational();
        List<String> affectedChangelistIds = partialTracker.getAffectedChangeListsIds();
        if (!isOperational) {
            return new TrackerData(isReleased, affectedChangelistIds, null);
        }
        List<LocalRange> ranges = partialTracker.getRanges();
        CharSequence localText = this.getContent2().getDocument().getImmutableCharSequence();
        CharSequence vcsText = this.getContent1().getDocument().getImmutableCharSequence();
        CharSequence trackerVcsText = partialTracker.getVcsDocument().getImmutableCharSequence();
        TrackerDiffData diffData = new TrackerDiffData(ranges, localText, vcsText, trackerVcsText);
        return new TrackerData(isReleased, affectedChangelistIds, diffData);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 18: 
            case 19: 
            case 20: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 18: 
            case 19: 
            case 20: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localRequest";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 18: 
            case 19: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/actions/diff/lst/SimpleLocalChangeListDiffViewer";
                break;
            }
            case 5: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ranges";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localText";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsText";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trackerVcsText";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/actions/diff/lst/SimpleLocalChangeListDiffViewer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createTitles";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditorPopupActions";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "performRediff";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "performRediffUsingPartialTracker";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalSelectedLines";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 18: 
            case 19: 
            case 20: 
            case 22: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "performRediff";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "performRediffUsingPartialTracker";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getLocalSelectedLines";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 18: 
            case 19: 
            case 20: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class TrackerDiffData {
        @Nullable
        public final List<LocalRange> ranges;
        @NotNull
        public final CharSequence localText;
        @NotNull
        public final CharSequence vcsText;
        @NotNull
        public final CharSequence trackerVcsText;

        TrackerDiffData(@Nullable List<LocalRange> ranges, @NotNull CharSequence localText, @NotNull CharSequence vcsText, @NotNull CharSequence trackerVcsText) {
            if (localText == null) {
                TrackerDiffData.$$$reportNull$$$0(0);
            }
            if (vcsText == null) {
                TrackerDiffData.$$$reportNull$$$0(1);
            }
            if (trackerVcsText == null) {
                TrackerDiffData.$$$reportNull$$$0(2);
            }
            this.ranges = ranges;
            this.localText = localText;
            this.vcsText = vcsText;
            this.trackerVcsText = trackerVcsText;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "localText";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "vcsText";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "trackerVcsText";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/vcs/changes/actions/diff/lst/SimpleLocalChangeListDiffViewer$TrackerDiffData";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class TrackerData {
        private final boolean isReleased;
        @NotNull
        public final List<String> affectedChangelist;
        @Nullable
        public final TrackerDiffData diffData;

        TrackerData(boolean isReleased, @NotNull List<String> affectedChangelist, @Nullable TrackerDiffData diffData) {
            if (affectedChangelist == null) {
                TrackerData.$$$reportNull$$$0(0);
            }
            this.isReleased = isReleased;
            this.affectedChangelist = affectedChangelist;
            this.diffData = diffData;
        }

        static /* synthetic */ boolean access$200(TrackerData x0) {
            return x0.isReleased;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "affectedChangelist", "com/intellij/openapi/vcs/changes/actions/diff/lst/SimpleLocalChangeListDiffViewer$TrackerData", "<init>"));
        }
    }

    private class ExcludeAllCheckboxPanel
    extends JPanel {
        private final InplaceButton myCheckbox = new InplaceButton(null, AllIcons.Diff.GutterCheckBox, e -> this.toggleState());

        private ExcludeAllCheckboxPanel() {
            this.myCheckbox.setCursor(Cursor.getPredefinedCursor(12));
            this.myCheckbox.setVisible(false);
            this.add((Component)this.myCheckbox);
            SimpleLocalChangeListDiffViewer.this.getEditor2().getGutterComponentEx().addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    ApplicationManager.getApplication().invokeLater(() -> ExcludeAllCheckboxPanel.this.updateLayout(), ModalityState.any());
                }
            });
        }

        @Override
        public void doLayout() {
            Dimension size = this.myCheckbox.getPreferredSize();
            EditorGutterComponentEx gutter = SimpleLocalChangeListDiffViewer.this.getEditor2().getGutterComponentEx();
            int y = (this.getHeight() - size.height) / 2;
            int x = gutter.getIconAreaOffset() + 2;
            this.myCheckbox.setBounds(Math.min(this.getWidth() - AllIcons.Diff.GutterCheckBox.getIconWidth(), x), Math.max(0, y), size.width, size.height);
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension size = this.myCheckbox.getPreferredSize();
            EditorGutterComponentEx gutter = SimpleLocalChangeListDiffViewer.this.getEditor2().getGutterComponentEx();
            int gutterWidth = gutter.getLineMarkerFreePaintersAreaOffset();
            return new Dimension(Math.max(gutterWidth + JBUI.scale((int)2), size.width), size.height);
        }

        private void updateLayout() {
            this.invalidate();
            SimpleLocalChangeListDiffViewer.this.myPanel.validate();
            SimpleLocalChangeListDiffViewer.this.myPanel.repaint();
        }

        private void toggleState() {
            PartialLocalLineStatusTracker tracker = SimpleLocalChangeListDiffViewer.this.getPartialTracker();
            if (tracker != null && tracker.isValid()) {
                ExclusionState exclusionState = tracker.getExcludedFromCommitState(SimpleLocalChangeListDiffViewer.this.myChangelistId);
                SimpleLocalChangeListDiffViewer.this.getPartialTracker().setExcludedFromCommit(exclusionState == ExclusionState.ALL_INCLUDED);
                this.refresh();
                SimpleLocalChangeListDiffViewer.this.rediff();
            }
        }

        public void refresh() {
            Icon icon = this.getIcon();
            if (icon != null) {
                this.myCheckbox.setIcon(icon);
                this.myCheckbox.setVisible(true);
            } else {
                this.myCheckbox.setVisible(false);
            }
        }

        @Nullable
        private Icon getIcon() {
            if (!SimpleLocalChangeListDiffViewer.this.myAllowExcludeChangesFromCommit) {
                return null;
            }
            PartialLocalLineStatusTracker tracker = SimpleLocalChangeListDiffViewer.this.getPartialTracker();
            if (tracker == null || !tracker.isValid()) {
                return null;
            }
            ExclusionState exclusionState = tracker.getExcludedFromCommitState(SimpleLocalChangeListDiffViewer.this.myChangelistId);
            switch (exclusionState) {
                case ALL_INCLUDED: {
                    return AllIcons.Diff.GutterCheckBoxSelected;
                }
                case ALL_EXCLUDED: {
                    return AllIcons.Diff.GutterCheckBox;
                }
                case PARTIALLY: {
                    return AllIcons.Diff.GutterCheckBoxIndeterminate;
                }
            }
            return null;
        }
    }

    private abstract class MySelectedChangesActionBase
    extends DumbAwareAction {
        private final boolean myActiveChangelistOnly;
        private final boolean myShortcut;

        MySelectedChangesActionBase(boolean activeChangelistOnly, boolean shortcut) {
            this.myActiveChangelistOnly = activeChangelistOnly;
            this.myShortcut = shortcut;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                MySelectedChangesActionBase.$$$reportNull$$$0(0);
            }
            if (this.myActiveChangelistOnly && !SimpleLocalChangeListDiffViewer.this.myAllowExcludeChangesFromCommit) {
                e.getPresentation().setEnabledAndVisible(false);
                return;
            }
            if (this.myShortcut) {
                e.getPresentation().setEnabledAndVisible(true);
                return;
            }
            PartialLocalLineStatusTracker tracker = SimpleLocalChangeListDiffViewer.this.getPartialTracker();
            Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
            Side side = Side.fromValue(SimpleLocalChangeListDiffViewer.this.getEditors(), (Object)editor);
            if (side == null || tracker == null) {
                e.getPresentation().setVisible(true);
                e.getPresentation().setEnabled(false);
                e.getPresentation().setText(this.getText(Collections.emptyList()));
                return;
            }
            List<MySimpleDiffChange> selectedChanges = this.getSelectedChanges(side);
            e.getPresentation().setVisible(true);
            e.getPresentation().setEnabled(!selectedChanges.isEmpty());
            e.getPresentation().setText(this.getText(selectedChanges));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                MySelectedChangesActionBase.$$$reportNull$$$0(1);
            }
            PartialLocalLineStatusTracker tracker = SimpleLocalChangeListDiffViewer.this.getPartialTracker();
            Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
            Side side = Side.fromValue(SimpleLocalChangeListDiffViewer.this.getEditors(), (Object)editor);
            if (editor == null || side == null || tracker == null) {
                return;
            }
            List<MySimpleDiffChange> selectedChanges = this.getSelectedChanges(side);
            if (selectedChanges.isEmpty()) {
                return;
            }
            this.doPerform(e, tracker, selectedChanges);
        }

        @NotNull
        private List<MySimpleDiffChange> getSelectedChanges(@NotNull Side side) {
            if (side == null) {
                MySelectedChangesActionBase.$$$reportNull$$$0(2);
            }
            List changes2 = ContainerUtil.findAll((Collection)SimpleLocalChangeListDiffViewer.this.getSelectedChanges(side), MySimpleDiffChange.class);
            if (this.myActiveChangelistOnly) {
                List list2 = ContainerUtil.filter((Collection)changes2, MySimpleDiffChange::isFromActiveChangelist);
                if (list2 == null) {
                    MySelectedChangesActionBase.$$$reportNull$$$0(3);
                }
                return list2;
            }
            List list3 = changes2;
            if (list3 == null) {
                MySelectedChangesActionBase.$$$reportNull$$$0(4);
            }
            return list3;
        }

        @NotNull
        protected String getText(@NotNull List<MySimpleDiffChange> selectedChanges) {
            if (selectedChanges == null) {
                MySelectedChangesActionBase.$$$reportNull$$$0(5);
            }
            String string = this.getTemplatePresentation().getText();
            if (string == null) {
                MySelectedChangesActionBase.$$$reportNull$$$0(6);
            }
            return string;
        }

        protected abstract void doPerform(@NotNull AnActionEvent var1, @NotNull PartialLocalLineStatusTracker var2, @NotNull List<MySimpleDiffChange> var3);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "side";
                    break;
                }
                case 3: 
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/actions/diff/lst/SimpleLocalChangeListDiffViewer$MySelectedChangesActionBase";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selectedChanges";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/actions/diff/lst/SimpleLocalChangeListDiffViewer$MySelectedChangesActionBase";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSelectedChanges";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getSelectedChanges";
                    break;
                }
                case 3: 
                case 4: 
                case 6: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getText";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class IncludeOnlySelectedChangesIntoCommitAction
    extends MySelectedChangesActionBase {
        IncludeOnlySelectedChangesIntoCommitAction(boolean shortcut) {
            super(true, shortcut);
            ActionUtil.copyFrom((AnAction)this, (String)"Vcs.Diff.IncludeOnlyChangedLinesIntoCommit");
        }

        @Override
        protected void doPerform(@NotNull AnActionEvent e, @NotNull PartialLocalLineStatusTracker tracker, @NotNull List<MySimpleDiffChange> selectedChanges) {
            if (e == null) {
                IncludeOnlySelectedChangesIntoCommitAction.$$$reportNull$$$0(0);
            }
            if (tracker == null) {
                IncludeOnlySelectedChangesIntoCommitAction.$$$reportNull$$$0(1);
            }
            if (selectedChanges == null) {
                IncludeOnlySelectedChangesIntoCommitAction.$$$reportNull$$$0(2);
            }
            BitSet selectedLines = SimpleLocalChangeListDiffViewer.getLocalSelectedLines(selectedChanges);
            tracker.setExcludedFromCommit(true);
            tracker.setExcludedFromCommit(selectedLines, false);
            SimpleLocalChangeListDiffViewer.this.rediff();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "e";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "tracker";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "selectedChanges";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/vcs/changes/actions/diff/lst/SimpleLocalChangeListDiffViewer$IncludeOnlySelectedChangesIntoCommitAction";
            objectArray[2] = "doPerform";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class ExcludeSelectedChangesFromCommitAction
    extends MySelectedChangesActionBase {
        ExcludeSelectedChangesFromCommitAction(boolean shortcut) {
            super(true, shortcut);
            ActionUtil.copyFrom((AnAction)this, (String)"Vcs.Diff.ExcludeChangedLinesFromCommit");
        }

        @Override
        @NotNull
        protected String getText(@NotNull List<MySimpleDiffChange> selectedChanges) {
            if (selectedChanges == null) {
                ExcludeSelectedChangesFromCommitAction.$$$reportNull$$$0(0);
            }
            boolean hasExcluded = ContainerUtil.or(selectedChanges, MySimpleDiffChange::isExcludedFromCommit);
            String string = selectedChanges.isEmpty() || !hasExcluded ? "Exclude Lines from Commit" : "Include Lines into Commit";
            if (string == null) {
                ExcludeSelectedChangesFromCommitAction.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        protected void doPerform(@NotNull AnActionEvent e, @NotNull PartialLocalLineStatusTracker tracker, @NotNull List<MySimpleDiffChange> selectedChanges) {
            if (e == null) {
                ExcludeSelectedChangesFromCommitAction.$$$reportNull$$$0(2);
            }
            if (tracker == null) {
                ExcludeSelectedChangesFromCommitAction.$$$reportNull$$$0(3);
            }
            if (selectedChanges == null) {
                ExcludeSelectedChangesFromCommitAction.$$$reportNull$$$0(4);
            }
            BitSet selectedLines = SimpleLocalChangeListDiffViewer.getLocalSelectedLines(selectedChanges);
            boolean hasExcluded = ContainerUtil.or(selectedChanges, MySimpleDiffChange::isExcludedFromCommit);
            tracker.setExcludedFromCommit(selectedLines, !hasExcluded);
            SimpleLocalChangeListDiffViewer.this.rediff();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selectedChanges";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/actions/diff/lst/SimpleLocalChangeListDiffViewer$ExcludeSelectedChangesFromCommitAction";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tracker";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/actions/diff/lst/SimpleLocalChangeListDiffViewer$ExcludeSelectedChangesFromCommitAction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getText";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "doPerform";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class MoveSelectedChangesToAnotherChangelistAction
    extends MySelectedChangesActionBase {
        MoveSelectedChangesToAnotherChangelistAction(boolean shortcut) {
            super(false, shortcut);
            this.copyShortcutFrom(ActionManager.getInstance().getAction("Vcs.MoveChangedLinesToChangelist"));
        }

        @Override
        @NotNull
        protected String getText(@NotNull List<MySimpleDiffChange> selectedChanges) {
            if (selectedChanges == null) {
                MoveSelectedChangesToAnotherChangelistAction.$$$reportNull$$$0(0);
            }
            if (!selectedChanges.isEmpty() && ContainerUtil.and(selectedChanges, change -> !change.isFromActiveChangelist())) {
                String shortChangeListName = StringUtil.trimMiddle((String)SimpleLocalChangeListDiffViewer.this.myChangelistName, (int)40);
                String string = String.format("Move to '%s' Changelist", StringUtil.escapeMnemonics((String)shortChangeListName));
                if (string == null) {
                    MoveSelectedChangesToAnotherChangelistAction.$$$reportNull$$$0(1);
                }
                return string;
            }
            String string = ActionsBundle.message((String)"action.ChangesView.Move.text", (Object[])new Object[0]);
            if (string == null) {
                MoveSelectedChangesToAnotherChangelistAction.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        protected void doPerform(@NotNull AnActionEvent e, @NotNull PartialLocalLineStatusTracker tracker, @NotNull List<MySimpleDiffChange> selectedChanges) {
            if (e == null) {
                MoveSelectedChangesToAnotherChangelistAction.$$$reportNull$$$0(3);
            }
            if (tracker == null) {
                MoveSelectedChangesToAnotherChangelistAction.$$$reportNull$$$0(4);
            }
            if (selectedChanges == null) {
                MoveSelectedChangesToAnotherChangelistAction.$$$reportNull$$$0(5);
            }
            BitSet selectedLines = SimpleLocalChangeListDiffViewer.getLocalSelectedLines(selectedChanges);
            if (ContainerUtil.and(selectedChanges, change -> !change.isFromActiveChangelist())) {
                LocalChangeList changeList = ChangeListManager.getInstance((Project)SimpleLocalChangeListDiffViewer.this.getProject()).getChangeList(SimpleLocalChangeListDiffViewer.this.myChangelistId);
                if (changeList != null) {
                    tracker.moveToChangelist(selectedLines, changeList);
                }
            } else {
                MoveChangesLineStatusAction.moveToAnotherChangelist(tracker, selectedLines);
            }
            SimpleLocalChangeListDiffViewer.this.rediff();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selectedChanges";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/actions/diff/lst/SimpleLocalChangeListDiffViewer$MoveSelectedChangesToAnotherChangelistAction";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tracker";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/actions/diff/lst/SimpleLocalChangeListDiffViewer$MoveSelectedChangesToAnotherChangelistAction";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getText";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "doPerform";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class MyLineStatusTrackerManagerListener
    extends LineStatusTrackerManager.ListenerAdapter {
        @NotNull
        private final PartialLocalLineStatusTracker.Listener myListener;

        MyLineStatusTrackerManagerListener(PartialLocalLineStatusTracker.Listener trackerListener) {
            if (trackerListener == null) {
                MyLineStatusTrackerManagerListener.$$$reportNull$$$0(0);
            }
            this.myListener = trackerListener;
        }

        @Override
        public void onTrackerAdded(@NotNull LineStatusTracker<?> tracker) {
            if (tracker == null) {
                MyLineStatusTrackerManagerListener.$$$reportNull$$$0(1);
            }
            if (tracker instanceof PartialLocalLineStatusTracker && tracker.getVirtualFile().equals(SimpleLocalChangeListDiffViewer.this.myLocalRequest.getVirtualFile())) {
                ((PartialLocalLineStatusTracker)tracker).addListener(this.myListener, (Disposable)SimpleLocalChangeListDiffViewer.this);
                SimpleLocalChangeListDiffViewer.this.scheduleRediff();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "trackerListener";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tracker";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/changes/actions/diff/lst/SimpleLocalChangeListDiffViewer$MyLineStatusTrackerManagerListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onTrackerAdded";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyTrackerListener
    extends PartialLocalLineStatusTracker.ListenerAdapter {
        private MyTrackerListener() {
        }

        @Override
        public void onBecomingValid(@NotNull PartialLocalLineStatusTracker tracker) {
            if (tracker == null) {
                MyTrackerListener.$$$reportNull$$$0(0);
            }
            SimpleLocalChangeListDiffViewer.this.scheduleRediff();
        }

        @Override
        public void onChangeListMarkerChange(@NotNull PartialLocalLineStatusTracker tracker) {
            if (tracker == null) {
                MyTrackerListener.$$$reportNull$$$0(1);
            }
            SimpleLocalChangeListDiffViewer.this.scheduleRediff();
        }

        @Override
        public void onExcludedFromCommitChange(@NotNull PartialLocalLineStatusTracker tracker) {
            if (tracker == null) {
                MyTrackerListener.$$$reportNull$$$0(2);
            }
            SimpleLocalChangeListDiffViewer.this.scheduleRediff();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "tracker";
            objectArray2[1] = "com/intellij/openapi/vcs/changes/actions/diff/lst/SimpleLocalChangeListDiffViewer$MyTrackerListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onBecomingValid";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onChangeListMarkerChange";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onExcludedFromCommitChange";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MySimpleDiffChange
    extends SimpleDiffChange {
        @NotNull
        private final String myChangelistId;
        private final boolean myIsExcludedFromCommit;

        MySimpleDiffChange(LineFragment fragment, boolean isExcluded, @NotNull boolean isSkipped, String changelistId, boolean isExcludedFromCommit) {
            if (fragment == null) {
                MySimpleDiffChange.$$$reportNull$$$0(0);
            }
            if (changelistId == null) {
                MySimpleDiffChange.$$$reportNull$$$0(1);
            }
            super(SimpleLocalChangeListDiffViewer.this, fragment, isExcluded, isSkipped);
            this.myChangelistId = changelistId;
            this.myIsExcludedFromCommit = isExcludedFromCommit;
        }

        @NotNull
        private SimpleLocalChangeListDiffViewer getViewer() {
            SimpleLocalChangeListDiffViewer simpleLocalChangeListDiffViewer = (SimpleLocalChangeListDiffViewer)this.myViewer;
            if (simpleLocalChangeListDiffViewer == null) {
                MySimpleDiffChange.$$$reportNull$$$0(2);
            }
            return simpleLocalChangeListDiffViewer;
        }

        public boolean isFromActiveChangelist() {
            return this.myChangelistId.equals(this.getViewer().myChangelistId);
        }

        public boolean isExcludedFromCommit() {
            return this.myIsExcludedFromCommit;
        }

        @Override
        protected void doInstallActionHighlighters() {
            super.doInstallActionHighlighters();
            if (SimpleLocalChangeListDiffViewer.this.myAllowExcludeChangesFromCommit && this.isFromActiveChangelist()) {
                this.myOperations.add(new ExcludeGutterOperation());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fragment";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changelistId";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/actions/diff/lst/SimpleLocalChangeListDiffViewer$MySimpleDiffChange";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/actions/diff/lst/SimpleLocalChangeListDiffViewer$MySimpleDiffChange";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getViewer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private class ExcludeGutterOperation
        extends SimpleDiffChange.GutterOperation {
            ExcludeGutterOperation() {
                super(Side.RIGHT);
            }

            @Override
            public GutterIconRenderer createRenderer() {
                if (!MySimpleDiffChange.this.isFromActiveChangelist()) {
                    return null;
                }
                Icon icon = MySimpleDiffChange.this.myIsExcludedFromCommit ? AllIcons.Diff.GutterCheckBox : AllIcons.Diff.GutterCheckBoxSelected;
                return new DiffGutterRenderer(icon, "Include into commit"){

                    @Override
                    protected void handleMouseClick() {
                        if (!MySimpleDiffChange.this.isValid()) {
                            return;
                        }
                        PartialLocalLineStatusTracker tracker = MySimpleDiffChange.this.getViewer().getPartialTracker();
                        if (tracker == null) {
                            return;
                        }
                        LocalRange range2 = (LocalRange)tracker.getRangeForLine(MySimpleDiffChange.this.getStartLine(Side.RIGHT));
                        if (range2 == null) {
                            return;
                        }
                        tracker.setExcludedFromCommit(range2, !MySimpleDiffChange.this.myIsExcludedFromCommit);
                        MySimpleDiffChange.this.getViewer().rediff();
                    }
                };
            }
        }
    }
}

