/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.FileHolder;
import com.intellij.openapi.vcs.changes.VcsModifiableDirtyScope;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class VirtualFileHolder
implements FileHolder {
    private final Set<VirtualFile> myFiles = new HashSet<VirtualFile>();
    private final Project myProject;
    private final FileHolder.HolderType myType;

    public VirtualFileHolder(Project project, FileHolder.HolderType type) {
        this.myProject = project;
        this.myType = type;
    }

    @Override
    public FileHolder.HolderType getType() {
        return this.myType;
    }

    public void notifyVcsStarted(AbstractVcs vcs) {
    }

    @Override
    public void cleanAll() {
        this.myFiles.clear();
    }

    static void cleanScope(Project project, Collection<VirtualFile> files2, VcsModifiableDirtyScope scope) {
        ReadAction.run(() -> {
            block7: {
                block6: {
                    if (project.isDisposed() || files2.isEmpty()) {
                        return;
                    }
                    if (scope.getRecursivelyDirtyDirectories().size() != 0) break block6;
                    Set dirtyFiles = scope.getDirtyFiles();
                    boolean cleanDroppedFiles = false;
                    for (FilePath dirtyFile : dirtyFiles) {
                        VirtualFile f = dirtyFile.getVirtualFile();
                        if (f != null) {
                            files2.remove(f);
                            continue;
                        }
                        cleanDroppedFiles = true;
                    }
                    if (!cleanDroppedFiles) break block7;
                    Iterator iterator = files2.iterator();
                    while (iterator.hasNext()) {
                        VirtualFile file2 = (VirtualFile)iterator.next();
                        if (!VirtualFileHolder.fileDropped(file2)) continue;
                        iterator.remove();
                        scope.addDirtyFile(VcsUtil.getFilePath((VirtualFile)file2));
                    }
                    break block7;
                }
                Iterator iterator = files2.iterator();
                while (iterator.hasNext()) {
                    VirtualFile file3 = (VirtualFile)iterator.next();
                    boolean fileDropped = VirtualFileHolder.fileDropped(file3);
                    if (fileDropped) {
                        scope.addDirtyFile(VcsUtil.getFilePath((VirtualFile)file3));
                    }
                    if (!fileDropped && !scope.belongsTo(VcsUtil.getFilePath((VirtualFile)file3))) continue;
                    iterator.remove();
                }
            }
        });
    }

    @Override
    public void cleanAndAdjustScope(@NotNull VcsModifiableDirtyScope scope) {
        if (scope == null) {
            VirtualFileHolder.$$$reportNull$$$0(0);
        }
        VirtualFileHolder.cleanScope(this.myProject, this.myFiles, scope);
    }

    private static boolean fileDropped(VirtualFile file2) {
        return !file2.isValid();
    }

    public void addFile(VirtualFile file2) {
        this.myFiles.add(file2);
    }

    public void removeFile(VirtualFile file2) {
        this.myFiles.remove(file2);
    }

    @NotNull
    public List<VirtualFile> getFiles() {
        ArrayList<VirtualFile> arrayList = new ArrayList<VirtualFile>(this.myFiles);
        if (arrayList == null) {
            VirtualFileHolder.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @Override
    public VirtualFileHolder copy() {
        VirtualFileHolder copyHolder = new VirtualFileHolder(this.myProject, this.myType);
        copyHolder.myFiles.addAll(this.myFiles);
        return copyHolder;
    }

    public boolean containsFile(VirtualFile file2) {
        return this.myFiles.contains(file2);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VirtualFileHolder that = (VirtualFileHolder)o;
        return this.myFiles.equals(that.myFiles);
    }

    public int hashCode() {
        return this.myFiles.hashCode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/VirtualFileHolder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/VirtualFileHolder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "cleanAndAdjustScope";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

