/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsListener;
import com.intellij.openapi.vcs.changes.VcsIgnoreFilesCheckerKt;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.project.ProjectKt;
import com.intellij.vcsUtil.VcsImplUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\b\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/openapi/vcs/changes/VcsIgnoreFilesChecker;", "Lcom/intellij/openapi/components/ProjectComponent;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "generateVcsIgnoreFileIfNeeded", "Ljava/util/concurrent/Future;", "projectOpened", "", "intellij.platform.vcs.impl"})
public final class VcsIgnoreFilesChecker
implements ProjectComponent {
    private final Project project;

    public void projectOpened() {
        if (ProjectKt.isDirectoryBased(this.project)) {
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
            if (!application.isUnitTestMode()) {
                this.project.getMessageBus().connect().subscribe(ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED, (Object)new VcsListener(this){
                    final /* synthetic */ VcsIgnoreFilesChecker this$0;

                    public final void directoryMappingChanged() {
                        VcsIgnoreFilesChecker.access$generateVcsIgnoreFileIfNeeded(this.this$0, VcsIgnoreFilesChecker.access$getProject$p(this.this$0));
                    }
                    {
                        this.this$0 = vcsIgnoreFilesChecker;
                    }
                });
            }
        }
    }

    private final Future<?> generateVcsIgnoreFileIfNeeded(Project project) {
        Future future2 = ApplicationManager.getApplication().executeOnPooledThread(new Runnable(project){
            final /* synthetic */ Project $project;

            public final void run() {
                if (this.$project.isDisposed()) {
                    return;
                }
                String string = ProjectKt.getStateStore(this.$project).getProjectConfigDir();
                if (string == null) {
                    return;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"project.stateStore.proje\u2026urn@executeOnPooledThread");
                String projectConfigDirPath = string;
                VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(projectConfigDirPath);
                if (virtualFile == null) {
                    return;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"LocalFileSystem.getInsta\u2026urn@executeOnPooledThread");
                VirtualFile projectConfigDirVFile = virtualFile;
                AbstractVcs abstractVcs = VcsUtil.getVcsFor((Project)this.$project, (VirtualFile)projectConfigDirVFile);
                if (abstractVcs == null) {
                    return;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)abstractVcs, (String)"VcsUtil.getVcsFor(projec\u2026urn@executeOnPooledThread");
                AbstractVcs vcs = abstractVcs;
                VcsIgnoreFilesCheckerKt.access$getLOG$p().debug("Generate VCS ignore file for " + vcs.getName());
                VcsImplUtil.generateIgnoreFileIfNeeded(this.$project, vcs, projectConfigDirVFile);
            }
            {
                this.$project = project;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)future2, (String)"ApplicationManager.getAp\u2026jectConfigDirVFile)\n    }");
        return future2;
    }

    public VcsIgnoreFilesChecker(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.project = project;
    }

    public static final /* synthetic */ Future access$generateVcsIgnoreFileIfNeeded(VcsIgnoreFilesChecker $this, Project project) {
        return $this.generateVcsIgnoreFileIfNeeded(project);
    }

    public static final /* synthetic */ Project access$getProject$p(VcsIgnoreFilesChecker $this) {
        return $this.project;
    }
}

