/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.UpdateInBackground;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.actions.AbstractVcsAction;
import com.intellij.openapi.vcs.actions.VcsContext;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.history.VcsHistoryProvider;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.vcs.log.VcsLogFileHistoryProvider;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TabbedShowHistoryAction
extends AbstractVcsAction
implements UpdateInBackground {
    @Override
    protected void update(@NotNull VcsContext context, @NotNull Presentation presentation) {
        if (context == null) {
            TabbedShowHistoryAction.$$$reportNull$$$0(0);
        }
        if (presentation == null) {
            TabbedShowHistoryAction.$$$reportNull$$$0(1);
        }
        Project project = context.getProject();
        presentation.setEnabled(this.isEnabled(context));
        presentation.setVisible(project != null && ProjectLevelVcsManager.getInstance((Project)project).hasActiveVcss());
    }

    protected boolean isEnabled(@NotNull VcsContext context) {
        if (context == null) {
            TabbedShowHistoryAction.$$$reportNull$$$0(2);
        }
        boolean result2 = false;
        Project project = context.getProject();
        if (project != null) {
            Pair<FilePath, VirtualFile> pair = TabbedShowHistoryAction.getPathAndParentFile(context);
            if (pair.first != null && pair.second != null) {
                result2 = TabbedShowHistoryAction.isEnabled(project, (FilePath)pair.first, (VirtualFile)pair.second);
            }
        }
        return result2;
    }

    private static boolean isEnabled(@NotNull Project project, @NotNull FilePath path, @NotNull VirtualFile fileOrParent) {
        boolean fileInVcs;
        if (project == null) {
            TabbedShowHistoryAction.$$$reportNull$$$0(3);
        }
        if (path == null) {
            TabbedShowHistoryAction.$$$reportNull$$$0(4);
        }
        if (fileOrParent == null) {
            TabbedShowHistoryAction.$$$reportNull$$$0(5);
        }
        if (!(fileInVcs = AbstractVcs.fileInVcsByFileStatus((Project)project, (VirtualFile)fileOrParent))) {
            return false;
        }
        AbstractVcs vcs = ChangesUtil.getVcsForFile((VirtualFile)fileOrParent, (Project)project);
        if (vcs == null) {
            return false;
        }
        return TabbedShowHistoryAction.canShowNewFileHistory(project, path) || TabbedShowHistoryAction.canShowOldFileHistory(vcs, path, fileOrParent);
    }

    private static boolean canShowOldFileHistory(@NotNull AbstractVcs vcs, @NotNull FilePath path, @NotNull VirtualFile fileOrParent) {
        VcsHistoryProvider provider;
        if (vcs == null) {
            TabbedShowHistoryAction.$$$reportNull$$$0(6);
        }
        if (path == null) {
            TabbedShowHistoryAction.$$$reportNull$$$0(7);
        }
        if (fileOrParent == null) {
            TabbedShowHistoryAction.$$$reportNull$$$0(8);
        }
        return (provider = vcs.getVcsHistoryProvider()) != null && (provider.supportsHistoryForDirectories() || !path.isDirectory()) && provider.canShowHistoryFor(fileOrParent);
    }

    private static boolean canShowNewFileHistory(@NotNull Project project, @NotNull FilePath path) {
        VcsLogFileHistoryProvider historyProvider;
        if (project == null) {
            TabbedShowHistoryAction.$$$reportNull$$$0(9);
        }
        if (path == null) {
            TabbedShowHistoryAction.$$$reportNull$$$0(10);
        }
        return (historyProvider = (VcsLogFileHistoryProvider)ServiceManager.getService(VcsLogFileHistoryProvider.class)) != null && historyProvider.canShowFileHistory(project, path);
    }

    @NotNull
    private static Pair<FilePath, VirtualFile> getPathAndParentFile(@NotNull VcsContext context) {
        List selectedFiles;
        if (context == null) {
            TabbedShowHistoryAction.$$$reportNull$$$0(11);
        }
        if ((selectedFiles = context.getSelectedFilesStream().limit(2L).collect(Collectors.toList())).size() > 0) {
            if (selectedFiles.size() != 1) {
                Pair pair = Pair.empty();
                if (pair == null) {
                    TabbedShowHistoryAction.$$$reportNull$$$0(12);
                }
                return pair;
            }
            VirtualFile file2 = (VirtualFile)selectedFiles.get(0);
            Pair pair = Pair.create((Object)VcsUtil.getFilePath((VirtualFile)file2), (Object)file2);
            if (pair == null) {
                TabbedShowHistoryAction.$$$reportNull$$$0(13);
            }
            return pair;
        }
        File[] ioFiles = context.getSelectedIOFiles();
        if (ioFiles != null && ioFiles.length > 0) {
            for (File ioFile : ioFiles) {
                VirtualFile parent = TabbedShowHistoryAction.getParentVirtualFile(ioFile);
                if (parent == null) continue;
                Pair pair = Pair.create((Object)VcsUtil.getFilePath((VirtualFile)parent, (String)ioFile.getName()), (Object)parent);
                if (pair == null) {
                    TabbedShowHistoryAction.$$$reportNull$$$0(14);
                }
                return pair;
            }
        }
        Pair pair = Pair.empty();
        if (pair == null) {
            TabbedShowHistoryAction.$$$reportNull$$$0(15);
        }
        return pair;
    }

    @Nullable
    private static VirtualFile getParentVirtualFile(@NotNull File ioFile) {
        File parentIoFile;
        if (ioFile == null) {
            TabbedShowHistoryAction.$$$reportNull$$$0(16);
        }
        return (parentIoFile = ioFile.getParentFile()) != null ? LocalFileSystem.getInstance().findFileByIoFile(parentIoFile) : null;
    }

    @Override
    protected void actionPerformed(@NotNull VcsContext context) {
        if (context == null) {
            TabbedShowHistoryAction.$$$reportNull$$$0(17);
        }
        Project project = (Project)ObjectUtils.assertNotNull((Object)context.getProject());
        Pair<FilePath, VirtualFile> pair = TabbedShowHistoryAction.getPathAndParentFile(context);
        FilePath path = (FilePath)ObjectUtils.assertNotNull((Object)pair.first);
        VirtualFile fileOrParent = (VirtualFile)ObjectUtils.assertNotNull((Object)pair.second);
        AbstractVcs vcs = (AbstractVcs)ObjectUtils.assertNotNull((Object)ChangesUtil.getVcsForFile((VirtualFile)fileOrParent, (Project)project));
        if (TabbedShowHistoryAction.canShowNewFileHistory(project, path)) {
            TabbedShowHistoryAction.showNewFileHistory(project, path);
        } else {
            TabbedShowHistoryAction.showOldFileHistory(project, vcs, path);
        }
    }

    private static void showNewFileHistory(@NotNull Project project, @NotNull FilePath path) {
        if (project == null) {
            TabbedShowHistoryAction.$$$reportNull$$$0(18);
        }
        if (path == null) {
            TabbedShowHistoryAction.$$$reportNull$$$0(19);
        }
        VcsLogFileHistoryProvider historyProvider = (VcsLogFileHistoryProvider)ServiceManager.getService(VcsLogFileHistoryProvider.class);
        historyProvider.showFileHistory(project, path, null);
    }

    private static void showOldFileHistory(@NotNull Project project, @NotNull AbstractVcs vcs, @NotNull FilePath path) {
        if (project == null) {
            TabbedShowHistoryAction.$$$reportNull$$$0(20);
        }
        if (vcs == null) {
            TabbedShowHistoryAction.$$$reportNull$$$0(21);
        }
        if (path == null) {
            TabbedShowHistoryAction.$$$reportNull$$$0(22);
        }
        VcsHistoryProvider provider = (VcsHistoryProvider)ObjectUtils.assertNotNull((Object)vcs.getVcsHistoryProvider());
        AbstractVcsHelper.getInstance((Project)project).showFileHistory(provider, vcs.getAnnotationProvider(), path, vcs);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 3: 
            case 9: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileOrParent";
                break;
            }
            case 6: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/actions/TabbedShowHistoryAction";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ioFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/actions/TabbedShowHistoryAction";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathAndParentFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isEnabled";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "canShowOldFileHistory";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "canShowNewFileHistory";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getPathAndParentFile";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getParentVirtualFile";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "showNewFileHistory";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "showOldFileHistory";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

