/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.io;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathUtilRt;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u0003\u001a\u000e\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0003\u001a\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000b\u001a\u00020\u0003\u001a\n\u0010\u000f\u001a\u00020\u0010*\u00020\u0011\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0015\u0010\u0002\u001a\u00020\u0003*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\"\u0015\u0010\u0007\u001a\u00020\u0003*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\u0012"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "parentSystemIndependentPath", "", "Ljava/io/File;", "getParentSystemIndependentPath", "(Ljava/io/File;)Ljava/lang/String;", "systemIndependentPath", "getSystemIndependentPath", "endsWithName", "", "path", "name", "endsWithSlash", "getParentPath", "setOwnerPermissions", "", "Ljava/nio/file/Path;", "intellij.platform.ide.impl"})
public final class FileUtilKt {
    private static final Logger LOG;

    @NotNull
    public static final String getSystemIndependentPath(@NotNull File $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        String string = $receiver.getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"path");
        return StringsKt.replace$default((String)string, (char)File.separatorChar, (char)'/', (boolean)false, (int)4, null);
    }

    @NotNull
    public static final String getParentSystemIndependentPath(@NotNull File $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        String string = $receiver.getParent();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"parent");
        return StringsKt.replace$default((String)string, (char)File.separatorChar, (char)'/', (boolean)false, (int)4, null);
    }

    @Nullable
    public static final String getParentPath(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        return StringUtil.nullize((String)PathUtilRt.getParentPath((String)path));
    }

    public static final boolean endsWithSlash(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Character c = StringsKt.getOrNull((CharSequence)path, (int)(path.length() - 1));
        return c != null && c.charValue() == '/';
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean endsWithName(@NotNull String path, @NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        if (!StringsKt.endsWith$default((String)path, (String)name, (boolean)false, (int)2, null)) return false;
        if (path.length() == name.length()) return true;
        Character c = StringsKt.getOrNull((CharSequence)path, (int)(path.length() - name.length() - 1));
        if (c == null) return false;
        if (c.charValue() != '/') return false;
        return true;
    }

    public static final void setOwnerPermissions(@NotNull Path $receiver) {
        block2: {
            PosixFileAttributeView posixFileAttributeView;
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
            PosixFileAttributeView posixFileAttributeView2 = Files.getFileAttributeView($receiver, PosixFileAttributeView.class, new LinkOption[0]);
            if (posixFileAttributeView2 == null) break block2;
            PosixFileAttributeView it = posixFileAttributeView = posixFileAttributeView2;
            boolean bl = false;
            try {
                it.setPermissions(SetsKt.setOf((Object[])new PosixFilePermission[]{PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE}));
            }
            catch (IOException e) {
                LOG.warn((Throwable)e);
            }
        }
    }

    static {
        Logger logger = Logger.getInstance((String)"#com.intellij.openapi.util.io.FileUtil");
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(\"#com\u2026penapi.util.io.FileUtil\")");
        LOG = logger;
    }
}

