/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.WindowStateService;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.FrameState;
import com.intellij.ui.ScreenUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class WindowStateServiceImpl
extends WindowStateService
implements PersistentStateComponent<Element> {
    @NonNls
    private static final String KEY = "key";
    @NonNls
    private static final String STATE = "state";
    @NonNls
    private static final String X = "x";
    @NonNls
    private static final String Y = "y";
    @NonNls
    private static final String WIDTH = "width";
    @NonNls
    private static final String HEIGHT = "height";
    @NonNls
    private static final String MAXIMIZED = "maximized";
    @NonNls
    private static final String FULL_SCREEN = "full-screen";
    private static final Logger LOG = Logger.getInstance(WindowStateService.class);
    private final Map<String, WindowState> myStateMap = new TreeMap<String, WindowState>();

    WindowStateServiceImpl() {
    }

    abstract Point getDefaultLocationFor(@NotNull String var1);

    abstract Dimension getDefaultSizeFor(@NotNull String var1);

    abstract Rectangle getDefaultBoundsFor(@NotNull String var1);

    abstract boolean getDefaultMaximizedFor(Object var1, @NotNull String var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Element getState() {
        Element element = new Element(STATE);
        Map<String, WindowState> map2 = this.myStateMap;
        synchronized (map2) {
            for (Map.Entry<String, WindowState> entry : this.myStateMap.entrySet()) {
                String key = entry.getKey();
                if (key == null) continue;
                WindowState state = entry.getValue();
                Element child2 = new Element(STATE);
                if (state.myLocation != null) {
                    child2.setAttribute(X, Integer.toString(((WindowState)state).myLocation.x));
                    child2.setAttribute(Y, Integer.toString(((WindowState)state).myLocation.y));
                }
                if (state.mySize != null) {
                    child2.setAttribute(WIDTH, Integer.toString(((WindowState)state).mySize.width));
                    child2.setAttribute(HEIGHT, Integer.toString(((WindowState)state).mySize.height));
                }
                if (state.myMaximized) {
                    child2.setAttribute(MAXIMIZED, Boolean.toString(true));
                }
                if (state.myFullScreen) {
                    child2.setAttribute(FULL_SCREEN, Boolean.toString(true));
                }
                child2.setAttribute(KEY, key);
                element.addContent(child2);
            }
        }
        return element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void loadState(@NotNull Element element) {
        if (element == null) {
            WindowStateServiceImpl.$$$reportNull$$$0(0);
        }
        Map<String, WindowState> map2 = this.myStateMap;
        synchronized (map2) {
            this.myStateMap.clear();
            for (Element child2 : element.getChildren()) {
                String key;
                if (!STATE.equals(child2.getName()) || (key = child2.getAttributeValue(KEY)) == null) continue;
                Point location = null;
                try {
                    location = new Point(Integer.parseInt(child2.getAttributeValue(X)), Integer.parseInt(child2.getAttributeValue(Y)));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                Dimension size = null;
                try {
                    size = new Dimension(Integer.parseInt(child2.getAttributeValue(WIDTH)), Integer.parseInt(child2.getAttributeValue(HEIGHT)));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (location == null && size == null) continue;
                WindowState state = new WindowState();
                state.myLocation = location;
                state.mySize = size;
                state.myMaximized = Boolean.parseBoolean(child2.getAttributeValue(MAXIMIZED));
                state.myFullScreen = Boolean.parseBoolean(child2.getAttributeValue(FULL_SCREEN));
                this.myStateMap.put(key, state);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadStateFor(Object object, @NotNull String key, @NotNull Component component) {
        Frame frame;
        if (key == null) {
            WindowStateServiceImpl.$$$reportNull$$$0(1);
        }
        if (component == null) {
            WindowStateServiceImpl.$$$reportNull$$$0(2);
        }
        Point location = null;
        Dimension size = null;
        boolean maximized = false;
        Map<String, WindowState> map2 = this.myStateMap;
        synchronized (map2) {
            WindowState state = this.getFor(object, key, WindowState.class);
            if (state != null) {
                location = state.myLocation;
                size = state.mySize;
                maximized = state.myMaximized;
            }
        }
        if (location == null && size == null) {
            location = this.getDefaultLocationFor(key);
            if (!WindowStateServiceImpl.isVisible(location, size = this.getDefaultSizeFor(key))) {
                return false;
            }
            maximized = this.getDefaultMaximizedFor(object, key);
        }
        Frame frame2 = frame = component instanceof Frame ? (Frame)component : null;
        if (frame != null && 0 != frame.getExtendedState()) {
            frame.setExtendedState(0);
        }
        Rectangle bounds2 = component.getBounds();
        if (location != null) {
            bounds2.setLocation(location);
        }
        if (size != null) {
            bounds2.setSize(size);
        }
        if (bounds2.isEmpty()) {
            bounds2.setSize(component.getPreferredSize());
        }
        component.setBounds(bounds2);
        if (maximized && frame != null) {
            frame.setExtendedState(6);
        }
        return true;
    }

    public void saveStateFor(Object object, @NotNull String key, @NotNull Component component) {
        if (key == null) {
            WindowStateServiceImpl.$$$reportNull$$$0(3);
        }
        if (component == null) {
            WindowStateServiceImpl.$$$reportNull$$$0(4);
        }
        FrameState state = FrameState.getFrameState(component);
        this.putFor(object, key, state.getLocation(), true, state.getSize(), true, state.isMaximized(), true, state.isFullScreen(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Point getLocationFor(Object object, @NotNull String key) {
        Point location;
        if (key == null) {
            WindowStateServiceImpl.$$$reportNull$$$0(5);
        }
        Map<String, WindowState> map2 = this.myStateMap;
        synchronized (map2) {
            location = this.getFor(object, key, Point.class);
        }
        return location != null ? location : this.getDefaultLocationFor(key);
    }

    public void putLocationFor(Object object, @NotNull String key, Point location) {
        if (key == null) {
            WindowStateServiceImpl.$$$reportNull$$$0(6);
        }
        this.putFor(object, key, location, true, null, false, false, false, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension getSizeFor(Object object, @NotNull String key) {
        Dimension size;
        if (key == null) {
            WindowStateServiceImpl.$$$reportNull$$$0(7);
        }
        Map<String, WindowState> map2 = this.myStateMap;
        synchronized (map2) {
            size = this.getFor(object, key, Dimension.class);
        }
        return size != null ? size : this.getDefaultSizeFor(key);
    }

    public void putSizeFor(Object object, @NotNull String key, Dimension size) {
        if (key == null) {
            WindowStateServiceImpl.$$$reportNull$$$0(8);
        }
        this.putFor(object, key, null, false, size, true, false, false, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Rectangle getBoundsFor(Object object, @NotNull String key) {
        Rectangle bounds2;
        if (key == null) {
            WindowStateServiceImpl.$$$reportNull$$$0(9);
        }
        Map<String, WindowState> map2 = this.myStateMap;
        synchronized (map2) {
            bounds2 = this.getFor(object, key, Rectangle.class);
        }
        return bounds2 != null ? bounds2 : this.getDefaultBoundsFor(key);
    }

    public void putBoundsFor(Object object, @NotNull String key, Rectangle bounds2) {
        if (key == null) {
            WindowStateServiceImpl.$$$reportNull$$$0(10);
        }
        Point location = bounds2 == null ? null : bounds2.getLocation();
        Dimension size = bounds2 == null ? null : bounds2.getSize();
        this.putFor(object, key, location, true, size, true, false, false, false, false);
    }

    private <T> T getFor(Object object, @NotNull String key, @NotNull Class<T> type) {
        GraphicsDevice screen;
        float scale;
        Function<String, Object> getState2;
        Object state;
        if (key == null) {
            WindowStateServiceImpl.$$$reportNull$$$0(11);
        }
        if (type == null) {
            WindowStateServiceImpl.$$$reportNull$$$0(12);
        }
        if ((state = (getState2 = arg_0 -> this.lambda$getFor$0(scale = WindowStateServiceImpl.getSysScale(screen = WindowStateServiceImpl.getScreen(object)), type, arg_0)).apply(WindowStateServiceImpl.getKey(screen, key))) == null) {
            state = getState2.apply(WindowStateServiceImpl.getOldKey(screen, key));
        }
        if (state != null) {
            return (T)state;
        }
        if (object != null) {
            return this.getFor(null, key, type);
        }
        return (T)getState2.apply(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putFor(Object object, @NotNull String key, Point location, boolean locationSet, Dimension size, boolean sizeSet, boolean maximized, boolean maximizedSet, boolean fullScreen, boolean fullScreenSet) {
        if (key == null) {
            WindowStateServiceImpl.$$$reportNull$$$0(13);
        }
        Map<String, WindowState> map2 = this.myStateMap;
        synchronized (map2) {
            GraphicsDevice screen = WindowStateServiceImpl.getScreen(object);
            float scale = WindowStateServiceImpl.getSysScale(screen);
            BiFunction<String, String, Void> putState = (newKey, oldKey) -> {
                WindowState state;
                WindowState oldState;
                WindowState windowState = oldState = oldKey != null ? this.myStateMap.remove(oldKey) : null;
                if (oldState != null) {
                    oldState.scaleDown(scale);
                    WindowState newState = this.myStateMap.get(newKey);
                    if (newState != null) {
                        newState.merge(oldState);
                    } else {
                        this.myStateMap.put((String)newKey, oldState);
                    }
                }
                if ((state = this.myStateMap.get(newKey)) != null) {
                    if (state.set(location, locationSet, size, sizeSet, maximized, maximizedSet, fullScreen, fullScreenSet)) {
                        state.scaleUp(scale);
                    } else {
                        this.myStateMap.remove(newKey);
                    }
                } else {
                    state = new WindowState();
                    if (state.set(location, locationSet, size, sizeSet, maximized, maximizedSet, fullScreen, fullScreenSet)) {
                        state.scaleUp(scale);
                        this.myStateMap.put((String)newKey, state);
                    }
                }
                return null;
            };
            putState.apply(WindowStateServiceImpl.getKey(screen, key), WindowStateServiceImpl.getOldKey(screen, key));
            if (screen != null) {
                putState.apply(WindowStateServiceImpl.getKey(null, key), WindowStateServiceImpl.getOldKey(null, key));
            }
            putState.apply(key, null);
        }
    }

    private static float getSysScale(GraphicsDevice screen) {
        return UIUtil.isJreHiDPIEnabled() && screen != null ? JBUI.sysScale((GraphicsConfiguration)screen.getDefaultConfiguration()) : 1.0f;
    }

    @NotNull
    private static String getOldKey(@Nullable GraphicsDevice screen, String key) {
        GraphicsEnvironment environment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        if (environment.isHeadlessInstance()) {
            String string = key + ".headless";
            if (string == null) {
                WindowStateServiceImpl.$$$reportNull$$$0(14);
            }
            return string;
        }
        StringBuilder sb = new StringBuilder(key);
        for (GraphicsDevice device : environment.getScreenDevices()) {
            Rectangle bounds2 = device.getDefaultConfiguration().getBounds();
            WindowStateServiceImpl.normalizeSize(device, bounds2);
            sb.append('/').append(bounds2.x);
            sb.append('.').append(bounds2.y);
            sb.append('.').append(bounds2.width);
            sb.append('.').append(bounds2.height);
        }
        if (screen != null) {
            Rectangle bounds3 = screen.getDefaultConfiguration().getBounds();
            WindowStateServiceImpl.normalizeSize(screen, bounds3);
            sb.append('@').append(bounds3.x);
            sb.append('.').append(bounds3.y);
            sb.append('.').append(bounds3.width);
            sb.append('.').append(bounds3.height);
        }
        String string = sb.toString();
        if (string == null) {
            WindowStateServiceImpl.$$$reportNull$$$0(15);
        }
        return string;
    }

    @NotNull
    private static String getKey(@Nullable GraphicsDevice screen, String key) {
        GraphicsEnvironment environment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        if (environment.isHeadlessInstance()) {
            String string = key + ".headless";
            if (string == null) {
                WindowStateServiceImpl.$$$reportNull$$$0(16);
            }
            return string;
        }
        StringBuilder sb = new StringBuilder(key);
        if (screen == null) {
            for (GraphicsDevice device : environment.getScreenDevices()) {
                Rectangle bounds2 = device.getDefaultConfiguration().getBounds();
                WindowStateServiceImpl.normalizeSize(device, bounds2);
                sb.append('/').append(bounds2.width);
                sb.append('.').append(bounds2.height);
            }
        } else {
            Rectangle bounds3 = screen.getDefaultConfiguration().getBounds();
            WindowStateServiceImpl.normalizeSize(screen, bounds3);
            sb.append('@').append(bounds3.width);
            sb.append('.').append(bounds3.height);
            if (JBUI.isPixHiDPI((GraphicsConfiguration)screen.getDefaultConfiguration())) {
                int dpi = (int)(96.0f * JBUI.pixScale((GraphicsConfiguration)screen.getDefaultConfiguration()));
                sb.append("@").append(dpi).append("dpi");
            }
        }
        String string = sb.toString();
        if (string == null) {
            WindowStateServiceImpl.$$$reportNull$$$0(17);
        }
        return string;
    }

    private static void normalizeSize(GraphicsDevice screen, Rectangle bounds2) {
        if (UIUtil.isJreHiDPIEnabled()) {
            float scale = JBUI.sysScale((GraphicsConfiguration)screen.getDefaultConfiguration());
            bounds2.setSize((int)Math.ceil((float)bounds2.width * scale), (int)Math.ceil((float)bounds2.height * scale));
        }
    }

    private static GraphicsDevice getScreen(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Project) {
            Project project = (Project)object;
            object = WindowManager.getInstance().getFrame(project);
            if (object == null) {
                LOG.warn("cannot find a project frame for " + project);
                return null;
            }
        }
        if (object instanceof Window) {
            GraphicsDevice device;
            Window window = (Window)object;
            GraphicsConfiguration gc = window.getGraphicsConfiguration();
            GraphicsDevice graphicsDevice = device = gc != null ? window.getGraphicsConfiguration().getDevice() : ScreenUtil.getScreenDevice((Rectangle)window.getBounds());
            if (device != null) {
                return device;
            }
        }
        LOG.warn("cannot find a screen for " + object);
        return null;
    }

    private static boolean isVisible(WindowState state) {
        return state != null && WindowStateServiceImpl.isVisible(state.myLocation, state.mySize);
    }

    private static boolean isVisible(Point location, Dimension size) {
        if (location == null) {
            return size != null;
        }
        if (ScreenUtil.isVisible((Point)location)) {
            return true;
        }
        if (size == null) {
            return false;
        }
        return ScreenUtil.isVisible((Rectangle)new Rectangle(location, size));
    }

    private /* synthetic */ Object lambda$getFor$0(float scale, Class type, String _key) {
        WindowState state = this.myStateMap.get(_key);
        if (state == null) {
            return null;
        }
        if (WindowStateServiceImpl.isVisible(state = state.copy().scaleDown(scale))) {
            if (type == WindowState.class) {
                return state;
            }
            if (type == Point.class) {
                return state.getLocation();
            }
            if (type == Dimension.class) {
                return state.getSize();
            }
            if (type == Rectangle.class) {
                return state.getBounds();
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = KEY;
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/WindowStateServiceImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/WindowStateServiceImpl";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getOldKey";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "loadStateFor";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "saveStateFor";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getLocationFor";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "putLocationFor";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getSizeFor";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "putSizeFor";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getBoundsFor";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "putBoundsFor";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getFor";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "putFor";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class WindowState {
        private Point myLocation;
        private Dimension mySize;
        private boolean myMaximized;
        private boolean myFullScreen;

        private WindowState() {
        }

        private Point getLocation() {
            return this.myLocation == null ? null : new Point(this.myLocation);
        }

        private Dimension getSize() {
            return this.mySize == null ? null : new Dimension(this.mySize);
        }

        private Rectangle getBounds() {
            return this.myLocation == null || this.mySize == null ? null : new Rectangle(this.myLocation, this.mySize);
        }

        private WindowState scaleDown(float scale) {
            if (scale == 1.0f) {
                return this;
            }
            if (this.myLocation != null) {
                this.myLocation.setLocation((float)this.myLocation.x / scale, (float)this.myLocation.y / scale);
            }
            if (this.mySize != null) {
                this.mySize.setSize((float)this.mySize.width / scale, (float)this.mySize.height / scale);
            }
            return this;
        }

        public WindowState scaleUp(float scale) {
            if (scale == 1.0f) {
                return this;
            }
            if (this.myLocation != null) {
                this.myLocation.setLocation((float)this.myLocation.x * scale, (float)this.myLocation.y * scale);
            }
            if (this.mySize != null) {
                this.mySize.setSize((float)this.mySize.width * scale, (float)this.mySize.height * scale);
            }
            return this;
        }

        private WindowState copy() {
            WindowState ws = new WindowState();
            ws.myLocation = this.myLocation == null ? null : this.myLocation.getLocation();
            ws.mySize = this.mySize == null ? null : this.mySize.getSize();
            ws.myMaximized = this.myMaximized;
            ws.myFullScreen = this.myFullScreen;
            return ws;
        }

        private boolean set(Point location, boolean locationSet, Dimension size, boolean sizeSet, boolean maximized, boolean maximizedSet, boolean fullScreen, boolean fullScreenSet) {
            if (locationSet) {
                Point point = this.myLocation = location == null ? null : new Point(location);
            }
            if (sizeSet) {
                Dimension dimension = this.mySize = size == null ? null : new Dimension(size);
            }
            if (maximizedSet) {
                this.myMaximized = maximized;
            }
            if (fullScreenSet) {
                this.myFullScreen = fullScreen;
            }
            return this.myLocation != null || this.mySize != null;
        }

        private void merge(@NotNull WindowState state) {
            if (state == null) {
                WindowState.$$$reportNull$$$0(0);
            }
            if (this.myLocation == null && state.myLocation != null) {
                this.myLocation = state.myLocation.getLocation();
            }
            if (this.mySize == null && state.mySize != null) {
                this.mySize = state.mySize.getSize();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", WindowStateServiceImpl.STATE, "com/intellij/openapi/util/WindowStateServiceImpl$WindowState", "merge"));
        }
    }
}

