/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl.libraries;

import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.libraries.LibraryProperties;
import com.intellij.openapi.roots.libraries.LibraryType;
import com.intellij.openapi.roots.libraries.LibraryTypeService;
import com.intellij.openapi.roots.libraries.NewLibraryConfiguration;
import com.intellij.openapi.roots.libraries.ui.LibraryRootsComponentDescriptor;
import com.intellij.openapi.roots.libraries.ui.OrderRoot;
import com.intellij.openapi.roots.libraries.ui.impl.RootDetectionUtil;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditor;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import java.awt.Component;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LibraryTypeServiceImpl
extends LibraryTypeService {
    private static final String DEFAULT_LIBRARY_NAME = "Unnamed";

    @Override
    public NewLibraryConfiguration createLibraryFromFiles(@NotNull LibraryRootsComponentDescriptor descriptor, @NotNull JComponent parentComponent, @Nullable VirtualFile contextDirectory, LibraryType<?> type, Project project) {
        if (descriptor == null) {
            LibraryTypeServiceImpl.$$$reportNull$$$0(0);
        }
        if (parentComponent == null) {
            LibraryTypeServiceImpl.$$$reportNull$$$0(1);
        }
        FileChooserDescriptor chooserDescriptor = descriptor.createAttachFilesChooserDescriptor(null);
        chooserDescriptor.setTitle("Select Library Files");
        VirtualFile[] rootCandidates = FileChooser.chooseFiles((FileChooserDescriptor)chooserDescriptor, (Component)parentComponent, (Project)project, (VirtualFile)contextDirectory);
        if (rootCandidates.length == 0) {
            return null;
        }
        List<OrderRoot> roots = RootDetectionUtil.detectRoots(Arrays.asList(rootCandidates), parentComponent, project, descriptor);
        if (roots.isEmpty()) {
            return null;
        }
        String name = LibraryTypeServiceImpl.suggestLibraryName(roots);
        return LibraryTypeServiceImpl.doCreate(type, name, roots);
    }

    @NotNull
    private static <P extends LibraryProperties<?>> NewLibraryConfiguration doCreate(LibraryType<P> type, String name, final List<? extends OrderRoot> roots) {
        NewLibraryConfiguration newLibraryConfiguration = new NewLibraryConfiguration(name, type, type != null ? type.getKind().createDefaultProperties() : null){

            @Override
            public void addRoots(@NotNull LibraryEditor editor) {
                if (editor == null) {
                    1.$$$reportNull$$$0(0);
                }
                editor.addRoots(roots);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/roots/impl/libraries/LibraryTypeServiceImpl$1", "addRoots"));
            }
        };
        if (newLibraryConfiguration == null) {
            LibraryTypeServiceImpl.$$$reportNull$$$0(2);
        }
        return newLibraryConfiguration;
    }

    @NotNull
    public static String suggestLibraryName(@NotNull VirtualFile[] classesRoots) {
        if (classesRoots == null) {
            LibraryTypeServiceImpl.$$$reportNull$$$0(3);
        }
        if (classesRoots.length >= 1) {
            String string = FileUtil.getNameWithoutExtension((String)PathUtil.getFileName((String)classesRoots[0].getPath()));
            if (string == null) {
                LibraryTypeServiceImpl.$$$reportNull$$$0(4);
            }
            return string;
        }
        if (DEFAULT_LIBRARY_NAME == null) {
            LibraryTypeServiceImpl.$$$reportNull$$$0(5);
        }
        return DEFAULT_LIBRARY_NAME;
    }

    @NotNull
    public static String suggestLibraryName(@NotNull List<? extends OrderRoot> roots) {
        if (roots == null) {
            LibraryTypeServiceImpl.$$$reportNull$$$0(6);
        }
        if (roots.size() >= 1) {
            String string = FileUtil.getNameWithoutExtension((String)PathUtil.getFileName((String)roots.get(0).getFile().getPath()));
            if (string == null) {
                LibraryTypeServiceImpl.$$$reportNull$$$0(7);
            }
            return string;
        }
        if (DEFAULT_LIBRARY_NAME == null) {
            LibraryTypeServiceImpl.$$$reportNull$$$0(8);
        }
        return DEFAULT_LIBRARY_NAME;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentComponent";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/impl/libraries/LibraryTypeServiceImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classesRoots";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/impl/libraries/LibraryTypeServiceImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "doCreate";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestLibraryName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createLibraryFromFiles";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                break;
            }
            case 3: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "suggestLibraryName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

