/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.impl.FileTypeAssocTable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.UnloadedModuleDescription;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.AdditionalLibraryRootsProvider;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.JavaSyntheticLibrary;
import com.intellij.openapi.roots.LibraryOrSdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderEnumerationHandler;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.SyntheticLibrary;
import com.intellij.openapi.roots.impl.ContentEntryImpl;
import com.intellij.openapi.roots.impl.DirectoryIndexExcludePolicy;
import com.intellij.openapi.roots.impl.DirectoryInfo;
import com.intellij.openapi.roots.impl.DirectoryInfoImpl;
import com.intellij.openapi.roots.impl.DirectoryInfoWithExcludePatterns;
import com.intellij.openapi.roots.impl.NonProjectDirectoryInfo;
import com.intellij.openapi.roots.impl.OrderEnumeratorBase;
import com.intellij.openapi.roots.impl.PackageDirectoryCache;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.util.CollectionQuery;
import com.intellij.util.Function;
import com.intellij.util.Query;
import com.intellij.util.containers.ConcurrentBitSet;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.SLRUMap;
import com.intellij.util.containers.Stack;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.fileTypes.FileNameMatcherFactory;

public class RootIndex {
    static final Comparator<OrderEntry> BY_OWNER_MODULE = (o1, o2) -> {
        String name1 = o1.getOwnerModule().getName();
        String name2 = o2.getOwnerModule().getName();
        return name1.compareTo(name2);
    };
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.roots.impl.RootIndex");
    private static final FileTypeRegistry ourFileTypes = FileTypeRegistry.getInstance();
    private final Map<VirtualFile, String> myPackagePrefixByRoot;
    private final Map<VirtualFile, DirectoryInfo> myRootInfos;
    private final ConcurrentBitSet myNonInterestingIds;
    @NotNull
    private final Project myProject;
    final PackageDirectoryCache myPackageDirectoryCache;
    private OrderEntryGraph myOrderEntryGraph;

    public RootIndex(@NotNull Project project) {
        if (project == null) {
            RootIndex.$$$reportNull$$$0(0);
        }
        this.myPackagePrefixByRoot = ContainerUtil.newHashMap();
        this.myRootInfos = ContainerUtil.newHashMap();
        this.myNonInterestingIds = new ConcurrentBitSet();
        this.myProject = project;
        ApplicationManager.getApplication().assertReadAccessAllowed();
        RootInfo info = this.buildRootInfo(project);
        MultiMap rootsByPackagePrefix = MultiMap.create();
        Set<VirtualFile> allRoots = info.getAllRoots();
        for (VirtualFile root : allRoots) {
            Pair<DirectoryInfo, String> pair;
            List<VirtualFile> hierarchy = RootIndex.getHierarchy(root, allRoots, info);
            if (hierarchy != null) {
                pair = RootIndex.calcDirectoryInfo(root, hierarchy, info);
            } else {
                Pair<DirectoryInfo, String> pair2;
                pair = pair2;
                super((Object)NonProjectDirectoryInfo.IGNORED, null);
            }
            Pair<DirectoryInfo, String> pair3 = pair;
            this.myRootInfos.put(root, (DirectoryInfo)pair3.first);
            rootsByPackagePrefix.putValue(pair3.second, (Object)root);
            this.myPackagePrefixByRoot.put(root, (String)pair3.second);
        }
        this.myPackageDirectoryCache = new PackageDirectoryCache(rootsByPackagePrefix){

            @Override
            protected boolean isPackageDirectory(@NotNull VirtualFile dir, @NotNull String packageName) {
                if (dir == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (packageName == null) {
                    1.$$$reportNull$$$0(1);
                }
                return RootIndex.this.getInfoForFile(dir).isInProject(dir) && packageName.equals(RootIndex.this.getPackageName(dir));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "dir";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "packageName";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/openapi/roots/impl/RootIndex$1";
                objectArray[2] = "isPackageDirectory";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    public void onLowMemory() {
        this.myPackageDirectoryCache.onLowMemory();
    }

    @NotNull
    private RootInfo buildRootInfo(@NotNull Project project) {
        if (project == null) {
            RootIndex.$$$reportNull$$$0(1);
        }
        RootInfo info = new RootInfo();
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        for (Module module : moduleManager.getModules()) {
            ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
            for (VirtualFile contentRoot : moduleRootManager.getContentRoots()) {
                if (info.contentRootOf.containsKey(contentRoot) || !RootIndex.ensureValid(contentRoot, module)) continue;
                info.contentRootOf.put(contentRoot, module);
            }
            for (ContentEntry contentEntry : moduleRootManager.getContentEntries()) {
                Object patterns;
                int n;
                if (!(contentEntry instanceof ContentEntryImpl) || !((ContentEntryImpl)contentEntry).isDisposed()) {
                    VirtualFile[] virtualFileArray = contentEntry.getExcludeFolderFiles();
                    int n2 = virtualFileArray.length;
                    for (n = 0; n < n2; ++n) {
                        VirtualFile excludeRoot = virtualFileArray[n];
                        if (!RootIndex.ensureValid(excludeRoot, contentEntry)) continue;
                        info.excludedFromModule.put(excludeRoot, module);
                    }
                    patterns = contentEntry.getExcludePatterns();
                    if (!patterns.isEmpty()) {
                        FileTypeAssocTable table = new FileTypeAssocTable();
                        Iterator iterator = patterns.iterator();
                        while (iterator.hasNext()) {
                            String pattern = (String)iterator.next();
                            table.addAssociation(FileNameMatcherFactory.getInstance().createMatcher(pattern), (Object)Boolean.TRUE);
                        }
                        info.excludeFromContentRootTables.put(contentEntry.getFile(), (FileTypeAssocTable<Boolean>)table);
                    }
                }
                patterns = contentEntry.getSourceFolders();
                int table = ((SourceFolder[])patterns).length;
                for (n = 0; n < table; ++n) {
                    VirtualFile[] sourceFolder = patterns[n];
                    VirtualFile sourceFolderRoot = sourceFolder.getFile();
                    if (sourceFolderRoot == null || !RootIndex.ensureValid(sourceFolderRoot, sourceFolder)) continue;
                    info.sourceFolders.put(sourceFolderRoot, (SourceFolder)sourceFolder);
                    info.classAndSourceRoots.add(sourceFolderRoot);
                    info.sourceRootOf.putValue((Object)sourceFolderRoot, (Object)module);
                    info.packagePrefix.put(sourceFolderRoot, sourceFolder.getPackagePrefix());
                }
            }
            for (OrderEntry orderEntry : moduleRootManager.getOrderEntries()) {
                Library library;
                if (!(orderEntry instanceof LibraryOrSdkOrderEntry)) continue;
                LibraryOrSdkOrderEntry entry = (LibraryOrSdkOrderEntry)orderEntry;
                VirtualFile[] sourceRoots = entry.getRootFiles(OrderRootType.SOURCES);
                VirtualFile[] classRoots = entry.getRootFiles(OrderRootType.CLASSES);
                for (VirtualFile sourceRoot : sourceRoots) {
                    if (!RootIndex.ensureValid(sourceRoot, entry)) continue;
                    info.classAndSourceRoots.add(sourceRoot);
                    info.libraryOrSdkSources.add(sourceRoot);
                    info.packagePrefix.put(sourceRoot, "");
                }
                for (VirtualFile classRoot : classRoots) {
                    if (!RootIndex.ensureValid(classRoot, entry)) continue;
                    info.classAndSourceRoots.add(classRoot);
                    info.libraryOrSdkClasses.add(classRoot);
                    info.packagePrefix.put(classRoot, "");
                }
                if (!(orderEntry instanceof LibraryOrderEntry) || (library = ((LibraryOrderEntry)orderEntry).getLibrary()) == null) continue;
                for (VirtualFile root : ((LibraryEx)library).getExcludedRoots()) {
                    if (!RootIndex.ensureValid(root, library)) continue;
                    info.excludedFromLibraries.putValue((Object)root, (Object)library);
                }
                for (VirtualFile root : sourceRoots) {
                    if (!RootIndex.ensureValid(root, library)) continue;
                    info.sourceOfLibraries.putValue((Object)root, (Object)library);
                }
                for (VirtualFile root : classRoots) {
                    if (!RootIndex.ensureValid(root, library)) continue;
                    info.classOfLibraries.putValue((Object)root, (Object)library);
                }
            }
        }
        for (AdditionalLibraryRootsProvider provider : AdditionalLibraryRootsProvider.EP_NAME.getExtensionList()) {
            Collection<SyntheticLibrary> libraries = provider.getAdditionalProjectLibraries(project);
            for (SyntheticLibrary descriptor : libraries) {
                for (VirtualFile sourceRoot : descriptor.getSourceRoots()) {
                    if (!RootIndex.ensureValid(sourceRoot, descriptor)) continue;
                    info.libraryOrSdkSources.add(sourceRoot);
                    info.classAndSourceRoots.add(sourceRoot);
                    if (descriptor instanceof JavaSyntheticLibrary) {
                        info.packagePrefix.put(sourceRoot, "");
                    }
                    info.sourceOfLibraries.putValue((Object)sourceRoot, (Object)descriptor);
                }
                for (VirtualFile classRoot : descriptor.getBinaryRoots()) {
                    if (!RootIndex.ensureValid(classRoot, project)) continue;
                    info.libraryOrSdkClasses.add(classRoot);
                    info.classAndSourceRoots.add(classRoot);
                    if (descriptor instanceof JavaSyntheticLibrary) {
                        info.packagePrefix.put(classRoot, "");
                    }
                    info.classOfLibraries.putValue((Object)classRoot, (Object)descriptor);
                }
                for (VirtualFile file3 : descriptor.getExcludedRoots()) {
                    if (!RootIndex.ensureValid(file3, project)) continue;
                    info.excludedFromLibraries.putValue((Object)file3, (Object)descriptor);
                }
            }
        }
        for (DirectoryIndexExcludePolicy policy : (DirectoryIndexExcludePolicy[])DirectoryIndexExcludePolicy.EP_NAME.getExtensions((AreaInstance)project)) {
            List files2 = ContainerUtil.mapNotNull((Object[])policy.getExcludeUrlsForProject(), url -> VirtualFileManager.getInstance().findFileByUrl(url));
            info.excludedFromProject.addAll(ContainerUtil.filter((Collection)files2, file2 -> RootIndex.ensureValid(file2, policy)));
            Function<Sdk, List<VirtualFile>> fun = policy.getExcludeSdkRootsStrategy();
            if (fun == null) continue;
            HashSet<Sdk> sdks = new HashSet<Sdk>();
            for (Module m : ModuleManager.getInstance((Project)this.myProject).getModules()) {
                Sdk sdk = ModuleRootManager.getInstance((Module)m).getSdk();
                if (sdk == null) continue;
                sdks.add(sdk);
            }
            HashSet<VirtualFile> roots = new HashSet<VirtualFile>();
            for (Sdk sdk : sdks) {
                roots.addAll(Arrays.asList(sdk.getRootProvider().getFiles(OrderRootType.CLASSES)));
            }
            for (Sdk sdk : sdks) {
                info.excludedFromSdkRoots.addAll(ContainerUtil.filter((Collection)((Collection)fun.fun((Object)sdk)), file2 -> RootIndex.ensureValid(file2, policy) && !roots.contains(file2)));
            }
        }
        for (UnloadedModuleDescription description : moduleManager.getUnloadedModuleDescriptions()) {
            for (VirtualFilePointer pointer : description.getContentRoots()) {
                VirtualFile contentRoot = pointer.getFile();
                if (contentRoot == null || !RootIndex.ensureValid(contentRoot, description)) continue;
                info.contentRootOfUnloaded.put(contentRoot, description.getName());
            }
        }
        RootInfo rootInfo = info;
        if (rootInfo == null) {
            RootIndex.$$$reportNull$$$0(2);
        }
        return rootInfo;
    }

    private static boolean ensureValid(@NotNull VirtualFile file2, @NotNull Object container) {
        if (file2 == null) {
            RootIndex.$$$reportNull$$$0(3);
        }
        if (container == null) {
            RootIndex.$$$reportNull$$$0(4);
        }
        if (!(file2 instanceof VirtualFileWithId)) {
            return false;
        }
        if (!file2.isValid()) {
            LOG.error("Invalid root " + file2 + " in " + container);
            return false;
        }
        return true;
    }

    @NotNull
    private synchronized OrderEntryGraph getOrderEntryGraph() {
        if (this.myOrderEntryGraph == null) {
            RootInfo rootInfo = this.buildRootInfo(this.myProject);
            this.myOrderEntryGraph = new OrderEntryGraph(this.myProject, rootInfo);
        }
        OrderEntryGraph orderEntryGraph = this.myOrderEntryGraph;
        if (orderEntryGraph == null) {
            RootIndex.$$$reportNull$$$0(5);
        }
        return orderEntryGraph;
    }

    @NotNull
    public DirectoryInfo getInfoForFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            RootIndex.$$$reportNull$$$0(6);
        }
        if (!file2.isValid() || !(file2 instanceof VirtualFileWithId)) {
            NonProjectDirectoryInfo nonProjectDirectoryInfo = NonProjectDirectoryInfo.INVALID;
            if (nonProjectDirectoryInfo == null) {
                RootIndex.$$$reportNull$$$0(7);
            }
            return nonProjectDirectoryInfo;
        }
        for (VirtualFile each = file2; each != null; each = each.getParent()) {
            int id = ((VirtualFileWithId)each).getId();
            if (this.myNonInterestingIds.get(id)) continue;
            DirectoryInfo info = this.myRootInfos.get(each);
            if (info != null) {
                DirectoryInfo directoryInfo = info;
                if (directoryInfo == null) {
                    RootIndex.$$$reportNull$$$0(8);
                }
                return directoryInfo;
            }
            if (ourFileTypes.isFileIgnored(each)) {
                NonProjectDirectoryInfo nonProjectDirectoryInfo = NonProjectDirectoryInfo.IGNORED;
                if (nonProjectDirectoryInfo == null) {
                    RootIndex.$$$reportNull$$$0(9);
                }
                return nonProjectDirectoryInfo;
            }
            this.myNonInterestingIds.set(id);
        }
        NonProjectDirectoryInfo nonProjectDirectoryInfo = NonProjectDirectoryInfo.NOT_UNDER_PROJECT_ROOTS;
        if (nonProjectDirectoryInfo == null) {
            RootIndex.$$$reportNull$$$0(10);
        }
        return nonProjectDirectoryInfo;
    }

    @NotNull
    public Query<VirtualFile> getDirectoriesByPackageName(@NotNull String packageName, boolean includeLibrarySources) {
        if (packageName == null) {
            RootIndex.$$$reportNull$$$0(11);
        }
        List result2 = this.myPackageDirectoryCache.getDirectoriesByPackageName(packageName);
        if (!includeLibrarySources) {
            result2 = ContainerUtil.filter(result2, file2 -> {
                DirectoryInfo info = this.getInfoForFile((VirtualFile)file2);
                return info.isInProject((VirtualFile)file2) && (!info.isInLibrarySource((VirtualFile)file2) || info.isInModuleSource((VirtualFile)file2) || info.hasLibraryClassRoot());
            });
        }
        CollectionQuery collectionQuery = new CollectionQuery(result2);
        if (collectionQuery == null) {
            RootIndex.$$$reportNull$$$0(12);
        }
        return collectionQuery;
    }

    @Nullable
    public String getPackageName(@NotNull VirtualFile dir) {
        if (dir == null) {
            RootIndex.$$$reportNull$$$0(13);
        }
        if (dir.isDirectory()) {
            if (ourFileTypes.isFileIgnored(dir)) {
                return null;
            }
            if (this.myPackagePrefixByRoot.containsKey(dir)) {
                return this.myPackagePrefixByRoot.get(dir);
            }
            VirtualFile parent = dir.getParent();
            if (parent != null) {
                return RootIndex.getPackageNameForSubdir(this.getPackageName(parent), dir.getName());
            }
        }
        return null;
    }

    @Nullable
    private static String getPackageNameForSubdir(@Nullable String parentPackageName, @NotNull String subdirName) {
        if (subdirName == null) {
            RootIndex.$$$reportNull$$$0(14);
        }
        if (parentPackageName == null) {
            return null;
        }
        return parentPackageName.isEmpty() ? subdirName : parentPackageName + "." + subdirName;
    }

    @Nullable(value="returns null only if dir is under ignored folder")
    private static List<VirtualFile> getHierarchy(VirtualFile dir, @NotNull Set<? extends VirtualFile> allRoots, @NotNull RootInfo info) {
        if (allRoots == null) {
            RootIndex.$$$reportNull$$$0(15);
        }
        if (info == null) {
            RootIndex.$$$reportNull$$$0(16);
        }
        ArrayList hierarchy = ContainerUtil.newArrayList();
        boolean hasContentRoots = false;
        while (dir != null) {
            if (!(hasContentRoots |= info.contentRootOf.get(dir) != null) && ourFileTypes.isFileIgnored(dir)) {
                return null;
            }
            if (allRoots.contains(dir)) {
                hierarchy.add(dir);
            }
            dir = dir.getParent();
        }
        return hierarchy;
    }

    @NotNull
    private static Pair<DirectoryInfo, String> calcDirectoryInfo(@NotNull VirtualFile root, @NotNull List<? extends VirtualFile> hierarchy, @NotNull RootInfo info) {
        VirtualFile nearestContentRoot;
        boolean inProject;
        if (root == null) {
            RootIndex.$$$reportNull$$$0(17);
        }
        if (hierarchy == null) {
            RootIndex.$$$reportNull$$$0(18);
        }
        if (info == null) {
            RootIndex.$$$reportNull$$$0(19);
        }
        VirtualFile moduleContentRoot = info.findNearestContentRoot(hierarchy);
        Pair librarySourceRootInfo = info.findLibraryRootInfo(hierarchy, true);
        VirtualFile librarySourceRoot = (VirtualFile)Pair.getFirst((Pair)librarySourceRootInfo);
        Pair libraryClassRootInfo = info.findLibraryRootInfo(hierarchy, false);
        VirtualFile libraryClassRoot = (VirtualFile)Pair.getFirst((Pair)libraryClassRootInfo);
        boolean bl = inProject = moduleContentRoot != null || (libraryClassRoot != null || librarySourceRoot != null) && !info.excludedFromSdkRoots.contains(root);
        if (inProject) {
            nearestContentRoot = moduleContentRoot;
        } else {
            nearestContentRoot = info.findNearestContentRootForExcluded(hierarchy);
            if (nearestContentRoot == null) {
                Pair pair = new Pair((Object)NonProjectDirectoryInfo.EXCLUDED, null);
                if (pair == null) {
                    RootIndex.$$$reportNull$$$0(20);
                }
                return pair;
            }
        }
        VirtualFile sourceRoot = info.findPackageRootInfo(hierarchy, moduleContentRoot, null, librarySourceRoot);
        VirtualFile moduleSourceRoot = info.findPackageRootInfo(hierarchy, moduleContentRoot, null, null);
        boolean inModuleSources = moduleSourceRoot != null;
        boolean inLibrarySource = librarySourceRoot != null;
        SourceFolder sourceFolder = moduleSourceRoot != null ? info.sourceFolders.get(moduleSourceRoot) : null;
        Module module = info.contentRootOf.get(nearestContentRoot);
        String unloadedModuleName = info.contentRootOfUnloaded.get(nearestContentRoot);
        FileTypeAssocTable<Boolean> contentExcludePatterns = moduleContentRoot != null ? info.excludeFromContentRootTables.get(moduleContentRoot) : null;
        Condition<VirtualFile> libraryExclusionPredicate = RootIndex.getLibraryExclusionPredicate(librarySourceRootInfo);
        DirectoryInfoImpl directoryInfo = contentExcludePatterns != null || libraryExclusionPredicate != null ? new DirectoryInfoWithExcludePatterns(root, module, nearestContentRoot, sourceRoot, sourceFolder, libraryClassRoot, inModuleSources, inLibrarySource, !inProject, contentExcludePatterns, libraryExclusionPredicate, unloadedModuleName) : new DirectoryInfoImpl(root, module, nearestContentRoot, sourceRoot, sourceFolder, libraryClassRoot, inModuleSources, inLibrarySource, !inProject, unloadedModuleName);
        String packagePrefix = info.calcPackagePrefix(root, hierarchy, moduleContentRoot, libraryClassRoot, librarySourceRoot);
        Pair pair = Pair.create((Object)directoryInfo, (Object)packagePrefix);
        if (pair == null) {
            RootIndex.$$$reportNull$$$0(21);
        }
        return pair;
    }

    @Nullable
    private static Condition<VirtualFile> getLibraryExclusionPredicate(@Nullable Pair<VirtualFile, Collection<?>> libraryRootInfo) {
        Condition result2 = Conditions.alwaysFalse();
        if (libraryRootInfo != null) {
            for (Object library : (Collection)libraryRootInfo.second) {
                Condition<VirtualFile> exclusionPredicate;
                Condition<VirtualFile> condition = exclusionPredicate = library instanceof SyntheticLibrary ? ((SyntheticLibrary)library).getExcludeFileCondition() : null;
                if (exclusionPredicate == null) continue;
                result2 = Conditions.or((Condition)result2, exclusionPredicate);
            }
        }
        return result2 != Condition.FALSE ? result2 : null;
    }

    @NotNull
    public List<OrderEntry> getOrderEntries(@NotNull DirectoryInfo info) {
        if (info == null) {
            RootIndex.$$$reportNull$$$0(22);
        }
        if (!(info instanceof DirectoryInfoImpl)) {
            List<OrderEntry> list2 = Collections.emptyList();
            if (list2 == null) {
                RootIndex.$$$reportNull$$$0(23);
            }
            return list2;
        }
        List list3 = this.getOrderEntryGraph().getOrderEntries(((DirectoryInfoImpl)info).getRoot());
        if (list3 == null) {
            RootIndex.$$$reportNull$$$0(24);
        }
        return list3;
    }

    @NotNull
    Set<String> getDependentUnloadedModules(@NotNull Module module) {
        if (module == null) {
            RootIndex.$$$reportNull$$$0(25);
        }
        Set<String> set2 = this.getOrderEntryGraph().getDependentUnloadedModules(module);
        if (set2 == null) {
            RootIndex.$$$reportNull$$$0(26);
        }
        return set2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 26: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 26: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/impl/RootIndex";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subdirName";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allRoots";
                break;
            }
            case 16: 
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hierarchy";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/impl/RootIndex";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildRootInfo";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrderEntryGraph";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getInfoForFile";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectoriesByPackageName";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "calcDirectoryInfo";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrderEntries";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependentUnloadedModules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildRootInfo";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 26: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "ensureValid";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getInfoForFile";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getDirectoriesByPackageName";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getPackageName";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getPackageNameForSubdir";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getHierarchy";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "calcDirectoryInfo";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getOrderEntries";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getDependentUnloadedModules";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 26: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static abstract class SynchronizedSLRUCache<K, V>
    extends SLRUMap<K, V> {
        protected final Object myLock = new Object();

        SynchronizedSLRUCache(int protectedQueueSize, int probationalQueueSize) {
            super(protectedQueueSize, probationalQueueSize);
        }

        @NotNull
        public abstract V createValue(@NotNull K var1);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @NotNull
        public V get(K key) {
            Object value;
            Object object = this.myLock;
            synchronized (object) {
                value = super.get(key);
                if (value != null) {
                    Object object2 = value;
                    // MONITOREXIT @DISABLED, blocks:[3, 7] lbl6 : MonitorExitStatement: MONITOREXIT : var3_2
                    if (object2 == null) {
                        SynchronizedSLRUCache.$$$reportNull$$$0(0);
                    }
                    return (V)object2;
                }
            }
            value = this.createValue(key);
            object = this.myLock;
            synchronized (object) {
                this.put(key, value);
            }
            Object object3 = value;
            if (object3 == null) {
                SynchronizedSLRUCache.$$$reportNull$$$0(1);
            }
            return (V)object3;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/RootIndex$SynchronizedSLRUCache", "get"));
        }
    }

    private static class RootInfo {
        @NotNull
        final LinkedHashSet<VirtualFile> classAndSourceRoots = ContainerUtil.newLinkedHashSet();
        @NotNull
        final Set<VirtualFile> libraryOrSdkSources = ContainerUtil.newHashSet();
        @NotNull
        final Set<VirtualFile> libraryOrSdkClasses = ContainerUtil.newHashSet();
        @NotNull
        final Map<VirtualFile, Module> contentRootOf = ContainerUtil.newHashMap();
        @NotNull
        final Map<VirtualFile, String> contentRootOfUnloaded = ContainerUtil.newHashMap();
        @NotNull
        final MultiMap<VirtualFile, Module> sourceRootOf = MultiMap.createSet();
        @NotNull
        final Map<VirtualFile, SourceFolder> sourceFolders = ContainerUtil.newHashMap();
        @NotNull
        final MultiMap<VirtualFile, Object> excludedFromLibraries = MultiMap.createSmart();
        @NotNull
        final MultiMap<VirtualFile, Object> classOfLibraries = MultiMap.createSmart();
        @NotNull
        final MultiMap<VirtualFile, Object> sourceOfLibraries = MultiMap.createSmart();
        @NotNull
        final Set<VirtualFile> excludedFromProject = ContainerUtil.newHashSet();
        @NotNull
        final Set<VirtualFile> excludedFromSdkRoots = ContainerUtil.newHashSet();
        @NotNull
        final Map<VirtualFile, Module> excludedFromModule = ContainerUtil.newHashMap();
        @NotNull
        final Map<VirtualFile, FileTypeAssocTable<Boolean>> excludeFromContentRootTables = ContainerUtil.newHashMap();
        @NotNull
        final Map<VirtualFile, String> packagePrefix = ContainerUtil.newHashMap();

        private RootInfo() {
        }

        @NotNull
        Set<VirtualFile> getAllRoots() {
            LinkedHashSet result2 = ContainerUtil.newLinkedHashSet();
            result2.addAll(this.classAndSourceRoots);
            result2.addAll(this.contentRootOf.keySet());
            result2.addAll(this.contentRootOfUnloaded.keySet());
            result2.addAll(this.excludedFromLibraries.keySet());
            result2.addAll(this.excludedFromModule.keySet());
            result2.addAll(this.excludedFromProject);
            result2.addAll(this.excludedFromSdkRoots);
            LinkedHashSet linkedHashSet = result2;
            if (linkedHashSet == null) {
                RootInfo.$$$reportNull$$$0(0);
            }
            return linkedHashSet;
        }

        @Nullable
        private VirtualFile findNearestContentRoot(@NotNull List<? extends VirtualFile> hierarchy) {
            if (hierarchy == null) {
                RootInfo.$$$reportNull$$$0(1);
            }
            Collection sourceRootOwners = null;
            boolean underExcludedSourceRoot = false;
            for (VirtualFile virtualFile : hierarchy) {
                Collection modulesForSourceRoot;
                FileTypeAssocTable<Boolean> table;
                Module module = this.contentRootOf.get(virtualFile);
                Module excludedFrom = this.excludedFromModule.get(virtualFile);
                if (module != null && (table = this.excludeFromContentRootTables.get(virtualFile)) != null && RootInfo.isExcludedByPattern(virtualFile, hierarchy, table)) {
                    excludedFrom = module;
                }
                if (module != null && (excludedFrom != module || underExcludedSourceRoot && sourceRootOwners.contains(module))) {
                    return virtualFile;
                }
                if (excludedFrom != null || this.excludedFromProject.contains(virtualFile) || this.contentRootOfUnloaded.containsKey(virtualFile)) {
                    if (sourceRootOwners != null) {
                        underExcludedSourceRoot = true;
                    } else {
                        return null;
                    }
                }
                if (underExcludedSourceRoot || !this.sourceRootOf.containsKey((Object)virtualFile) || (modulesForSourceRoot = this.sourceRootOf.get((Object)virtualFile)).isEmpty()) continue;
                if (sourceRootOwners == null) {
                    sourceRootOwners = modulesForSourceRoot;
                    continue;
                }
                sourceRootOwners = ContainerUtil.union((Collection)sourceRootOwners, (Collection)modulesForSourceRoot);
            }
            return null;
        }

        private static boolean isExcludedByPattern(@NotNull VirtualFile contentRoot, List<? extends VirtualFile> hierarchy, @NotNull FileTypeAssocTable<Boolean> table) {
            if (contentRoot == null) {
                RootInfo.$$$reportNull$$$0(2);
            }
            if (table == null) {
                RootInfo.$$$reportNull$$$0(3);
            }
            for (VirtualFile virtualFile : hierarchy) {
                if (table.findAssociatedFileType(virtualFile.getNameSequence()) != null) {
                    return true;
                }
                if (!virtualFile.equals(contentRoot)) continue;
                break;
            }
            return false;
        }

        @Nullable
        private VirtualFile findNearestContentRootForExcluded(@NotNull List<? extends VirtualFile> hierarchy) {
            if (hierarchy == null) {
                RootInfo.$$$reportNull$$$0(4);
            }
            for (VirtualFile virtualFile : hierarchy) {
                if (!this.contentRootOf.containsKey(virtualFile) && !this.contentRootOfUnloaded.containsKey(virtualFile)) continue;
                return virtualFile;
            }
            return null;
        }

        @Nullable
        private Pair<VirtualFile, Collection<?>> findLibraryRootInfo(@NotNull List<? extends VirtualFile> hierarchy, boolean source) {
            if (hierarchy == null) {
                RootInfo.$$$reportNull$$$0(5);
            }
            HashSet librariesToIgnore = ContainerUtil.newHashSet();
            for (VirtualFile virtualFile : hierarchy) {
                Collection<Object> rootProducers;
                librariesToIgnore.addAll(this.excludedFromLibraries.get((Object)virtualFile));
                if (source && this.libraryOrSdkSources.contains(virtualFile)) {
                    if (!this.sourceOfLibraries.containsKey((Object)virtualFile)) {
                        return Pair.create((Object)virtualFile, Collections.emptySet());
                    }
                    rootProducers = RootInfo.findLibraryRootProducers(this.sourceOfLibraries.get((Object)virtualFile), virtualFile, librariesToIgnore);
                    if (rootProducers.isEmpty()) continue;
                    return Pair.create((Object)virtualFile, rootProducers);
                }
                if (source || !this.libraryOrSdkClasses.contains(virtualFile)) continue;
                if (!this.classOfLibraries.containsKey((Object)virtualFile)) {
                    return Pair.create((Object)virtualFile, Collections.emptySet());
                }
                rootProducers = RootInfo.findLibraryRootProducers(this.classOfLibraries.get((Object)virtualFile), virtualFile, librariesToIgnore);
                if (rootProducers.isEmpty()) continue;
                return Pair.create((Object)virtualFile, rootProducers);
            }
            return null;
        }

        @NotNull
        private static Collection<Object> findLibraryRootProducers(@NotNull Collection<?> producers, @NotNull VirtualFile root, @NotNull Set<?> librariesToIgnore) {
            if (producers == null) {
                RootInfo.$$$reportNull$$$0(6);
            }
            if (root == null) {
                RootInfo.$$$reportNull$$$0(7);
            }
            if (librariesToIgnore == null) {
                RootInfo.$$$reportNull$$$0(8);
            }
            HashSet libraries = ContainerUtil.newHashSet();
            for (Object library : producers) {
                Condition<VirtualFile> exclusion;
                if (librariesToIgnore.contains(library) || library instanceof SyntheticLibrary && (exclusion = ((SyntheticLibrary)library).getExcludeFileCondition()) != null && exclusion.value((Object)root)) continue;
                libraries.add(library);
            }
            HashSet hashSet = libraries;
            if (hashSet == null) {
                RootInfo.$$$reportNull$$$0(9);
            }
            return hashSet;
        }

        private String calcPackagePrefix(@NotNull VirtualFile root, @NotNull List<? extends VirtualFile> hierarchy, VirtualFile moduleContentRoot, VirtualFile libraryClassRoot, VirtualFile librarySourceRoot) {
            VirtualFile packageRoot;
            String prefix;
            if (root == null) {
                RootInfo.$$$reportNull$$$0(10);
            }
            if (hierarchy == null) {
                RootInfo.$$$reportNull$$$0(11);
            }
            if ((prefix = this.packagePrefix.get(packageRoot = this.findPackageRootInfo(hierarchy, moduleContentRoot, libraryClassRoot, librarySourceRoot))) != null && !root.equals(packageRoot)) {
                assert (packageRoot != null);
                String relative = VfsUtilCore.getRelativePath((VirtualFile)root, (VirtualFile)packageRoot, (char)'.');
                prefix = StringUtil.isEmpty((String)prefix) ? relative : prefix + '.' + relative;
            }
            return prefix;
        }

        @Nullable
        private VirtualFile findPackageRootInfo(@NotNull List<? extends VirtualFile> hierarchy, VirtualFile moduleContentRoot, VirtualFile libraryClassRoot, VirtualFile librarySourceRoot) {
            if (hierarchy == null) {
                RootInfo.$$$reportNull$$$0(12);
            }
            for (VirtualFile virtualFile : hierarchy) {
                if (moduleContentRoot != null && this.sourceRootOf.get((Object)virtualFile).contains(this.contentRootOf.get(moduleContentRoot)) && librarySourceRoot == null) {
                    return virtualFile;
                }
                if (virtualFile.equals(libraryClassRoot) || virtualFile.equals(librarySourceRoot)) {
                    return virtualFile;
                }
                if (!virtualFile.equals(moduleContentRoot) || this.sourceRootOf.containsKey((Object)virtualFile) || librarySourceRoot != null || libraryClassRoot != null) continue;
                return null;
            }
            return null;
        }

        @NotNull
        private LinkedHashSet<OrderEntry> getLibraryOrderEntries(@NotNull List<? extends VirtualFile> hierarchy, @Nullable VirtualFile libraryClassRoot, @Nullable VirtualFile librarySourceRoot, @NotNull MultiMap<VirtualFile, OrderEntry> libClassRootEntries, @NotNull MultiMap<VirtualFile, OrderEntry> libSourceRootEntries) {
            if (hierarchy == null) {
                RootInfo.$$$reportNull$$$0(13);
            }
            if (libClassRootEntries == null) {
                RootInfo.$$$reportNull$$$0(14);
            }
            if (libSourceRootEntries == null) {
                RootInfo.$$$reportNull$$$0(15);
            }
            LinkedHashSet orderEntries = ContainerUtil.newLinkedHashSet();
            for (VirtualFile virtualFile : hierarchy) {
                if (virtualFile.equals(libraryClassRoot) && !this.sourceRootOf.containsKey((Object)virtualFile)) {
                    orderEntries.addAll(libClassRootEntries.get((Object)virtualFile));
                }
                if (virtualFile.equals(librarySourceRoot) && libraryClassRoot == null) {
                    orderEntries.addAll(libSourceRootEntries.get((Object)virtualFile));
                }
                if (!libClassRootEntries.containsKey((Object)virtualFile) && (!this.sourceRootOf.containsKey((Object)virtualFile) || librarySourceRoot != null)) continue;
                break;
            }
            LinkedHashSet linkedHashSet = orderEntries;
            if (linkedHashSet == null) {
                RootInfo.$$$reportNull$$$0(16);
            }
            return linkedHashSet;
        }

        @Nullable
        private ModuleSourceOrderEntry getModuleSourceEntry(@NotNull List<? extends VirtualFile> hierarchy, @NotNull VirtualFile moduleContentRoot, @NotNull MultiMap<VirtualFile, OrderEntry> libClassRootEntries) {
            if (hierarchy == null) {
                RootInfo.$$$reportNull$$$0(17);
            }
            if (moduleContentRoot == null) {
                RootInfo.$$$reportNull$$$0(18);
            }
            if (libClassRootEntries == null) {
                RootInfo.$$$reportNull$$$0(19);
            }
            Module module = this.contentRootOf.get(moduleContentRoot);
            for (VirtualFile virtualFile : hierarchy) {
                if (this.sourceRootOf.get((Object)virtualFile).contains(module)) {
                    return (ModuleSourceOrderEntry)ContainerUtil.findInstance((Object[])ModuleRootManager.getInstance((Module)module).getOrderEntries(), ModuleSourceOrderEntry.class);
                }
                if (!libClassRootEntries.containsKey((Object)virtualFile)) continue;
                return null;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 17: 
                case 18: 
                case 19: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 17: 
                case 18: 
                case 19: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/roots/impl/RootIndex$RootInfo";
                    break;
                }
                case 1: 
                case 4: 
                case 5: 
                case 11: 
                case 12: 
                case 13: 
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "hierarchy";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "contentRoot";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "table";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "producers";
                    break;
                }
                case 7: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "librariesToIgnore";
                    break;
                }
                case 14: 
                case 19: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "libClassRootEntries";
                    break;
                }
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "libSourceRootEntries";
                    break;
                }
                case 18: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "moduleContentRoot";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAllRoots";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 17: 
                case 18: 
                case 19: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/roots/impl/RootIndex$RootInfo";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "findLibraryRootProducers";
                    break;
                }
                case 16: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLibraryOrderEntries";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "findNearestContentRoot";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "isExcludedByPattern";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "findNearestContentRootForExcluded";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "findLibraryRootInfo";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "findLibraryRootProducers";
                    break;
                }
                case 10: 
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "calcPackagePrefix";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "findPackageRootInfo";
                    break;
                }
                case 13: 
                case 14: 
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "getLibraryOrderEntries";
                    break;
                }
                case 17: 
                case 18: 
                case 19: {
                    objectArray = objectArray;
                    objectArray[2] = "getModuleSourceEntry";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 17: 
                case 18: 
                case 19: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class OrderEntryGraph {
        final Project myProject;
        final RootInfo myRootInfo;
        final Set<VirtualFile> myAllRoots;
        Graph myGraph;
        MultiMap<VirtualFile, Node> myRoots;
        final SynchronizedSLRUCache<VirtualFile, List<OrderEntry>> myCache;
        final SynchronizedSLRUCache<Module, Set<String>> myDependentUnloadedModulesCache;
        private MultiMap<VirtualFile, OrderEntry> myLibClassRootEntries;
        private MultiMap<VirtualFile, OrderEntry> myLibSourceRootEntries;

        OrderEntryGraph(@NotNull Project project, @NotNull RootInfo rootInfo) {
            if (project == null) {
                OrderEntryGraph.$$$reportNull$$$0(0);
            }
            if (rootInfo == null) {
                OrderEntryGraph.$$$reportNull$$$0(1);
            }
            this.myProject = project;
            this.myRootInfo = rootInfo;
            this.myAllRoots = this.myRootInfo.getAllRoots();
            int cacheSize = Math.max(25, this.myAllRoots.size() / 100 * 2);
            this.myCache = new SynchronizedSLRUCache<VirtualFile, List<OrderEntry>>(cacheSize, cacheSize){

                @Override
                @NotNull
                public List<OrderEntry> createValue(@NotNull VirtualFile key) {
                    if (key == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    List list2 = this.collectOrderEntries(key);
                    if (list2 == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return list2;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 1: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 1: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "key";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/openapi/roots/impl/RootIndex$OrderEntryGraph$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/openapi/roots/impl/RootIndex$OrderEntryGraph$1";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "createValue";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "createValue";
                            break;
                        }
                        case 1: {
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 1: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            };
            int dependentUnloadedModulesCacheSize = ModuleManager.getInstance((Project)project).getModules().length / 2;
            this.myDependentUnloadedModulesCache = new SynchronizedSLRUCache<Module, Set<String>>(dependentUnloadedModulesCacheSize, dependentUnloadedModulesCacheSize){

                @Override
                @NotNull
                public Set<String> createValue(@NotNull Module key) {
                    if (key == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    Set set2 = this.collectDependentUnloadedModules(key);
                    if (set2 == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    return set2;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 1: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 1: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "key";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/openapi/roots/impl/RootIndex$OrderEntryGraph$2";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/openapi/roots/impl/RootIndex$OrderEntryGraph$2";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "createValue";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "createValue";
                            break;
                        }
                        case 1: {
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 1: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            };
            this.initGraph();
            this.initLibraryRoots();
        }

        private void initGraph() {
            Graph graph2 = new Graph();
            MultiMap roots = MultiMap.createSmart();
            ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
            for (Module module : moduleManager.getModules()) {
                ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
                List<OrderEnumerationHandler> handlers = OrderEnumeratorBase.getCustomHandlers(module);
                for (OrderEntry orderEntry : moduleRootManager.getOrderEntries()) {
                    ModuleOrderEntry moduleOrderEntry;
                    Module depModule;
                    if (!(orderEntry instanceof ModuleOrderEntry) || (depModule = (moduleOrderEntry = (ModuleOrderEntry)orderEntry).getModule()) == null) continue;
                    Node node = graph2.myNodes.get(depModule);
                    OrderEnumerator en = OrderEnumerator.orderEntries((Module)depModule).exportedOnly();
                    if (node == null) {
                        VirtualFile[] importedSourceRoots;
                        VirtualFile[] importedClassRoots;
                        node = new Node();
                        node.myKey = depModule;
                        graph2.myNodes.put(depModule, node);
                        for (VirtualFile importedClassRoot : importedClassRoots = en.classes().usingCache().getRoots()) {
                            roots.putValue((Object)importedClassRoot, (Object)node);
                        }
                        for (VirtualFile sourceRoot : importedSourceRoots = en.sources().usingCache().getRoots()) {
                            roots.putValue((Object)sourceRoot, (Object)node);
                        }
                    }
                    boolean shouldRecurse = en.recursively().shouldRecurse(moduleOrderEntry, handlers);
                    node.myEdges.add(new Edge(module, moduleOrderEntry, shouldRecurse));
                }
            }
            for (UnloadedModuleDescription description : moduleManager.getUnloadedModuleDescriptions()) {
                for (String depName : description.getDependencyModuleNames()) {
                    Module depModule = moduleManager.findModuleByName(depName);
                    if (depModule == null) continue;
                    Node node = graph2.myNodes.get(depModule);
                    if (node == null) {
                        node = new Node();
                        node.myKey = depModule;
                        graph2.myNodes.put(depModule, node);
                    }
                    if (node.myUnloadedDependentModules == null) {
                        node.myUnloadedDependentModules = new LinkedHashSet<String>();
                    }
                    node.myUnloadedDependentModules.add(description.getName());
                }
            }
            this.myGraph = graph2;
            this.myRoots = roots;
        }

        private void initLibraryRoots() {
            MultiMap libClassRootEntries = MultiMap.createSmart();
            MultiMap libSourceRootEntries = MultiMap.createSmart();
            for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
                ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
                for (OrderEntry orderEntry : moduleRootManager.getOrderEntries()) {
                    if (!(orderEntry instanceof LibraryOrSdkOrderEntry)) continue;
                    LibraryOrSdkOrderEntry entry = (LibraryOrSdkOrderEntry)orderEntry;
                    for (VirtualFile sourceRoot : entry.getRootFiles(OrderRootType.SOURCES)) {
                        libSourceRootEntries.putValue((Object)sourceRoot, (Object)orderEntry);
                    }
                    for (VirtualFile classRoot : entry.getRootFiles(OrderRootType.CLASSES)) {
                        libClassRootEntries.putValue((Object)classRoot, (Object)orderEntry);
                    }
                }
            }
            this.myLibClassRootEntries = libClassRootEntries;
            this.myLibSourceRootEntries = libSourceRootEntries;
        }

        @NotNull
        private List<OrderEntry> getOrderEntries(@NotNull VirtualFile file2) {
            if (file2 == null) {
                OrderEntryGraph.$$$reportNull$$$0(2);
            }
            List<OrderEntry> list2 = this.myCache.get(file2);
            if (list2 == null) {
                OrderEntryGraph.$$$reportNull$$$0(3);
            }
            return list2;
        }

        @NotNull
        private List<OrderEntry> collectOrderEntries(@NotNull VirtualFile file2) {
            List roots;
            if (file2 == null) {
                OrderEntryGraph.$$$reportNull$$$0(4);
            }
            if ((roots = RootIndex.getHierarchy(file2, this.myAllRoots, this.myRootInfo)) == null) {
                List<OrderEntry> list2 = Collections.emptyList();
                if (list2 == null) {
                    OrderEntryGraph.$$$reportNull$$$0(5);
                }
                return list2;
            }
            Stack stack = new Stack();
            for (VirtualFile root : roots) {
                Collection nodes = this.myRoots.get((Object)root);
                for (Node node : nodes) {
                    stack.push((Object)node);
                }
            }
            HashSet<Node> seen = new HashSet<Node>();
            ArrayList<OrderEntry> result2 = new ArrayList<OrderEntry>();
            while (!stack.isEmpty()) {
                Node node = (Node)stack.pop();
                if (seen.contains(node)) continue;
                seen.add(node);
                for (Edge edge : node.myEdges) {
                    Node targetNode;
                    result2.add((OrderEntry)edge.myOrderEntry);
                    if (!edge.myRecursive || (targetNode = this.myGraph.myNodes.get(edge.myKey)) == null) continue;
                    stack.push((Object)targetNode);
                }
            }
            Pair libraryClassRootInfo = this.myRootInfo.findLibraryRootInfo(roots, false);
            Pair librarySourceRootInfo = this.myRootInfo.findLibraryRootInfo(roots, true);
            result2.addAll(this.myRootInfo.getLibraryOrderEntries(roots, (VirtualFile)Pair.getFirst((Pair)libraryClassRootInfo), (VirtualFile)Pair.getFirst((Pair)librarySourceRootInfo), (MultiMap<VirtualFile, OrderEntry>)this.myLibClassRootEntries, (MultiMap<VirtualFile, OrderEntry>)this.myLibSourceRootEntries));
            VirtualFile moduleContentRoot = this.myRootInfo.findNearestContentRoot(roots);
            if (moduleContentRoot != null) {
                ContainerUtil.addIfNotNull(result2, (Object)this.myRootInfo.getModuleSourceEntry(roots, moduleContentRoot, (MultiMap<VirtualFile, OrderEntry>)this.myLibClassRootEntries));
            }
            Collections.sort(result2, BY_OWNER_MODULE);
            ArrayList<OrderEntry> arrayList = result2;
            if (arrayList == null) {
                OrderEntryGraph.$$$reportNull$$$0(6);
            }
            return arrayList;
        }

        @NotNull
        Set<String> getDependentUnloadedModules(@NotNull Module module) {
            if (module == null) {
                OrderEntryGraph.$$$reportNull$$$0(7);
            }
            Set<String> set2 = this.myDependentUnloadedModulesCache.get(module);
            if (set2 == null) {
                OrderEntryGraph.$$$reportNull$$$0(8);
            }
            return set2;
        }

        @NotNull
        private Set<String> collectDependentUnloadedModules(@NotNull Module module) {
            Node start2;
            if (module == null) {
                OrderEntryGraph.$$$reportNull$$$0(9);
            }
            if ((start2 = this.myGraph.myNodes.get(module)) == null) {
                Set<String> set2 = Collections.emptySet();
                if (set2 == null) {
                    OrderEntryGraph.$$$reportNull$$$0(10);
                }
                return set2;
            }
            ArrayDeque<Node> stack = new ArrayDeque<Node>();
            stack.push(start2);
            HashSet<Node> seen = new HashSet<Node>();
            Set<String> result2 = null;
            while (!stack.isEmpty()) {
                Node node = (Node)stack.pop();
                if (!seen.add(node)) continue;
                if (node.myUnloadedDependentModules != null) {
                    if (result2 == null) {
                        result2 = new LinkedHashSet<String>(node.myUnloadedDependentModules);
                    } else {
                        result2.addAll(node.myUnloadedDependentModules);
                    }
                }
                for (Edge edge : node.myEdges) {
                    Node targetNode;
                    if (!edge.myRecursive || (targetNode = this.myGraph.myNodes.get(edge.myKey)) == null) continue;
                    stack.push(targetNode);
                }
            }
            Set<String> set3 = result2 != null ? result2 : Collections.emptySet();
            if (set3 == null) {
                OrderEntryGraph.$$$reportNull$$$0(11);
            }
            return set3;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 5: 
                case 6: 
                case 8: 
                case 10: 
                case 11: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 5: 
                case 6: 
                case 8: 
                case 10: 
                case 11: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rootInfo";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 3: 
                case 5: 
                case 6: 
                case 8: 
                case 10: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/roots/impl/RootIndex$OrderEntryGraph";
                    break;
                }
                case 7: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/roots/impl/RootIndex$OrderEntryGraph";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOrderEntries";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "collectOrderEntries";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDependentUnloadedModules";
                    break;
                }
                case 10: 
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "collectDependentUnloadedModules";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getOrderEntries";
                    break;
                }
                case 3: 
                case 5: 
                case 6: 
                case 8: 
                case 10: 
                case 11: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "collectOrderEntries";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "getDependentUnloadedModules";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "collectDependentUnloadedModules";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 5: 
                case 6: 
                case 8: 
                case 10: 
                case 11: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private static class Graph {
            Map<Module, Node> myNodes = new HashMap<Module, Node>();

            private Graph() {
            }
        }

        private static class Node {
            Module myKey;
            List<Edge> myEdges = new ArrayList<Edge>();
            Set<String> myUnloadedDependentModules;

            private Node() {
            }

            public String toString() {
                return this.myKey.toString();
            }
        }

        private static class Edge {
            Module myKey;
            ModuleOrderEntry myOrderEntry;
            boolean myRecursive;

            Edge(@NotNull Module key, @NotNull ModuleOrderEntry orderEntry, boolean recursive) {
                if (key == null) {
                    Edge.$$$reportNull$$$0(0);
                }
                if (orderEntry == null) {
                    Edge.$$$reportNull$$$0(1);
                }
                this.myKey = key;
                this.myOrderEntry = orderEntry;
                this.myRecursive = recursive;
            }

            public String toString() {
                return this.myOrderEntry.toString();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "key";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "orderEntry";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/openapi/roots/impl/RootIndex$OrderEntryGraph$Edge";
                objectArray[2] = "<init>";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }
}

