/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleJdkOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.RootPolicy;
import com.intellij.openapi.roots.RootProvider;
import com.intellij.openapi.roots.impl.ClonableOrderEntry;
import com.intellij.openapi.roots.impl.LibraryOrderEntryBaseImpl;
import com.intellij.openapi.roots.impl.OrderEntryFactory;
import com.intellij.openapi.roots.impl.ProjectRootManagerImpl;
import com.intellij.openapi.roots.impl.RootModelImpl;
import com.intellij.openapi.roots.impl.SdkFinder;
import com.intellij.openapi.roots.impl.WritableOrderEntry;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleJdkOrderEntryImpl
extends LibraryOrderEntryBaseImpl
implements WritableOrderEntry,
ClonableOrderEntry,
ModuleJdkOrderEntry,
ProjectJdkTable.Listener {
    @NonNls
    public static final String ENTRY_TYPE = "jdk";
    @NonNls
    private static final String JDK_NAME_ATTR = "jdkName";
    @NonNls
    private static final String JDK_TYPE_ATTR = "jdkType";
    @Nullable
    private Sdk myJdk;
    private String myJdkName;
    private String myJdkType;

    ModuleJdkOrderEntryImpl(@NotNull Sdk projectJdk, @NotNull RootModelImpl rootModel, @NotNull ProjectRootManagerImpl projectRootManager) {
        if (projectJdk == null) {
            ModuleJdkOrderEntryImpl.$$$reportNull$$$0(0);
        }
        if (rootModel == null) {
            ModuleJdkOrderEntryImpl.$$$reportNull$$$0(1);
        }
        if (projectRootManager == null) {
            ModuleJdkOrderEntryImpl.$$$reportNull$$$0(2);
        }
        super(rootModel, projectRootManager);
        this.init(projectJdk, null, null);
    }

    ModuleJdkOrderEntryImpl(@NotNull Element element, @NotNull RootModelImpl rootModel, @NotNull ProjectRootManagerImpl projectRootManager) throws InvalidDataException {
        Sdk jdkByName;
        if (element == null) {
            ModuleJdkOrderEntryImpl.$$$reportNull$$$0(3);
        }
        if (rootModel == null) {
            ModuleJdkOrderEntryImpl.$$$reportNull$$$0(4);
        }
        if (projectRootManager == null) {
            ModuleJdkOrderEntryImpl.$$$reportNull$$$0(5);
        }
        super(rootModel, projectRootManager);
        if (!element.getName().equals("orderEntry")) {
            throw new InvalidDataException();
        }
        Attribute jdkNameAttribute = element.getAttribute(JDK_NAME_ATTR);
        if (jdkNameAttribute == null) {
            throw new InvalidDataException();
        }
        String jdkName = jdkNameAttribute.getValue();
        String jdkType = element.getAttributeValue(JDK_TYPE_ATTR);
        Sdk sdk = jdkByName = jdkType == null ? null : ModuleJdkOrderEntryImpl.findJdk(jdkName, jdkType);
        if (jdkByName == null) {
            this.init(null, jdkName, jdkType);
        } else {
            this.init(jdkByName, null, null);
        }
    }

    @Nullable
    private static Sdk findJdk(@NotNull String sdkName, @NotNull String sdkType) {
        if (sdkName == null) {
            ModuleJdkOrderEntryImpl.$$$reportNull$$$0(6);
        }
        if (sdkType == null) {
            ModuleJdkOrderEntryImpl.$$$reportNull$$$0(7);
        }
        for (SdkFinder sdkFinder : (SdkFinder[])SdkFinder.EP_NAME.getExtensions()) {
            Sdk sdk = sdkFinder.findSdk(sdkName, sdkType);
            if (sdk == null) continue;
            return sdk;
        }
        ProjectJdkTable projectJdkTable = ProjectJdkTable.getInstance();
        return projectJdkTable.findJdk(sdkName, sdkType);
    }

    private ModuleJdkOrderEntryImpl(@NotNull ModuleJdkOrderEntryImpl that, @NotNull RootModelImpl rootModel, @NotNull ProjectRootManagerImpl projectRootManager) {
        if (that == null) {
            ModuleJdkOrderEntryImpl.$$$reportNull$$$0(8);
        }
        if (rootModel == null) {
            ModuleJdkOrderEntryImpl.$$$reportNull$$$0(9);
        }
        if (projectRootManager == null) {
            ModuleJdkOrderEntryImpl.$$$reportNull$$$0(10);
        }
        super(rootModel, projectRootManager);
        this.init(that.myJdk, that.getJdkName(), that.getJdkType());
    }

    ModuleJdkOrderEntryImpl(String jdkName, String jdkType, @NotNull RootModelImpl rootModel, @NotNull ProjectRootManagerImpl projectRootManager) {
        if (rootModel == null) {
            ModuleJdkOrderEntryImpl.$$$reportNull$$$0(11);
        }
        if (projectRootManager == null) {
            ModuleJdkOrderEntryImpl.$$$reportNull$$$0(12);
        }
        super(rootModel, projectRootManager);
        this.init(null, jdkName, jdkType);
    }

    private void init(Sdk jdk, String jdkName, String jdkType) {
        this.myJdk = jdk;
        this.setJdkName(jdkName);
        this.setJdkType(jdkType);
        this.myProjectRootManagerImpl.addJdkTableListener(this, this);
        this.init();
    }

    private String getJdkType() {
        if (this.myJdk != null) {
            return this.myJdk.getSdkType().getName();
        }
        return this.myJdkType;
    }

    @Override
    protected RootProvider getRootProvider() {
        return this.myJdk == null ? null : this.myJdk.getRootProvider();
    }

    @Nullable
    public Sdk getJdk() {
        return this.getRootModel().getConfigurationAccessor().getSdk(this.myJdk, this.myJdkName);
    }

    @Nullable
    public String getJdkName() {
        if (this.myJdkName != null) {
            return this.myJdkName;
        }
        Sdk jdk = this.getJdk();
        if (jdk != null) {
            return jdk.getName();
        }
        return null;
    }

    public boolean isSynthetic() {
        return true;
    }

    @NotNull
    public String getPresentableName() {
        String string = "< " + (this.myJdk == null ? this.getJdkName() : this.myJdk.getName()) + " >";
        if (string == null) {
            ModuleJdkOrderEntryImpl.$$$reportNull$$$0(13);
        }
        return string;
    }

    public boolean isValid() {
        return !this.isDisposed() && this.getJdk() != null;
    }

    public <R> R accept(@NotNull RootPolicy<R> policy, R initialValue) {
        if (policy == null) {
            ModuleJdkOrderEntryImpl.$$$reportNull$$$0(14);
        }
        return (R)policy.visitModuleJdkOrderEntry((ModuleJdkOrderEntry)this, initialValue);
    }

    public void jdkAdded(@NotNull Sdk jdk) {
        if (jdk == null) {
            ModuleJdkOrderEntryImpl.$$$reportNull$$$0(15);
        }
        if (this.myJdk == null && jdk.getName().equals(this.getJdkName())) {
            this.myJdk = jdk;
            this.setJdkName(null);
            this.setJdkType(null);
            this.updateFromRootProviderAndSubscribe();
        }
    }

    public void jdkNameChanged(@NotNull Sdk jdk, @NotNull String previousName) {
        if (jdk == null) {
            ModuleJdkOrderEntryImpl.$$$reportNull$$$0(16);
        }
        if (previousName == null) {
            ModuleJdkOrderEntryImpl.$$$reportNull$$$0(17);
        }
        if (this.myJdk == null && jdk.getName().equals(this.getJdkName())) {
            this.myJdk = jdk;
            this.setJdkName(null);
            this.setJdkType(null);
            this.updateFromRootProviderAndSubscribe();
        }
    }

    public void jdkRemoved(@NotNull Sdk jdk) {
        if (jdk == null) {
            ModuleJdkOrderEntryImpl.$$$reportNull$$$0(18);
        }
        if (jdk == this.myJdk) {
            this.setJdkName(this.myJdk.getName());
            this.setJdkType(this.myJdk.getSdkType().getName());
            this.myJdk = null;
            this.updateFromRootProviderAndSubscribe();
        }
    }

    @Override
    public void writeExternal(@NotNull Element rootElement) throws WriteExternalException {
        String jdkType;
        if (rootElement == null) {
            ModuleJdkOrderEntryImpl.$$$reportNull$$$0(19);
        }
        Element element = OrderEntryFactory.createOrderEntryElement(ENTRY_TYPE);
        String jdkName = this.getJdkName();
        if (jdkName != null) {
            element.setAttribute(JDK_NAME_ATTR, jdkName);
        }
        if ((jdkType = this.getJdkType()) != null) {
            element.setAttribute(JDK_TYPE_ATTR, jdkType);
        }
        rootElement.addContent(element);
    }

    @Override
    @NotNull
    public OrderEntry cloneEntry(@NotNull RootModelImpl rootModel, @NotNull ProjectRootManagerImpl projectRootManager, @NotNull VirtualFilePointerManager filePointerManager) {
        if (rootModel == null) {
            ModuleJdkOrderEntryImpl.$$$reportNull$$$0(20);
        }
        if (projectRootManager == null) {
            ModuleJdkOrderEntryImpl.$$$reportNull$$$0(21);
        }
        if (filePointerManager == null) {
            ModuleJdkOrderEntryImpl.$$$reportNull$$$0(22);
        }
        ModuleJdkOrderEntryImpl moduleJdkOrderEntryImpl = new ModuleJdkOrderEntryImpl(this, rootModel, ProjectRootManagerImpl.getInstanceImpl(this.getRootModel().getModule().getProject()));
        if (moduleJdkOrderEntryImpl == null) {
            ModuleJdkOrderEntryImpl.$$$reportNull$$$0(23);
        }
        return moduleJdkOrderEntryImpl;
    }

    private void setJdkName(String jdkName) {
        this.myJdkName = jdkName;
    }

    private void setJdkType(String jdkType) {
        this.myJdkType = jdkType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: 
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 13: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectJdk";
                break;
            }
            case 1: 
            case 4: 
            case 9: 
            case 11: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootModel";
                break;
            }
            case 2: 
            case 5: 
            case 10: 
            case 12: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectRootManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkType";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "that";
                break;
            }
            case 13: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/impl/ModuleJdkOrderEntryImpl";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "policy";
                break;
            }
            case 15: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = ENTRY_TYPE;
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "previousName";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootElement";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePointerManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/impl/ModuleJdkOrderEntryImpl";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "cloneEntry";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findJdk";
                break;
            }
            case 13: 
            case 23: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "jdkAdded";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "jdkNameChanged";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "jdkRemoved";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "cloneEntry";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 13: 
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

