/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap.impl;

import com.intellij.openapi.util.InvalidDataException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;

public class Converter01 {
    @NonNls
    private static final String KEY_MAP = "keymap";
    @NonNls
    private static final String UNKNOWN_ELEMENT = "unknown element: ";
    @NonNls
    private static final String UNKNOWN_VERSION = "unknown version: ";
    @NonNls
    private static final String VERSION = "version";
    @NonNls
    private static final String DISABLE_MNEMONICS = "disableMnemonics";
    @NonNls
    private static final String DISABLE_MNEMONICS_ATTRIBUTE = "disable-Mnemonics";
    @NonNls
    private static final String NAME_ATTRIBUTE = "name";
    @NonNls
    private static final String BINDING = "binding";
    @NonNls
    private static final String ID_ATTRIBUTE = "id";
    @NonNls
    private static final String KEYSTROKE_ATTRIBUTE = "keystroke";
    @NonNls
    private static final String SUFFIX_ATTRIBUTE = "suffix";
    @NonNls
    private static final String KEYBOARD_SHORTCUT = "keyboard-shortcut";
    @NonNls
    private static final String FIRST_KEYSTROKE_ATTRIBUTE = "first-keystroke";
    @NonNls
    private static final String SECOND_KEYSTROKE_ATTRIBUTE = "second-keystroke";
    @NonNls
    private static final String MOUSE_SHORTCUT = "mouse-shortcut";
    @NonNls
    private static final String ACTION = "action";

    public static void convert(Element keymapElement) throws InvalidDataException {
        ArrayList<Element> elements;
        if (!KEY_MAP.equals(keymapElement.getName())) {
            throw new IllegalArgumentException(UNKNOWN_ELEMENT + keymapElement);
        }
        String version2 = keymapElement.getAttributeValue(VERSION);
        if (version2 != null) {
            throw new InvalidDataException(UNKNOWN_VERSION + version2);
        }
        keymapElement.setAttribute(VERSION, Integer.toString(1));
        boolean disableMnemonics = Boolean.valueOf(DISABLE_MNEMONICS);
        keymapElement.removeAttribute(DISABLE_MNEMONICS);
        keymapElement.setAttribute(DISABLE_MNEMONICS_ATTRIBUTE, Boolean.toString(disableMnemonics));
        String name = keymapElement.getAttributeValue(NAME_ATTRIBUTE);
        if (name == null) {
            throw new InvalidDataException("Attribute 'name' of <keymap> must be specified");
        }
        HashMap id2elements = new HashMap();
        Iterator i = keymapElement.getChildren().iterator();
        while (i.hasNext()) {
            String id;
            Element oldChild = (Element)i.next();
            if (BINDING.equals(oldChild.getName())) {
                id = oldChild.getAttributeValue(ID_ATTRIBUTE);
                if (id == null) {
                    throw new InvalidDataException("attribute 'id' must be specified");
                }
                String keystroke = oldChild.getAttributeValue(KEYSTROKE_ATTRIBUTE);
                String suffix = oldChild.getAttributeValue(SUFFIX_ATTRIBUTE);
                if (keystroke != null) {
                    ArrayList<Element> elements2;
                    Element newChild = new Element(KEYBOARD_SHORTCUT);
                    newChild.setAttribute(FIRST_KEYSTROKE_ATTRIBUTE, keystroke);
                    if (suffix != null) {
                        newChild.setAttribute(SECOND_KEYSTROKE_ATTRIBUTE, suffix);
                    }
                    if ((elements2 = (ArrayList<Element>)id2elements.get(id)) == null) {
                        elements2 = new ArrayList<Element>(2);
                        id2elements.put(id, elements2);
                    }
                    elements2.add(newChild);
                } else {
                    id2elements.put(id, new ArrayList(0));
                }
                i.remove();
                continue;
            }
            if (MOUSE_SHORTCUT.equals(oldChild.getName())) {
                id = oldChild.getAttributeValue(ID_ATTRIBUTE);
                if (id == null) {
                    throw new InvalidDataException("Attribute 'id' of <mouse-shortcut> must be specified; keymap name=" + name);
                }
                oldChild.removeAttribute(ID_ATTRIBUTE);
                i.remove();
                elements = (ArrayList)id2elements.get(id);
                if (elements == null) {
                    elements = new ArrayList<Element>(2);
                    id2elements.put(id, elements);
                }
                elements.add(oldChild);
                continue;
            }
            throw new InvalidDataException("unknown element : " + oldChild.getName());
        }
        for (String id : id2elements.keySet()) {
            Element actionElement = new Element(ACTION);
            actionElement.setAttribute(ID_ATTRIBUTE, id);
            elements = (ArrayList<Element>)id2elements.get(id);
            for (Element newChild : elements) {
                actionElement.addContent(newChild);
            }
            keymapElement.addContent(actionElement);
        }
    }
}

