/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl.text;

import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.TextEditorLocation;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.fileEditor.impl.text.AsyncEditorLoader;
import com.intellij.openapi.fileEditor.impl.text.TextEditorComponent;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.fileEditor.impl.text.TextEditorState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextEditorImpl
extends UserDataHolderBase
implements TextEditor {
    private static final Logger LOG = Logger.getInstance(TextEditorImpl.class);
    private static final Key<TransientEditorState> TRANSIENT_EDITOR_STATE_KEY = Key.create((String)"transientState");
    protected final Project myProject;
    private final PropertyChangeSupport myChangeSupport;
    @NotNull
    private final TextEditorComponent myComponent;
    @NotNull
    protected final VirtualFile myFile;
    private final AsyncEditorLoader myAsyncLoader;
    private final Future<?> myLoadingFinished;

    TextEditorImpl(@NotNull Project project, @NotNull VirtualFile file2, TextEditorProvider provider) {
        if (project == null) {
            TextEditorImpl.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            TextEditorImpl.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myFile = file2;
        this.myChangeSupport = new PropertyChangeSupport((Object)this);
        this.myComponent = this.createEditorComponent(project, file2);
        TransientEditorState state = (TransientEditorState)this.myFile.getUserData(TRANSIENT_EDITOR_STATE_KEY);
        if (state != null) {
            state.applyTo(this.getEditor());
            this.myFile.putUserData(TRANSIENT_EDITOR_STATE_KEY, null);
        }
        Disposer.register((Disposable)this, (Disposable)this.myComponent);
        this.myAsyncLoader = new AsyncEditorLoader(this, this.myComponent, provider);
        this.myLoadingFinished = this.myAsyncLoader.start();
    }

    @NotNull
    protected AsyncEditorLoader.LoadEditorResult loadEditorInBackground() {
        EditorColorsScheme scheme2 = EditorColorsManager.getInstance().getGlobalScheme();
        EditorHighlighter highlighter = EditorHighlighterFactory.getInstance().createEditorHighlighter(this.myFile, scheme2, this.myProject);
        EditorEx editor = (EditorEx)this.getEditor();
        highlighter.setText(editor.getDocument().getImmutableCharSequence());
        long stamp = editor.getDocument().getModificationStamp();
        Language language = TextEditorImpl.getDocumentLanguage(editor);
        AsyncEditorLoader.LoadEditorResult loadEditorResult = new AsyncEditorLoader.LoadEditorResult(document -> stamp == document.getModificationStamp(), () -> {
            editor.getSettings().setLanguage(language);
            editor.setHighlighter(highlighter);
        });
        if (loadEditorResult == null) {
            TextEditorImpl.$$$reportNull$$$0(2);
        }
        return loadEditorResult;
    }

    @Nullable
    public static Language getDocumentLanguage(@NotNull Editor editor) {
        Project project;
        if (editor == null) {
            TextEditorImpl.$$$reportNull$$$0(3);
        }
        LOG.assertTrue((project = editor.getProject()) != null);
        if (!project.isDisposed()) {
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
            PsiFile file2 = documentManager.getPsiFile(editor.getDocument());
            if (file2 != null) {
                return file2.getLanguage();
            }
        } else {
            LOG.warn("Attempting to get a language for document on a disposed project: " + project.getName());
        }
        return null;
    }

    @NotNull
    protected TextEditorComponent createEditorComponent(Project project, VirtualFile file2) {
        TextEditorComponent textEditorComponent = new TextEditorComponent(project, file2, this);
        if (textEditorComponent == null) {
            TextEditorImpl.$$$reportNull$$$0(4);
        }
        return textEditorComponent;
    }

    public void dispose() {
        if (Boolean.TRUE.equals(this.myFile.getUserData(FileEditorManagerImpl.CLOSING_TO_REOPEN))) {
            this.myFile.putUserData(TRANSIENT_EDITOR_STATE_KEY, (Object)TransientEditorState.forEditor(this.getEditor()));
        }
    }

    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile = this.myFile;
        if (virtualFile == null) {
            TextEditorImpl.$$$reportNull$$$0(5);
        }
        return virtualFile;
    }

    @NotNull
    public TextEditorComponent getComponent() {
        TextEditorComponent textEditorComponent = this.myComponent;
        if (textEditorComponent == null) {
            TextEditorImpl.$$$reportNull$$$0(6);
        }
        return textEditorComponent;
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        JComponent jComponent = this.getActiveEditor().getContentComponent();
        if (jComponent == null) {
            TextEditorImpl.$$$reportNull$$$0(7);
        }
        return jComponent;
    }

    @NotNull
    public Editor getEditor() {
        Editor editor = this.getActiveEditor();
        if (editor == null) {
            TextEditorImpl.$$$reportNull$$$0(8);
        }
        return editor;
    }

    @NotNull
    private Editor getActiveEditor() {
        Editor editor = this.myComponent.getEditor();
        if (editor == null) {
            TextEditorImpl.$$$reportNull$$$0(9);
        }
        return editor;
    }

    @NotNull
    public String getName() {
        if ("Text" == null) {
            TextEditorImpl.$$$reportNull$$$0(10);
        }
        return "Text";
    }

    @NotNull
    public FileEditorState getState(@NotNull FileEditorStateLevel level) {
        if (level == null) {
            TextEditorImpl.$$$reportNull$$$0(11);
        }
        TextEditorState textEditorState = this.myAsyncLoader.getEditorState(level);
        if (textEditorState == null) {
            TextEditorImpl.$$$reportNull$$$0(12);
        }
        return textEditorState;
    }

    public void setState(@NotNull FileEditorState state) {
        if (state == null) {
            TextEditorImpl.$$$reportNull$$$0(13);
        }
        this.setState(state, false);
    }

    public void setState(@NotNull FileEditorState state, boolean exactState) {
        if (state == null) {
            TextEditorImpl.$$$reportNull$$$0(14);
        }
        if (state instanceof TextEditorState) {
            this.myAsyncLoader.setEditorState((TextEditorState)state, exactState);
        }
    }

    public boolean isModified() {
        return this.myComponent.isModified();
    }

    public boolean isValid() {
        return this.myComponent.isEditorValid();
    }

    public void selectNotify() {
        this.myComponent.selectNotify();
    }

    public void deselectNotify() {
    }

    public void updateModifiedProperty() {
        this.myComponent.updateModifiedProperty();
    }

    void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.myChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        if (listener2 == null) {
            TextEditorImpl.$$$reportNull$$$0(15);
        }
        this.myChangeSupport.addPropertyChangeListener(listener2);
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        if (listener2 == null) {
            TextEditorImpl.$$$reportNull$$$0(16);
        }
        this.myChangeSupport.removePropertyChangeListener(listener2);
    }

    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        return null;
    }

    public FileEditorLocation getCurrentLocation() {
        return new TextEditorLocation(this.getEditor().getCaretModel().getLogicalPosition(), (TextEditor)this);
    }

    public StructureViewBuilder getStructureViewBuilder() {
        Document document = this.myComponent.getEditor().getDocument();
        VirtualFile file2 = FileDocumentManager.getInstance().getFile(document);
        if (file2 == null || !file2.isValid()) {
            return null;
        }
        return StructureViewBuilder.PROVIDER.getStructureViewBuilder(file2.getFileType(), file2, this.myProject);
    }

    public boolean canNavigateTo(@NotNull Navigatable navigatable) {
        if (navigatable == null) {
            TextEditorImpl.$$$reportNull$$$0(17);
        }
        return navigatable instanceof OpenFileDescriptor && (((OpenFileDescriptor)navigatable).getLine() >= 0 || ((OpenFileDescriptor)navigatable).getOffset() >= 0);
    }

    public void navigateTo(@NotNull Navigatable navigatable) {
        if (navigatable == null) {
            TextEditorImpl.$$$reportNull$$$0(18);
        }
        ((OpenFileDescriptor)navigatable).navigateIn(this.getEditor());
    }

    public String toString() {
        return "Editor: " + this.myComponent.getFile();
    }

    /*
     * WARNING - void declaration
     */
    public void waitForLoaded(long timeout, @NotNull TimeUnit timeUnit) throws TimeoutException {
        if (timeUnit == null) {
            TextEditorImpl.$$$reportNull$$$0(19);
        }
        try {
            void unit;
            this.myLoadingFinished.get(timeout, (TimeUnit)unit);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileEditor/impl/text/TextEditorImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "navigatable";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unit";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileEditor/impl/text/TextEditorImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "loadEditorInBackground";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditorComponent";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredFocusedComponent";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditor";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveEditor";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getDocumentLanguage";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setState";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addPropertyChangeListener";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "removePropertyChangeListener";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "canNavigateTo";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "navigateTo";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "waitForLoaded";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class TransientEditorState {
        private boolean softWrapsEnabled;

        private TransientEditorState() {
        }

        private static TransientEditorState forEditor(Editor editor) {
            TransientEditorState state = new TransientEditorState();
            state.softWrapsEnabled = editor.getSettings().isUseSoftWraps();
            return state;
        }

        private void applyTo(Editor editor) {
            editor.getSettings().setUseSoftWraps(this.softWrapsEnabled);
        }
    }
}

