/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.ide.RemoteDesktopService;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.VisibleAreaEvent;
import com.intellij.openapi.editor.event.VisibleAreaListener;
import com.intellij.openapi.editor.ex.ScrollingModelEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.ScrollRequestListener;
import com.intellij.openapi.editor.impl.VisibleEditorsTracker;
import com.intellij.openapi.fileEditor.impl.text.AsyncEditorLoader;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.components.Interpolable;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.Animator;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScrollingModelImpl
implements ScrollingModelEx {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.editor.impl.ScrollingModelImpl");
    private final EditorImpl myEditor;
    private final List<VisibleAreaListener> myVisibleAreaListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private final List<ScrollRequestListener> myScrollRequestListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private AnimatedScrollingRunnable myCurrentAnimationRequest;
    private boolean myAnimationDisabled;
    private int myAccumulatedXOffset = -1;
    private int myAccumulatedYOffset = -1;
    private boolean myAccumulateViewportChanges;
    private boolean myViewportPositioned;
    private final DocumentListener myDocumentListener = new DocumentListener(){

        public void beforeDocumentChange(@NotNull DocumentEvent e) {
            if (e == null) {
                1.$$$reportNull$$$0(0);
            }
            if (!ScrollingModelImpl.this.myEditor.getDocument().isInBulkUpdate()) {
                ScrollingModelImpl.this.cancelAnimatedScrolling(true);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/ScrollingModelImpl$1", "beforeDocumentChange"));
        }
    };
    private final ChangeListener myViewportChangeListener = new ChangeListener(){
        private Rectangle myLastViewRect;

        @Override
        public void stateChanged(ChangeEvent event) {
            Rectangle viewRect = ScrollingModelImpl.this.getVisibleArea();
            VisibleAreaEvent visibleAreaEvent = new VisibleAreaEvent((Editor)ScrollingModelImpl.this.myEditor, this.myLastViewRect, viewRect);
            if (!ScrollingModelImpl.this.myViewportPositioned && viewRect.height > 0) {
                ScrollingModelImpl.this.myViewportPositioned = true;
                if (ScrollingModelImpl.this.adjustVerticalOffsetIfNecessary()) {
                    return;
                }
            }
            this.myLastViewRect = viewRect;
            for (VisibleAreaListener listener2 : ScrollingModelImpl.this.myVisibleAreaListeners) {
                listener2.visibleAreaChanged(visibleAreaEvent);
            }
        }
    };

    public ScrollingModelImpl(EditorImpl editor) {
        this.myEditor = editor;
        this.myEditor.getScrollPane().getViewport().addChangeListener(this.myViewportChangeListener);
        this.myEditor.getDocument().addDocumentListener(this.myDocumentListener);
    }

    private boolean adjustVerticalOffsetIfNecessary() {
        int currentOffset;
        int maxY = Math.max(this.myEditor.getLineHeight(), this.myEditor.getDocument().getLineCount() * this.myEditor.getLineHeight());
        int minPreferredY = maxY - this.getVisibleArea().height * 2 / 3;
        int offsetToUse = Math.min(minPreferredY, currentOffset = this.getVerticalScrollOffset());
        if (offsetToUse != currentOffset) {
            this.scroll(this.getHorizontalScrollOffset(), offsetToUse);
            return true;
        }
        return false;
    }

    @NotNull
    public Rectangle getVisibleArea() {
        ScrollingModelImpl.assertIsDispatchThread();
        Rectangle rectangle = this.myEditor.getScrollPane().getViewport().getViewRect();
        if (rectangle == null) {
            ScrollingModelImpl.$$$reportNull$$$0(0);
        }
        return rectangle;
    }

    @NotNull
    public Rectangle getVisibleAreaOnScrollingFinished() {
        ScrollingModelImpl.assertIsDispatchThread();
        if (SystemProperties.isTrueSmoothScrollingEnabled()) {
            Rectangle viewRect = this.myEditor.getScrollPane().getViewport().getViewRect();
            Rectangle rectangle = new Rectangle(ScrollingModelImpl.getOffset(this.getHorizontalScrollBar()), ScrollingModelImpl.getOffset(this.getVerticalScrollBar()), viewRect.width, viewRect.height);
            if (rectangle == null) {
                ScrollingModelImpl.$$$reportNull$$$0(1);
            }
            return rectangle;
        }
        if (this.myCurrentAnimationRequest != null) {
            Rectangle rectangle = this.myCurrentAnimationRequest.getTargetVisibleArea();
            if (rectangle == null) {
                ScrollingModelImpl.$$$reportNull$$$0(2);
            }
            return rectangle;
        }
        Rectangle rectangle = this.getVisibleArea();
        if (rectangle == null) {
            ScrollingModelImpl.$$$reportNull$$$0(3);
        }
        return rectangle;
    }

    public void scrollToCaret(@NotNull ScrollType scrollType) {
        if (scrollType == null) {
            ScrollingModelImpl.$$$reportNull$$$0(4);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace(new Throwable());
        }
        ScrollingModelImpl.assertIsDispatchThread();
        this.myEditor.validateSize();
        AsyncEditorLoader.performWhenLoaded(this.myEditor, () -> this.scrollTo(this.myEditor.getCaretModel().getVisualPosition(), scrollType));
    }

    private void scrollTo(@NotNull VisualPosition pos, @NotNull ScrollType scrollType) {
        if (pos == null) {
            ScrollingModelImpl.$$$reportNull$$$0(5);
        }
        if (scrollType == null) {
            ScrollingModelImpl.$$$reportNull$$$0(6);
        }
        for (ScrollRequestListener listener2 : this.myScrollRequestListeners) {
            listener2.scrollRequested(this.myEditor.visualToLogicalPosition(pos), scrollType);
        }
        Point targetLocation = this.myEditor.visualPositionToXY(pos);
        this.scrollTo(targetLocation, scrollType);
    }

    private void scrollTo(@NotNull Point targetLocation, @NotNull ScrollType scrollType) {
        AnimatedScrollingRunnable canceledThread;
        if (targetLocation == null) {
            ScrollingModelImpl.$$$reportNull$$$0(7);
        }
        if (scrollType == null) {
            ScrollingModelImpl.$$$reportNull$$$0(8);
        }
        Rectangle viewRect = (canceledThread = this.cancelAnimatedScrolling(false)) != null ? canceledThread.getTargetVisibleArea() : this.getVisibleArea();
        Point p = this.calcOffsetsToScroll(targetLocation, scrollType, viewRect);
        this.scroll(p.x, p.y);
    }

    public void scrollTo(@NotNull LogicalPosition pos, @NotNull ScrollType scrollType) {
        if (pos == null) {
            ScrollingModelImpl.$$$reportNull$$$0(9);
        }
        if (scrollType == null) {
            ScrollingModelImpl.$$$reportNull$$$0(10);
        }
        ScrollingModelImpl.assertIsDispatchThread();
        AsyncEditorLoader.performWhenLoaded(this.myEditor, () -> {
            for (ScrollRequestListener listener2 : this.myScrollRequestListeners) {
                listener2.scrollRequested(pos, scrollType);
            }
            this.scrollTo(this.myEditor.logicalPositionToXY(pos), scrollType);
        });
    }

    private static void assertIsDispatchThread() {
        ApplicationManager.getApplication().assertIsDispatchThread();
    }

    public void runActionOnScrollingFinished(@NotNull Runnable action) {
        if (action == null) {
            ScrollingModelImpl.$$$reportNull$$$0(11);
        }
        ScrollingModelImpl.assertIsDispatchThread();
        if (this.myCurrentAnimationRequest != null) {
            this.myCurrentAnimationRequest.addPostRunnable(action);
            return;
        }
        action.run();
    }

    public boolean isAnimationEnabled() {
        return !this.myAnimationDisabled;
    }

    public void disableAnimation() {
        this.myAnimationDisabled = true;
    }

    public void enableAnimation() {
        this.myAnimationDisabled = false;
    }

    private Point calcOffsetsToScroll(Point targetLocation, ScrollType scrollType, Rectangle viewRect) {
        int hOffset;
        if (this.myEditor.getSettings().isRefrainFromScrolling() && viewRect.contains(targetLocation) && (scrollType == ScrollType.CENTER || scrollType == ScrollType.CENTER_DOWN || scrollType == ScrollType.CENTER_UP)) {
            scrollType = ScrollType.RELATIVE;
        }
        int spaceWidth = EditorUtil.getSpaceWidth(0, this.myEditor);
        int xInsets = this.myEditor.getSettings().getAdditionalColumnsCount() * spaceWidth;
        int n = hOffset = scrollType == ScrollType.CENTER || scrollType == ScrollType.CENTER_DOWN || scrollType == ScrollType.CENTER_UP ? 0 : viewRect.x;
        if (targetLocation.x < hOffset) {
            int inset = 4 * spaceWidth;
            hOffset = scrollType == ScrollType.MAKE_VISIBLE && targetLocation.x < viewRect.width - inset ? 0 : Math.max(0, targetLocation.x - inset);
        } else if (viewRect.width > 0 && targetLocation.x >= hOffset + viewRect.width) {
            hOffset = targetLocation.x - Math.max(0, viewRect.width - xInsets);
        }
        int lineHeight = this.myEditor.getLineHeight();
        int minAcceptableY = viewRect.y + Math.max(0, Math.min(lineHeight, viewRect.height - 3 * lineHeight));
        int maxAcceptableY = viewRect.y + (viewRect.height <= lineHeight ? 0 : viewRect.height - (viewRect.height <= 2 * lineHeight ? lineHeight : 2 * lineHeight));
        int scrollUpBy = minAcceptableY - targetLocation.y;
        int scrollDownBy = targetLocation.y - maxAcceptableY;
        int centerPosition = targetLocation.y - viewRect.height / 3;
        int vOffset = viewRect.y;
        if (scrollType == ScrollType.CENTER) {
            vOffset = centerPosition;
        } else if (scrollType == ScrollType.CENTER_UP) {
            if (scrollUpBy > 0 || scrollDownBy > 0 || vOffset > centerPosition) {
                vOffset = centerPosition;
            }
        } else if (scrollType == ScrollType.CENTER_DOWN) {
            if (scrollUpBy > 0 || scrollDownBy > 0 || vOffset < centerPosition) {
                vOffset = centerPosition;
            }
        } else if (scrollType == ScrollType.RELATIVE) {
            if (scrollUpBy > 0) {
                vOffset = viewRect.y - scrollUpBy;
            } else if (scrollDownBy > 0) {
                vOffset = viewRect.y + scrollDownBy;
            }
        } else if (scrollType == ScrollType.MAKE_VISIBLE && (scrollUpBy > 0 || scrollDownBy > 0)) {
            vOffset = centerPosition;
        }
        JScrollPane scrollPane = this.myEditor.getScrollPane();
        hOffset = Math.max(0, hOffset);
        vOffset = Math.max(0, vOffset);
        hOffset = Math.min(scrollPane.getHorizontalScrollBar().getMaximum() - ScrollingModelImpl.getExtent(scrollPane.getHorizontalScrollBar()), hOffset);
        vOffset = Math.min(scrollPane.getVerticalScrollBar().getMaximum() - ScrollingModelImpl.getExtent(scrollPane.getVerticalScrollBar()), vOffset);
        return new Point(hOffset, vOffset);
    }

    @Nullable
    public JScrollBar getVerticalScrollBar() {
        ScrollingModelImpl.assertIsDispatchThread();
        JScrollPane scrollPane = this.myEditor.getScrollPane();
        return scrollPane.getVerticalScrollBar();
    }

    @Nullable
    public JScrollBar getHorizontalScrollBar() {
        ScrollingModelImpl.assertIsDispatchThread();
        return this.myEditor.getScrollPane().getHorizontalScrollBar();
    }

    public int getVerticalScrollOffset() {
        return ScrollingModelImpl.getOffset(this.getVerticalScrollBar());
    }

    public int getHorizontalScrollOffset() {
        return ScrollingModelImpl.getOffset(this.getHorizontalScrollBar());
    }

    private static int getOffset(JScrollBar scrollBar) {
        return scrollBar == null ? 0 : (scrollBar instanceof Interpolable ? ((Interpolable)scrollBar).getTargetValue() : scrollBar.getValue());
    }

    private static int getExtent(JScrollBar scrollBar) {
        return scrollBar == null ? 0 : scrollBar.getModel().getExtent();
    }

    public void scrollVertically(int scrollOffset) {
        this.scroll(this.getHorizontalScrollOffset(), scrollOffset);
    }

    private void _scrollVertically(int scrollOffset) {
        ScrollingModelImpl.assertIsDispatchThread();
        this.myEditor.validateSize();
        JScrollBar scrollbar = this.myEditor.getScrollPane().getVerticalScrollBar();
        scrollbar.setValue(scrollOffset);
    }

    public void scrollHorizontally(int scrollOffset) {
        this.scroll(scrollOffset, this.getVerticalScrollOffset());
    }

    private void _scrollHorizontally(int scrollOffset) {
        ScrollingModelImpl.assertIsDispatchThread();
        this.myEditor.validateSize();
        JScrollBar scrollbar = this.myEditor.getScrollPane().getHorizontalScrollBar();
        scrollbar.setValue(scrollOffset);
    }

    public void scroll(int hOffset, int vOffset) {
        if (this.myAccumulateViewportChanges) {
            this.myAccumulatedXOffset = hOffset;
            this.myAccumulatedYOffset = vOffset;
            return;
        }
        this.cancelAnimatedScrolling(false);
        VisibleEditorsTracker editorsTracker = VisibleEditorsTracker.getInstance();
        boolean useAnimation = !this.myEditor.getSettings().isAnimatedScrolling() || this.myAnimationDisabled || RemoteDesktopService.isRemoteSession() ? false : (CommandProcessor.getInstance().getCurrentCommand() == null ? this.myEditor.getComponent().isShowing() : (editorsTracker.getCurrentCommandStart() - editorsTracker.getLastCommandFinish() < 100L ? false : editorsTracker.wasEditorVisibleOnCommandStart(this.myEditor)));
        this.cancelAnimatedScrolling(false);
        if (useAnimation) {
            int startHOffset = this.getHorizontalScrollOffset();
            int startVOffset = this.getVerticalScrollOffset();
            if (startHOffset == hOffset && startVOffset == vOffset) {
                return;
            }
            try {
                this.myCurrentAnimationRequest = new AnimatedScrollingRunnable(startHOffset, startVOffset, hOffset, vOffset);
            }
            catch (NoAnimationRequiredException e) {
                this._scrollHorizontally(hOffset);
                this._scrollVertically(vOffset);
            }
        } else {
            this._scrollHorizontally(hOffset);
            this._scrollVertically(vOffset);
        }
    }

    public void addVisibleAreaListener(@NotNull VisibleAreaListener listener2) {
        if (listener2 == null) {
            ScrollingModelImpl.$$$reportNull$$$0(12);
        }
        this.myVisibleAreaListeners.add(listener2);
    }

    public void removeVisibleAreaListener(@NotNull VisibleAreaListener listener2) {
        if (listener2 == null) {
            ScrollingModelImpl.$$$reportNull$$$0(13);
        }
        boolean success2 = this.myVisibleAreaListeners.remove(listener2);
        LOG.assertTrue(success2);
    }

    public void finishAnimation() {
        this.cancelAnimatedScrolling(true);
    }

    @Nullable
    private AnimatedScrollingRunnable cancelAnimatedScrolling(boolean scrollToTarget) {
        AnimatedScrollingRunnable request = this.myCurrentAnimationRequest;
        this.myCurrentAnimationRequest = null;
        if (request != null) {
            request.cancel(scrollToTarget);
        }
        return request;
    }

    public void dispose() {
        this.myEditor.getDocument().removeDocumentListener(this.myDocumentListener);
        this.myEditor.getScrollPane().getViewport().removeChangeListener(this.myViewportChangeListener);
    }

    public void beforeModalityStateChanged() {
        this.cancelAnimatedScrolling(true);
    }

    public boolean isScrollingNow() {
        return this.myCurrentAnimationRequest != null;
    }

    @Override
    public void accumulateViewportChanges() {
        this.myAccumulateViewportChanges = true;
    }

    @Override
    public void flushViewportChanges() {
        this.myAccumulateViewportChanges = false;
        if (this.myAccumulatedXOffset >= 0 && this.myAccumulatedYOffset >= 0) {
            this.scroll(this.myAccumulatedXOffset, this.myAccumulatedYOffset);
            this.myAccumulatedYOffset = -1;
            this.myAccumulatedXOffset = -1;
            this.cancelAnimatedScrolling(true);
        }
    }

    void onBulkDocumentUpdateStarted() {
        this.cancelAnimatedScrolling(true);
    }

    public void addScrollRequestListener(ScrollRequestListener scrollRequestListener, Disposable parentDisposable) {
        this.myScrollRequestListeners.add(scrollRequestListener);
        Disposer.register((Disposable)parentDisposable, () -> this.myScrollRequestListeners.remove(scrollRequestListener));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/ScrollingModelImpl";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scrollType";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pos";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetLocation";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisibleArea";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisibleAreaOnScrollingFinished";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/ScrollingModelImpl";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "scrollToCaret";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "scrollTo";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "runActionOnScrollingFinished";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addVisibleAreaListener";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "removeVisibleAreaListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class NoAnimationRequiredException
    extends Exception {
        private NoAnimationRequiredException() {
        }
    }

    private class AnimatedScrollingRunnable {
        private static final int SCROLL_DURATION = 100;
        private static final int SCROLL_INTERVAL = 10;
        private final int myStartHOffset;
        private final int myStartVOffset;
        private final int myEndHOffset;
        private final int myEndVOffset;
        private final int myAnimationDuration;
        private final ArrayList<Runnable> myPostRunnables = new ArrayList();
        private final int myHDist;
        private final int myVDist;
        private final int myMaxDistToScroll;
        private final double myTotalDist;
        private final double myScrollDist;
        private final int myStepCount;
        private final double myPow;
        private final Animator myAnimator;

        AnimatedScrollingRunnable(int startHOffset, int startVOffset, int endHOffset, int endVOffset) throws NoAnimationRequiredException {
            this.myStartHOffset = startHOffset;
            this.myStartVOffset = startVOffset;
            this.myEndHOffset = endHOffset;
            this.myEndVOffset = endVOffset;
            this.myHDist = Math.abs(this.myEndHOffset - this.myStartHOffset);
            this.myVDist = Math.abs(this.myEndVOffset - this.myStartVOffset);
            this.myMaxDistToScroll = ScrollingModelImpl.this.myEditor.getLineHeight() * 50;
            this.myTotalDist = Math.sqrt((double)this.myHDist * (double)this.myHDist + (double)this.myVDist * (double)this.myVDist);
            this.myScrollDist = Math.min(this.myTotalDist, (double)this.myMaxDistToScroll);
            this.myAnimationDuration = this.calcAnimationDuration();
            if (this.myAnimationDuration < 20) {
                throw new NoAnimationRequiredException();
            }
            this.myStepCount = this.myAnimationDuration / 10 - 1;
            double firstStepTime = 1.0 / (double)this.myStepCount;
            double firstScrollDist = 5.0;
            if (this.myTotalDist > this.myScrollDist) {
                firstScrollDist *= this.myTotalDist / this.myScrollDist;
                firstScrollDist = Math.min(firstScrollDist, (double)(ScrollingModelImpl.this.myEditor.getLineHeight() * 5));
            }
            this.myPow = this.myScrollDist > 0.0 ? this.setupPow(firstStepTime, firstScrollDist / this.myScrollDist) : 1.0;
            this.myAnimator = new Animator("Animated scroller", this.myStepCount, 100, false, true){

                public void paintNow(int frame, int totalFrames, int cycle) {
                    double time = ((double)frame + 1.0) / (double)totalFrames;
                    double fraction = AnimatedScrollingRunnable.this.timeToFraction(time);
                    int hOffset = (int)((double)AnimatedScrollingRunnable.this.myStartHOffset + (double)(AnimatedScrollingRunnable.this.myEndHOffset - AnimatedScrollingRunnable.this.myStartHOffset) * fraction + 0.5);
                    int vOffset = (int)((double)AnimatedScrollingRunnable.this.myStartVOffset + (double)(AnimatedScrollingRunnable.this.myEndVOffset - AnimatedScrollingRunnable.this.myStartVOffset) * fraction + 0.5);
                    ScrollingModelImpl.this._scrollHorizontally(hOffset);
                    ScrollingModelImpl.this._scrollVertically(vOffset);
                }

                protected void paintCycleEnd() {
                    if (!this.isDisposed()) {
                        AnimatedScrollingRunnable.this.finish(true);
                    }
                }
            };
            this.myAnimator.resume();
        }

        @NotNull
        Rectangle getTargetVisibleArea() {
            Rectangle viewRect = ScrollingModelImpl.this.getVisibleArea();
            Rectangle rectangle = new Rectangle(this.myEndHOffset, this.myEndVOffset, viewRect.width, viewRect.height);
            if (rectangle == null) {
                AnimatedScrollingRunnable.$$$reportNull$$$0(0);
            }
            return rectangle;
        }

        public void cancel(boolean scrollToTarget) {
            ScrollingModelImpl.assertIsDispatchThread();
            this.finish(scrollToTarget);
        }

        void addPostRunnable(Runnable runnable2) {
            this.myPostRunnables.add(runnable2);
        }

        private void finish(boolean scrollToTarget) {
            if (scrollToTarget || !this.myPostRunnables.isEmpty()) {
                ScrollingModelImpl.this._scrollHorizontally(this.myEndHOffset);
                ScrollingModelImpl.this._scrollVertically(this.myEndVOffset);
                this.executePostRunnables();
            }
            Disposer.dispose((Disposable)this.myAnimator);
            if (ScrollingModelImpl.this.myCurrentAnimationRequest == this) {
                ScrollingModelImpl.this.myCurrentAnimationRequest = null;
            }
        }

        private void executePostRunnables() {
            for (Runnable runnable2 : this.myPostRunnables) {
                runnable2.run();
            }
        }

        private double timeToFraction(double time) {
            if (time > 0.5) {
                return 1.0 - this.timeToFraction(1.0 - time);
            }
            double fraction = Math.pow(time * 2.0, this.myPow) / 2.0;
            if (this.myTotalDist > (double)this.myMaxDistToScroll) {
                fraction *= (double)this.myMaxDistToScroll / this.myTotalDist;
            }
            return fraction;
        }

        private double setupPow(double inTime, double moveBy) {
            double pow = Math.log(2.0 * moveBy) / Math.log(2.0 * inTime);
            if (pow < 1.0) {
                pow = 1.0;
            }
            return pow;
        }

        private int calcAnimationDuration() {
            int lineHeight = ScrollingModelImpl.this.myEditor.getLineHeight();
            double lineDist = this.myTotalDist / (double)lineHeight;
            double part = (lineDist - 1.0) / 10.0;
            if (part > 1.0) {
                part = 1.0;
            }
            return (int)(part * 100.0);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/ScrollingModelImpl$AnimatedScrollingRunnable", "getTargetVisibleArea"));
        }
    }
}

