/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.util.Key;
import org.jetbrains.annotations.NotNull;

public class EditorMouseHoverPopupControl {
    private static final Logger LOG = Logger.getInstance(EditorMouseHoverPopupControl.class);
    private static final Key<Integer> MOUSE_TRACKING_DISABLED_COUNT = Key.create((String)"MOUSE_TRACKING_DISABLED_COUNT");

    public static void disablePopups(@NotNull Editor editor) {
        if (editor == null) {
            EditorMouseHoverPopupControl.$$$reportNull$$$0(0);
        }
        EditorMouseHoverPopupControl.setTrackingDisabled(editor, true);
    }

    public static void enablePopups(@NotNull Editor editor) {
        if (editor == null) {
            EditorMouseHoverPopupControl.$$$reportNull$$$0(1);
        }
        EditorMouseHoverPopupControl.setTrackingDisabled(editor, false);
    }

    private static void setTrackingDisabled(@NotNull Editor editor, boolean value) {
        if (editor == null) {
            EditorMouseHoverPopupControl.$$$reportNull$$$0(2);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        Integer userData = (Integer)editor.getUserData(MOUSE_TRACKING_DISABLED_COUNT);
        int count = (userData == null ? 0 : userData) + (value ? 1 : -1);
        if (count < 0) {
            LOG.warn((Throwable)new IllegalStateException("Editor mouse hover popups weren't disabled previously"));
            count = 0;
        }
        editor.putUserData(MOUSE_TRACKING_DISABLED_COUNT, (Object)(count == 0 ? null : Integer.valueOf(count)));
    }

    public static boolean arePopupsDisabled(@NotNull Editor editor) {
        if (editor == null) {
            EditorMouseHoverPopupControl.$$$reportNull$$$0(3);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        return editor.getUserData(MOUSE_TRACKING_DISABLED_COUNT) != null || editor.getComponent().getClientProperty(EditorImpl.IGNORE_MOUSE_TRACKING) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "editor";
        objectArray2[1] = "com/intellij/openapi/editor/impl/EditorMouseHoverPopupControl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "disablePopups";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "enablePopups";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setTrackingDisabled";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "arePopupsDisabled";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

