/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.codeInsight.daemon.GutterMark;
import com.intellij.codeInsight.daemon.NonHideableIconGutterMark;
import com.intellij.codeInsight.folding.impl.FoldingUtil;
import com.intellij.codeInsight.hint.TooltipController;
import com.intellij.codeInsight.hint.TooltipGroup;
import com.intellij.codeInsight.hint.TooltipRenderer;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.dnd.DnDDragStartBean;
import com.intellij.ide.dnd.DnDImage;
import com.intellij.ide.dnd.DnDNativeTarget;
import com.intellij.ide.dnd.DnDSupport;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.customization.CustomActionsSchema;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorBundle;
import com.intellij.openapi.editor.EditorGutter;
import com.intellij.openapi.editor.EditorGutterAction;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingGroup;
import com.intellij.openapi.editor.GutterMarkPreprocessor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.TextAnnotationGutterProvider;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.ex.EditorMarkupModel;
import com.intellij.openapi.editor.ex.MarkupIterator;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.ex.util.EditorUIUtil;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.AccessibleGutterLine;
import com.intellij.openapi.editor.impl.DisplayedFoldingAnchor;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.FoldingAnchorsOverlayStrategy;
import com.intellij.openapi.editor.impl.view.IterationState;
import com.intellij.openapi.editor.impl.view.VisualLinesIterator;
import com.intellij.openapi.editor.markup.ActiveGutterRenderer;
import com.intellij.openapi.editor.markup.GutterDraggableObject;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.LineMarkerRenderer;
import com.intellij.openapi.editor.markup.LineMarkerRendererEx;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.impl.IdeGlassPaneImpl;
import com.intellij.ui.HintHint;
import com.intellij.ui.JBColor;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.paint.LinePainter2D;
import com.intellij.ui.paint.PaintUtil;
import com.intellij.ui.paint.RectanglePainter2D;
import com.intellij.util.BitUtil;
import com.intellij.util.Function;
import com.intellij.util.IconUtil;
import com.intellij.util.NullableFunction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBSwingUtilities;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.JBValue;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.ScreenReader;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntFunction;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TIntObjectProcedure;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ComponentEvent;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class EditorGutterComponentImpl
extends EditorGutterComponentEx
implements MouseListener,
MouseMotionListener,
DataProvider,
Accessible {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.editor.impl.EditorGutterComponentImpl");
    private static final JBValue.JBValueGroup JBVG = new JBValue.JBValueGroup();
    private static final JBValue START_ICON_AREA_WIDTH = JBVG.value(17.0f);
    private static final JBValue FREE_PAINTERS_LEFT_AREA_WIDTH = JBVG.value(8.0f);
    private static final JBValue FREE_PAINTERS_RIGHT_AREA_WIDTH = JBVG.value(5.0f);
    private static final JBValue GAP_BETWEEN_ICONS = JBVG.value(3.0f);
    private static final JBValue GAP_BETWEEN_AREAS = JBVG.value(5.0f);
    private static final JBValue GAP_BETWEEN_ANNOTATIONS = JBVG.value(5.0f);
    private static final TooltipGroup GUTTER_TOOLTIP_GROUP = new TooltipGroup("GUTTER_TOOLTIP_GROUP", 0);
    private int myLogicalLineAtCursor;
    private final EditorImpl myEditor;
    private final FoldingAnchorsOverlayStrategy myAnchorsDisplayStrategy;
    @Nullable
    private TIntObjectHashMap<List<GutterMark>> myLineToGutterRenderers;
    private boolean myLineToGutterRenderersCacheForLogicalLines;
    private int myStartIconAreaWidth;
    private int myIconsAreaWidth;
    private int myLineNumberAreaWidth;
    private int myAdditionalLineNumberAreaWidth;
    @NotNull
    private List<FoldRegion> myActiveFoldRegions;
    private int myTextAnnotationGuttersSize;
    private int myTextAnnotationExtraSize;
    TIntArrayList myTextAnnotationGutterSizes;
    ArrayList<TextAnnotationGutterProvider> myTextAnnotationGutters;
    private final Map<TextAnnotationGutterProvider, EditorGutterAction> myProviderToListener;
    private String myLastGutterToolTip;
    @NotNull
    private TIntFunction myLineNumberConvertor;
    @Nullable
    private TIntFunction myAdditionalLineNumberConvertor;
    private boolean myShowDefaultGutterPopup;
    private boolean myCanCloseAnnotations;
    @Nullable
    private ActionGroup myCustomGutterPopupGroup;
    private final TIntObjectHashMap<Color> myTextFgColors;
    private boolean myPaintBackground;
    private boolean myLeftFreePaintersAreaShown;
    private boolean myRightFreePaintersAreaShown;
    boolean myForceLeftFreePaintersAreaShown;
    boolean myForceRightFreePaintersAreaShown;
    private int myLastNonDumbModeIconAreaWidth;
    boolean myDnDInProgress;
    @Nullable
    private AccessibleGutterLine myAccessibleGutterLine;
    private GutterIconRenderer myCalculatingInBackground;
    private ProgressIndicator myBackgroundIndicator;

    EditorGutterComponentImpl(@NotNull EditorImpl editor) {
        if (editor == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(0);
        }
        this.myStartIconAreaWidth = START_ICON_AREA_WIDTH.get();
        this.myActiveFoldRegions = Collections.emptyList();
        this.myTextAnnotationGutterSizes = new TIntArrayList();
        this.myTextAnnotationGutters = new ArrayList();
        this.myProviderToListener = new HashMap<TextAnnotationGutterProvider, EditorGutterAction>();
        this.myLineNumberConvertor = value -> value;
        this.myShowDefaultGutterPopup = true;
        this.myCanCloseAnnotations = true;
        this.myTextFgColors = new TIntObjectHashMap();
        this.myPaintBackground = true;
        this.myBackgroundIndicator = new EmptyProgressIndicator();
        this.myEditor = editor;
        if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
            this.installDnD();
        }
        this.setOpaque(true);
        this.myAnchorsDisplayStrategy = new FoldingAnchorsOverlayStrategy(editor);
        Project project = this.myEditor.getProject();
        if (project != null) {
            project.getMessageBus().connect(this.myEditor.getDisposable()).subscribe(DumbService.DUMB_MODE, (Object)new DumbService.DumbModeListener(){

                public void exitDumbMode() {
                    EditorGutterComponentImpl.this.updateSize();
                }
            });
        }
        if (ScreenReader.isActive()) {
            AccessibleGutterLine.installListeners(this);
        } else {
            ScreenReader.addPropertyChangeListener((String)"ScreenReader.active", (Disposable)editor.getDisposable(), e -> {
                if (((Boolean)e.getNewValue()).booleanValue()) {
                    AccessibleGutterLine.installListeners(this);
                }
            });
        }
        UISettings.setupEditorAntialiasing((JComponent)this);
    }

    @NotNull
    EditorImpl getEditor() {
        EditorImpl editorImpl = this.myEditor;
        if (editorImpl == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(1);
        }
        return editorImpl;
    }

    private void installDnD() {
        DnDSupport.createBuilder((JComponent)this).setBeanProvider(info -> {
            GutterMark renderer2 = this.getGutterRenderer(info.getPoint());
            if (renderer2 instanceof GutterIconRenderer && ((GutterIconRenderer)renderer2).getDraggableObject() != null && (info.isCopy() || info.isMove())) {
                this.myDnDInProgress = true;
                return new DnDDragStartBean((Object)renderer2);
            }
            return null;
        }).setDropHandler(e -> {
            Transferable transferable;
            Object attachedObject = e.getAttachedObject();
            if (attachedObject instanceof GutterIconRenderer && this.checkDumbAware(attachedObject)) {
                int line;
                GutterDraggableObject draggableObject = ((GutterIconRenderer)attachedObject).getDraggableObject();
                if (draggableObject != null && (line = this.convertPointToLineNumber(e.getPoint())) != -1) {
                    draggableObject.copy(line, this.myEditor.getVirtualFile(), e.getAction().getActionId());
                }
            } else if (attachedObject instanceof DnDNativeTarget.EventInfo && this.myEditor.getSettings().isDndEnabled() && (transferable = ((DnDNativeTarget.EventInfo)attachedObject).getTransferable()) != null && transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                EditorImpl.handleDrop(this.myEditor, transferable, e.getAction().getActionId());
            }
            this.myDnDInProgress = false;
        }).setTargetChecker(e -> {
            int line;
            Transferable transferable;
            Object attachedObject = e.getAttachedObject();
            if (attachedObject instanceof GutterIconRenderer && this.checkDumbAware(attachedObject)) {
                int line2;
                GutterDraggableObject draggableObject = ((GutterIconRenderer)attachedObject).getDraggableObject();
                if (draggableObject != null && (line2 = this.convertPointToLineNumber(e.getPoint())) != -1) {
                    e.setDropPossible(true);
                    e.setCursor(draggableObject.getCursor(line2, e.getAction().getActionId()));
                }
            } else if (attachedObject instanceof DnDNativeTarget.EventInfo && this.myEditor.getSettings().isDndEnabled() && (transferable = ((DnDNativeTarget.EventInfo)attachedObject).getTransferable()) != null && transferable.isDataFlavorSupported(DataFlavor.stringFlavor) && (line = this.convertPointToLineNumber(e.getPoint())) != -1) {
                e.setDropPossible(true);
                this.myEditor.getCaretModel().moveToOffset(this.myEditor.getDocument().getLineStartOffset(line));
            }
            return true;
        }).setImageProvider((Function)((NullableFunction)info -> {
            boolean inUserScale = !SystemInfo.isWindows || !UIUtil.isJreHiDPI((Component)this.myEditor.getComponent());
            BufferedImage image = ImageUtil.toBufferedImage((Image)this.getDragImage(this.getGutterRenderer(info.getPoint())), (boolean)inUserScale);
            return new DnDImage((Image)image, new Point(((Image)image).getWidth(null) / 2, ((Image)image).getHeight(null) / 2));
        })).enableAsNativeTarget().install();
    }

    Image getDragImage(GutterMark renderer2) {
        return IconUtil.toImage((Icon)this.scaleIcon(renderer2.getIcon()));
    }

    private void fireResized() {
        this.processComponentEvent(new ComponentEvent(this, 101));
    }

    @Override
    public Dimension getPreferredSize() {
        int w = this.getFoldingAreaOffset() + this.getFoldingAreaWidth();
        Dimension size = new Dimension(w, this.myEditor.getPreferredHeight());
        JBInsets.addTo((Dimension)size, (Insets)this.getInsets());
        return size;
    }

    @Override
    protected void setUI(ComponentUI newUI) {
        super.setUI(newUI);
        this.reinitSettings(true);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.reinitSettings(true);
    }

    public void reinitSettings(boolean updateGutterSize) {
        this.updateSize(false, updateGutterSize);
        this.repaint();
    }

    @Override
    protected Graphics getComponentGraphics(Graphics graphics) {
        return JBSwingUtilities.runGlobalCGTransform((JComponent)this, (Graphics)super.getComponentGraphics(graphics));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics g_) {
        int lastVisibleOffset;
        int firstVisibleOffset;
        int endVisualLine;
        int startVisualLine;
        Rectangle clip = g_.getClipBounds();
        if (clip.height < 0) {
            return;
        }
        Graphics2D g = (Graphics2D)this.getComponentGraphics(g_);
        AffineTransform old = this.setMirrorTransformIfNeeded(g, 0, this.getWidth());
        EditorUIUtil.setupAntialiasing(g);
        Color backgroundColor = this.getBackground();
        if (this.myEditor.isDisposed()) {
            g.setColor(this.myEditor.getDisposedBackground());
            g.fillRect(clip.x, clip.y, clip.width, clip.height);
            return;
        }
        Segment focusModeRange = this.myEditor.getFocusModeRange();
        if (focusModeRange == null) {
            startVisualLine = this.myEditor.yToVisualLine(clip.y);
            endVisualLine = this.myEditor.yToVisualLine(clip.y + clip.height);
            firstVisibleOffset = this.myEditor.visualLineStartOffset(startVisualLine);
            lastVisibleOffset = this.myEditor.visualLineStartOffset(endVisualLine + 1);
        } else {
            firstVisibleOffset = focusModeRange.getStartOffset();
            lastVisibleOffset = focusModeRange.getEndOffset();
            startVisualLine = this.myEditor.offsetToVisualLine(firstVisibleOffset);
            endVisualLine = this.myEditor.offsetToVisualLine(lastVisibleOffset);
        }
        int gutterSeparatorX = this.getWhitespaceSeparatorOffset();
        this.paintBackground(g, clip, 0, gutterSeparatorX, backgroundColor);
        this.paintBackground(g, clip, gutterSeparatorX, this.getFoldingAreaWidth(), this.myEditor.getBackgroundColor());
        this.paintEditorBackgrounds(g, firstVisibleOffset, lastVisibleOffset);
        Object hint = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        if (!UIUtil.isJreHiDPI((Graphics2D)g)) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        try {
            this.paintAnnotations(g, startVisualLine, endVisualLine);
            if (focusModeRange != null) {
                int startY = Math.max(this.myEditor.visualLineToY(startVisualLine), clip.y);
                int endY = Math.min(this.myEditor.visualLineToY(endVisualLine), clip.y + clip.height);
                g.setClip(clip.x, startY, clip.width, endY - startY);
            }
            this.paintLineMarkers(g, firstVisibleOffset, lastVisibleOffset, startVisualLine, endVisualLine);
            g.setClip(clip);
            this.paintFoldingLines(g, clip);
            this.paintFoldingTree(g, clip, firstVisibleOffset, lastVisibleOffset);
            this.paintLineNumbers(g, startVisualLine, endVisualLine);
            this.paintCurrentAccessibleLine(g);
        }
        finally {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, hint);
        }
        if (old != null) {
            g.setTransform(old);
        }
    }

    private void paintEditorBackgrounds(Graphics g, int firstVisibleOffset, int lastVisibleOffset) {
        this.myTextFgColors.clear();
        Color defaultBackgroundColor = this.myEditor.getBackgroundColor();
        Color defaultForegroundColor = this.myEditor.getColorsScheme().getDefaultForeground();
        int startX = this.myEditor.isInDistractionFreeMode() ? 0 : this.getWhitespaceSeparatorOffset();
        IterationState state = new IterationState(this.myEditor, firstVisibleOffset, lastVisibleOffset, null, true, false, true, false);
        while (!state.atEnd()) {
            this.drawEditorBackgroundForRange(g, state.getStartOffset(), state.getEndOffset(), state.getMergedAttributes(), defaultBackgroundColor, defaultForegroundColor, startX);
            state.advance();
        }
    }

    private void drawEditorBackgroundForRange(Graphics g, int startOffset, int endOffset, TextAttributes attributes, Color defaultBackgroundColor, Color defaultForegroundColor, int startX) {
        VisualPosition visualStart = this.myEditor.offsetToVisualPosition(startOffset, true, false);
        VisualPosition visualEnd = this.myEditor.offsetToVisualPosition(endOffset, false, false);
        for (int line = visualStart.getLine(); line <= visualEnd.getLine(); ++line) {
            if (line == visualStart.getLine()) {
                if (visualStart.getColumn() != 0) continue;
                this.drawEditorLineBackgroundRect(g, attributes, line, defaultBackgroundColor, defaultForegroundColor, startX, this.myEditor.visualLineToY(line));
                continue;
            }
            if (line == visualEnd.getLine() && visualEnd.getColumn() == 0) continue;
            this.drawEditorLineBackgroundRect(g, attributes, line, defaultBackgroundColor, defaultForegroundColor, startX, this.myEditor.visualLineToY(line));
        }
    }

    private void drawEditorLineBackgroundRect(Graphics g, TextAttributes attributes, int visualLine, Color defaultBackgroundColor, Color defaultForegroundColor, int startX, int startY) {
        Color color = this.myEditor.getBackgroundColor(attributes);
        if (!Comparing.equal((Object)color, (Object)defaultBackgroundColor)) {
            Color fgColor = attributes.getForegroundColor();
            if (!Comparing.equal((Object)fgColor, (Object)defaultForegroundColor)) {
                this.myTextFgColors.put(visualLine, (Object)fgColor);
            }
            g.setColor(color);
            g.fillRect(startX, startY, this.getWidth() - startX, this.myEditor.getLineHeight());
        }
    }

    private void processClose(MouseEvent e) {
        IdeEventQueue queue2 = IdeEventQueue.getInstance();
        if (this.getGutterRenderer(e) != null) {
            return;
        }
        if (this.myEditor.getMouseEventArea(e) == EditorMouseEventArea.ANNOTATIONS_AREA) {
            queue2.blockNextEvents(e);
            this.closeAllAnnotations();
            e.consume();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintAnnotations(Graphics2D g, int startVisualLine, int endVisualLine) {
        int x = this.getAnnotationsAreaOffset();
        int w = this.getAnnotationsAreaWidthEx();
        if (w == 0) {
            return;
        }
        AffineTransform old = this.setMirrorTransformIfNeeded(g, x, w);
        try {
            Color color = this.myEditor.getColorsScheme().getColor(EditorColors.ANNOTATIONS_COLOR);
            g.setColor(color != null ? color : JBColor.blue);
            g.setFont(this.myEditor.getColorsScheme().getFont(EditorFontType.PLAIN));
            for (int i = 0; i < this.myTextAnnotationGutters.size(); ++i) {
                TextAnnotationGutterProvider gutterProvider = this.myTextAnnotationGutters.get(i);
                int lineHeight = this.myEditor.getLineHeight();
                int lastLine = this.myEditor.logicalToVisualPosition((LogicalPosition)new LogicalPosition((int)this.endLineNumber(), (int)0)).line;
                if (startVisualLine > (endVisualLine = Math.min(endVisualLine, lastLine))) {
                    break;
                }
                int annotationSize = this.myTextAnnotationGutterSizes.get(i);
                if (startVisualLine == 0 && endVisualLine == 0) {
                    this.paintAnnotationLine(g, gutterProvider, 0, x, 0, annotationSize, lineHeight);
                } else {
                    VisualLinesIterator visLinesIterator = new VisualLinesIterator(this.myEditor, startVisualLine);
                    while (!visLinesIterator.atEnd() && visLinesIterator.getVisualLine() <= endVisualLine) {
                        int logLine = visLinesIterator.getStartLogicalLine();
                        int y = visLinesIterator.getY();
                        this.paintAnnotationLine(g, gutterProvider, logLine, x, y, annotationSize, lineHeight);
                        visLinesIterator.advance();
                    }
                }
                x += annotationSize;
            }
        }
        finally {
            if (old != null) {
                g.setTransform(old);
            }
        }
    }

    private void paintAnnotationLine(Graphics g, TextAnnotationGutterProvider gutterProvider, int line, int x, int y, int width, int height) {
        String s = gutterProvider.getLineText(line, (Editor)this.myEditor);
        Color bg = gutterProvider.getBgColor(line, (Editor)this.myEditor);
        if (bg != null) {
            g.setColor(bg);
            g.fillRect(x, y, width, height);
        }
        if (!StringUtil.isEmpty((String)s)) {
            g.setColor(this.myEditor.getColorsScheme().getColor(gutterProvider.getColor(line, (Editor)this.myEditor)));
            EditorFontType style = gutterProvider.getStyle(line, (Editor)this.myEditor);
            Font font = this.getFontForText(s, style);
            g.setFont(font);
            g.drawString(s, EditorGutterComponentImpl.getGapBetweenAnnotations() / 2 + x, y + this.myEditor.getAscent());
        }
    }

    private Font getFontForText(String text, EditorFontType style) {
        Font font = this.myEditor.getColorsScheme().getFont(style);
        if (font.canDisplayUpTo(text) != -1) {
            font = UIUtil.getFontWithFallback((Font)font);
        }
        return font;
    }

    private void paintFoldingTree(Graphics g, Rectangle clip, int firstVisibleOffset, int lastVisibleOffset) {
        if (this.isFoldingOutlineShown()) {
            this.doPaintFoldingTree((Graphics2D)g, clip, firstVisibleOffset, lastVisibleOffset);
        }
    }

    private void paintLineMarkers(Graphics2D g, int firstVisibleOffset, int lastVisibleOffset, int firstVisibleLine, int lastVisibleLine) {
        if (this.isLineMarkersShown()) {
            this.paintGutterRenderers(g, firstVisibleOffset, lastVisibleOffset, firstVisibleLine, lastVisibleLine);
        }
    }

    private void paintBackground(Graphics g, Rectangle clip, int x, int width, Color background) {
        g.setColor(background);
        g.fillRect(x, clip.y, width, clip.height);
        this.paintCaretRowBackground(g, x, width);
    }

    private void paintCaretRowBackground(Graphics g, int x, int width) {
        if (!this.myEditor.getSettings().isCaretRowShown()) {
            return;
        }
        VisualPosition visCaret = this.myEditor.getCaretModel().getVisualPosition();
        Color caretRowColor = this.myEditor.getColorsScheme().getColor(EditorColors.CARET_ROW_COLOR);
        if (caretRowColor != null) {
            g.setColor(caretRowColor);
            Point caretPoint = this.myEditor.visualPositionToXY(visCaret);
            g.fillRect(x, caretPoint.y, width, this.myEditor.getLineHeight());
        }
    }

    private void paintLineNumbers(Graphics2D g, int startVisualLine, int endVisualLine) {
        if (this.isLineNumbersShown()) {
            int offset = this.getLineNumberAreaOffset() + this.myLineNumberAreaWidth;
            this.doPaintLineNumbers(g, startVisualLine, endVisualLine, offset, this.myLineNumberConvertor);
            if (this.myAdditionalLineNumberConvertor != null) {
                this.doPaintLineNumbers(g, startVisualLine, endVisualLine, offset + EditorGutterComponentImpl.getAreaWidthWithGap(this.myAdditionalLineNumberAreaWidth), this.myAdditionalLineNumberConvertor);
            }
        }
    }

    private void paintCurrentAccessibleLine(Graphics2D g) {
        if (this.myAccessibleGutterLine != null) {
            this.myAccessibleGutterLine.paint(g);
        }
    }

    @Override
    public Color getBackground() {
        if (this.myEditor.isInDistractionFreeMode() || !this.myPaintBackground) {
            return this.myEditor.getBackgroundColor();
        }
        Color color = this.myEditor.getColorsScheme().getColor(EditorColors.GUTTER_BACKGROUND);
        return color != null ? color : EditorColors.GUTTER_BACKGROUND.getDefaultColor();
    }

    private Font getFontForLineNumbers() {
        Font editorFont = this.myEditor.getColorsScheme().getFont(EditorFontType.PLAIN);
        float editorFontSize = editorFont.getSize2D();
        return editorFont.deriveFont(Math.max(1.0f, editorFontSize - 1.0f));
    }

    private int calcLineNumbersAreaWidth(int maxLineNumber) {
        return this.getFontMetrics(this.getFontForLineNumbers()).stringWidth(Integer.toString(maxLineNumber + 1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPaintLineNumbers(Graphics2D g, int startVisualLine, int endVisualLine, int offset, @NotNull TIntFunction convertor) {
        int lastLine;
        if (convertor == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(2);
        }
        if (startVisualLine > (endVisualLine = Math.min(endVisualLine, lastLine = this.myEditor.logicalToVisualPosition((LogicalPosition)new LogicalPosition((int)this.endLineNumber(), (int)0)).line))) {
            return;
        }
        Color color = this.myEditor.getColorsScheme().getColor(EditorColors.LINE_NUMBERS_COLOR);
        Color colorUnderCaretRow = this.myEditor.getColorsScheme().getColor(EditorColors.LINE_NUMBER_ON_CARET_ROW_COLOR);
        Font font = this.getFontForLineNumbers();
        g.setFont(font);
        AffineTransform old = this.setMirrorTransformIfNeeded(g, this.getLineNumberAreaOffset(), this.getLineNumberAreaWidth());
        try {
            int caretLine = convertor.execute(this.myEditor.getCaretModel().getLogicalPosition().line);
            VisualLinesIterator visLinesIterator = new VisualLinesIterator(this.myEditor, startVisualLine);
            while (!visLinesIterator.atEnd() && visLinesIterator.getVisualLine() <= endVisualLine) {
                int logLine;
                if (!visLinesIterator.startsWithSoftWrap() && (logLine = convertor.execute(visLinesIterator.getStartLogicalLine())) >= 0) {
                    int startY = visLinesIterator.getY();
                    if (this.myEditor.isInDistractionFreeMode()) {
                        Color fgColor = (Color)this.myTextFgColors.get(visLinesIterator.getVisualLine());
                        g.setColor(fgColor != null ? fgColor : (color != null ? color : JBColor.blue));
                    } else {
                        g.setColor(color);
                    }
                    if (colorUnderCaretRow != null && caretLine == logLine) {
                        g.setColor(colorUnderCaretRow);
                    }
                    String s = String.valueOf(logLine + 1);
                    int textOffset = this.isMirrored() ? offset - this.getLineNumberAreaWidth() - 1 : offset - g.getFontMetrics().stringWidth(s);
                    g.drawString(s, textOffset, startY + this.myEditor.getAscent());
                }
                visLinesIterator.advance();
            }
        }
        finally {
            if (old != null) {
                g.setTransform(old);
            }
        }
    }

    private int endLineNumber() {
        return Math.max(0, this.myEditor.getDocument().getLineCount() - 1);
    }

    @Nullable
    public Object getData(@NotNull @NonNls String dataId) {
        if (dataId == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(3);
        }
        if (this.myEditor.isDisposed()) {
            return null;
        }
        if (EditorGutter.KEY.is(dataId)) {
            return this;
        }
        if (CommonDataKeys.EDITOR.is(dataId)) {
            return this.myEditor;
        }
        if (EditorGutterComponentEx.LOGICAL_LINE_AT_CURSOR.is(dataId)) {
            return this.myLogicalLineAtCursor;
        }
        return null;
    }

    void processRangeHighlighters(int startOffset, int endOffset, @NotNull RangeHighlighterProcessor processor2) {
        if (processor2 == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(4);
        }
        DocumentEx document = this.myEditor.getDocument();
        MarkupIterator<RangeHighlighterEx> docHighlighters = this.myEditor.getFilteredDocumentMarkupModel().overlappingIterator(startOffset, endOffset);
        MarkupIterator<RangeHighlighterEx> editorHighlighters = this.myEditor.getMarkupModel().overlappingIterator(startOffset, endOffset);
        try {
            RangeHighlighterEx lastDocHighlighter = null;
            RangeHighlighterEx lastEditorHighlighter = null;
            while (true) {
                int endLineIndex;
                int startLineIndex;
                RangeHighlighterEx lowerHighlighter;
                if (lastDocHighlighter == null && docHighlighters.hasNext()) {
                    lastDocHighlighter = (RangeHighlighterEx)docHighlighters.next();
                    if (!lastDocHighlighter.isValid() || lastDocHighlighter.getAffectedAreaStartOffset() > endOffset) {
                        lastDocHighlighter = null;
                        continue;
                    }
                    if (lastDocHighlighter.getAffectedAreaEndOffset() < startOffset) {
                        lastDocHighlighter = null;
                        continue;
                    }
                }
                if (lastEditorHighlighter == null && editorHighlighters.hasNext()) {
                    lastEditorHighlighter = (RangeHighlighterEx)editorHighlighters.next();
                    if (!lastEditorHighlighter.isValid() || lastEditorHighlighter.getAffectedAreaStartOffset() > endOffset) {
                        lastEditorHighlighter = null;
                        continue;
                    }
                    if (lastEditorHighlighter.getAffectedAreaEndOffset() < startOffset) {
                        lastEditorHighlighter = null;
                        continue;
                    }
                }
                if (lastDocHighlighter == null && lastEditorHighlighter == null) {
                    return;
                }
                if (EditorGutterComponentImpl.less(lastDocHighlighter, lastEditorHighlighter)) {
                    lowerHighlighter = lastDocHighlighter;
                    lastDocHighlighter = null;
                } else {
                    lowerHighlighter = lastEditorHighlighter;
                    lastEditorHighlighter = null;
                }
                if (!lowerHighlighter.isValid() || !EditorGutterComponentImpl.isValidLine(document, startLineIndex = lowerHighlighter.getDocument().getLineNumber(startOffset)) || !EditorGutterComponentImpl.isValidLine(document, endLineIndex = lowerHighlighter.getDocument().getLineNumber(endOffset))) continue;
                processor2.process(lowerHighlighter);
            }
        }
        finally {
            docHighlighters.dispose();
            editorHighlighters.dispose();
        }
    }

    private static boolean isValidLine(@NotNull Document document, int line) {
        if (document == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(5);
        }
        if (line < 0) {
            return false;
        }
        int lineCount = document.getLineCount();
        return lineCount == 0 ? line == 0 : line < lineCount;
    }

    private static boolean less(RangeHighlighter h1, RangeHighlighter h2) {
        return h1 != null && (h2 == null || h1.getStartOffset() < h2.getStartOffset());
    }

    @Override
    public void revalidateMarkup() {
        this.updateSize();
    }

    void updateSizeOnShowNotify() {
        this.updateSize(false, true);
    }

    public void updateSize() {
        this.updateSize(false, false);
    }

    void updateSize(boolean onLayout, boolean canShrink) {
        int prevHash = this.sizeHash();
        if (!onLayout) {
            this.clearLineToGutterRenderersCache();
            this.calcLineNumberAreaWidth();
            this.calcLineMarkerAreaWidth(canShrink);
            this.calcAnnotationsSize();
        }
        this.calcAnnotationExtraSize();
        if (prevHash != this.sizeHash()) {
            this.fireResized();
        }
        this.repaint();
    }

    private int sizeHash() {
        int result2 = this.getLineMarkerAreaWidth();
        result2 = 31 * result2 + this.myTextAnnotationGuttersSize;
        result2 = 31 * result2 + this.myTextAnnotationExtraSize;
        result2 = 31 * result2 + this.getLineNumberAreaWidth();
        return result2;
    }

    private void calcAnnotationsSize() {
        this.myTextAnnotationGuttersSize = 0;
        int lineCount = Math.max(this.myEditor.getDocument().getLineCount(), 1);
        int guttersCount = this.myTextAnnotationGutters.size();
        for (int j = 0; j < guttersCount; ++j) {
            TextAnnotationGutterProvider gutterProvider = this.myTextAnnotationGutters.get(j);
            int gutterSize = 0;
            for (int i = 0; i < lineCount; ++i) {
                String lineText = gutterProvider.getLineText(i, (Editor)this.myEditor);
                if (StringUtil.isEmpty((String)lineText)) continue;
                EditorFontType style = gutterProvider.getStyle(i, (Editor)this.myEditor);
                Font font = this.getFontForText(lineText, style);
                FontMetrics fontMetrics = this.getFontMetrics(font);
                gutterSize = Math.max(gutterSize, fontMetrics.stringWidth(lineText));
            }
            if (gutterSize > 0 && j < guttersCount - 1) {
                gutterSize += EditorGutterComponentImpl.getGapBetweenAnnotations();
            }
            this.myTextAnnotationGutterSizes.set(j, gutterSize);
            this.myTextAnnotationGuttersSize += gutterSize;
        }
    }

    private void calcAnnotationExtraSize() {
        int width;
        this.myTextAnnotationExtraSize = 0;
        if (!this.myEditor.isInDistractionFreeMode() || this.isMirrored()) {
            return;
        }
        Window frame = SwingUtilities.getWindowAncestor(this.myEditor.getComponent());
        if (frame == null) {
            return;
        }
        EditorSettings settings = this.myEditor.getSettings();
        int rightMargin = settings.getRightMargin(this.myEditor.getProject());
        if (rightMargin <= 0) {
            return;
        }
        JComponent editorComponent = this.myEditor.getComponent();
        RelativePoint point = new RelativePoint((Component)editorComponent, new Point(0, 0));
        Point editorLocationInWindow = point.getPoint((Component)frame);
        int editorLocationX = (int)editorLocationInWindow.getX();
        int rightMarginX = rightMargin * EditorUtil.getSpaceWidth(0, this.myEditor) + editorLocationX;
        if (rightMarginX < (width = editorLocationX + editorComponent.getWidth()) && editorLocationX < width - rightMarginX) {
            int centeredSize = (width - rightMarginX - editorLocationX) / 2 - (this.getLineMarkerAreaWidth() + this.getLineNumberAreaWidth() + this.getFoldingAreaWidth() + 2 * EditorGutterComponentImpl.getGapBetweenAreas());
            this.myTextAnnotationExtraSize = Math.max(0, centeredSize - this.myTextAnnotationGuttersSize);
        }
    }

    private boolean logicalLinesMatchVisualOnes() {
        return this.myEditor.getSoftWrapModel().getSoftWrapsIntroducedLinesNumber() == 0 && this.myEditor.getFoldingModel().getTotalNumberOfFoldedLines() == 0;
    }

    void clearLineToGutterRenderersCache() {
        this.myLineToGutterRenderers = null;
    }

    private void buildGutterRenderersCache() {
        this.myLineToGutterRenderersCacheForLogicalLines = this.logicalLinesMatchVisualOnes();
        this.myLineToGutterRenderers = new TIntObjectHashMap();
        this.processRangeHighlighters(0, this.myEditor.getDocument().getTextLength(), highlighter -> {
            GutterIconRenderer renderer2 = highlighter.getGutterIconRenderer();
            if (renderer2 == null) {
                return;
            }
            if (!this.areIconsShown() && !(renderer2 instanceof NonHideableIconGutterMark)) {
                return;
            }
            if (!this.isHighlighterVisible(highlighter)) {
                return;
            }
            int line = this.myEditor.offsetToVisualLine(highlighter.getStartOffset());
            List renderers = (List)this.myLineToGutterRenderers.get(line);
            if (renderers == null) {
                renderers = new SmartList();
                this.myLineToGutterRenderers.put(line, (Object)renderers);
            }
            renderers.add(renderer2);
        });
        this.myLineToGutterRenderers.transformValues(value -> {
            List newValue = value;
            for (GutterMarkPreprocessor preprocessor : (GutterMarkPreprocessor[])GutterMarkPreprocessor.EP_NAME.getExtensions()) {
                newValue = preprocessor.processMarkers(value);
            }
            newValue = ContainerUtil.getFirstItems((List)newValue, (int)4);
            return newValue;
        });
    }

    private void calcLineMarkerAreaWidth(boolean canShrink) {
        this.myLeftFreePaintersAreaShown = this.myForceLeftFreePaintersAreaShown;
        this.myRightFreePaintersAreaShown = this.myForceRightFreePaintersAreaShown;
        this.processRangeHighlighters(0, this.myEditor.getDocument().getTextLength(), highlighter -> {
            LineMarkerRenderer lineMarkerRenderer = highlighter.getLineMarkerRenderer();
            if (lineMarkerRenderer != null) {
                LineMarkerRendererEx.Position position = EditorGutterComponentImpl.getLineMarkerPosition(lineMarkerRenderer);
                if (position == LineMarkerRendererEx.Position.LEFT && this.isLineMarkerVisible(highlighter)) {
                    this.myLeftFreePaintersAreaShown = true;
                }
                if (position == LineMarkerRendererEx.Position.RIGHT && this.isLineMarkerVisible(highlighter)) {
                    this.myRightFreePaintersAreaShown = true;
                }
            }
        });
        int minWidth = this.areIconsShown() ? this.scaleWidth(this.myStartIconAreaWidth) : 0;
        this.myIconsAreaWidth = canShrink ? minWidth : Math.max(this.myIconsAreaWidth, minWidth);
        this.processGutterRenderers((TIntObjectProcedure<List<GutterMark>>)((TIntObjectProcedure)(line, renderers) -> {
            int width = 1;
            for (int i = 0; i < renderers.size(); ++i) {
                GutterMark renderer2 = (GutterMark)renderers.get(i);
                if (!this.checkDumbAware(renderer2)) continue;
                width += this.scaleIcon(renderer2.getIcon()).getIconWidth();
                if (i <= 0) continue;
                width += EditorGutterComponentImpl.getGapBetweenIcons();
            }
            if (this.myIconsAreaWidth < width) {
                this.myIconsAreaWidth = width + 1;
            }
            return true;
        }));
        if (this.isDumbMode()) {
            this.myIconsAreaWidth = Math.max(this.myIconsAreaWidth, this.myLastNonDumbModeIconAreaWidth);
        } else {
            this.myLastNonDumbModeIconAreaWidth = this.myIconsAreaWidth;
        }
    }

    @Nullable
    List<GutterMark> getGutterRenderers(int line) {
        if (this.myLineToGutterRenderers == null || this.myLineToGutterRenderersCacheForLogicalLines != this.logicalLinesMatchVisualOnes()) {
            this.buildGutterRenderersCache();
        }
        return (List)this.myLineToGutterRenderers.get(line);
    }

    private void processGutterRenderers(@NotNull TIntObjectProcedure<List<GutterMark>> processor2) {
        if (processor2 == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(6);
        }
        if (this.myLineToGutterRenderers == null || this.myLineToGutterRenderersCacheForLogicalLines != this.logicalLinesMatchVisualOnes()) {
            this.buildGutterRenderersCache();
        }
        this.myLineToGutterRenderers.forEachEntry(processor2);
    }

    private boolean isHighlighterVisible(RangeHighlighter highlighter) {
        return !FoldingUtil.isHighlighterFolded(this.myEditor, highlighter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintGutterRenderers(Graphics2D g, int firstVisibleOffset, int lastVisibleOffset, int firstVisibleLine, int lastVisibleLine) {
        Object hint = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        try {
            ArrayList highlighters = new ArrayList();
            this.processRangeHighlighters(firstVisibleOffset, lastVisibleOffset, highlighter -> {
                LineMarkerRenderer renderer2 = highlighter.getLineMarkerRenderer();
                if (renderer2 != null) {
                    highlighters.add(highlighter);
                }
            });
            ContainerUtil.sort(highlighters, Comparator.comparingInt(RangeHighlighter::getLayer));
            for (RangeHighlighter highlighter2 : highlighters) {
                this.paintLineMarkerRenderer(highlighter2, g);
            }
        }
        finally {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, hint);
        }
        this.paintIcons(firstVisibleLine, lastVisibleLine, g);
    }

    private void paintIcons(int firstVisibleLine, int lastVisibleLine, Graphics2D g) {
        for (int line = firstVisibleLine; line <= lastVisibleLine; ++line) {
            List<GutterMark> renderers = this.getGutterRenderers(line);
            if (renderers == null) continue;
            this.paintIconRow(line, renderers, g);
        }
    }

    private void paintIconRow(int line, List<GutterMark> row2, Graphics2D g) {
        this.processIconsRow(line, row2, (x, y, renderer2) -> {
            Icon icon = this.scaleIcon(renderer2.getIcon());
            AffineTransform old = this.setMirrorTransformIfNeeded(g, x, icon.getIconWidth());
            try {
                icon.paintIcon(this, g, x, y);
            }
            finally {
                if (old != null) {
                    g.setTransform(old);
                }
            }
        });
    }

    private void paintLineMarkerRenderer(RangeHighlighter highlighter, Graphics g) {
        Rectangle rectangle;
        LineMarkerRenderer lineMarkerRenderer = highlighter.getLineMarkerRenderer();
        if (lineMarkerRenderer != null && (rectangle = this.getLineRendererRectangle(highlighter)) != null) {
            lineMarkerRenderer.paint((Editor)this.myEditor, g, rectangle);
        }
    }

    private boolean isLineMarkerVisible(RangeHighlighter highlighter) {
        int startOffset = highlighter.getStartOffset();
        int endOffset = highlighter.getEndOffset();
        FoldRegion startFoldRegion = this.myEditor.getFoldingModel().getCollapsedRegionAtOffset(startOffset);
        FoldRegion endFoldRegion = this.myEditor.getFoldingModel().getCollapsedRegionAtOffset(endOffset);
        return startFoldRegion == null || !startFoldRegion.equals(endFoldRegion);
    }

    @Nullable
    Rectangle getLineRendererRectangle(RangeHighlighter highlighter) {
        int x;
        int w;
        if (!this.isLineMarkerVisible(highlighter)) {
            return null;
        }
        int startOffset = highlighter.getStartOffset();
        int endOffset = highlighter.getEndOffset();
        int startY = this.myEditor.visualLineToY(this.myEditor.offsetToVisualLine(startOffset));
        int endY = this.myEditor.visualLineToY(this.myEditor.offsetToVisualLine(endOffset));
        endY += this.myEditor.getLineHeight();
        LineMarkerRenderer renderer2 = (LineMarkerRenderer)ObjectUtils.assertNotNull((Object)highlighter.getLineMarkerRenderer());
        LineMarkerRendererEx.Position position = EditorGutterComponentImpl.getLineMarkerPosition(renderer2);
        switch (position) {
            case LEFT: {
                w = this.getLeftFreePaintersAreaWidth();
                x = this.getLeftFreePaintersAreaOffset();
                break;
            }
            case RIGHT: {
                w = this.getRightFreePaintersAreaWidth();
                x = this.getLineMarkerFreePaintersAreaOffset();
                break;
            }
            case CUSTOM: {
                w = this.getWidth();
                x = 0;
                break;
            }
            default: {
                throw new IllegalArgumentException(position.name());
            }
        }
        int height = endY - startY;
        return new Rectangle(x, startY, w, height);
    }

    private float getEditorScaleFactor() {
        float scale;
        if (Registry.is((String)"editor.scale.gutter.icons") && Math.abs(1.0f - (scale = this.myEditor.getScale())) > 0.1f) {
            return scale;
        }
        return 1.0f;
    }

    Icon scaleIcon(Icon icon) {
        float scale = this.getEditorScaleFactor();
        return scale == 1.0f ? icon : IconUtil.scale((Icon)icon, (Component)this, (float)scale);
    }

    private int scaleWidth(int width) {
        return (int)(this.getEditorScaleFactor() * (float)width);
    }

    void processIconsRow(int line, @NotNull List<? extends GutterMark> row2, @NotNull LineGutterIconRendererProcessor processor2) {
        if (row2 == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(7);
        }
        if (processor2 == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(8);
        }
        int middleCount = 0;
        int middleSize = 0;
        int x = this.getIconAreaOffset() + 2;
        int y = this.myEditor.visualLineToY(line);
        for (GutterMark gutterMark : row2) {
            if (!this.checkDumbAware(gutterMark)) continue;
            GutterIconRenderer.Alignment alignment = ((GutterIconRenderer)gutterMark).getAlignment();
            Icon icon = this.scaleIcon(gutterMark.getIcon());
            if (alignment == GutterIconRenderer.Alignment.LEFT) {
                processor2.process(x, y + this.getTextAlignmentShift(icon), gutterMark);
                x += icon.getIconWidth() + EditorGutterComponentImpl.getGapBetweenIcons();
                continue;
            }
            if (alignment != GutterIconRenderer.Alignment.CENTER) continue;
            ++middleCount;
            middleSize += icon.getIconWidth() + EditorGutterComponentImpl.getGapBetweenIcons();
        }
        int leftSize = x - this.getIconAreaOffset();
        x = this.getIconAreaOffset() + this.myIconsAreaWidth;
        for (GutterMark gutterMark : row2) {
            if (!this.checkDumbAware(gutterMark) || ((GutterIconRenderer)gutterMark).getAlignment() != GutterIconRenderer.Alignment.RIGHT) continue;
            Icon icon = this.scaleIcon(gutterMark.getIcon());
            processor2.process(x -= icon.getIconWidth(), y + this.getTextAlignmentShift(icon), gutterMark);
            x -= EditorGutterComponentImpl.getGapBetweenIcons();
        }
        int n = this.myIconsAreaWidth + this.getIconAreaOffset() - x + 1;
        if (middleCount > 0) {
            x = this.getIconAreaOffset() + leftSize + (this.myIconsAreaWidth - leftSize - n - (middleSize -= EditorGutterComponentImpl.getGapBetweenIcons())) / 2;
            for (GutterMark gutterMark : row2) {
                if (!this.checkDumbAware(gutterMark) || ((GutterIconRenderer)gutterMark).getAlignment() != GutterIconRenderer.Alignment.CENTER) continue;
                Icon icon2 = this.scaleIcon(gutterMark.getIcon());
                processor2.process(x, y + this.getTextAlignmentShift(icon2), gutterMark);
                x += icon2.getIconWidth() + EditorGutterComponentImpl.getGapBetweenIcons();
            }
        }
    }

    private int getTextAlignmentShift(Icon icon) {
        int centerRelative = (this.myEditor.getLineHeight() - icon.getIconHeight()) / 2;
        int baselineRelative = this.myEditor.getAscent() - icon.getIconHeight();
        return Math.max(centerRelative, baselineRelative);
    }

    private Color getOutlineColor(boolean isActive) {
        ColorKey key = isActive ? EditorColors.SELECTED_TEARLINE_COLOR : EditorColors.TEARLINE_COLOR;
        Color color = this.myEditor.getColorsScheme().getColor(key);
        return color != null ? color : JBColor.black;
    }

    public void registerTextAnnotation(@NotNull TextAnnotationGutterProvider provider) {
        if (provider == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(9);
        }
        this.myTextAnnotationGutters.add(provider);
        this.myTextAnnotationGutterSizes.add(0);
        this.updateSize();
    }

    public void registerTextAnnotation(@NotNull TextAnnotationGutterProvider provider, @NotNull EditorGutterAction action) {
        if (provider == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(10);
        }
        if (action == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(11);
        }
        this.myTextAnnotationGutters.add(provider);
        this.myProviderToListener.put(provider, action);
        this.myTextAnnotationGutterSizes.add(0);
        this.updateSize();
    }

    @Override
    @NotNull
    public List<TextAnnotationGutterProvider> getTextAnnotations() {
        ArrayList<TextAnnotationGutterProvider> arrayList = new ArrayList<TextAnnotationGutterProvider>(this.myTextAnnotationGutters);
        if (arrayList == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(12);
        }
        return arrayList;
    }

    private void doPaintFoldingTree(Graphics2D g, Rectangle clip, int firstVisibleOffset, int lastVisibleOffset) {
        double width = this.getFoldingAnchorWidth2D();
        Collection<DisplayedFoldingAnchor> anchorsToDisplay = this.myAnchorsDisplayStrategy.getAnchorsToDisplay(firstVisibleOffset, lastVisibleOffset, this.myActiveFoldRegions);
        for (DisplayedFoldingAnchor anchor2 : anchorsToDisplay) {
            this.drawFoldingAnchor(width, clip, g, anchor2.visualLine, anchor2.type, this.myActiveFoldRegions.contains(anchor2.foldRegion));
        }
    }

    private void paintFoldingLines(Graphics2D g, Rectangle clip) {
        boolean shown = this.isFoldingOutlineShown();
        double x = this.getWhitespaceSeparatorOffset2D();
        if ((shown || this.myEditor.isInDistractionFreeMode() && Registry.is((String)"editor.distraction.gutter.separator")) && this.myPaintBackground) {
            g.setColor(this.getOutlineColor(false));
            LinePainter2D.paint((Graphics2D)g, (double)x, (double)clip.y, (double)x, (double)(clip.y + clip.height), (LinePainter2D.StrokeType)LinePainter2D.StrokeType.CENTERED, (double)this.getStrokeWidth());
        }
        if (!shown) {
            return;
        }
        this.myActiveFoldRegions.forEach(region -> {
            int foldEnd;
            int foldStart;
            if (region.isValid() && region.isExpanded() && (foldStart = this.myEditor.offsetToVisualLine(region.getStartOffset())) < (foldEnd = this.myEditor.offsetToVisualLine(region.getEndOffset()))) {
                int startY = this.getLineCenterY(foldStart);
                int endY = this.getLineCenterY(foldEnd);
                if (startY <= clip.y + clip.height && endY + 1 + this.myEditor.getDescent() >= clip.y) {
                    g.setColor(this.getOutlineColor(true));
                    LinePainter2D.paint((Graphics2D)g, (double)x, (double)startY, (double)x, (double)endY, (LinePainter2D.StrokeType)LinePainter2D.StrokeType.CENTERED, (double)this.getStrokeWidth());
                }
            }
        });
    }

    @Override
    public int getWhitespaceSeparatorOffset() {
        return (int)Math.round(this.getWhitespaceSeparatorOffset2D());
    }

    private double getWhitespaceSeparatorOffset2D() {
        return PaintUtil.alignToInt((double)((double)this.getFoldingAreaOffset() + (double)this.getFoldingAnchorWidth() / 2.0), (JBUI.ScaleContext)JBUI.ScaleContext.create((Component)this.myEditor.getComponent()), (PaintUtil.RoundingMode)PaintUtil.RoundingMode.ROUND, null);
    }

    void setActiveFoldRegions(@NotNull List<FoldRegion> activeFoldRegions) {
        if (activeFoldRegions == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(13);
        }
        if (!this.myActiveFoldRegions.equals(activeFoldRegions)) {
            this.myActiveFoldRegions = activeFoldRegions;
            this.repaint();
        }
    }

    private int getLineCenterY(int line) {
        return this.myEditor.visualLineToY(line) + this.myEditor.getLineHeight() / 2;
    }

    private double getFoldAnchorY(int line, double width) {
        return (double)(this.myEditor.visualLineToY(line) + this.myEditor.getAscent()) - width;
    }

    int getHeadCenterY(FoldRegion foldRange) {
        return this.getLineCenterY(this.myEditor.offsetToVisualLine(foldRange.getStartOffset()));
    }

    private void drawFoldingAnchor(double width, Rectangle clip, Graphics2D g, int visualLine, DisplayedFoldingAnchor.Type type, boolean active) {
        double off = width / 4.0;
        double height = width + off;
        double baseHeight = height - width / 2.0;
        double y = this.getFoldAnchorY(visualLine, width);
        double centerX = LinePainter2D.getStrokeCenter((Graphics2D)g, (double)this.getWhitespaceSeparatorOffset2D(), (LinePainter2D.StrokeType)LinePainter2D.StrokeType.CENTERED, (double)this.getStrokeWidth());
        double strokeOff = centerX - this.getWhitespaceSeparatorOffset2D();
        double centerY = PaintUtil.alignToInt((double)(y + width / 2.0), (Graphics2D)g) + strokeOff;
        switch (type) {
            case COLLAPSED: 
            case COLLAPSED_SINGLE_LINE: {
                if (!(y <= (double)(clip.y + clip.height)) || !(y + height >= (double)clip.y)) break;
                this.drawSquareWithPlusOrMinus(g, centerX, centerY, width, true, active);
                break;
            }
            case EXPANDED_SINGLE_LINE: {
                if (!(y <= (double)(clip.y + clip.height)) || !(y + height >= (double)clip.y)) break;
                this.drawSquareWithPlusOrMinus(g, centerX, centerY, width, false, active);
                break;
            }
            case EXPANDED_TOP: {
                if (!(y <= (double)(clip.y + clip.height)) || !(y + height >= (double)clip.y)) break;
                this.drawDirectedBox(g, centerX, centerY, width, height, baseHeight, active);
                break;
            }
            case EXPANDED_BOTTOM: {
                y += width;
                if (!(y - height <= (double)(clip.y + clip.height)) || !(y >= (double)clip.y)) break;
                this.drawDirectedBox(g, centerX, centerY, width, -height, -baseHeight, active);
            }
        }
    }

    private void drawDirectedBox(Graphics2D g, double centerX, double centerY, double width, double height, double baseHeight, boolean active) {
        double sw = this.getStrokeWidth();
        Rectangle2D rect = RectanglePainter2D.align((Graphics2D)g, EnumSet.of(LinePainter2D.Align.CENTER_X, LinePainter2D.Align.CENTER_Y), (double)centerX, (double)centerY, (double)width, (double)width, (LinePainter2D.StrokeType)LinePainter2D.StrokeType.CENTERED, (double)sw);
        double x1 = rect.getX();
        double x2 = x1 + rect.getWidth() - 1.0;
        double y = height > 0.0 ? rect.getY() : rect.getY() + rect.getHeight() - 1.0;
        double[] dxPoints = new double[]{x1, x1, x2, x2, centerX};
        double[] dyPoints = new double[]{y + baseHeight, y, y, y + baseHeight, y + height + (double)(height < 0.0 ? 1 : 0)};
        g.setColor(this.myEditor.getBackgroundColor());
        LinePainter2D.fillPolygon((Graphics2D)g, (double[])dxPoints, (double[])dyPoints, (int)5, (LinePainter2D.StrokeType)LinePainter2D.StrokeType.CENTERED_CAPS_SQUARE, (double)sw, (Object)RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(this.getOutlineColor(active));
        LinePainter2D.paintPolygon((Graphics2D)g, (double[])dxPoints, (double[])dyPoints, (int)5, (LinePainter2D.StrokeType)LinePainter2D.StrokeType.CENTERED_CAPS_SQUARE, (double)sw, (Object)RenderingHints.VALUE_ANTIALIAS_ON);
        this.drawLine(g, false, centerX, centerY, width, sw);
    }

    private void drawLine(Graphics2D g, boolean vertical, double centerX, double centerY, double width, double strokeWidth) {
        double length = width - this.getSquareInnerOffset(width) * 2.0;
        Line2D line = LinePainter2D.align((Graphics2D)g, EnumSet.of(LinePainter2D.Align.CENTER_X, LinePainter2D.Align.CENTER_Y), (double)centerX, (double)centerY, (double)length, (boolean)vertical, (LinePainter2D.StrokeType)LinePainter2D.StrokeType.CENTERED, (double)strokeWidth);
        LinePainter2D.paint((Graphics2D)g, (Line2D)line, (LinePainter2D.StrokeType)LinePainter2D.StrokeType.CENTERED, (double)strokeWidth, (Object)RenderingHints.VALUE_ANTIALIAS_OFF);
    }

    private void drawSquareWithPlusOrMinus(Graphics2D g, double centerX, double centerY, double width, boolean plus, boolean active) {
        double sw = this.getStrokeWidth();
        Rectangle2D rect = RectanglePainter2D.align((Graphics2D)g, EnumSet.of(LinePainter2D.Align.CENTER_X, LinePainter2D.Align.CENTER_Y), (double)centerX, (double)centerY, (double)width, (double)width, (LinePainter2D.StrokeType)LinePainter2D.StrokeType.CENTERED, (double)sw);
        g.setColor(this.myEditor.getBackgroundColor());
        RectanglePainter2D.FILL.paint(g, rect, null, LinePainter2D.StrokeType.CENTERED, sw, RenderingHints.VALUE_ANTIALIAS_OFF);
        g.setColor(this.getOutlineColor(active));
        RectanglePainter2D.DRAW.paint(g, rect, null, LinePainter2D.StrokeType.CENTERED, sw, RenderingHints.VALUE_ANTIALIAS_OFF);
        this.drawLine(g, false, centerX, centerY, width, sw);
        if (plus) {
            this.drawLine(g, true, centerX, centerY, width, sw);
        }
    }

    private double getSquareInnerOffset(double width) {
        return Math.max(width / 5.0, this.scale(2.0));
    }

    private double scale(double v) {
        return JBUI.scale((float)((float)v)) * this.myEditor.getScale();
    }

    private int getFoldingAnchorWidth() {
        return (int)Math.round(this.getFoldingAnchorWidth2D());
    }

    private double getFoldingAnchorWidth2D() {
        return Math.min(this.scale(4.0), (double)((float)this.myEditor.getLineHeight() / 2.0f - JBUI.scale((float)2.0f))) * 2.0;
    }

    private double getStrokeWidth() {
        double sw = UIUtil.isJreHiDPIEnabled() || this.scale(1.0) < 2.0 ? 1.0 : 2.0;
        JBUI.ScaleContext ctx = JBUI.ScaleContext.create((Component)this.myEditor.getComponent());
        return PaintUtil.alignToInt((double)sw, (JBUI.ScaleContext)ctx, (PaintUtil.RoundingMode)(PaintUtil.devValue((double)1.0, (JBUI.ScaleContext)ctx) > 2.0 ? PaintUtil.RoundingMode.FLOOR : PaintUtil.RoundingMode.ROUND), null);
    }

    private int getFoldingAreaOffset() {
        return this.getLineMarkerAreaOffset() + this.getLineMarkerAreaWidth();
    }

    private int getFoldingAreaWidth() {
        return this.isFoldingOutlineShown() ? this.getFoldingAnchorWidth() + JBUI.scale((int)2) : (this.isRealEditor() ? this.getFoldingAnchorWidth() : 0);
    }

    private boolean isRealEditor() {
        return EditorUtil.isRealFileEditor(this.myEditor);
    }

    boolean isLineMarkersShown() {
        return this.myEditor.getSettings().isLineMarkerAreaShown();
    }

    boolean areIconsShown() {
        return this.myEditor.getSettings().areGutterIconsShown();
    }

    boolean isLineNumbersShown() {
        return this.myEditor.getSettings().isLineNumbersShown();
    }

    public boolean isAnnotationsShown() {
        return !this.myTextAnnotationGutters.isEmpty();
    }

    private boolean isFoldingOutlineShown() {
        return this.myEditor.getSettings().isFoldingOutlineShown() && this.myEditor.getFoldingModel().isFoldingEnabled() && !this.myEditor.isInPresentationMode();
    }

    private static int getGapBetweenAreas() {
        return GAP_BETWEEN_AREAS.get();
    }

    private static int getAreaWidthWithGap(int width) {
        if (width > 0) {
            return width + EditorGutterComponentImpl.getGapBetweenAreas();
        }
        return 0;
    }

    private static int getGapBetweenIcons() {
        return GAP_BETWEEN_ICONS.get();
    }

    private static int getGapBetweenAnnotations() {
        return GAP_BETWEEN_ANNOTATIONS.get();
    }

    int getLineNumberAreaWidth() {
        return this.isLineNumbersShown() ? this.myLineNumberAreaWidth + EditorGutterComponentImpl.getAreaWidthWithGap(this.myAdditionalLineNumberAreaWidth) : 0;
    }

    private int getLineMarkerAreaWidth() {
        return this.isLineMarkersShown() ? this.getLeftFreePaintersAreaWidth() + this.myIconsAreaWidth + this.getGapAfterIconsArea() + this.getRightFreePaintersAreaWidth() : 0;
    }

    private void calcLineNumberAreaWidth() {
        if (!this.isLineNumbersShown()) {
            return;
        }
        int maxLineNumber = this.getMaxLineNumber(this.myLineNumberConvertor);
        this.myLineNumberAreaWidth = this.calcLineNumbersAreaWidth(maxLineNumber);
        this.myAdditionalLineNumberAreaWidth = 0;
        if (this.myAdditionalLineNumberConvertor != null) {
            int maxAdditionalLineNumber = this.getMaxLineNumber(this.myAdditionalLineNumberConvertor);
            this.myAdditionalLineNumberAreaWidth = this.calcLineNumbersAreaWidth(maxAdditionalLineNumber);
        }
    }

    private int getMaxLineNumber(@NotNull TIntFunction convertor) {
        if (convertor == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(14);
        }
        for (int i = this.endLineNumber(); i >= 0; --i) {
            int number = convertor.execute(i);
            if (number < 0) continue;
            return number;
        }
        return 0;
    }

    @Nullable
    EditorMouseEventArea getEditorMouseAreaByOffset(int offset) {
        if (this.isLineNumbersShown() && offset < this.getLineNumberAreaOffset() + this.getLineNumberAreaWidth()) {
            return EditorMouseEventArea.LINE_NUMBERS_AREA;
        }
        if (this.isAnnotationsShown() && offset < this.getAnnotationsAreaOffset() + this.getAnnotationsAreaWidth()) {
            return EditorMouseEventArea.ANNOTATIONS_AREA;
        }
        if (this.isLineMarkersShown() && offset < this.getFoldingAreaOffset()) {
            return EditorMouseEventArea.LINE_MARKERS_AREA;
        }
        if (this.isFoldingOutlineShown() && offset < this.getFoldingAreaOffset() + this.getFoldingAreaWidth()) {
            return EditorMouseEventArea.FOLDING_OUTLINE_AREA;
        }
        return null;
    }

    int getLineNumberAreaOffset() {
        if (this.getLineNumberAreaWidth() == 0 && this.getAnnotationsAreaWidthEx() == 0 && this.getLineMarkerAreaWidth() == 0) {
            return this.getFoldingAreaWidth() == 0 ? 0 : 1;
        }
        if (this.getLineNumberAreaWidth() == 0 && this.getAnnotationsAreaWidthEx() > 0) {
            return 0;
        }
        return EditorGutterComponentImpl.getGapBetweenAreas();
    }

    @Override
    public int getAnnotationsAreaOffset() {
        return this.getLineNumberAreaOffset() + EditorGutterComponentImpl.getAreaWidthWithGap(this.getLineNumberAreaWidth());
    }

    @Override
    public int getAnnotationsAreaWidth() {
        return this.myTextAnnotationGuttersSize;
    }

    private int getAnnotationsAreaWidthEx() {
        return this.myTextAnnotationGuttersSize + this.myTextAnnotationExtraSize;
    }

    @Override
    public int getLineMarkerAreaOffset() {
        return this.getAnnotationsAreaOffset() + EditorGutterComponentImpl.getAreaWidthWithGap(this.getAnnotationsAreaWidthEx());
    }

    @Override
    public int getIconAreaOffset() {
        return this.getLineMarkerAreaOffset() + this.getLeftFreePaintersAreaWidth();
    }

    private int getLeftFreePaintersAreaOffset() {
        return this.getLineMarkerAreaOffset();
    }

    @Override
    public int getLineMarkerFreePaintersAreaOffset() {
        return this.getIconAreaOffset() + this.myIconsAreaWidth + this.getGapAfterIconsArea();
    }

    private int getLeftFreePaintersAreaWidth() {
        return this.myLeftFreePaintersAreaShown ? FREE_PAINTERS_LEFT_AREA_WIDTH.get() : 0;
    }

    private int getRightFreePaintersAreaWidth() {
        return this.myRightFreePaintersAreaShown ? FREE_PAINTERS_RIGHT_AREA_WIDTH.get() : 0;
    }

    @Override
    public int getIconsAreaWidth() {
        return this.myIconsAreaWidth;
    }

    private int getGapAfterIconsArea() {
        return this.isRealEditor() && this.areIconsShown() ? EditorGutterComponentImpl.getGapBetweenAreas() : 0;
    }

    private boolean isMirrored() {
        return this.myEditor.getVerticalScrollbarOrientation() != 1;
    }

    @Nullable
    private AffineTransform setMirrorTransformIfNeeded(Graphics2D g, int offset, int width) {
        if (this.isMirrored()) {
            AffineTransform old = g.getTransform();
            AffineTransform transform = new AffineTransform(old);
            transform.scale(-1.0, 1.0);
            transform.translate(-offset * 2 - width, 0.0);
            g.setTransform(transform);
            return old;
        }
        return null;
    }

    @Override
    @Nullable
    public FoldRegion findFoldingAnchorAt(int x, int y) {
        if (!this.myEditor.getSettings().isFoldingOutlineShown()) {
            return null;
        }
        int anchorX = this.getFoldingAreaOffset();
        int anchorWidth = this.getFoldingAnchorWidth();
        int visualLine = this.myEditor.yToVisualLine(y);
        int neighbourhoodStartOffset = this.myEditor.logicalPositionToOffset(this.myEditor.visualToLogicalPosition(new VisualPosition(visualLine, 0)));
        int neighbourhoodEndOffset = this.myEditor.logicalPositionToOffset(this.myEditor.visualToLogicalPosition(new VisualPosition(visualLine, Integer.MAX_VALUE)));
        Collection<DisplayedFoldingAnchor> displayedAnchors = this.myAnchorsDisplayStrategy.getAnchorsToDisplay(neighbourhoodStartOffset, neighbourhoodEndOffset, Collections.emptyList());
        x = this.convertX(x);
        for (DisplayedFoldingAnchor anchor2 : displayedAnchors) {
            Rectangle r = this.rectangleByFoldOffset(anchor2.visualLine, anchorWidth, anchorX);
            if (r.x >= x || x > r.x + r.width || r.y >= y || y > r.y + r.height) continue;
            return anchor2.foldRegion;
        }
        return null;
    }

    private Rectangle rectangleByFoldOffset(int foldStart, int anchorWidth, int anchorX) {
        return new Rectangle(anchorX, (int)this.getFoldAnchorY(foldStart, anchorWidth), anchorWidth, anchorWidth);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        TooltipController.getInstance().cancelTooltips();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        GutterIconRenderer renderer2 = this.getGutterRenderer(e);
        if (renderer2 == null) {
            TextAnnotationGutterProvider provider = this.getProviderAtPoint(e.getPoint());
            String toolTip = null;
            if (provider == null) {
                ActiveGutterRenderer lineRenderer = this.getActiveRendererByMouseEvent(e);
                if (lineRenderer != null) {
                    toolTip = lineRenderer.getTooltipText();
                }
            } else {
                int line = this.getLineNumAtPoint(e.getPoint());
                toolTip = provider.getToolTip(line, (Editor)this.myEditor);
                if (!Comparing.equal((String)toolTip, (String)this.myLastGutterToolTip)) {
                    TooltipController.getInstance().cancelTooltip(GUTTER_TOOLTIP_GROUP, e, true);
                    this.myLastGutterToolTip = toolTip;
                }
            }
            this.tooltipAvailable(toolTip, e, null);
        } else {
            this.computeTooltipInBackground(renderer2, e);
        }
    }

    private void computeTooltipInBackground(final @NotNull GutterIconRenderer renderer2, final @NotNull MouseEvent e) {
        if (renderer2 == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(15);
        }
        if (e == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(16);
        }
        if (this.myCalculatingInBackground == renderer2 && !this.myBackgroundIndicator.isCanceled()) {
            return;
        }
        this.myCalculatingInBackground = renderer2;
        this.myBackgroundIndicator.cancel();
        this.myBackgroundIndicator = new ProgressIndicatorBase();
        final AtomicReference tooltip = new AtomicReference();
        ProgressManager.getInstance().runProcessWithProgressAsynchronously(new Task.Backgroundable(this.myEditor.getProject(), "Constructing Tooltip"){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    2.$$$reportNull$$$0(0);
                }
                tooltip.set(ReadAction.compute(() -> renderer2.getTooltipText()));
            }

            public void onSuccess() {
                EditorGutterComponentImpl.this.tooltipAvailable((String)tooltip.get(), e, (GutterMark)renderer2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/editor/impl/EditorGutterComponentImpl$2", "run"));
            }
        }, this.myBackgroundIndicator);
    }

    void tooltipAvailable(@Nullable String toolTip, @NotNull MouseEvent e, @Nullable GutterMark renderer2) {
        if (e == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(17);
        }
        this.myCalculatingInBackground = null;
        TooltipController controller = TooltipController.getInstance();
        if (toolTip == null || toolTip.isEmpty() || this.myEditor.isDisposed()) {
            controller.cancelTooltip(GUTTER_TOOLTIP_GROUP, e, false);
        } else {
            Ref t = new Ref((Object)e.getPoint());
            int line = this.myEditor.yToVisualLine(e.getY());
            List<GutterMark> row2 = this.getGutterRenderers(line);
            Balloon.Position ballPosition = Balloon.Position.atRight;
            if (row2 != null) {
                TreeMap xPos = new TreeMap();
                int[] currentPos = new int[]{0};
                this.processIconsRow(line, row2, (x, y, r) -> {
                    xPos.put(x, r);
                    if (renderer2 == r) {
                        currentPos[0] = x;
                        Icon icon = this.scaleIcon(r.getIcon());
                        t.set((Object)new Point(x + icon.getIconWidth() / 2, y + icon.getIconHeight() / 2));
                    }
                });
                ArrayList xx = new ArrayList(xPos.keySet());
                int posIndex = xx.indexOf(currentPos[0]);
                if (xPos.size() > 1 && posIndex == 0) {
                    ballPosition = Balloon.Position.below;
                }
            }
            RelativePoint showPoint = new RelativePoint((Component)this, (Point)t.get());
            TooltipRenderer tr = ((EditorMarkupModel)((Object)this.myEditor.getMarkupModel())).getErrorStripTooltipRendererProvider().calcTooltipRenderer(toolTip);
            HintHint hint = new HintHint(this, (Point)t.get()).setAwtTooltip(true).setPreferredPosition(ballPosition).setRequestFocus(ScreenReader.isActive());
            if (this.myEditor.getComponent().getRootPane() != null) {
                controller.showTooltipByMouseMove(this.myEditor, showPoint, tr, false, GUTTER_TOOLTIP_GROUP, hint);
            }
        }
    }

    void validateMousePointer(@NotNull MouseEvent e) {
        GutterIconRenderer renderer2;
        if (e == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(18);
        }
        if (IdeGlassPaneImpl.hasPreProcessedCursor(this)) {
            return;
        }
        FoldRegion foldingAtCursor = this.findFoldingAnchorAt(e.getX(), e.getY());
        this.setActiveFoldRegions(this.getGroupRegions(foldingAtCursor));
        Cursor cursor = Cursor.getPredefinedCursor(0);
        if (foldingAtCursor != null) {
            cursor = Cursor.getPredefinedCursor(12);
        }
        if ((renderer2 = this.getGutterRenderer(e)) != null) {
            if (renderer2.isNavigateAction()) {
                cursor = Cursor.getPredefinedCursor(12);
            }
        } else {
            ActiveGutterRenderer lineRenderer = this.getActiveRendererByMouseEvent(e);
            if (lineRenderer != null) {
                cursor = Cursor.getPredefinedCursor(12);
            } else {
                EditorGutterAction action;
                TextAnnotationGutterProvider provider = this.getProviderAtPoint(e.getPoint());
                if (provider != null && this.myProviderToListener.containsKey(provider) && (action = this.myProviderToListener.get(provider)) != null) {
                    int line = this.getLineNumAtPoint(e.getPoint());
                    cursor = action.getCursor(line);
                }
            }
        }
        UIUtil.setCursor((Component)this, (Cursor)cursor);
    }

    @NotNull
    private List<FoldRegion> getGroupRegions(@Nullable FoldRegion foldingAtCursor) {
        if (foldingAtCursor == null) {
            List<FoldRegion> list2 = Collections.emptyList();
            if (list2 == null) {
                EditorGutterComponentImpl.$$$reportNull$$$0(19);
            }
            return list2;
        }
        FoldingGroup group = foldingAtCursor.getGroup();
        if (group == null) {
            List<FoldRegion> list3 = Collections.singletonList(foldingAtCursor);
            if (list3 == null) {
                EditorGutterComponentImpl.$$$reportNull$$$0(20);
            }
            return list3;
        }
        List<FoldRegion> list4 = this.myEditor.getFoldingModel().getGroupedRegions(group);
        if (list4 == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(21);
        }
        return list4;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.invokePopup(e);
        }
    }

    private void fireEventToTextAnnotationListeners(MouseEvent e) {
        if (this.myEditor.getMouseEventArea(e) == EditorMouseEventArea.ANNOTATIONS_AREA) {
            int line;
            Point clickPoint = e.getPoint();
            TextAnnotationGutterProvider provider = this.getProviderAtPoint(clickPoint);
            if (provider == null) {
                return;
            }
            if (this.myProviderToListener.containsKey(provider) && (line = this.getLineNumAtPoint(clickPoint)) >= 0 && line < this.myEditor.getDocument().getLineCount() && UIUtil.isActionClick((MouseEvent)e, (int)502)) {
                this.myProviderToListener.get(provider).doAction(line);
            }
        }
    }

    private int getLineNumAtPoint(Point clickPoint) {
        return EditorUtil.yPositionToLogicalLine((Editor)this.myEditor, clickPoint);
    }

    @Nullable
    private TextAnnotationGutterProvider getProviderAtPoint(Point clickPoint) {
        int current = this.getAnnotationsAreaOffset();
        if (clickPoint.x < current) {
            return null;
        }
        for (int i = 0; i < this.myTextAnnotationGutterSizes.size(); ++i) {
            if (clickPoint.x > (current += this.myTextAnnotationGutterSizes.get(i))) continue;
            return this.myTextAnnotationGutters.get(i);
        }
        return null;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger() || this.isPopupAction(e)) {
            this.invokePopup(e);
        } else if (UIUtil.isCloseClick((MouseEvent)e)) {
            this.processClose(e);
        }
    }

    private boolean isPopupAction(MouseEvent e) {
        GutterIconRenderer renderer2 = this.getGutterRenderer(e);
        return renderer2 != null && renderer2.getClickAction() == null && renderer2.getPopupMenuActions() != null;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.invokePopup(e);
            return;
        }
        GutterIconRenderer renderer2 = this.getGutterRenderer(e);
        AnAction clickAction = null;
        if (renderer2 != null && e.getButton() < 4) {
            AnAction anAction = clickAction = BitUtil.isSet((int)e.getModifiers(), (int)8) ? renderer2.getMiddleButtonClickAction() : renderer2.getClickAction();
        }
        if (clickAction != null) {
            this.performAction(clickAction, e, "ICON_NAVIGATION", this.myEditor.getDataContext());
            this.repaint();
            e.consume();
        } else {
            ActiveGutterRenderer lineRenderer = this.getActiveRendererByMouseEvent(e);
            if (lineRenderer != null) {
                lineRenderer.doAction((Editor)this.myEditor, e);
            } else {
                this.fireEventToTextAnnotationListeners(e);
            }
        }
    }

    private boolean isDumbMode() {
        Project project = this.myEditor.getProject();
        return project != null && DumbService.isDumb((Project)project);
    }

    private boolean checkDumbAware(@NotNull Object possiblyDumbAware) {
        if (possiblyDumbAware == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(22);
        }
        return !this.isDumbMode() || DumbService.isDumbAware((Object)possiblyDumbAware);
    }

    private void notifyNotDumbAware() {
        Project project = this.myEditor.getProject();
        if (project != null) {
            DumbService.getInstance((Project)project).showDumbModeNotification("This functionality is not available during indexing");
        }
    }

    private void performAction(@NotNull AnAction action, @NotNull InputEvent e, @NotNull String place, @NotNull DataContext context) {
        if (action == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(23);
        }
        if (e == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(24);
        }
        if (place == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(25);
        }
        if (context == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(26);
        }
        if (!this.checkDumbAware(action)) {
            this.notifyNotDumbAware();
            return;
        }
        AnActionEvent actionEvent = AnActionEvent.createFromAnAction((AnAction)action, (InputEvent)e, (String)place, (DataContext)context);
        action.update(actionEvent);
        if (actionEvent.getPresentation().isEnabledAndVisible()) {
            ActionUtil.performActionDumbAwareWithCallbacks((AnAction)action, (AnActionEvent)actionEvent, (DataContext)context);
        }
    }

    @Nullable
    private ActiveGutterRenderer getActiveRendererByMouseEvent(MouseEvent e) {
        if (this.findFoldingAnchorAt(e.getX(), e.getY()) != null) {
            return null;
        }
        if (e.isConsumed() || e.getX() > this.getWhitespaceSeparatorOffset()) {
            return null;
        }
        ActiveGutterRenderer[] gutterRenderer = new ActiveGutterRenderer[]{null};
        int[] layer = new int[]{-1};
        Rectangle clip = this.myEditor.getScrollingModel().getVisibleArea();
        int firstVisibleOffset = this.myEditor.logicalPositionToOffset(this.myEditor.xyToLogicalPosition(new Point(0, clip.y - this.myEditor.getLineHeight())));
        int lastVisibleOffset = this.myEditor.logicalPositionToOffset(this.myEditor.xyToLogicalPosition(new Point(0, clip.y + clip.height + this.myEditor.getLineHeight())));
        this.processRangeHighlighters(firstVisibleOffset, lastVisibleOffset, highlighter -> {
            LineMarkerRenderer renderer2 = highlighter.getLineMarkerRenderer();
            if (renderer2 == null) {
                return;
            }
            if (gutterRenderer[0] != null && layer[0] >= highlighter.getLayer()) {
                return;
            }
            Rectangle rectangle = this.getLineRendererRectangle(highlighter);
            if (rectangle == null) {
                return;
            }
            int startY = rectangle.y;
            int endY = startY + rectangle.height;
            if (startY == endY) {
                endY += this.myEditor.getLineHeight();
            }
            if (startY < e.getY() && e.getY() <= endY && renderer2 instanceof ActiveGutterRenderer && ((ActiveGutterRenderer)renderer2).canDoAction((Editor)this.myEditor, e)) {
                gutterRenderer[0] = (ActiveGutterRenderer)renderer2;
                layer[0] = highlighter.getLayer();
            }
        });
        return gutterRenderer[0];
    }

    public void closeAllAnnotations() {
        if (!this.myCanCloseAnnotations) {
            return;
        }
        for (TextAnnotationGutterProvider provider : this.myTextAnnotationGutters) {
            provider.gutterClosed();
        }
        this.revalidateSizes();
    }

    private void revalidateSizes() {
        this.myTextAnnotationGutters = new ArrayList();
        this.myTextAnnotationGutterSizes = new TIntArrayList();
        this.updateSize();
    }

    @Override
    @Nullable
    public Point getCenterPoint(GutterIconRenderer renderer2) {
        Ref result2 = Ref.create();
        if (!this.areIconsShown()) {
            this.processGutterRenderers((TIntObjectProcedure<List<GutterMark>>)((TIntObjectProcedure)(line, renderers) -> {
                if (ContainerUtil.find((Iterable)renderers, (Object)renderer2) != null) {
                    result2.set((Object)new Point(this.getIconAreaOffset(), this.getLineCenterY(line)));
                    return false;
                }
                return true;
            }));
        } else {
            this.processGutterRenderers((TIntObjectProcedure<List<GutterMark>>)((TIntObjectProcedure)(line, renderers) -> {
                this.processIconsRow(line, (List<? extends GutterMark>)renderers, (x, y, r) -> {
                    if (result2.isNull() && r.equals(renderer2)) {
                        Icon icon = this.scaleIcon(r.getIcon());
                        result2.set((Object)new Point(x + icon.getIconWidth() / 2, y + icon.getIconHeight() / 2));
                    }
                });
                return result2.isNull();
            }));
        }
        return (Point)result2.get();
    }

    @Override
    public void setLineNumberConvertor(@Nullable TIntFunction lineNumberConvertor) {
        this.setLineNumberConvertor(lineNumberConvertor, null);
    }

    @Override
    public void setLineNumberConvertor(@Nullable TIntFunction lineNumberConvertor1, @Nullable TIntFunction lineNumberConvertor2) {
        this.myLineNumberConvertor = lineNumberConvertor1 != null ? lineNumberConvertor1 : value -> value;
        this.myAdditionalLineNumberConvertor = lineNumberConvertor2;
    }

    @Override
    public void setShowDefaultGutterPopup(boolean show) {
        this.myShowDefaultGutterPopup = show;
    }

    @Override
    public void setCanCloseAnnotations(boolean canCloseAnnotations) {
        this.myCanCloseAnnotations = canCloseAnnotations;
    }

    @Override
    public void setGutterPopupGroup(@Nullable ActionGroup group) {
        this.myCustomGutterPopupGroup = group;
    }

    @Override
    public void setPaintBackground(boolean value) {
        this.myPaintBackground = value;
    }

    @Override
    public void setForceShowLeftFreePaintersArea(boolean value) {
        this.myForceLeftFreePaintersAreaShown = value;
    }

    @Override
    public void setForceShowRightFreePaintersArea(boolean value) {
        this.myForceRightFreePaintersAreaShown = value;
    }

    @Override
    public void setInitialIconAreaWidth(int width) {
        this.myStartIconAreaWidth = width;
    }

    private void invokePopup(MouseEvent e) {
        this.myLogicalLineAtCursor = EditorUtil.yPositionToLogicalLine((Editor)this.myEditor, e);
        ActionManager actionManager = ActionManager.getInstance();
        if (this.myEditor.getMouseEventArea(e) == EditorMouseEventArea.ANNOTATIONS_AREA) {
            ArrayList<CloseAnnotationsAction> addActions = new ArrayList<CloseAnnotationsAction>();
            if (this.myCanCloseAnnotations) {
                addActions.add(new CloseAnnotationsAction());
            }
            for (TextAnnotationGutterProvider textAnnotationGutterProvider : this.myTextAnnotationGutters) {
                List list2 = textAnnotationGutterProvider.getPopupActions(this.myLogicalLineAtCursor, (Editor)this.myEditor);
                if (list2 == null) continue;
                for (AnAction action : list2) {
                    if (addActions.contains(action)) continue;
                    addActions.add((CloseAnnotationsAction)action);
                }
            }
            if (!addActions.isEmpty()) {
                DefaultActionGroup actionGroup = new DefaultActionGroup(EditorBundle.message((String)"editor.annotations.action.group.name", (Object[])new Object[0]), true);
                for (AnAction anAction : addActions) {
                    actionGroup.add(anAction);
                }
                JPopupMenu jPopupMenu = actionManager.createActionPopupMenu("", (ActionGroup)actionGroup).getComponent();
                jPopupMenu.show(this, e.getX(), e.getY());
                e.consume();
            }
        } else {
            GutterIconRenderer renderer2 = this.getGutterRenderer(e);
            if (renderer2 != null) {
                AnAction rightButtonAction = renderer2.getRightButtonClickAction();
                if (rightButtonAction != null) {
                    this.performAction(rightButtonAction, e, "ICON_NAVIGATION_SECONDARY_BUTTON", this.myEditor.getDataContext());
                    e.consume();
                } else {
                    ActionGroup actionGroup = renderer2.getPopupMenuActions();
                    if (actionGroup != null) {
                        if (this.checkDumbAware(actionGroup)) {
                            actionManager.createActionPopupMenu("unknown", actionGroup).getComponent().show(this, e.getX(), e.getY());
                        } else {
                            this.notifyNotDumbAware();
                        }
                        e.consume();
                    }
                }
            } else {
                ActionGroup group = this.myCustomGutterPopupGroup;
                if (group == null && this.myShowDefaultGutterPopup) {
                    group = (ActionGroup)CustomActionsSchema.getInstance().getCorrectedAction("EditorGutterPopupMenu");
                }
                if (group != null) {
                    ActionPopupMenu actionPopupMenu = actionManager.createActionPopupMenu("unknown", group);
                    actionPopupMenu.getComponent().show(this, e.getX(), e.getY());
                }
                e.consume();
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
        TooltipController.getInstance().cancelTooltip(GUTTER_TOOLTIP_GROUP, e, false);
    }

    private int convertPointToLineNumber(Point p) {
        int line;
        DocumentEx document = this.myEditor.getDocument();
        if (!EditorGutterComponentImpl.isValidLine(document, line = EditorUtil.yPositionToLogicalLine((Editor)this.myEditor, p))) {
            return -1;
        }
        int startOffset = document.getLineStartOffset(line);
        FoldRegion region = this.myEditor.getFoldingModel().getCollapsedRegionAtOffset(startOffset);
        if (region != null) {
            return document.getLineNumber(region.getEndOffset());
        }
        return line;
    }

    @Override
    @Nullable
    public GutterMark getGutterRenderer(Point p) {
        int line = this.myEditor.yToVisualLine(p.y);
        List<GutterMark> renderers = this.getGutterRenderers(line);
        if (renderers == null) {
            return null;
        }
        GutterMark[] result2 = new GutterMark[]{null};
        this.processIconsRow(line, renderers, (x, y, renderer2) -> {
            int ex = this.convertX((int)p.getX());
            Icon icon = this.scaleIcon(renderer2.getIcon());
            if (x <= ex && ex <= x + icon.getIconWidth()) {
                result2[0] = renderer2;
            }
        });
        return result2[0];
    }

    @Nullable
    private GutterIconRenderer getGutterRenderer(MouseEvent e) {
        return (GutterIconRenderer)this.getGutterRenderer(e.getPoint());
    }

    @NotNull
    static LineMarkerRendererEx.Position getLineMarkerPosition(@NotNull LineMarkerRenderer renderer2) {
        if (renderer2 == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(27);
        }
        if (renderer2 instanceof LineMarkerRendererEx) {
            LineMarkerRendererEx.Position position = ((LineMarkerRendererEx)renderer2).getPosition();
            if (position == null) {
                EditorGutterComponentImpl.$$$reportNull$$$0(28);
            }
            return position;
        }
        LineMarkerRendererEx.Position position = LineMarkerRendererEx.Position.RIGHT;
        if (position == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(29);
        }
        return position;
    }

    int convertX(int x) {
        if (!this.isMirrored()) {
            return x;
        }
        return this.getWidth() - x;
    }

    public void dispose() {
        for (TextAnnotationGutterProvider gutterProvider : this.myTextAnnotationGutters) {
            gutterProvider.gutterClosed();
        }
        this.myProviderToListener.clear();
    }

    @Override
    public boolean isFocusable() {
        return ScreenReader.isActive();
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new JComponent.AccessibleJComponent(){};
        }
        return this.accessibleContext;
    }

    void setCurrentAccessibleLine(@Nullable AccessibleGutterLine line) {
        this.myAccessibleGutterLine = line;
    }

    @Nullable
    AccessibleGutterLine getCurrentAccessibleLine() {
        return this.myAccessibleGutterLine;
    }

    void escapeCurrentAccessibleLine() {
        if (this.myAccessibleGutterLine != null) {
            this.myAccessibleGutterLine.escape(true);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 12: 
            case 19: 
            case 20: 
            case 21: 
            case 28: 
            case 29: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 12: 
            case 19: 
            case 20: 
            case 21: 
            case 28: 
            case 29: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 12: 
            case 19: 
            case 20: 
            case 21: 
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/EditorGutterComponentImpl";
                break;
            }
            case 2: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "convertor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "row";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 11: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activeFoldRegions";
                break;
            }
            case 15: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "possiblyDumbAware";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/EditorGutterComponentImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditor";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextAnnotations";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupRegions";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getLineMarkerPosition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 12: 
            case 19: 
            case 20: 
            case 21: 
            case 28: 
            case 29: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "doPaintLineNumbers";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processRangeHighlighters";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isValidLine";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processGutterRenderers";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processIconsRow";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "registerTextAnnotation";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setActiveFoldRegions";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getMaxLineNumber";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "computeTooltipInBackground";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "tooltipAvailable";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "validateMousePointer";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "checkDumbAware";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "performAction";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getLineMarkerPosition";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 12: 
            case 19: 
            case 20: 
            case 21: 
            case 28: 
            case 29: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class CloseAnnotationsAction
    extends DumbAwareAction {
        CloseAnnotationsAction() {
            super(EditorBundle.message((String)"close.editor.annotations.action.name", (Object[])new Object[0]));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                CloseAnnotationsAction.$$$reportNull$$$0(0);
            }
            EditorGutterComponentImpl.this.closeAllAnnotations();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/EditorGutterComponentImpl$CloseAnnotationsAction", "actionPerformed"));
        }
    }

    @FunctionalInterface
    static interface LineGutterIconRendererProcessor {
        public void process(int var1, int var2, @NotNull GutterMark var3);
    }

    @FunctionalInterface
    static interface RangeHighlighterProcessor {
        public void process(@NotNull RangeHighlighter var1);
    }
}

