/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.util;

import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.diff.DiffColors;
import com.intellij.openapi.diff.impl.util.TextDiffTypeEnum;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import java.awt.Color;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextDiffType {
    public static final TextDiffType INSERT = new TextDiffType(TextDiffTypeEnum.INSERT, DiffBundle.message((String)"diff.type.inserted.name", (Object[])new Object[0]), DiffColors.DIFF_INSERTED);
    public static final TextDiffType CHANGED = new TextDiffType(TextDiffTypeEnum.CHANGED, DiffBundle.message((String)"diff.type.changed.name", (Object[])new Object[0]), DiffColors.DIFF_MODIFIED);
    public static final TextDiffType DELETED = new TextDiffType(TextDiffTypeEnum.DELETED, DiffBundle.message((String)"diff.type.deleted.name", (Object[])new Object[0]), DiffColors.DIFF_DELETED);
    public static final TextDiffType CONFLICT = new TextDiffType(TextDiffTypeEnum.CONFLICT, DiffBundle.message((String)"diff.type.conflict.name", (Object[])new Object[0]), DiffColors.DIFF_CONFLICT);
    public static final TextDiffType NONE = new TextDiffType(TextDiffTypeEnum.NONE, DiffBundle.message((String)"diff.type.none.name", (Object[])new Object[0]), null);
    public static final List<TextDiffType> DIFF_TYPES = Arrays.asList(DELETED, CHANGED, INSERT);
    public static final List<TextDiffType> MERGE_TYPES = Arrays.asList(DELETED, CHANGED, INSERT, CONFLICT);
    private final TextDiffTypeEnum myType;
    private final TextAttributesKey myAttributesKey;
    private final String myDisplayName;

    @NotNull
    public static TextDiffType create(@Nullable TextDiffTypeEnum type) {
        if (TextDiffTypeEnum.INSERT.equals((Object)type)) {
            TextDiffType textDiffType = INSERT;
            if (textDiffType == null) {
                TextDiffType.$$$reportNull$$$0(0);
            }
            return textDiffType;
        }
        if (TextDiffTypeEnum.CHANGED.equals((Object)type)) {
            TextDiffType textDiffType = CHANGED;
            if (textDiffType == null) {
                TextDiffType.$$$reportNull$$$0(1);
            }
            return textDiffType;
        }
        if (TextDiffTypeEnum.DELETED.equals((Object)type)) {
            TextDiffType textDiffType = DELETED;
            if (textDiffType == null) {
                TextDiffType.$$$reportNull$$$0(2);
            }
            return textDiffType;
        }
        if (TextDiffTypeEnum.CONFLICT.equals((Object)type)) {
            TextDiffType textDiffType = CONFLICT;
            if (textDiffType == null) {
                TextDiffType.$$$reportNull$$$0(3);
            }
            return textDiffType;
        }
        TextDiffType textDiffType = NONE;
        if (textDiffType == null) {
            TextDiffType.$$$reportNull$$$0(4);
        }
        return textDiffType;
    }

    private TextDiffType(TextDiffTypeEnum type, String displayName, TextAttributesKey attributesKey) {
        this.myType = type;
        this.myAttributesKey = attributesKey;
        this.myDisplayName = displayName;
    }

    public String getDisplayName() {
        return this.myDisplayName;
    }

    public TextAttributesKey getAttributesKey() {
        return this.myAttributesKey;
    }

    @Nullable
    public TextAttributes getTextAttributes(@NotNull EditorColorsScheme scheme2) {
        if (scheme2 == null) {
            TextDiffType.$$$reportNull$$$0(5);
        }
        return scheme2.getAttributes(this.myAttributesKey);
    }

    @Nullable
    public Color getPolygonColor(Editor editor) {
        TextAttributes attributes = this.getTextAttributes(editor);
        return attributes == null ? null : attributes.getBackgroundColor();
    }

    @Nullable
    public TextAttributes getTextAttributes(@NotNull Editor editor) {
        if (editor == null) {
            TextDiffType.$$$reportNull$$$0(6);
        }
        return this.getTextAttributes(editor.getColorsScheme());
    }

    public String toString() {
        return this.myDisplayName;
    }

    public TextDiffTypeEnum getType() {
        return this.myType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/diff/impl/util/TextDiffType";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scheme";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/diff/impl/util/TextDiffType";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getTextAttributes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

