/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.patch.formove;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import com.intellij.openapi.diff.impl.patch.apply.ApplyFilePatchBase;
import com.intellij.openapi.diff.impl.patch.apply.ApplyFilePatchFactory;
import com.intellij.openapi.diff.impl.patch.formove.PatchApplier;
import com.intellij.openapi.diff.impl.patch.formove.PathMerger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.ex.FileTypeChooser;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.openapi.vcs.changes.patch.RelativePathCalculator;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PathsVerifier {
    private final Project myProject;
    private final VirtualFile myBaseDirectory;
    private final List<? extends FilePatch> myPatches;
    private final Map<VirtualFile, MovedFileData> myMovedFiles;
    private final List<FilePath> myBeforePaths;
    private final List<VirtualFile> myCreatedDirectories;
    private final List<PatchAndFile> myTextPatches;
    private final List<PatchAndFile> myBinaryPatches;
    @NotNull
    private final List<VirtualFile> myWritableFiles;
    private final ProjectLevelVcsManager myVcsManager;
    private final List<FilePatch> mySkipped;
    private DelayedPrecheckContext myDelayedPrecheckContext;
    private final List<FilePath> myAddedPaths;
    private final List<FilePath> myDeletedPaths;
    private boolean myIgnoreContentRootsCheck;

    public PathsVerifier(@NotNull Project project, @NotNull VirtualFile baseDirectory, @NotNull List<? extends FilePatch> patches2) {
        if (project == null) {
            PathsVerifier.$$$reportNull$$$0(0);
        }
        if (baseDirectory == null) {
            PathsVerifier.$$$reportNull$$$0(1);
        }
        if (patches2 == null) {
            PathsVerifier.$$$reportNull$$$0(2);
        }
        this.myProject = project;
        this.myBaseDirectory = baseDirectory;
        this.myPatches = patches2;
        this.myMovedFiles = new HashMap<VirtualFile, MovedFileData>();
        this.myBeforePaths = new ArrayList<FilePath>();
        this.myCreatedDirectories = new ArrayList<VirtualFile>();
        this.myTextPatches = new ArrayList<PatchAndFile>();
        this.myBinaryPatches = new ArrayList<PatchAndFile>();
        this.myWritableFiles = new ArrayList<VirtualFile>();
        this.myVcsManager = ProjectLevelVcsManager.getInstance((Project)this.myProject);
        this.mySkipped = new ArrayList<FilePatch>();
        this.myAddedPaths = new ArrayList<FilePath>();
        this.myDeletedPaths = new ArrayList<FilePath>();
    }

    public List<FilePath> getDirectlyAffected() {
        ArrayList<FilePath> affected = new ArrayList<FilePath>();
        PathsVerifier.addAllFilePath(this.myCreatedDirectories, affected);
        PathsVerifier.addAllFilePath(this.myWritableFiles, affected);
        affected.addAll(this.myBeforePaths);
        return affected;
    }

    public List<VirtualFile> getAllAffected() {
        VirtualFile parent;
        ArrayList<VirtualFile> affected = new ArrayList<VirtualFile>();
        affected.addAll(this.myCreatedDirectories);
        affected.addAll(this.myWritableFiles);
        for (VirtualFile file2 : this.myMovedFiles.keySet()) {
            parent = file2.getParent();
            if (parent == null) continue;
            affected.add(parent);
        }
        for (FilePath path : this.myBeforePaths) {
            VirtualFile parentFile;
            parent = path.getParentPath();
            if (parent == null || (parentFile = parent.getVirtualFile()) == null) continue;
            affected.add(parentFile);
        }
        return affected;
    }

    private static void addAllFilePath(Collection<? extends VirtualFile> files2, Collection<? super FilePath> paths) {
        for (VirtualFile virtualFile : files2) {
            paths.add((FilePath)VcsUtil.getFilePath((VirtualFile)virtualFile));
        }
    }

    public List<FilePatch> nonWriteActionPreCheck() {
        ArrayList failedToApply = ContainerUtil.newArrayList();
        this.myDelayedPrecheckContext = new DelayedPrecheckContext(this.myProject);
        for (FilePatch filePatch : this.myPatches) {
            CheckPath checker = this.getChecker(filePatch);
            if (checker.canBeApplied(this.myDelayedPrecheckContext)) continue;
            this.revert(checker.getErrorMessage());
            failedToApply.add(filePatch);
        }
        Collection<FilePatch> skipped = this.myDelayedPrecheckContext.doDelayed();
        this.mySkipped.addAll(skipped);
        this.myPatches.removeAll(skipped);
        this.myPatches.removeAll(failedToApply);
        return failedToApply;
    }

    public List<FilePatch> getSkipped() {
        return this.mySkipped;
    }

    public List<FilePatch> execute() {
        ArrayList failedPatches = ContainerUtil.newArrayList();
        try {
            ArrayList<CheckPath> checkers = new ArrayList<CheckPath>(this.myPatches.size());
            for (FilePatch filePatch : this.myPatches) {
                CheckPath checker = this.getChecker(filePatch);
                checkers.add(checker);
            }
            for (CheckPath checkPath : checkers) {
                if (checkPath.check()) continue;
                failedPatches.add(checkPath.getPatch());
                this.revert(checkPath.getErrorMessage());
            }
        }
        catch (IOException e) {
            this.revert(e.getMessage());
        }
        this.myPatches.removeAll(failedPatches);
        return failedPatches;
    }

    private CheckPath getChecker(FilePatch patch) {
        String beforeFileName = patch.getBeforeName();
        String afterFileName = patch.getAfterName();
        if (beforeFileName == null || patch.isNewFile()) {
            return new CheckAdded(patch);
        }
        if (afterFileName == null || patch.isDeletedFile()) {
            return new CheckDeleted(patch);
        }
        if (!beforeFileName.equals(afterFileName)) {
            return new CheckMoved(patch);
        }
        return new CheckModified(patch);
    }

    public Collection<FilePath> getToBeAdded() {
        return this.myAddedPaths;
    }

    public Collection<FilePath> getToBeDeleted() {
        return this.myDeletedPaths;
    }

    @NotNull
    public Collection<FilePatch> filterBadFileTypePatches() {
        List failedTextPatches = ContainerUtil.findAll(this.myTextPatches, textPatch -> !this.isFileTypeOk(textPatch.getFile()));
        this.myTextPatches.removeAll(failedTextPatches);
        List list2 = ContainerUtil.map((Collection)failedTextPatches, patchInfo -> patchInfo.getApplyPatch().getPatch());
        if (list2 == null) {
            PathsVerifier.$$$reportNull$$$0(3);
        }
        return list2;
    }

    private boolean isFileTypeOk(@NotNull VirtualFile file2) {
        if (file2 == null) {
            PathsVerifier.$$$reportNull$$$0(4);
        }
        if (file2.isDirectory()) {
            PatchApplier.showError(this.myProject, "Cannot apply content for " + file2.getPresentableName() + " file from patch because it is directory.");
            return false;
        }
        FileType fileType = file2.getFileType();
        if (fileType == FileTypes.UNKNOWN && (fileType = FileTypeChooser.associateFileType(file2.getName())) == null) {
            PatchApplier.showError(this.myProject, "Cannot apply content for " + file2.getPresentableName() + " file from patch because its type not defined.");
            return false;
        }
        if (fileType.isBinary()) {
            PatchApplier.showError(this.myProject, "Cannot apply file " + file2.getPresentableName() + " from patch because it is binary.");
            return false;
        }
        return true;
    }

    private void addPatch(@NotNull FilePatch patch, @NotNull VirtualFile file2) {
        if (patch == null) {
            PathsVerifier.$$$reportNull$$$0(5);
        }
        if (file2 == null) {
            PathsVerifier.$$$reportNull$$$0(6);
        }
        if (patch instanceof TextFilePatch) {
            this.myTextPatches.add(new PatchAndFile(file2, ApplyFilePatchFactory.create((TextFilePatch)patch)));
        } else {
            this.myBinaryPatches.add(new PatchAndFile(file2, ApplyFilePatchFactory.createGeneral(patch)));
        }
        this.myWritableFiles.add(file2);
    }

    private static String fileNotFoundMessage(String path) {
        return VcsBundle.message((String)"cannot.find.file.to.patch", (Object[])new Object[]{path});
    }

    private static String fileAlreadyExists(String path) {
        return VcsBundle.message((String)"cannot.apply.file.already.exists", (Object[])new Object[]{path});
    }

    private void revert(String errorMessage) {
        PatchApplier.showError(this.myProject, errorMessage);
    }

    private static VirtualFile createFile(VirtualFile parent, String name) throws IOException {
        return parent.createChildData(PatchApplier.class, name);
    }

    private static VirtualFile moveFile(VirtualFile file2, VirtualFile newParent) throws IOException {
        file2.move(FilePatch.class, newParent);
        return file2;
    }

    @Nullable
    private VirtualFile makeSureParentPathExists(String[] pieces) throws IOException {
        VirtualFile child2 = this.myBaseDirectory;
        int size = pieces.length - 1;
        for (int i = 0; i < size; ++i) {
            String piece = pieces[i];
            if (StringUtil.isEmptyOrSpaces((String)piece)) continue;
            if ("..".equals(piece)) {
                child2 = child2.getParent();
                continue;
            }
            VirtualFile nextChild = child2.findChild(piece);
            if (nextChild == null) {
                nextChild = VfsUtil.createDirectories((String)(child2.getPath() + '/' + piece));
                if (nextChild == null) {
                    throw new IOException("Can't create directory: " + piece);
                }
                this.myCreatedDirectories.add(nextChild);
            }
            child2 = nextChild;
        }
        return child2;
    }

    public List<PatchAndFile> getTextPatches() {
        return this.myTextPatches;
    }

    public List<PatchAndFile> getBinaryPatches() {
        return this.myBinaryPatches;
    }

    @NotNull
    public List<VirtualFile> getWritableFiles() {
        List<VirtualFile> list2 = this.myWritableFiles;
        if (list2 == null) {
            PathsVerifier.$$$reportNull$$$0(7);
        }
        return list2;
    }

    public void doMoveIfNeeded(VirtualFile file2) throws IOException {
        final MovedFileData movedFile = this.myMovedFiles.get(file2);
        if (movedFile != null) {
            this.myBeforePaths.add(VcsUtil.getFilePath((VirtualFile)file2));
            ApplicationManager.getApplication().runWriteAction((ThrowableComputable)new ThrowableComputable<VirtualFile, IOException>(){

                public VirtualFile compute() throws IOException {
                    return movedFile.doMove();
                }
            });
        }
    }

    public void setIgnoreContentRootsCheck(boolean ignoreContentRootsCheck) {
        this.myIgnoreContentRootsCheck = ignoreContentRootsCheck;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDirectory";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patches";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/diff/impl/patch/formove/PathsVerifier";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patch";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/diff/impl/patch/formove/PathsVerifier";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "filterBadFileTypePatches";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getWritableFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 7: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isFileTypeOk";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addPatch";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class PatchAndFile {
        private final VirtualFile myFile;
        private final ApplyFilePatchBase<?> myPatch;

        public PatchAndFile(VirtualFile file2, ApplyFilePatchBase<?> patch) {
            this.myFile = file2;
            this.myPatch = patch;
        }

        public VirtualFile getFile() {
            return this.myFile;
        }

        public ApplyFilePatchBase<?> getApplyPatch() {
            return this.myPatch;
        }
    }

    private static class DelayedPrecheckContext {
        private final Map<FilePath, FilePatch> mySkipDeleted;
        private final Map<FilePath, FilePatch> myOverrideExisting;
        private final List<FilePath> myOverridenPaths;
        private final Project myProject;

        private DelayedPrecheckContext(Project project) {
            this.myProject = project;
            this.myOverrideExisting = new HashMap<FilePath, FilePatch>();
            this.mySkipDeleted = new HashMap<FilePath, FilePatch>();
            this.myOverridenPaths = new LinkedList<FilePath>();
        }

        public void addSkip(FilePath path, FilePatch filePatch) {
            this.mySkipDeleted.put(path, filePatch);
        }

        public void addOverrideExisting(FilePatch patch, FilePath filePath) {
            if (!this.myOverrideExisting.containsKey(filePath)) {
                this.myOverrideExisting.put(filePath, patch);
            }
        }

        public Collection<FilePatch> doDelayed() {
            LinkedList<FilePatch> result2 = new LinkedList<FilePatch>();
            if (!this.myOverrideExisting.isEmpty()) {
                String title = "Overwrite Existing Files";
                ArrayList<FilePath> files2 = new ArrayList<FilePath>(this.myOverrideExisting.keySet());
                Collection selected = AbstractVcsHelper.getInstance((Project)this.myProject).selectFilePathsToProcess(files2, "Overwrite Existing Files", "\nThe following files should be created by patch, but they already exist.\nDo you want to overwrite them?\n", "Overwrite Existing Files", "The following file should be created by patch, but it already exists.\nDo you want to overwrite it?\n{0}", VcsShowConfirmationOption.STATIC_SHOW_CONFIRMATION, "Overwrite", "Cancel");
                if (selected != null) {
                    for (FilePath path : selected) {
                        this.myOverrideExisting.remove(path);
                    }
                }
                result2.addAll(this.myOverrideExisting.values());
                if (selected != null) {
                    this.myOverridenPaths.addAll(selected);
                }
            }
            result2.addAll(this.mySkipDeleted.values());
            return result2;
        }

        public List<FilePath> getOverridenPaths() {
            return this.myOverridenPaths;
        }

        public Collection<FilePath> getAlreadyDeletedPaths() {
            return this.mySkipDeleted.keySet();
        }
    }

    private static class MovedFileData {
        private final VirtualFile myNewParent;
        private final VirtualFile myCurrent;
        private final String myNewName;

        private MovedFileData(@NotNull VirtualFile newParent, @NotNull VirtualFile current, @NotNull String newName) {
            if (newParent == null) {
                MovedFileData.$$$reportNull$$$0(0);
            }
            if (current == null) {
                MovedFileData.$$$reportNull$$$0(1);
            }
            if (newName == null) {
                MovedFileData.$$$reportNull$$$0(2);
            }
            this.myNewParent = newParent;
            this.myCurrent = current;
            this.myNewName = newName;
        }

        public VirtualFile getCurrent() {
            return this.myCurrent;
        }

        public VirtualFile getNewParent() {
            return this.myNewParent;
        }

        public String getNewName() {
            return this.myNewName;
        }

        public VirtualFile doMove() throws IOException {
            boolean needMove;
            VirtualFile oldParent = this.myCurrent.getParent();
            boolean needRename = !Comparing.equal((String)this.myCurrent.getName(), (String)this.myNewName);
            boolean bl = needMove = !this.myNewParent.equals(oldParent);
            if (needRename) {
                File oldParentFile;
                File targetAfterRenameFile;
                if (needMove && (targetAfterRenameFile = new File(oldParentFile = VfsUtilCore.virtualToIoFile((VirtualFile)oldParent), this.myNewName)).exists() && this.myCurrent.exists()) {
                    this.performRenameWithConflicts(oldParentFile);
                    return this.myCurrent;
                }
                this.myCurrent.rename(PatchApplier.class, this.myNewName);
            }
            if (needMove) {
                this.myCurrent.move(PatchApplier.class, this.myNewParent);
            }
            return this.myCurrent;
        }

        private void performRenameWithConflicts(@NotNull File oldParent) throws IOException {
            if (oldParent == null) {
                MovedFileData.$$$reportNull$$$0(3);
            }
            File tmpFileWithUniqueName = FileUtil.createTempFile((File)oldParent, (String)"tempFileToMove", null, (boolean)false);
            File newParentFile = VfsUtilCore.virtualToIoFile((VirtualFile)this.myNewParent);
            File destFile = new File(newParentFile, tmpFileWithUniqueName.getName());
            while (destFile.exists()) {
                destFile = new File(newParentFile, FileUtil.createTempFile((File)oldParent, (String)FileUtil.getNameWithoutExtension((String)destFile.getName()), null, (boolean)false).getName());
            }
            this.myCurrent.rename(PatchApplier.class, destFile.getName());
            this.myCurrent.move(PatchApplier.class, this.myNewParent);
            this.myCurrent.rename(PatchApplier.class, this.myNewName);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newParent";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "current";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newName";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "oldParent";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/diff/impl/patch/formove/PathsVerifier$MovedFileData";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "performRenameWithConflicts";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private abstract class CheckPath {
        protected final String myBeforeName;
        protected final String myAfterName;
        protected final FilePatch myPatch;
        private String myErrorMessage;

        CheckPath(FilePatch path) {
            this.myPatch = path;
            this.myBeforeName = path.getBeforeName();
            this.myAfterName = path.getAfterName();
        }

        public String getErrorMessage() {
            return this.myErrorMessage;
        }

        public void setErrorMessage(String errorMessage) {
            this.myErrorMessage = errorMessage;
        }

        public boolean canBeApplied(DelayedPrecheckContext context) {
            VirtualFile beforeFile = this.getMappedFile(this.myBeforeName);
            VirtualFile afterFile = this.getMappedFile(this.myAfterName);
            return this.precheck(beforeFile, afterFile, context);
        }

        protected abstract boolean precheck(VirtualFile var1, VirtualFile var2, DelayedPrecheckContext var3);

        protected abstract boolean check() throws IOException;

        @Contract(value="null, _ -> false")
        protected boolean checkExistsAndValid(@Nullable VirtualFile file2, String name) {
            if (file2 == null) {
                this.setErrorMessage(PathsVerifier.fileNotFoundMessage(name));
                return false;
            }
            return this.checkModificationValid(file2, name);
        }

        protected boolean checkModificationValid(VirtualFile file2, String name) {
            if (ApplicationManager.getApplication().isUnitTestMode() && PathsVerifier.this.myIgnoreContentRootsCheck) {
                return true;
            }
            if (file2 == null || !this.inContent(file2) || PathsVerifier.this.myVcsManager.getVcsRootFor(file2) == null) {
                this.setErrorMessage("File to patch found outside content root: " + name);
                return false;
            }
            return true;
        }

        @Nullable
        protected VirtualFile getMappedFile(String path) {
            return PathMerger.getFile(PathsVerifier.this.myBaseDirectory, path);
        }

        protected FilePath getMappedFilePath(String path) {
            return PathMerger.getFile(VcsUtil.getFilePath((VirtualFile)PathsVerifier.this.myBaseDirectory), path);
        }

        private boolean inContent(VirtualFile file2) {
            return PathsVerifier.this.myVcsManager.isFileInContent(file2);
        }

        public FilePatch getPatch() {
            return this.myPatch;
        }
    }

    private class CheckMoved
    extends CheckPath {
        private CheckMoved(FilePatch path) {
            super(path);
        }

        @Override
        protected boolean precheck(VirtualFile beforeFile, VirtualFile afterFile, DelayedPrecheckContext context) {
            if (beforeFile == null) {
                this.setErrorMessage(PathsVerifier.fileNotFoundMessage(this.myBeforeName));
            } else if (afterFile != null) {
                this.setErrorMessage(PathsVerifier.fileAlreadyExists(afterFile.getPath()));
            }
            return beforeFile != null && afterFile == null;
        }

        @Override
        public boolean check() throws IOException {
            String[] pieces = RelativePathCalculator.split(this.myAfterName);
            VirtualFile afterFileParent = PathsVerifier.this.makeSureParentPathExists(pieces);
            if (afterFileParent == null) {
                this.setErrorMessage(PathsVerifier.fileNotFoundMessage(this.myAfterName));
                return false;
            }
            VirtualFile beforeFile = this.getMappedFile(this.myBeforeName);
            if (!this.checkExistsAndValid(beforeFile, this.myBeforeName)) {
                return false;
            }
            PathsVerifier.this.myMovedFiles.put(beforeFile, new MovedFileData(afterFileParent, beforeFile, this.myPatch.getAfterFileName()));
            PathsVerifier.this.addPatch(this.myPatch, beforeFile);
            return true;
        }
    }

    private class CheckAdded
    extends CheckPath {
        private CheckAdded(FilePatch path) {
            super(path);
        }

        @Override
        protected boolean precheck(VirtualFile beforeFile, VirtualFile afterFile, DelayedPrecheckContext context) {
            if (afterFile != null) {
                context.addOverrideExisting(this.myPatch, VcsUtil.getFilePath((VirtualFile)afterFile));
            }
            return true;
        }

        @Override
        public boolean check() throws IOException {
            VirtualFile file2;
            String[] pieces = RelativePathCalculator.split(this.myAfterName);
            VirtualFile parent = PathsVerifier.this.makeSureParentPathExists(pieces);
            if (parent == null) {
                this.setErrorMessage(PathsVerifier.fileNotFoundMessage(this.myAfterName));
                return false;
            }
            String name = pieces[pieces.length - 1];
            File afterFile = new File(parent.getPath(), name);
            VirtualFile virtualFile = file2 = PathsVerifier.this.myDelayedPrecheckContext.getOverridenPaths().contains(VcsUtil.getFilePath((File)afterFile)) ? parent.findChild(name) : PathsVerifier.createFile(parent, name);
            if (file2 == null) {
                this.setErrorMessage(PathsVerifier.fileNotFoundMessage(this.myAfterName));
                return false;
            }
            PathsVerifier.this.myAddedPaths.add(VcsUtil.getFilePath((VirtualFile)file2));
            if (!this.checkExistsAndValid(file2, this.myAfterName)) {
                return false;
            }
            PathsVerifier.this.addPatch(this.myPatch, file2);
            return true;
        }
    }

    private class CheckDeleted
    extends CheckPath {
        protected CheckDeleted(FilePatch path) {
            super(path);
        }

        @Override
        protected boolean precheck(VirtualFile beforeFile, VirtualFile afterFile, DelayedPrecheckContext context) {
            if (beforeFile == null) {
                context.addSkip(this.getMappedFilePath(this.myBeforeName), this.myPatch);
            }
            return true;
        }

        @Override
        protected boolean check() {
            VirtualFile beforeFile = this.getMappedFile(this.myBeforeName);
            if (!this.checkExistsAndValid(beforeFile, this.myBeforeName)) {
                return false;
            }
            PathsVerifier.this.addPatch(this.myPatch, beforeFile);
            FilePath filePath = VcsUtil.getFilePath((VirtualFile)beforeFile.getParent(), (String)beforeFile.getName(), (boolean)beforeFile.isDirectory());
            if (this.myPatch.isDeletedFile() || this.myPatch.getAfterName() == null) {
                PathsVerifier.this.myDeletedPaths.add(filePath);
            }
            PathsVerifier.this.myBeforePaths.add(filePath);
            return true;
        }
    }

    private class CheckModified
    extends CheckDeleted {
        private CheckModified(FilePatch path) {
            super(path);
        }
    }
}

