/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PreloadingActivity;
import com.intellij.openapi.components.BaseComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorBase;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import com.intellij.util.io.storage.HeavyProcessLatch;
import java.util.concurrent.Executor;

public class Preloader
implements Disposable,
BaseComponent {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.application.Preloader");
    private final Executor myExecutor = SequentialTaskExecutor.createSequentialApplicationPoolExecutor((String)"Preloader Pool");
    private final ProgressIndicator myIndicator = new ProgressIndicatorBase();
    private final ProgressIndicator myWrappingIndicator = new AbstractProgressIndicatorBase(){

        @Override
        public void checkCanceled() {
            Preloader.checkHeavyProcessRunning();
            Preloader.this.myIndicator.checkCanceled();
        }

        @Override
        public boolean isCanceled() {
            return Preloader.this.myIndicator.isCanceled();
        }
    };

    private static void checkHeavyProcessRunning() {
        if (HeavyProcessLatch.INSTANCE.isRunning()) {
            TimeoutUtil.sleep((long)1L);
        }
    }

    public void initComponent() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        if (!Registry.is((String)"enable.activity.preloading")) {
            return;
        }
        ProgressManager progressManager = ProgressManager.getInstance();
        for (PreloadingActivity activity : (PreloadingActivity[])PreloadingActivity.EP_NAME.getExtensions()) {
            this.myExecutor.execute(() -> {
                if (this.myIndicator.isCanceled()) {
                    return;
                }
                Preloader.checkHeavyProcessRunning();
                if (this.myIndicator.isCanceled()) {
                    return;
                }
                progressManager.runProcess(() -> {
                    long startTime = System.nanoTime();
                    try {
                        activity.preload(this.myWrappingIndicator);
                    }
                    catch (ProcessCanceledException processCanceledException) {
                        // empty catch block
                    }
                    long ms = (System.nanoTime() - startTime) / 1000000L;
                    LOG.info(activity.getClass().getName() + " took " + ms + " ms");
                }, this.myIndicator);
            });
        }
    }

    public void dispose() {
        this.myIndicator.cancel();
    }
}

