/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notification.impl.ui;

import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.JBValue;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Path2D;
import java.awt.geom.RoundRectangle2D;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicToggleButtonUI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StickyButtonUI<B extends AbstractButton>
extends BasicToggleButtonUI {
    private static final JBValue FONT_SIZE = new JBValue.Float(11.0f);
    private static final JBValue BW = new JBValue.Float(1.0f);

    @Override
    protected void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        b.setFont(UIManager.getFont("Button.font").deriveFont(1, FONT_SIZE.get()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics g, JComponent c) {
        Graphics2D g2 = (Graphics2D)g.create();
        try {
            Color borderColor;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            AbstractButton button = (AbstractButton)c;
            int width = button.getWidth();
            int height = button.getHeight();
            int arcSize = this.getArcSize();
            if (c.isOpaque()) {
                g2.setColor(c.getBackground());
                g2.fill(new Rectangle(c.getSize()));
            }
            RoundRectangle2D.Float outerShape = new RoundRectangle2D.Float(0.0f, 0.0f, width, height, arcSize, arcSize);
            ButtonModel model = button.getModel();
            if (model.isSelected()) {
                g2.setColor(this.getSelectionColor(button));
            } else if (model.isRollover()) {
                g2.setColor(this.getRolloverColor(button));
            } else {
                Color bg = this.getBackgroundColor(button);
                if (bg != null) {
                    g2.setColor(bg);
                }
            }
            g2.fill(outerShape);
            Color color = borderColor = button.hasFocus() ? this.getFocusColor(button) : this.getUnfocusedBorderColor(button);
            if (borderColor != null) {
                g2.setColor(borderColor);
                Path2D.Float border = new Path2D.Float(0);
                border.append(outerShape, false);
                border.append(new RoundRectangle2D.Float(BW.get(), BW.get(), width - BW.get() * 2, height - BW.get() * 2, arcSize - BW.get(), arcSize - BW.get()), false);
                g2.fill(border);
            }
        }
        finally {
            g2.dispose();
        }
        super.paint(g, c);
    }

    @Nullable
    protected Color getUnfocusedBorderColor(@NotNull B button) {
        if (button == null) {
            StickyButtonUI.$$$reportNull$$$0(0);
        }
        return null;
    }

    protected Color getFocusColor(@NotNull B button) {
        if (button == null) {
            StickyButtonUI.$$$reportNull$$$0(1);
        }
        return Gray._100;
    }

    protected Color getSelectionColor(@NotNull B button) {
        if (button == null) {
            StickyButtonUI.$$$reportNull$$$0(2);
        }
        return JBColor.GRAY;
    }

    protected Color getRolloverColor(@NotNull B button) {
        if (button == null) {
            StickyButtonUI.$$$reportNull$$$0(3);
        }
        return JBColor.LIGHT_GRAY;
    }

    protected Color getBackgroundColor(@NotNull B button) {
        if (button == null) {
            StickyButtonUI.$$$reportNull$$$0(4);
        }
        return null;
    }

    protected int getArcSize() {
        return JBUI.scale((int)10);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "button";
        objectArray2[1] = "com/intellij/notification/impl/ui/StickyButtonUI";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getUnfocusedBorderColor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getFocusColor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getSelectionColor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getRolloverColor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getBackgroundColor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

