/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notification.impl;

import com.intellij.application.Topics;
import com.intellij.codeInsight.hint.TooltipController;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.FrameStateListener;
import com.intellij.ide.FrameStateManager;
import com.intellij.ide.ui.laf.darcula.ui.DarculaButtonPainter;
import com.intellij.ide.ui.laf.darcula.ui.DarculaButtonUI;
import com.intellij.notification.EventLog;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.notification.NotificationsAdapter;
import com.intellij.notification.NotificationsManager;
import com.intellij.notification.impl.NotificationActionProvider;
import com.intellij.notification.impl.NotificationFullContent;
import com.intellij.notification.impl.NotificationParentGroup;
import com.intellij.notification.impl.NotificationSettings;
import com.intellij.notification.impl.NotificationsConfigurationImpl;
import com.intellij.notification.impl.ui.NotificationsUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.DialogWrapperDialog;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.BalloonBuilder;
import com.intellij.openapi.ui.popup.JBPopupAdapter;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeBalloonLayoutImpl;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeFrame;
import com.intellij.ui.BalloonImpl;
import com.intellij.ui.BalloonLayout;
import com.intellij.ui.BalloonLayoutConfiguration;
import com.intellij.ui.BalloonLayoutData;
import com.intellij.ui.BalloonLayoutImpl;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ContextHelpLabel;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.NotificationBalloonActionProvider;
import com.intellij.ui.NotificationBalloonShadowBorderProvider;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.GradientViewport;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.labels.LinkListener;
import com.intellij.ui.components.panels.HorizontalLayout;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.util.ArrayUtil;
import com.intellij.util.FontUtil;
import com.intellij.util.Function;
import com.intellij.util.IconUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.AbstractLayoutManager;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.plaf.ButtonUI;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.EditorKit;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NotificationsManagerImpl
extends NotificationsManager {
    public static final Color DEFAULT_TEXT_COLOR = new JBColor((Color)Gray._0, (Color)Gray._191);
    private static final Color TEXT_COLOR = JBColor.namedColor((String)"Notification.foreground", (Color)DEFAULT_TEXT_COLOR);
    public static final Color FILL_COLOR = JBColor.namedColor((String)"Notification.background", (Color)new JBColor((Color)Gray._242, new Color(78, 80, 82)));
    public static final Color BORDER_COLOR = JBColor.namedColor((String)"Notification.borderColor", (Color)new JBColor(Gray._178.withAlpha(205), new Color(86, 90, 92, 205)));

    public NotificationsManagerImpl() {
        MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect();
        connection.subscribe(Notifications.TOPIC, (Object)new MyNotificationListener(null));
        connection.subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

            public void projectClosed(@NotNull Project project) {
                if (project == null) {
                    1.$$$reportNull$$$0(0);
                }
                for (Notification notification : NotificationsManagerImpl.this.getNotificationsOfType(Notification.class, project)) {
                    notification.hideBalloon();
                }
                TooltipController.getInstance().resetCurrent();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/notification/impl/NotificationsManagerImpl$1", "projectClosed"));
            }
        });
    }

    public void expire(@NotNull Notification notification) {
        if (notification == null) {
            NotificationsManagerImpl.$$$reportNull$$$0(0);
        }
        UIUtil.invokeLaterIfNeeded(() -> EventLog.expireNotification(notification));
    }

    @NotNull
    public <T extends Notification> T[] getNotificationsOfType(@NotNull Class<T> klass, @Nullable Project project) {
        if (klass == null) {
            NotificationsManagerImpl.$$$reportNull$$$0(1);
        }
        ArrayList<Notification> result2 = new ArrayList<Notification>();
        if (project == null || !project.isDefault() && !project.isDisposed()) {
            for (Notification notification : EventLog.getLogModel(project).getNotifications()) {
                if (!klass.isInstance(notification)) continue;
                result2.add(notification);
            }
        }
        Notification[] notificationArray = (Notification[])ArrayUtil.toObjectArray(result2, klass);
        if (notificationArray == null) {
            NotificationsManagerImpl.$$$reportNull$$$0(2);
        }
        return notificationArray;
    }

    private static void doNotify(@NotNull Notification notification, @Nullable NotificationDisplayType displayType, @Nullable Project project) {
        boolean willBeShown;
        NotificationsConfigurationImpl configuration;
        if (notification == null) {
            NotificationsManagerImpl.$$$reportNull$$$0(3);
        }
        if (!(configuration = NotificationsConfigurationImpl.getInstanceImpl()).isRegistered(notification.getGroupId())) {
            configuration.register(notification.getGroupId(), displayType == null ? NotificationDisplayType.BALLOON : displayType);
        }
        NotificationSettings settings = NotificationsConfigurationImpl.getSettings(notification.getGroupId());
        boolean shouldLog = settings.isShouldLog();
        boolean displayable = settings.getDisplayType() != NotificationDisplayType.NONE;
        boolean bl = willBeShown = displayable && NotificationsConfigurationImpl.getInstanceImpl().SHOW_BALLOONS;
        if (!shouldLog && !willBeShown) {
            notification.expire();
        }
        if (NotificationsConfigurationImpl.getInstanceImpl().SHOW_BALLOONS) {
            DumbAwareRunnable runnable2 = () -> NotificationsManagerImpl.showNotification(notification, project);
            if (project == null) {
                UIUtil.invokeLaterIfNeeded((Runnable)runnable2);
            } else if (!project.isDisposed()) {
                StartupManager.getInstance((Project)project).runWhenProjectIsInitialized((Runnable)runnable2);
            }
        }
    }

    private static void showNotification(final @NotNull Notification notification, @Nullable Project project) {
        Application application;
        if (notification == null) {
            NotificationsManagerImpl.$$$reportNull$$$0(4);
        }
        if ((application = ApplicationManager.getApplication()) instanceof ApplicationEx && !((ApplicationEx)application).isLoaded()) {
            application.invokeLater(() -> NotificationsManagerImpl.showNotification(notification, project), ModalityState.current());
            return;
        }
        String groupId = notification.getGroupId();
        NotificationSettings settings = NotificationsConfigurationImpl.getSettings(groupId);
        NotificationDisplayType type = settings.getDisplayType();
        String toolWindowId = NotificationsConfigurationImpl.getInstanceImpl().getToolWindowId(groupId);
        if (!(type != NotificationDisplayType.TOOL_WINDOW || toolWindowId != null && project != null && ToolWindowManager.getInstance((Project)project).canShowNotification(toolWindowId))) {
            type = NotificationDisplayType.BALLOON;
        }
        switch (type) {
            case NONE: {
                return;
            }
            default: {
                Balloon balloon = NotificationsManagerImpl.notifyByBalloon(notification, type, project);
                if (project == null || project.isDefault()) {
                    return;
                }
                if (settings.isShouldLog() && type != NotificationDisplayType.STICKY_BALLOON) break;
                if (balloon == null) {
                    notification.expire();
                    break;
                }
                balloon.addListener((JBPopupListener)new JBPopupAdapter(){

                    public void onClosed(@NotNull LightweightWindowEvent event) {
                        if (event == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        if (!event.isOk()) {
                            notification.expire();
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/notification/impl/NotificationsManagerImpl$2", "onClosed"));
                    }
                });
                break;
            }
            case TOOL_WINDOW: {
                BalloonLayout layout;
                Window window;
                HyperlinkListener listener2;
                MessageType messageType = notification.getType() == NotificationType.ERROR ? MessageType.ERROR : (notification.getType() == NotificationType.WARNING ? MessageType.WARNING : MessageType.INFO);
                final NotificationListener notificationListener = notification.getListener();
                HyperlinkListener hyperlinkListener = listener2 = notificationListener == null ? null : new HyperlinkListener(){

                    @Override
                    public void hyperlinkUpdate(HyperlinkEvent e) {
                        notificationListener.hyperlinkUpdate(notification, e);
                    }
                };
                assert (toolWindowId != null);
                assert (notification.getActions().isEmpty()) : "Actions are not shown for toolwindow notifications. Toolwindow id " + toolWindowId + ", group id '" + notification.getGroupId() + "\", title '" + notification.getTitle() + "\", content '" + notification.getContent() + "\"";
                String msg = notification.getTitle();
                if (StringUtil.isNotEmpty((String)notification.getContent())) {
                    if (StringUtil.isNotEmpty((String)msg)) {
                        msg = msg + "<br>";
                    }
                    msg = msg + notification.getContent();
                }
                if ((window = NotificationsManagerImpl.findWindowForBalloon(project)) instanceof IdeFrame && (layout = ((IdeFrame)window).getBalloonLayout()) != null) {
                    ((BalloonLayoutImpl)layout).remove(notification);
                }
                ToolWindowManager.getInstance((Project)project).notifyByBalloon(toolWindowId, messageType, msg, notification.getIcon(), listener2);
            }
        }
    }

    @Nullable
    private static Balloon notifyByBalloon(@NotNull Notification notification, @NotNull NotificationDisplayType displayType, @Nullable Project project) {
        if (notification == null) {
            NotificationsManagerImpl.$$$reportNull$$$0(5);
        }
        if (displayType == null) {
            NotificationsManagerImpl.$$$reportNull$$$0(6);
        }
        if (NotificationsManagerImpl.isDummyEnvironment()) {
            return null;
        }
        Window window = NotificationsManagerImpl.findWindowForBalloon(project);
        if (window instanceof IdeFrame) {
            BalloonLayout layout = ((IdeFrame)window).getBalloonLayout();
            if (layout == null) {
                return null;
            }
            Ref layoutDataRef = new Ref();
            if (project == null || project.isDefault()) {
                BalloonLayoutData layoutData = new BalloonLayoutData();
                layoutData.groupId = "";
                layoutData.welcomeScreen = layout instanceof WelcomeBalloonLayoutImpl;
                layoutData.type = notification.getType();
                layoutDataRef.set((Object)layoutData);
            } else {
                BalloonLayoutData.MergeInfo mergeData = ((BalloonLayoutImpl)layout).preMerge(notification);
                if (mergeData != null) {
                    BalloonLayoutData layoutData = new BalloonLayoutData();
                    layoutData.mergeData = mergeData;
                    layoutDataRef.set((Object)layoutData);
                }
            }
            Balloon balloon = NotificationsManagerImpl.createBalloon((IdeFrame)window, notification, false, false, (Ref<BalloonLayoutData>)layoutDataRef, (Disposable)(project != null ? project : ApplicationManager.getApplication()));
            if (notification.isExpired()) {
                return null;
            }
            layout.add(balloon, layoutDataRef.get());
            if (balloon.isDisposed()) {
                return null;
            }
            if (layoutDataRef.get() != null) {
                ((BalloonLayoutData)layoutDataRef.get()).project = project;
            }
            ((BalloonImpl)balloon).startFadeoutTimer(0);
            if (displayType == NotificationDisplayType.BALLOON || ProjectManager.getInstance().getOpenProjects().length == 0) {
                NotificationsManagerImpl.frameActivateBalloonListener(balloon, () -> {
                    if (!balloon.isDisposed()) {
                        ((BalloonImpl)balloon).startSmartFadeoutTimer(10000);
                    }
                });
            }
            return balloon;
        }
        return null;
    }

    public static void frameActivateBalloonListener(@NotNull Balloon balloon, final @NotNull Runnable callback2) {
        if (balloon == null) {
            NotificationsManagerImpl.$$$reportNull$$$0(7);
        }
        if (callback2 == null) {
            NotificationsManagerImpl.$$$reportNull$$$0(8);
        }
        if (ApplicationManager.getApplication().isActive()) {
            callback2.run();
        } else {
            Topics.subscribe((Topic)FrameStateListener.TOPIC, (Disposable)balloon, (Object)new FrameStateListener(){

                public void onFrameActivated() {
                    FrameStateManager.getInstance().removeListener((FrameStateListener)this);
                    callback2.run();
                }
            });
        }
    }

    @Nullable
    public static Window findWindowForBalloon(@Nullable Project project) {
        Window frame = WindowManager.getInstance().getFrame(project);
        if (frame == null && project == null) {
            frame = (Window)WelcomeFrame.getInstance();
        }
        if (frame == null && project == null) {
            frame = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
            while (frame instanceof DialogWrapperDialog && ((DialogWrapperDialog)frame).getDialogWrapper().isModalProgress()) {
                frame = frame.getOwner();
            }
        }
        return frame;
    }

    @NotNull
    public static Balloon createBalloon(@NotNull IdeFrame window, @NotNull Notification notification, boolean showCallout, boolean hideOnClickOutside, @NotNull Ref<BalloonLayoutData> layoutDataRef, @NotNull Disposable parentDisposable) {
        if (window == null) {
            NotificationsManagerImpl.$$$reportNull$$$0(9);
        }
        if (notification == null) {
            NotificationsManagerImpl.$$$reportNull$$$0(10);
        }
        if (layoutDataRef == null) {
            NotificationsManagerImpl.$$$reportNull$$$0(11);
        }
        if (parentDisposable == null) {
            NotificationsManagerImpl.$$$reportNull$$$0(12);
        }
        Balloon balloon = NotificationsManagerImpl.createBalloon(window.getComponent(), notification, showCallout, hideOnClickOutside, layoutDataRef, parentDisposable);
        if (balloon == null) {
            NotificationsManagerImpl.$$$reportNull$$$0(13);
        }
        return balloon;
    }

    @NotNull
    public static Balloon createBalloon(@Nullable JComponent windowComponent, @NotNull Notification notification, boolean showCallout, boolean hideOnClickOutside, @NotNull Ref<BalloonLayoutData> layoutDataRef, @NotNull Disposable parentDisposable) {
        JPanel buttons;
        String style;
        BalloonLayoutData layoutData;
        if (notification == null) {
            NotificationsManagerImpl.$$$reportNull$$$0(14);
        }
        if (layoutDataRef == null) {
            NotificationsManagerImpl.$$$reportNull$$$0(15);
        }
        if (parentDisposable == null) {
            NotificationsManagerImpl.$$$reportNull$$$0(16);
        }
        BalloonLayoutData balloonLayoutData = layoutData = layoutDataRef.isNull() ? new BalloonLayoutData() : (BalloonLayoutData)layoutDataRef.get();
        if (layoutData.groupId == null) {
            layoutData.groupId = notification.getGroupId();
            layoutData.id = notification.id;
        } else {
            layoutData.groupId = null;
            layoutData.mergeData = null;
        }
        layoutDataRef.set((Object)layoutData);
        if (layoutData.textColor == null) {
            layoutData.textColor = TEXT_COLOR;
        }
        if (layoutData.fillColor == null) {
            layoutData.fillColor = FILL_COLOR;
        }
        if (layoutData.borderColor == null) {
            layoutData.borderColor = BORDER_COLOR;
        }
        boolean actions = !notification.getActions().isEmpty();
        boolean showFullContent = layoutData.showFullContent || notification instanceof NotificationFullContent;
        final JEditorPane text = new JEditorPane(){

            @Override
            protected void paintComponent(Graphics g) {
                Point location;
                super.paintComponent(g);
                if (layoutData.showMinSize && (location = NotificationsManagerImpl.getCollapsedTextEndLocation(this, layoutData)) != null) {
                    if (g instanceof Graphics2D) {
                        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                    }
                    g.setColor(this.getForeground());
                    g.drawString("...", location.x, location.y + g.getFontMetrics().getAscent());
                }
            }
        };
        UIUtil.JBWordWrapHtmlEditorKit kit = new UIUtil.JBWordWrapHtmlEditorKit();
        kit.getStyleSheet().addRule("a {color: " + ColorUtil.toHtmlColor((Color)JBUI.CurrentTheme.Link.linkColor()) + "}");
        text.setEditorKit((EditorKit)kit);
        text.setForeground(layoutData.textColor);
        HyperlinkListener listener2 = NotificationsUtil.wrapListener(notification);
        if (listener2 != null) {
            text.addHyperlinkListener(listener2);
        }
        String fontStyle = NotificationsUtil.getFontStyle();
        int prefSize = new JLabel((String)NotificationsUtil.buildHtml((Notification)notification, null, (boolean)true, null, (String)fontStyle)).getPreferredSize().width;
        String string = style = prefSize > BalloonLayoutConfiguration.MaxWidth() ? BalloonLayoutConfiguration.MaxWidthStyle() : null;
        if (layoutData.showFullContent) {
            style = prefSize > BalloonLayoutConfiguration.MaxFullContentWidth() ? BalloonLayoutConfiguration.MaxFullContentWidthStyle() : null;
        }
        text.setText(NotificationsUtil.buildHtml(notification, style, true, null, fontStyle));
        text.setEditable(false);
        text.setOpaque(false);
        text.setBorder(null);
        NonOpaquePanel content = new NonOpaquePanel((LayoutManager)new BorderLayout());
        if (text.getCaret() != null) {
            text.setCaretPosition(0);
        }
        final JScrollPane pane = NotificationsManagerImpl.createBalloonScrollPane(text, false);
        pane.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                JScrollBar scrollBar = pane.getVerticalScrollBar();
                if (layoutData.showMinSize && scrollBar.getValue() > 0) {
                    scrollBar.removeAdjustmentListener(this);
                    scrollBar.setValue(0);
                    scrollBar.addAdjustmentListener(this);
                }
            }
        });
        LinkLabel expandAction = null;
        int lines2 = 3;
        if (notification.hasTitle()) {
            --lines2;
        }
        if (actions) {
            --lines2;
        }
        layoutData.fullHeight = text.getPreferredSize().height;
        layoutData.twoLineHeight = NotificationsManagerImpl.calculateContentHeight(lines2);
        layoutData.maxScrollHeight = Math.min(layoutData.fullHeight, NotificationsManagerImpl.calculateContentHeight(10));
        layoutData.configuration = BalloonLayoutConfiguration.create(notification, layoutData, actions);
        if (layoutData.welcomeScreen) {
            layoutData.maxScrollHeight = layoutData.fullHeight;
        } else if (!showFullContent && layoutData.maxScrollHeight != layoutData.fullHeight) {
            pane.setViewport((JViewport)((Object)new GradientViewport(text, (Insets)JBUI.insets((int)10, (int)0), true){

                @Override
                @Nullable
                protected Color getViewColor() {
                    return layoutData.fillColor;
                }

                @Override
                protected void paintGradient(Graphics g) {
                    if (!layoutData.showMinSize) {
                        super.paintGradient(g);
                    }
                }
            }));
        }
        NotificationsManagerImpl.configureBalloonScrollPane(pane, layoutData.fillColor);
        if (showFullContent) {
            if (windowComponent == null) {
                pane.setPreferredSize(text.getPreferredSize());
            } else {
                pane.setPreferredSize(new Dimension(text.getPreferredSize().width, (int)Math.min((double)layoutData.fullHeight, (double)windowComponent.getHeight() * 0.75)));
            }
        } else if (layoutData.twoLineHeight < layoutData.fullHeight) {
            text.setPreferredSize(null);
            Dimension size = text.getPreferredSize();
            size.height = layoutData.twoLineHeight;
            text.setPreferredSize(size);
            text.setSize(size);
            layoutData.showMinSize = true;
            pane.setHorizontalScrollBarPolicy(31);
            pane.setVerticalScrollBarPolicy(21);
            pane.setPreferredSize(size);
            text.setCaret(new TextCaret(layoutData));
            expandAction = new LinkLabel(null, AllIcons.Ide.Notification.Expand, (LinkListener)new LinkListener<Void>((JPanel)content){
                final /* synthetic */ JPanel val$content;
                {
                    this.val$content = jPanel;
                }

                public void linkSelected(LinkLabel link2, Void ignored) {
                    layoutData.showMinSize = !layoutData.showMinSize;
                    text.setPreferredSize(null);
                    Dimension size = text.getPreferredSize();
                    if (layoutData.showMinSize) {
                        size.height = layoutData.twoLineHeight;
                        pane.setVerticalScrollBarPolicy(21);
                        link2.setIcon(AllIcons.Ide.Notification.Expand);
                        link2.setHoveringIcon(AllIcons.Ide.Notification.ExpandHover);
                    } else {
                        text.select(0, 0);
                        size.height = layoutData.fullHeight;
                        pane.setVerticalScrollBarPolicy(20);
                        link2.setIcon(AllIcons.Ide.Notification.Collapse);
                        link2.setHoveringIcon(AllIcons.Ide.Notification.CollapseHover);
                    }
                    text.setPreferredSize(size);
                    text.setSize(size);
                    if (!layoutData.showMinSize) {
                        size = new Dimension(size.width, layoutData.maxScrollHeight);
                    }
                    pane.setPreferredSize(size);
                    this.val$content.doLayout();
                    layoutData.doLayout.run();
                }
            });
            expandAction.setHoveringIcon(AllIcons.Ide.Notification.ExpandHover);
        }
        final CenteredLayoutWithActions layout = new CenteredLayoutWithActions(text, layoutData);
        NonOpaquePanel centerPanel = new NonOpaquePanel(layout){

            protected void paintChildren(Graphics g) {
                super.paintChildren(g);
                Component title = layout.getTitle();
                if (title != null && layoutData.showActions != null && ((Boolean)layoutData.showActions.compute()).booleanValue()) {
                    int width = layoutData.configuration.allActionsOffset;
                    int x = this.getWidth() - width - JBUI.scale((int)5);
                    int y = layoutData.configuration.topSpaceHeight;
                    int height = title instanceof JEditorPane ? NotificationsManagerImpl.getFirstLineHeight((JEditorPane)title) : title.getHeight();
                    g.setColor(layoutData.fillColor);
                    g.fillRect(x, y, width, height);
                    width = layoutData.configuration.beforeGearSpace;
                    ((Graphics2D)g).setPaint(new GradientPaint(x -= width, y, ColorUtil.withAlpha((Color)layoutData.fillColor, (double)0.2), x + width, y, layoutData.fillColor));
                    g.fillRect(x, y, width, height);
                }
            }
        };
        content.add((Component)centerPanel, "Center");
        if (notification.hasTitle()) {
            String titleStyle = StringUtil.defaultIfEmpty((String)fontStyle, (String)"") + "white-space:nowrap;";
            JLabel title = new JLabel();
            title.setText(NotificationsUtil.buildHtml(notification, titleStyle, false, null, null));
            title.setOpaque(false);
            title.setForeground(layoutData.textColor);
            centerPanel.add((Component)title, "North");
        }
        if (expandAction != null) {
            centerPanel.add((Component)expandAction, "East");
        }
        if (notification.hasContent()) {
            centerPanel.add((Component)(layoutData.welcomeScreen ? text : pane), "Center");
        }
        if (!layoutData.welcomeScreen) {
            final Icon icon = NotificationsUtil.getIcon(notification);
            JComponent iconComponent = new JComponent(){

                @Override
                protected void paintComponent(Graphics g) {
                    super.paintComponent(g);
                    icon.paintIcon(this, g, layoutData.configuration.iconOffset.width, layoutData.configuration.iconOffset.height);
                }
            };
            iconComponent.setOpaque(false);
            iconComponent.setPreferredSize(new Dimension(layoutData.configuration.iconPanelWidth, 2 * layoutData.configuration.iconOffset.height + icon.getIconHeight()));
            content.add((Component)iconComponent, "West");
        }
        if ((buttons = NotificationsManagerImpl.createButtons(notification, (JPanel)content, listener2)) != null) {
            layoutData.groupId = null;
            layoutData.mergeData = null;
            buttons.setBorder((Border)JBUI.Borders.empty((int)0, (int)0, (int)5, (int)7));
        }
        HoverAdapter hoverAdapter = new HoverAdapter();
        hoverAdapter.addSource((Component)content);
        hoverAdapter.addSource((Component)centerPanel);
        hoverAdapter.addSource(text);
        hoverAdapter.addSource(pane);
        if (buttons == null && actions) {
            NotificationsManagerImpl.createActionPanel(notification, (JPanel)centerPanel, layoutData.configuration.actionGap, hoverAdapter);
        }
        if (expandAction != null) {
            hoverAdapter.addComponent((Component)expandAction, (Function<Component, Rectangle>)((Function)arg_0 -> NotificationsManagerImpl.lambda$createBalloon$4((JPanel)content, layoutData, text, pane, arg_0)));
        }
        hoverAdapter.initListeners();
        if (layoutData.mergeData != null) {
            NotificationsManagerImpl.createMergeAction(layoutData, (JPanel)content);
        }
        text.setSize(text.getPreferredSize());
        Dimension paneSize = new Dimension(text.getPreferredSize());
        int maxWidth = JBUI.scale((int)600);
        if (windowComponent != null) {
            maxWidth = Math.min(maxWidth, windowComponent.getWidth() - 20);
        }
        if (paneSize.width > maxWidth) {
            pane.setPreferredSize(new Dimension(maxWidth, paneSize.height + UIUtil.getScrollBarWidth()));
        }
        BalloonBuilder builder2 = JBPopupFactory.getInstance().createBalloonBuilder((JComponent)content);
        builder2.setFillColor(layoutData.fillColor).setCloseButtonEnabled(buttons == null).setShowCallout(showCallout).setShadow(false).setAnimationCycle(200).setHideOnClickOutside(hideOnClickOutside).setHideOnAction(hideOnClickOutside).setHideOnKeyOutside(hideOnClickOutside).setHideOnFrameResize(false).setBorderColor(layoutData.borderColor).setBorderInsets((Insets)JBUI.emptyInsets());
        if (layoutData.fadeoutTime != 0L) {
            builder2.setFadeoutTime(layoutData.fadeoutTime);
        }
        BalloonImpl balloon = (BalloonImpl)builder2.createBalloon();
        balloon.setAnimationEnabled(false);
        notification.setBalloon((Balloon)balloon);
        balloon.setShadowBorderProvider(new NotificationBalloonShadowBorderProvider(layoutData.fillColor, layoutData.borderColor));
        if (!layoutData.welcomeScreen && buttons == null) {
            balloon.setActionProvider(new NotificationBalloonActionProvider(balloon, layout.getTitle(), layoutData, notification.getGroupId()));
        }
        Disposer.register((Disposable)parentDisposable, (Disposable)balloon);
        BalloonImpl balloonImpl = balloon;
        if (balloonImpl == null) {
            NotificationsManagerImpl.$$$reportNull$$$0(17);
        }
        return balloonImpl;
    }

    @Nullable
    private static JPanel createButtons(@NotNull Notification notification, final @NotNull JPanel content, @Nullable HyperlinkListener listener2) {
        if (notification == null) {
            NotificationsManagerImpl.$$$reportNull$$$0(18);
        }
        if (content == null) {
            NotificationsManagerImpl.$$$reportNull$$$0(19);
        }
        if (notification instanceof NotificationActionProvider) {
            JPanel buttons = new JPanel((LayoutManager)new HorizontalLayout(5));
            buttons.setOpaque(false);
            content.add("South", buttons);
            final Ref defaultButton = new Ref();
            NotificationActionProvider provider = (NotificationActionProvider)notification;
            for (NotificationActionProvider.Action action : provider.getActions(listener2)) {
                JButton button = new JButton(action){

                    @Override
                    public void setUI(ButtonUI ui) {
                        boolean isDarcula;
                        boolean bl = isDarcula = ui instanceof DarculaButtonUI && UIUtil.isUnderDarcula();
                        if (isDarcula) {
                            ui = new DarculaButtonUI(){

                                @Override
                                protected Color getButtonColorStart() {
                                    return new ColorUIResource(5922657);
                                }

                                @Override
                                protected Color getButtonColorEnd() {
                                    return new ColorUIResource(5922657);
                                }
                            };
                        }
                        super.setUI(ui);
                        if (isDarcula) {
                            this.setBorder(new DarculaButtonPainter(){

                                @Override
                                public Paint getBorderPaint(Component button) {
                                    return new ColorUIResource(0x717777);
                                }
                            });
                        }
                    }
                };
                button.setOpaque(false);
                if (action.isDefaultAction()) {
                    defaultButton.setIfNull((Object)button);
                }
                buttons.add("RIGHT", button);
            }
            if (!defaultButton.isNull()) {
                UIUtil.addParentChangeListener((Component)content, (PropertyChangeListener)new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent event) {
                        if (event.getOldValue() == null && event.getNewValue() != null) {
                            UIUtil.removeParentChangeListener((Component)content, (PropertyChangeListener)this);
                            JRootPane rootPane = UIUtil.getRootPane((Component)content);
                            if (rootPane != null) {
                                rootPane.setDefaultButton((JButton)defaultButton.get());
                            }
                        }
                    }
                });
            }
            return buttons;
        }
        return null;
    }

    @NotNull
    public static JScrollPane createBalloonScrollPane(@NotNull Component content, boolean configure) {
        if (content == null) {
            NotificationsManagerImpl.$$$reportNull$$$0(20);
        }
        JScrollPane pane = ScrollPaneFactory.createScrollPane((Component)content, (boolean)true);
        if (configure) {
            NotificationsManagerImpl.configureBalloonScrollPane(pane, FILL_COLOR);
        }
        JScrollPane jScrollPane = pane;
        if (jScrollPane == null) {
            NotificationsManagerImpl.$$$reportNull$$$0(21);
        }
        return jScrollPane;
    }

    public static void configureBalloonScrollPane(@NotNull JScrollPane pane, @NotNull Color fillColor) {
        if (pane == null) {
            NotificationsManagerImpl.$$$reportNull$$$0(22);
        }
        if (fillColor == null) {
            NotificationsManagerImpl.$$$reportNull$$$0(23);
        }
        pane.setOpaque(false);
        pane.getViewport().setOpaque(false);
        pane.setBackground(fillColor);
        pane.getViewport().setBackground(fillColor);
        pane.getVerticalScrollBar().setBackground(fillColor);
    }

    private static void createActionPanel(final @NotNull Notification notification, @NotNull JPanel centerPanel, int gap, @NotNull HoverAdapter hoverAdapter) {
        if (notification == null) {
            NotificationsManagerImpl.$$$reportNull$$$0(24);
        }
        if (centerPanel == null) {
            NotificationsManagerImpl.$$$reportNull$$$0(25);
        }
        if (hoverAdapter == null) {
            NotificationsManagerImpl.$$$reportNull$$$0(26);
        }
        NonOpaquePanel actionPanel = new NonOpaquePanel((LayoutManager)new HorizontalLayout(gap, 0));
        centerPanel.add("South", (Component)actionPanel);
        List actions = notification.getActions();
        if (actions.size() > 2) {
            Object action = new DropDownAction(notification.getDropDownText(), new LinkListener<Void>(){

                public void linkSelected(LinkLabel link2, Void ignored) {
                    Container parent = link2.getParent();
                    int size = parent.getComponentCount();
                    DefaultActionGroup group = new DefaultActionGroup();
                    for (int i = 1; i < size; ++i) {
                        Component component = parent.getComponent(i);
                        if (component.isVisible()) continue;
                        group.add((AnAction)((LinkLabel)component).getLinkData());
                    }
                    NotificationsManagerImpl.showPopup(link2, group);
                }
            });
            Notification.setDataProvider((Notification)notification, action);
            action.setVisible(false);
            actionPanel.add((Component)action);
        }
        for (AnAction action : actions) {
            Presentation presentation = action.getTemplatePresentation();
            actionPanel.add("LEFT", (Component)new LinkLabel(presentation.getText(), presentation.getIcon(), (LinkListener)new LinkListener<AnAction>(){

                public void linkSelected(LinkLabel aSource, AnAction action) {
                    Notification.fire((Notification)notification, (AnAction)action, (DataContext)DataManager.getInstance().getDataContext((Component)aSource));
                }
            }, (Object)action));
        }
        AnAction helpAction = notification.getContextHelpAction();
        if (helpAction != null) {
            Presentation presentation = helpAction.getTemplatePresentation();
            ContextHelpLabel helpLabel = new ContextHelpLabel(presentation.getText(), presentation.getDescription());
            helpLabel.setForeground(UIUtil.getLabelDisabledForeground());
            actionPanel.add("LEFT", (Component)helpLabel);
        }
        JBInsets hover = JBUI.insets((int)8, (int)5, (int)8, (int)7);
        int count = actionPanel.getComponentCount();
        for (int i = 0; i < count; ++i) {
            hoverAdapter.addComponent(actionPanel.getComponent(i), (Insets)hover);
        }
        hoverAdapter.addSource((Component)actionPanel);
    }

    private static void createMergeAction(@NotNull BalloonLayoutData layoutData, @NotNull JPanel panel2) {
        if (layoutData == null) {
            NotificationsManagerImpl.$$$reportNull$$$0(27);
        }
        if (panel2 == null) {
            NotificationsManagerImpl.$$$reportNull$$$0(28);
        }
        StringBuilder title = new StringBuilder().append(layoutData.mergeData.count).append(" more");
        String shortTitle = NotificationParentGroup.getShortTitle(layoutData.groupId);
        if (shortTitle != null) {
            title.append(" from ").append(shortTitle);
        }
        LinkLabel<BalloonLayoutData> action = new LinkLabel<BalloonLayoutData>(title.toString(), null, (LinkListener)new LinkListener<BalloonLayoutData>(){

            public void linkSelected(LinkLabel aSource, BalloonLayoutData layoutData) {
                EventLog.showNotification(layoutData.project, layoutData.groupId, layoutData.getMergeIds());
            }
        }, layoutData){

            protected boolean isInClickableArea(Point pt) {
                return true;
            }

            protected Color getTextColor() {
                return JBColor.namedColor((String)"Notification.MoreButton.foreground", (Color)new JBColor(0x666666, 0x8C8C8C));
            }
        };
        action.setFont(FontUtil.minusOne((Font)action.getFont()));
        action.setHorizontalAlignment(0);
        action.setPaintUnderline(false);
        AbstractLayoutManager layout = new AbstractLayoutManager(){

            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(parent.getWidth(), JBUI.scale((int)20) + 2);
            }

            public void layoutContainer(Container parent) {
                parent.getComponent(0).setBounds(2, 1, parent.getWidth() - 4, JBUI.scale((int)20));
            }
        };
        NonOpaquePanel mergePanel = new NonOpaquePanel((LayoutManager)layout){

            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.setColor((Color)JBColor.namedColor((String)"Notification.MoreButton.background", (Color)new JBColor(0xE3E3E3, 3816509)));
                ((Graphics2D)g).fill(new Rectangle2D.Double(1.5, 1.0, (double)this.getWidth() - 2.5, this.getHeight() - 2));
                g.setColor((Color)JBColor.namedColor((String)"Notification.MoreButton.innerBorderColor", (Color)new JBColor(0xDBDBDB, 3487544)));
                if (SystemInfo.isMac) {
                    ((Graphics2D)g).draw(new Rectangle2D.Double(2.0, 0.0, (double)this.getWidth() - 3.5, 0.5));
                } else if (SystemInfo.isWindows) {
                    ((Graphics2D)g).draw(new Rectangle2D.Double(1.5, 0.0, this.getWidth() - 3, 0.5));
                } else {
                    ((Graphics2D)g).draw(new Rectangle2D.Double(1.5, 0.0, (double)this.getWidth() - 2.5, 0.5));
                }
            }
        };
        mergePanel.add((Component)action);
        panel2.add("South", (Component)mergePanel);
    }

    public static int calculateContentHeight(int lines2) {
        JEditorPane text = new JEditorPane();
        text.setEditorKit(UIUtil.getHTMLEditorKit());
        text.setText(NotificationsUtil.buildHtml(null, null, "Content" + StringUtil.repeat((String)"<br>\nContent", (int)(lines2 - 1)), null, null, null, NotificationsUtil.getFontStyle()));
        text.setEditable(false);
        text.setOpaque(false);
        text.setBorder(null);
        return text.getPreferredSize().height;
    }

    private static boolean isDummyEnvironment() {
        Application application = ApplicationManager.getApplication();
        return application.isUnitTestMode() || application.isCommandLine();
    }

    private static void showPopup(@NotNull LinkLabel link2, @NotNull DefaultActionGroup group) {
        if (link2 == null) {
            NotificationsManagerImpl.$$$reportNull$$$0(29);
        }
        if (group == null) {
            NotificationsManagerImpl.$$$reportNull$$$0(30);
        }
        if (link2.isShowing()) {
            ActionPopupMenu menu = ActionManager.getInstance().createActionPopupMenu("unknown", (ActionGroup)group);
            menu.getComponent().show((Component)link2, JBUI.scale((int)-10), link2.getHeight() + JBUI.scale((int)2));
        }
    }

    @Nullable
    private static Point getCollapsedTextEndLocation(@NotNull JEditorPane text, @NotNull BalloonLayoutData layoutData) {
        if (text == null) {
            NotificationsManagerImpl.$$$reportNull$$$0(31);
        }
        if (layoutData == null) {
            NotificationsManagerImpl.$$$reportNull$$$0(32);
        }
        try {
            int end = text.viewToModel(new Point(10, layoutData.twoLineHeight + 5));
            if (end == -1) {
                end = text.getDocument().getLength();
            }
            for (int i = end - 1; i >= 0; --i) {
                Rectangle r = text.modelToView(i);
                if (r == null || r.y >= layoutData.twoLineHeight) continue;
                return r.getLocation();
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return null;
    }

    private static int getFirstLineHeight(@NotNull JEditorPane text) {
        if (text == null) {
            NotificationsManagerImpl.$$$reportNull$$$0(33);
        }
        try {
            int end = text.getDocument().getLength();
            for (int i = 0; i < end; ++i) {
                Rectangle r = text.modelToView(i);
                if (r == null || r.height <= 0) continue;
                return r.height;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return 0;
    }

    private static /* synthetic */ Rectangle lambda$createBalloon$4(JPanel content, BalloonLayoutData layoutData, JEditorPane text, JScrollPane pane, Component component) {
        Rectangle bounds2;
        Point location = SwingUtilities.convertPoint(content.getParent(), content.getLocation(), component.getParent());
        if (layoutData.showMinSize) {
            JComponent centerComponent = layoutData.welcomeScreen ? text : pane;
            Point centerLocation = SwingUtilities.convertPoint(centerComponent.getParent(), centerComponent.getLocation(), component.getParent());
            bounds2 = new Rectangle(location.x, centerLocation.y, content.getWidth(), ((Component)centerComponent).getHeight());
        } else {
            bounds2 = new Rectangle(location.x, component.getY(), content.getWidth(), component.getHeight());
            JBInsets.addTo((Rectangle)bounds2, (Insets)JBUI.insets((int)5, (int)0, (int)7, (int)0));
        }
        return bounds2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 13: 
            case 17: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 13: 
            case 17: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notification";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "klass";
                break;
            }
            case 2: 
            case 13: 
            case 17: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/notification/impl/NotificationsManagerImpl";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayType";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "balloon";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "window";
                break;
            }
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layoutDataRef";
                break;
            }
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pane";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fillColor";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "centerPanel";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hoverAdapter";
                break;
            }
            case 27: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layoutData";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "link";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 31: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/notification/impl/NotificationsManagerImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotificationsOfType";
                break;
            }
            case 13: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createBalloon";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "createBalloonScrollPane";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "expire";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getNotificationsOfType";
                break;
            }
            case 2: 
            case 13: 
            case 17: 
            case 21: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doNotify";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "showNotification";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "notifyByBalloon";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "frameActivateBalloonListener";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createBalloon";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createButtons";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createBalloonScrollPane";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "configureBalloonScrollPane";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "createActionPanel";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "createMergeAction";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "showPopup";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getCollapsedTextEndLocation";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getFirstLineHeight";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 13: 
            case 17: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class TextCaret
    extends DefaultCaret
    implements UIResource {
        private final BalloonLayoutData myLayoutData;

        TextCaret(@NotNull BalloonLayoutData layoutData) {
            if (layoutData == null) {
                TextCaret.$$$reportNull$$$0(0);
            }
            this.myLayoutData = layoutData;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (!this.myLayoutData.showMinSize) {
                super.mouseClicked(e);
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (!this.myLayoutData.showMinSize) {
                super.mousePressed(e);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (!this.myLayoutData.showMinSize) {
                super.mouseReleased(e);
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            if (!this.myLayoutData.showMinSize) {
                super.mouseEntered(e);
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (!this.myLayoutData.showMinSize) {
                super.mouseExited(e);
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (!this.myLayoutData.showMinSize) {
                super.mouseDragged(e);
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (!this.myLayoutData.showMinSize) {
                super.mouseMoved(e);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "layoutData", "com/intellij/notification/impl/NotificationsManagerImpl$TextCaret", "<init>"));
        }
    }

    private static class CenteredLayoutWithActions
    extends BorderLayout {
        private final JEditorPane myText;
        private final BalloonLayoutData myLayoutData;
        private Component myTitleComponent;
        private Component myCenteredComponent;
        private JPanel myActionPanel;
        private Component myExpandAction;

        CenteredLayoutWithActions(JEditorPane text, BalloonLayoutData layoutData) {
            this.myText = text;
            this.myLayoutData = layoutData;
        }

        @Nullable
        public Component getTitle() {
            if (this.myTitleComponent != null) {
                return this.myTitleComponent;
            }
            if (this.myCenteredComponent != null) {
                if (this.myCenteredComponent instanceof JScrollPane) {
                    return ((JScrollPane)this.myCenteredComponent).getViewport().getView();
                }
                return this.myCenteredComponent;
            }
            return null;
        }

        @Override
        public void addLayoutComponent(Component comp, Object constraints) {
            if ("North".equals(constraints)) {
                this.myTitleComponent = comp;
            } else if ("Center".equals(constraints)) {
                this.myCenteredComponent = comp;
            } else if ("South".equals(constraints)) {
                this.myActionPanel = (JPanel)comp;
            } else if ("East".equals(constraints)) {
                this.myExpandAction = comp;
            }
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
            this.addLayoutComponent(comp, name);
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return this.layoutSize((Function<Component, Dimension>)((Function)component -> component.getPreferredSize()));
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.layoutSize((Function<Component, Dimension>)((Function)component -> component.getMinimumSize()));
        }

        private Dimension layoutSize(@NotNull Function<Component, Dimension> size) {
            if (size == null) {
                CenteredLayoutWithActions.$$$reportNull$$$0(0);
            }
            Dimension titleSize = this.myTitleComponent == null ? new Dimension() : (Dimension)size.fun((Object)this.myTitleComponent);
            Dimension centeredSize = this.myCenteredComponent == null ? new Dimension() : (Dimension)size.fun((Object)this.myCenteredComponent);
            Dimension actionSize = this.myActionPanel == null ? new Dimension() : (Dimension)size.fun((Object)this.myActionPanel);
            Dimension expandSize = this.myExpandAction == null || this.myLayoutData.showMinSize ? new Dimension() : (Dimension)size.fun((Object)this.myExpandAction);
            int height = this.myLayoutData.configuration.topSpaceHeight + titleSize.height + centeredSize.height + Math.max(actionSize.height, expandSize.height) + this.myLayoutData.configuration.bottomSpaceHeight;
            if (titleSize.height > 0 && centeredSize.height > 0) {
                height += this.myLayoutData.configuration.titleContentSpaceHeight;
            }
            if (centeredSize.height > 0 && actionSize.height > 0) {
                height += this.myLayoutData.configuration.contentActionsSpaceHeight;
            }
            if (titleSize.height > 0 && actionSize.height > 0) {
                height += this.myLayoutData.configuration.titleActionsSpaceHeight;
            }
            int titleWidth = titleSize.width + this.myLayoutData.configuration.closeOffset;
            int centerWidth = centeredSize.width + this.myLayoutData.configuration.closeOffset;
            int actionWidth = actionSize.width + expandSize.width;
            int width = Math.max(centerWidth, Math.max(titleWidth, actionWidth));
            if (!this.myLayoutData.showFullContent) {
                width = Math.min(width, BalloonLayoutConfiguration.MaxWidth());
            }
            width = Math.max(width, BalloonLayoutConfiguration.MinWidth());
            return new Dimension(width, height);
        }

        @Override
        public void layoutContainer(Container parent) {
            boolean isActions;
            int top = this.myLayoutData.configuration.topSpaceHeight;
            int width = parent.getWidth();
            Dimension centeredSize = this.myCenteredComponent == null ? new Dimension() : this.myCenteredComponent.getPreferredSize();
            boolean bl = isActions = this.myActionPanel != null || this.myExpandAction != null && !this.myLayoutData.showMinSize;
            if (this.myTitleComponent != null) {
                int titleHeight = this.myTitleComponent.getPreferredSize().height;
                this.myTitleComponent.setBounds(0, top, width - this.myLayoutData.configuration.closeOffset, titleHeight);
                top += titleHeight;
                if (this.myCenteredComponent != null) {
                    top += this.myLayoutData.configuration.titleContentSpaceHeight;
                } else if (isActions) {
                    top += this.myLayoutData.configuration.titleActionsSpaceHeight;
                }
            }
            if (this.myCenteredComponent != null) {
                int centeredWidth = width;
                if (!this.myLayoutData.showFullContent && !this.myLayoutData.showMinSize && this.myLayoutData.fullHeight != this.myLayoutData.maxScrollHeight) {
                    --centeredWidth;
                }
                this.myCenteredComponent.setBounds(0, top, centeredWidth, centeredSize.height);
                this.myCenteredComponent.revalidate();
            }
            if (this.myExpandAction != null) {
                Dimension size = this.myExpandAction.getPreferredSize();
                int x = width - size.width - this.myLayoutData.configuration.rightActionsOffset.width;
                if (this.myLayoutData.showMinSize) {
                    Point location = NotificationsManagerImpl.getCollapsedTextEndLocation(this.myText, this.myLayoutData);
                    if (location != null) {
                        int y = SwingUtilities.convertPoint((Component)this.myText, (int)location.x, (int)location.y, (Component)parent).y;
                        this.myExpandAction.setBounds(x, y, size.width, size.height);
                    }
                } else {
                    int y = parent.getHeight() - size.height - this.myLayoutData.configuration.bottomSpaceHeight;
                    this.myExpandAction.setBounds(x, y, size.width, size.height);
                }
            }
            if (this.myActionPanel != null) {
                int expandWidth = this.myExpandAction == null || this.myLayoutData.showMinSize ? 0 : this.myExpandAction.getPreferredSize().width;
                width -= this.myLayoutData.configuration.actionGap + expandWidth;
                int components = this.myActionPanel.getComponentCount();
                Component lastComponent = this.myActionPanel.getComponent(components - 1);
                if (lastComponent instanceof DropDownAction || lastComponent instanceof ContextHelpLabel) {
                    --components;
                }
                if (components > 2) {
                    Component component;
                    int i;
                    this.myActionPanel.getComponent(0).setVisible(false);
                    for (i = 1; i < components && !(component = this.myActionPanel.getComponent(i)).isVisible(); ++i) {
                        component.setVisible(true);
                    }
                    this.myActionPanel.doLayout();
                    if (this.myActionPanel.getPreferredSize().width > width) {
                        this.myActionPanel.getComponent(0).setVisible(true);
                        this.myActionPanel.getComponent(1).setVisible(false);
                        this.myActionPanel.getComponent(2).setVisible(false);
                        this.myActionPanel.doLayout();
                        for (i = 3; i < components - 1 && this.myActionPanel.getPreferredSize().width > width; ++i) {
                            this.myActionPanel.getComponent(i).setVisible(false);
                            this.myActionPanel.doLayout();
                        }
                    }
                }
                Dimension size = this.myActionPanel.getPreferredSize();
                int y = parent.getHeight() - size.height - this.myLayoutData.configuration.bottomSpaceHeight;
                this.myActionPanel.setBounds(0, y, width, size.height);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "size", "com/intellij/notification/impl/NotificationsManagerImpl$CenteredLayoutWithActions", "layoutSize"));
        }
    }

    private static class MyNotificationListener
    extends NotificationsAdapter {
        private final Project myProject;

        private MyNotificationListener(@Nullable Project project) {
            this.myProject = project;
        }

        public void notify(@NotNull Notification notification) {
            if (notification == null) {
                MyNotificationListener.$$$reportNull$$$0(0);
            }
            NotificationsManagerImpl.doNotify(notification, null, this.myProject);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/notification/impl/NotificationsManagerImpl$MyNotificationListener", "notify"));
        }
    }

    private static class DropDownAction
    extends LinkLabel<Void> {
        Icon myIcon = AllIcons.Ide.Notification.DropTriangle;

        DropDownAction(String text, @Nullable LinkListener<Void> listener2) {
            super(text, null, listener2);
            this.setHorizontalTextPosition(10);
            this.setIconTextGap(0);
            this.setIcon(new Icon(){

                @Override
                public void paintIcon(Component c, Graphics g, int x, int y) {
                    IconUtil.colorize((Graphics2D)((Graphics2D)g), (Icon)myIcon, (Color)this.getTextColor()).paintIcon(c, g, x - 1, y + 1);
                }

                @Override
                public int getIconWidth() {
                    return myIcon.getIconWidth();
                }

                @Override
                public int getIconHeight() {
                    return myIcon.getIconHeight();
                }
            });
        }

        @NotNull
        protected Rectangle getTextBounds() {
            Rectangle bounds2 = super.getTextBounds();
            bounds2.x -= this.getIcon().getIconWidth();
            bounds2.width += 8;
            Rectangle rectangle = bounds2;
            if (rectangle == null) {
                DropDownAction.$$$reportNull$$$0(0);
            }
            return rectangle;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/notification/impl/NotificationsManagerImpl$DropDownAction", "getTextBounds"));
        }
    }

    public static class ProjectNotificationsComponent {
        public ProjectNotificationsComponent(@NotNull Project project) {
            if (project == null) {
                ProjectNotificationsComponent.$$$reportNull$$$0(0);
            }
            if (NotificationsManagerImpl.isDummyEnvironment()) {
                return;
            }
            project.getMessageBus().connect().subscribe(Notifications.TOPIC, (Object)new MyNotificationListener(project));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/notification/impl/NotificationsManagerImpl$ProjectNotificationsComponent", "<init>"));
        }
    }

    private static class HoverAdapter
    extends MouseAdapter
    implements MouseMotionListener {
        private final List<Pair<Component, ?>> myComponents = new ArrayList();
        private List<Component> mySources = new ArrayList<Component>();
        private Component myLastComponent;

        private HoverAdapter() {
        }

        public void addComponent(@NotNull Component component, @NotNull Function<Component, Rectangle> hover) {
            if (component == null) {
                HoverAdapter.$$$reportNull$$$0(0);
            }
            if (hover == null) {
                HoverAdapter.$$$reportNull$$$0(1);
            }
            this.myComponents.add(Pair.create((Object)component, hover));
        }

        public void addComponent(@NotNull Component component, @NotNull Insets hover) {
            if (component == null) {
                HoverAdapter.$$$reportNull$$$0(2);
            }
            if (hover == null) {
                HoverAdapter.$$$reportNull$$$0(3);
            }
            this.myComponents.add(Pair.create((Object)component, (Object)hover));
        }

        public void addSource(@NotNull Component component) {
            if (component == null) {
                HoverAdapter.$$$reportNull$$$0(4);
            }
            this.mySources.add(component);
        }

        public void initListeners() {
            if (!this.myComponents.isEmpty()) {
                for (Component source : this.mySources) {
                    source.addMouseMotionListener(this);
                    source.addMouseListener(this);
                }
                this.mySources = null;
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.handleEvent(e, true, false);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.handleEvent(e, false, false);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            this.handleEvent(e, false, true);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (this.myLastComponent != null) {
                HoverAdapter.mouseExited(e, this.myLastComponent);
                this.myLastComponent = null;
            }
        }

        private void handleEvent(MouseEvent e, boolean pressed, boolean moved) {
            HTMLDocument document;
            AttributeSet attributes;
            JEditorPane pane;
            int pos;
            if (e.getSource() instanceof JEditorPane && (pos = (pane = (JEditorPane)e.getSource()).viewToModel(e.getPoint())) >= 0 && (attributes = (document = (HTMLDocument)pane.getDocument()).getCharacterElement(pos).getAttributes()).getAttribute(HTML.Tag.A) != null) {
                return;
            }
            for (Pair<Component, ?> p : this.myComponents) {
                Rectangle bounds2;
                Component component = (Component)p.first;
                if (p.second instanceof Insets) {
                    bounds2 = component.getBounds();
                    JBInsets.addTo((Rectangle)bounds2, (Insets)((Insets)p.second));
                } else {
                    bounds2 = (Rectangle)((Function)p.second).fun((Object)component);
                }
                if (bounds2.contains(SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), component.getParent()))) {
                    if (this.myLastComponent != null && this.myLastComponent != component) {
                        HoverAdapter.mouseExited(e, this.myLastComponent);
                    }
                    this.myLastComponent = component;
                    MouseEvent event = HoverAdapter.createEvent(e, component);
                    if (moved) {
                        for (MouseMotionListener listener2 : component.getMouseMotionListeners()) {
                            listener2.mouseMoved(event);
                        }
                    } else {
                        MouseListener[] listeners = component.getMouseListeners();
                        if (pressed) {
                            for (MouseListener listener3 : listeners) {
                                listener3.mousePressed(event);
                            }
                        } else {
                            for (MouseListener listener4 : listeners) {
                                listener4.mouseReleased(event);
                            }
                        }
                    }
                    e.getComponent().setCursor(component.getCursor());
                    return;
                }
                if (component != this.myLastComponent) continue;
                this.myLastComponent = null;
                HoverAdapter.mouseExited(e, component);
            }
        }

        private static void mouseExited(MouseEvent e, Component component) {
            MouseListener[] listeners;
            e.getComponent().setCursor(null);
            MouseEvent event = HoverAdapter.createEvent(e, component);
            for (MouseListener listener2 : listeners = component.getMouseListeners()) {
                listener2.mouseExited(event);
            }
        }

        @NotNull
        private static MouseEvent createEvent(MouseEvent e, Component c) {
            MouseEvent mouseEvent = new MouseEvent(c, e.getID(), e.getWhen(), e.getModifiers(), 5, 5, e.getClickCount(), e.isPopupTrigger(), e.getButton());
            if (mouseEvent == null) {
                HoverAdapter.$$$reportNull$$$0(5);
            }
            return mouseEvent;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "hover";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/notification/impl/NotificationsManagerImpl$HoverAdapter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/notification/impl/NotificationsManagerImpl$HoverAdapter";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createEvent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "addComponent";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "addSource";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

