/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json;

import com.intellij.json.pointer.JsonPointerPosition;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.spellchecker.inspections.PlainTextSplitter;
import com.intellij.spellchecker.tokenizer.SpellcheckingStrategy;
import com.intellij.spellchecker.tokenizer.TokenConsumer;
import com.intellij.spellchecker.tokenizer.Tokenizer;
import com.intellij.util.ThreeState;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.JsonOriginalPsiWalker;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaResolver;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JsonSpellcheckerStrategy
extends SpellcheckingStrategy {
    private final Tokenizer<JsonStringLiteral> ourStringLiteralTokenizer = new Tokenizer<JsonStringLiteral>(){

        @Override
        public void tokenize(@NotNull JsonStringLiteral element, TokenConsumer consumer) {
            if (element == null) {
                1.$$$reportNull$$$0(0);
            }
            PlainTextSplitter textSplitter = PlainTextSplitter.getInstance();
            if (element.textContains('\\')) {
                List<Pair<TextRange, String>> fragments = element.getTextFragments();
                for (Pair<TextRange, String> fragment : fragments) {
                    TextRange fragmentRange = (TextRange)fragment.getFirst();
                    String escaped = (String)fragment.getSecond();
                    if (escaped.length() != fragmentRange.getLength() || escaped.startsWith("\\")) continue;
                    consumer.consumeToken(element, escaped, false, fragmentRange.getStartOffset(), TextRange.allOf((String)escaped), textSplitter);
                }
            } else {
                consumer.consumeToken(element, textSplitter);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/json/JsonSpellcheckerStrategy$1", "tokenize"));
        }
    };

    private static boolean matchesNameFromSchema(@NotNull JsonStringLiteral element) {
        VirtualFile file2;
        if (element == null) {
            JsonSpellcheckerStrategy.$$$reportNull$$$0(0);
        }
        if ((file2 = PsiUtilCore.getVirtualFile((PsiElement)element)) == null) {
            return false;
        }
        Project project = element.getProject();
        JsonSchemaService service2 = JsonSchemaService.Impl.get(project);
        if (!service2.isApplicableToFile(file2)) {
            return false;
        }
        JsonSchemaObject rootSchema = service2.getSchemaObject(file2);
        if (rootSchema == null) {
            return false;
        }
        String value = element.getValue();
        if (StringUtil.isEmpty((String)value)) {
            return false;
        }
        JsonOriginalPsiWalker walker = JsonOriginalPsiWalker.INSTANCE;
        PsiElement checkable = walker.findElementToCheck(element);
        if (checkable == null) {
            return false;
        }
        ThreeState isName = walker.isName(checkable);
        JsonPointerPosition position = walker.findPosition(checkable, isName == ThreeState.NO);
        if (position == null || position.isEmpty() && isName == ThreeState.NO) {
            return false;
        }
        Collection<JsonSchemaObject> schemas = new JsonSchemaResolver(project, rootSchema, false, position).resolve();
        if (schemas.isEmpty()) {
            return false;
        }
        return schemas.stream().anyMatch(s -> s.getProperties().keySet().contains(value) || s.getMatchingPatternPropertySchema(value) != null);
    }

    @Override
    @NotNull
    public Tokenizer getTokenizer(PsiElement element) {
        if (element instanceof JsonStringLiteral) {
            Tokenizer<JsonStringLiteral> tokenizer = JsonSpellcheckerStrategy.matchesNameFromSchema((JsonStringLiteral)element) ? EMPTY_TOKENIZER : this.ourStringLiteralTokenizer;
            if (tokenizer == null) {
                JsonSpellcheckerStrategy.$$$reportNull$$$0(1);
            }
            return tokenizer;
        }
        Tokenizer tokenizer = super.getTokenizer(element);
        if (tokenizer == null) {
            JsonSpellcheckerStrategy.$$$reportNull$$$0(2);
        }
        return tokenizer;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/json/JsonSpellcheckerStrategy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/json/JsonSpellcheckerStrategy";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTokenizer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "matchesNameFromSchema";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

