/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jps.impl;

import com.intellij.jps.impl.JpsPluginBean;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.util.containers.ContainerUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ServiceConfigurationError;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.plugin.JpsPluginManager;

public class JpsIdePluginManagerImpl
extends JpsPluginManager {
    private final List<PluginDescriptor> myExternalBuildPlugins = new CopyOnWriteArrayList<PluginDescriptor>();

    public JpsIdePluginManagerImpl() {
        ExtensionsArea rootArea = Extensions.getRootArea();
        if (rootArea.hasExtensionPoint(JpsPluginBean.EP_NAME)) {
            JpsPluginBean.EP_NAME.getPoint(null).addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<JpsPluginBean>(){

                public void extensionAdded(@NotNull JpsPluginBean extension, @Nullable PluginDescriptor pluginDescriptor) {
                    if (extension == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    ContainerUtil.addIfNotNull((Collection)JpsIdePluginManagerImpl.this.myExternalBuildPlugins, (Object)pluginDescriptor);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "com/intellij/jps/impl/JpsIdePluginManagerImpl$1", "extensionAdded"));
                }
            }, true, null);
        }
        if (rootArea.hasExtensionPoint("com.intellij.compileServer.plugin")) {
            ExtensionPoint extensionPoint = rootArea.getExtensionPoint("com.intellij.compileServer.plugin");
            extensionPoint.addExtensionPointListener(new ExtensionPointListener(){

                public void extensionAdded(@NotNull Object extension, @Nullable PluginDescriptor pluginDescriptor) {
                    if (extension == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    ContainerUtil.addIfNotNull((Collection)JpsIdePluginManagerImpl.this.myExternalBuildPlugins, (Object)pluginDescriptor);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "com/intellij/jps/impl/JpsIdePluginManagerImpl$2", "extensionAdded"));
                }
            });
        }
    }

    @NotNull
    public <T> Collection<T> loadExtensions(@NotNull Class<T> extensionClass) {
        if (extensionClass == null) {
            JpsIdePluginManagerImpl.$$$reportNull$$$0(0);
        }
        String resourceName = "META-INF/services/" + extensionClass.getName();
        LinkedHashSet<Class<T>> classes = new LinkedHashSet<Class<T>>();
        LinkedHashSet<ClassLoader> loaders = new LinkedHashSet<ClassLoader>();
        for (PluginDescriptor pluginDescriptor : this.myExternalBuildPlugins) {
            ContainerUtil.addIfNotNull(loaders, (Object)pluginDescriptor.getPluginClassLoader());
        }
        if (loaders.isEmpty()) {
            loaders.add(((Object)((Object)this)).getClass().getClassLoader());
        }
        HashSet<String> loadedUrls = new HashSet<String>();
        for (ClassLoader loader : loaders) {
            try {
                Enumeration<URL> enumeration = loader.getResources(resourceName);
                while (enumeration.hasMoreElements()) {
                    URL url = enumeration.nextElement();
                    if (!loadedUrls.add(url.toExternalForm())) continue;
                    JpsIdePluginManagerImpl.loadImplementations(url, loader, classes);
                }
            }
            catch (IOException iOException) {
                throw new ServiceConfigurationError("Cannot load configuration files for " + extensionClass.getName(), iOException);
            }
        }
        ArrayList<T> arrayList = new ArrayList<T>();
        for (Class clazz : classes) {
            try {
                arrayList.add(extensionClass.cast(clazz.newInstance()));
            }
            catch (Exception e) {
                throw new ServiceConfigurationError("Class " + clazz.getName() + " cannot be instantiated", e);
            }
        }
        ArrayList<T> arrayList2 = arrayList;
        if (arrayList2 == null) {
            JpsIdePluginManagerImpl.$$$reportNull$$$0(1);
        }
        return arrayList2;
    }

    private static <T> void loadImplementations(URL url, ClassLoader loader, Set<Class<T>> result2) throws IOException {
        for (String name : JpsIdePluginManagerImpl.loadClassNames(url)) {
            try {
                result2.add(Class.forName(name, false, loader));
            }
            catch (ClassNotFoundException e) {
                throw new ServiceConfigurationError("Cannot find class " + name, e);
            }
        }
    }

    private static List<String> loadClassNames(URL url) throws IOException {
        ArrayList<String> result2 = new ArrayList<String>();
        try (BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream(), StandardCharsets.UTF_8));){
            String line;
            while ((line = in.readLine()) != null) {
                int i = line.indexOf(35);
                if (i >= 0) {
                    line = line.substring(0, i);
                }
                if ((line = line.trim()).isEmpty()) continue;
                result2.add(line);
            }
        }
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jps/impl/JpsIdePluginManagerImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jps/impl/JpsIdePluginManagerImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "loadExtensions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadExtensions";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

