/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.utils;

import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.featureStatistics.FeatureUsageTrackerImpl;
import com.intellij.internal.statistic.connect.StatisticsService;
import com.intellij.internal.statistic.eventLog.EventLogStatisticsService;
import com.intellij.internal.statistic.persistence.SentUsagesPersistence;
import com.intellij.internal.statistic.persistence.UsageStatisticsPersistenceComponent;
import com.intellij.openapi.util.text.StringUtil;

public class StatisticsUploadAssistant {
    private static final String IDEA_SUPPRESS_REPORT_STATISTICS = "idea.suppress.statistics.report";
    private static final String ENABLE_LOCAL_STATISTICS_WITHOUT_REPORT = "idea.local.statistics.without.report";
    public static final Object LOCK = new Object();
    private static final EventLogStatisticsService logStatisticsService = new EventLogStatisticsService();

    private StatisticsUploadAssistant() {
    }

    public static boolean isShouldShowNotification() {
        return UsageStatisticsPersistenceComponent.getInstance().isShowNotification() && System.currentTimeMillis() - 604800000L > ((FeatureUsageTrackerImpl)FeatureUsageTracker.getInstance()).getFirstRunTime();
    }

    public static long getSendPeriodInMillis() {
        return UsageStatisticsPersistenceComponent.getInstance().getPeriod().getMillis();
    }

    public static boolean isTimeToSend() {
        return StatisticsUploadAssistant.isTimeToSend(UsageStatisticsPersistenceComponent.getInstance());
    }

    public static boolean isTimeToSend(UsageStatisticsPersistenceComponent settings) {
        long timeDelta = System.currentTimeMillis() - settings.getLastTimeSent();
        return Math.abs(timeDelta) > settings.getPeriod().getMillis();
    }

    public static boolean isSendAllowed() {
        return StatisticsUploadAssistant.isSendAllowed(UsageStatisticsPersistenceComponent.getInstance());
    }

    public static boolean isSendAllowed(SentUsagesPersistence settings) {
        return settings != null && settings.isAllowed() && !Boolean.getBoolean(IDEA_SUPPRESS_REPORT_STATISTICS) && !Boolean.getBoolean(ENABLE_LOCAL_STATISTICS_WITHOUT_REPORT);
    }

    public static boolean isCollectAllowed() {
        UsageStatisticsPersistenceComponent settings = UsageStatisticsPersistenceComponent.getInstance();
        return settings != null && settings.isAllowed() || Boolean.getBoolean(ENABLE_LOCAL_STATISTICS_WITHOUT_REPORT);
    }

    public static boolean isTestStatisticsEnabled() {
        return Boolean.getBoolean(ENABLE_LOCAL_STATISTICS_WITHOUT_REPORT) || StringUtil.isNotEmpty((String)System.getenv("TEAMCITY_VERSION"));
    }

    public static void updateSentTime() {
        UsageStatisticsPersistenceComponent.getInstance().setSentTime(System.currentTimeMillis());
    }

    public static StatisticsService getEventLogStatisticsService() {
        return logStatisticsService;
    }
}

