/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.service.fus.collectors;

import com.intellij.concurrency.JobScheduler;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.eventLog.FeatureUsageGroup;
import com.intellij.internal.statistic.eventLog.FeatureUsageLogger;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsageCollectorEP;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FUCounterUsageLogger {
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.internal.statistic.service.fus.collectors.FUCounterUsageLogger");
    private static final int LOG_REGISTERED_DELAY_MIN = 1440;
    private static final int LOG_REGISTERED_INITIAL_DELAY_MIN = 5;
    private static final String REGISTERED = "registered";
    private static final String[] GENERAL_GROUPS = new String[]{"lifecycle", "performance", "actions", "ui.dialogs", "toolwindow", "intentions", "toolbar", "run.configuration.exec", "file.types.usage", "productivity", "live.templates", "completion.postfix"};
    private static final FUCounterUsageLogger INSTANCE = new FUCounterUsageLogger();
    private final Map<String, FeatureUsageGroup> myGroups = new HashMap<String, FeatureUsageGroup>();

    @NotNull
    public static FUCounterUsageLogger getInstance() {
        FUCounterUsageLogger fUCounterUsageLogger = INSTANCE;
        if (fUCounterUsageLogger == null) {
            FUCounterUsageLogger.$$$reportNull$$$0(0);
        }
        return fUCounterUsageLogger;
    }

    public FUCounterUsageLogger() {
        int version2 = 9;
        for (String group : GENERAL_GROUPS) {
            this.register(new FeatureUsageGroup(group, version2));
        }
        for (CounterUsageCollectorEP ep : CounterUsageCollectorEP.EP_NAME.getExtensionList()) {
            String id = ep.getGroupId();
            if (!StringUtil.isNotEmpty((String)id)) continue;
            this.register(new FeatureUsageGroup(id, ep.version));
        }
        JobScheduler.getScheduler().scheduleWithFixedDelay(() -> this.logRegisteredGroups(), 5L, 1440L, TimeUnit.MINUTES);
    }

    public void register(@NotNull FeatureUsageGroup group) {
        if (group == null) {
            FUCounterUsageLogger.$$$reportNull$$$0(1);
        }
        this.myGroups.put(group.getId(), group);
    }

    public void logRegisteredGroups() {
        for (FeatureUsageGroup group : this.myGroups.values()) {
            FeatureUsageLogger.INSTANCE.log(group, REGISTERED);
        }
    }

    public void logEvent(@NotNull Project project, @NotNull String groupId, @NotNull String event) {
        FeatureUsageGroup group;
        if (project == null) {
            FUCounterUsageLogger.$$$reportNull$$$0(2);
        }
        if (groupId == null) {
            FUCounterUsageLogger.$$$reportNull$$$0(3);
        }
        if (event == null) {
            FUCounterUsageLogger.$$$reportNull$$$0(4);
        }
        if ((group = this.findRegisteredGroupById(groupId)) != null) {
            Map<String, Object> data = new FeatureUsageData().addProject(project).build();
            FeatureUsageLogger.INSTANCE.log(group, event, data);
        }
    }

    public void logEvent(@NotNull Project project, @NotNull String groupId, @NotNull String event, @NotNull FeatureUsageData data) {
        FeatureUsageGroup group;
        if (project == null) {
            FUCounterUsageLogger.$$$reportNull$$$0(5);
        }
        if (groupId == null) {
            FUCounterUsageLogger.$$$reportNull$$$0(6);
        }
        if (event == null) {
            FUCounterUsageLogger.$$$reportNull$$$0(7);
        }
        if (data == null) {
            FUCounterUsageLogger.$$$reportNull$$$0(8);
        }
        if ((group = this.findRegisteredGroupById(groupId)) != null) {
            FeatureUsageLogger.INSTANCE.log(group, event, data.addProject(project).build());
        }
    }

    public void logEvent(@NotNull String groupId, @NotNull String event) {
        FeatureUsageGroup group;
        if (groupId == null) {
            FUCounterUsageLogger.$$$reportNull$$$0(9);
        }
        if (event == null) {
            FUCounterUsageLogger.$$$reportNull$$$0(10);
        }
        if ((group = this.findRegisteredGroupById(groupId)) != null) {
            FeatureUsageLogger.INSTANCE.log(group, event);
        }
    }

    public void logEvent(@NotNull String groupId, @NotNull String event, @NotNull FeatureUsageData data) {
        FeatureUsageGroup group;
        if (groupId == null) {
            FUCounterUsageLogger.$$$reportNull$$$0(11);
        }
        if (event == null) {
            FUCounterUsageLogger.$$$reportNull$$$0(12);
        }
        if (data == null) {
            FUCounterUsageLogger.$$$reportNull$$$0(13);
        }
        if ((group = this.findRegisteredGroupById(groupId)) != null) {
            FeatureUsageLogger.INSTANCE.log(group, event, data.build());
        }
    }

    @Nullable
    private FeatureUsageGroup findRegisteredGroupById(@NotNull String groupId) {
        if (groupId == null) {
            FUCounterUsageLogger.$$$reportNull$$$0(14);
        }
        if (!this.myGroups.containsKey(groupId)) {
            LOG.warn("Cannot record event because group '" + groupId + "' is not registered.");
            return null;
        }
        return this.myGroups.get(groupId);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/service/fus/collectors/FUCounterUsageLogger";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupId";
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/service/fus/collectors/FUCounterUsageLogger";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "register";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "logEvent";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findRegisteredGroupById";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

