/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.intellij.internal.statistic.eventLog.FeatureUsageEventFileAppender;
import com.intellij.internal.statistic.eventLog.FeatureUsageEventWriter;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nH\u0002J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016J\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/internal/statistic/eventLog/FeatureUsageLogEventWriter;", "Lcom/intellij/internal/statistic/eventLog/FeatureUsageEventWriter;", "()V", "eventLogger", "Lorg/apache/log4j/Logger;", "fileAppender", "Lcom/intellij/internal/statistic/eventLog/FeatureUsageEventFileAppender;", "cleanup", "", "getEventLogDir", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "getFiles", "", "Ljava/io/File;", "log", "message", "", "intellij.platform.ide.impl"})
public final class FeatureUsageLogEventWriter
implements FeatureUsageEventWriter {
    private FeatureUsageEventFileAppender fileAppender;
    private final Logger eventLogger;

    private final Path getEventLogDir() {
        return Paths.get(PathManager.getSystemPath(), new String[0]).resolve("event-log");
    }

    @Override
    public void log(@NotNull String message) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        this.eventLogger.info((Object)message);
    }

    @Override
    @NotNull
    public List<File> getFiles() {
        Object[] files2;
        FeatureUsageEventFileAppender featureUsageEventFileAppender = this.fileAppender;
        String activeLog = featureUsageEventFileAppender != null ? featureUsageEventFileAppender.getActiveLogName() : null;
        Object object = files2 = new File(this.getEventLogDir().toUri()).listFiles(new FileFilter(activeLog){
            final /* synthetic */ String $activeLog;

            public final boolean accept(@NotNull File f) {
                Intrinsics.checkParameterIsNotNull((Object)f, (String)"f");
                return !StringUtil.equals((CharSequence)f.getName(), (CharSequence)this.$activeLog);
            }
            {
                this.$activeLog = string;
            }
        });
        if (files2 == null || (object = ArraysKt.toList((Object[])object)) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    @Override
    public void cleanup() {
        block0: {
            FeatureUsageEventFileAppender featureUsageEventFileAppender = this.fileAppender;
            if (featureUsageEventFileAppender == null) break block0;
            featureUsageEventFileAppender.cleanUp();
        }
    }

    public FeatureUsageLogEventWriter() {
        Logger logger = Logger.getLogger((String)"feature-usage-event-logger");
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getLogger(\"feature-usage-event-logger\")");
        this.eventLogger = logger;
        this.eventLogger.setLevel(Level.INFO);
        this.eventLogger.setAdditivity(false);
        PatternLayout pattern = new PatternLayout("%m\n");
        try {
            Path dir = this.getEventLogDir();
            FeatureUsageEventFileAppender featureUsageEventFileAppender = this.fileAppender = FeatureUsageEventFileAppender.create((Layout)pattern, dir);
            if (featureUsageEventFileAppender != null) {
                FeatureUsageEventFileAppender featureUsageEventFileAppender2;
                FeatureUsageEventFileAppender appender = featureUsageEventFileAppender2 = featureUsageEventFileAppender;
                boolean bl = false;
                appender.setMaxFileSize("200KB");
                this.eventLogger.addAppender((Appender)appender);
            }
        }
        catch (IOException e) {
            System.err.println("Unable to initialize logging for feature usage: " + e.getLocalizedMessage());
        }
    }
}

